vcpkg_from_github(
    OUT_SOURCE_PATH SOURCE_PATH
    REPO kcat/openal-soft
    REF ${VERSION}
    SHA512 3eebd18de4984691136738e8fe5851ac5dbdc8f17916cc9dcc599bd3bafc400c9dad9dc88844a9b77b1e8e372a041af342421bdf23746dffe4760f8385bd1e53
    HEAD_REF master
    PATCHES
        pkgconfig-cxx.diff
        devendor-fmt.diff
)

vcpkg_check_features(OUT_FEATURE_OPTIONS FEATURE_OPTIONS
    FEATURES
        pipewire    ALSOFT_BACKEND_PIPEWIRE
        pipewire    ALSOFT_REQUIRE_PIPEWIRE
        pulseaudio  ALSOFT_BACKEND_PULSEAUDIO
        pulseaudio  ALSOFT_REQUIRE_PULSEAUDIO
)

if(VCPKG_LIBRARY_LINKAGE STREQUAL "dynamic")
    set(OPENAL_LIBTYPE "SHARED")
else()
    set(OPENAL_LIBTYPE "STATIC")
endif()

set(ALSOFT_REQUIRE_LINUX OFF)
set(ALSOFT_REQUIRE_WINDOWS OFF)
set(ALSOFT_REQUIRE_WINDOWS_NOT_UWP OFF)
set(ALSOFT_REQUIRE_APPLE OFF)
set(ALSOFT_CPUEXT_NEON OFF)

if(VCPKG_TARGET_IS_LINUX)
    set(ALSOFT_REQUIRE_LINUX ON)
endif()
if(VCPKG_TARGET_IS_WINDOWS)
    set(ALSOFT_REQUIRE_WINDOWS ON)
    if(NOT VCPKG_TARGET_IS_UWP)
        set(ALSOFT_REQUIRE_WINDOWS_NOT_UWP ON)
    endif()
endif()
if(VCPKG_TARGET_IS_OSX OR VCPKG_TARGET_IS_IOS)
    set(ALSOFT_REQUIRE_APPLE ON)
endif()
if(VCPKG_TARGET_ARCHITECTURE STREQUAL "arm64")
    set(ALSOFT_CPUEXT_NEON ON)
endif()

vcpkg_find_acquire_program(PKGCONFIG)

vcpkg_cmake_configure(
    SOURCE_PATH "${SOURCE_PATH}"
    OPTIONS
        ${FEATURE_OPTIONS}
        -DALSOFT_CPUEXT_NEON=${ALSOFT_CPUEXT_NEON}
        -DALSOFT_EXAMPLES=OFF
        -DALSOFT_INSTALL_AMBDEC_PRESETS=OFF
        -DALSOFT_INSTALL_CONFIG=OFF
        -DALSOFT_INSTALL_HRTF_DATA=OFF
        -DALSOFT_NO_CONFIG_UTIL=ON
        -DALSOFT_UPDATE_BUILD_VERSION=OFF
        -DALSOFT_UTILS=OFF
        -DLIBTYPE=${OPENAL_LIBTYPE}
        "-DPKG_CONFIG_EXECUTABLE=${PKGCONFIG}"
        # order by CMakeLists.txt
        -DALSOFT_BACKEND_ALSA=${ALSOFT_REQUIRE_LINUX}
        -DALSOFT_REQUIRE_ALSA=${ALSOFT_REQUIRE_LINUX}
        -DALSOFT_BACKEND_OSS=OFF
        -DALSOFT_BACKEND_SOLARIS=OFF
        -DALSOFT_BACKEND_SNDIO=OFF
        -DALSOFT_BACKEND_WINMM=OFF
        -DALSOFT_BACKEND_DSOUND=${ALSOFT_REQUIRE_WINDOWS_NOT_UWP}
        -DALSOFT_REQUIRE_DSOUND=${ALSOFT_REQUIRE_WINDOWS_NOT_UWP}
        -DALSOFT_BACKEND_WASAPI=${ALSOFT_REQUIRE_WINDOWS}
        -DALSOFT_REQUIRE_WASAPI=${ALSOFT_REQUIRE_WINDOWS}
        -DALSOFT_BACKEND_JACK=OFF
        -DALSOFT_BACKEND_COREAUDIO=${ALSOFT_REQUIRE_APPLE}
        -DALSOFT_REQUIRE_COREAUDIO=${ALSOFT_REQUIRE_APPLE}
        -DALSOFT_BACKEND_OBOE=OFF
        -DALSOFT_BACKEND_OPENSL=${VCPKG_TARGET_IS_ANDROID}
        -DALSOFT_REQUIRE_OPENSL=${VCPKG_TARGET_IS_ANDROID}
        -DALSOFT_BACKEND_PORTAUDIO=OFF
        -DALSOFT_BACKEND_WAVE=ON
    MAYBE_UNUSED_VARIABLES
        # NOT WIN32
        ALSOFT_BACKEND_ALSA
        ALSOFT_REQUIRE_ALSA
        ALSOFT_BACKEND_OSS
        ALSOFT_BACKEND_SOLARIS
        ALSOFT_BACKEND_SNDIO
        # WIN32
        ALSOFT_BACKEND_WINMM
        ALSOFT_BACKEND_DSOUND
        ALSOFT_REQUIRE_DSOUND
        ALSOFT_BACKEND_WASAPI
        ALSOFT_REQUIRE_WASAPI
)

vcpkg_cmake_install()
vcpkg_copy_pdbs()
vcpkg_cmake_config_fixup(CONFIG_PATH "lib/cmake/OpenAL")
vcpkg_fixup_pkgconfig()

if(VCPKG_LIBRARY_LINKAGE STREQUAL "static")
    foreach(HEADER IN ITEMS al.h alc.h)
        vcpkg_replace_string("${CURRENT_PACKAGES_DIR}/include/AL/${HEADER}" "defined(AL_LIBTYPE_STATIC)" "1")
    endforeach()
endif()

file(REMOVE_RECURSE "${CURRENT_PACKAGES_DIR}/debug/include")
file(REMOVE_RECURSE "${CURRENT_PACKAGES_DIR}/debug/share")

file(READ "${SOURCE_PATH}/common/pffft.cpp" pffft_license)
string(REGEX REPLACE "[*]/.*" "*/\n" pffft_license "${pffft_license}")
file(WRITE "${CURRENT_BUILDTREES_DIR}/${TARGET_TRIPLET}-rel/pffft Notice" "${pffft_license}")
vcpkg_install_copyright(FILE_LIST "${SOURCE_PATH}/COPYING" "${CURRENT_BUILDTREES_DIR}/${TARGET_TRIPLET}-rel/pffft Notice")