/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.image.apng.argb8888;

import java.util.ArrayList;
import java.util.List;
import org.jackhuang.hmcl.ui.image.apng.argb8888.Argb8888Bitmap;
import org.jackhuang.hmcl.ui.image.apng.chunks.PngAnimationControl;
import org.jackhuang.hmcl.ui.image.apng.chunks.PngFrameControl;
import org.jackhuang.hmcl.ui.image.apng.chunks.PngHeader;

public final class Argb8888BitmapSequence {
    public final PngHeader header;
    public final Argb8888Bitmap defaultImage;
    private boolean defaultImageIsSet = false;
    private PngAnimationControl animationControl;
    List<Frame> animationFrames;

    public Argb8888BitmapSequence(PngHeader header) {
        this.header = header;
        this.defaultImage = new Argb8888Bitmap(header.width, header.height);
    }

    public void receiveAnimationControl(PngAnimationControl animationControl) {
        this.animationControl = animationControl;
        this.animationFrames = new ArrayList<Frame>(animationControl.numFrames);
    }

    public void receiveDefaultImage(Argb8888Bitmap bitmap) {
        this.defaultImageIsSet = true;
    }

    public boolean hasDefaultImage() {
        return this.defaultImageIsSet;
    }

    public boolean isAnimated() {
        return null != this.animationControl && this.animationControl.numFrames > 0;
    }

    public PngAnimationControl getAnimationControl() {
        return this.animationControl;
    }

    public List<Frame> getAnimationFrames() {
        return this.animationFrames;
    }

    public static final class Frame {
        public final PngFrameControl control;
        public final Argb8888Bitmap bitmap;

        public Frame(PngFrameControl control, Argb8888Bitmap bitmap) {
            this.control = control;
            this.bitmap = bitmap;
        }
    }
}

