/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.upgrade;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.Optional;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.upgrade.UpdateChannel;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.NetworkUtils;

public final class RemoteVersion {
    private final UpdateChannel channel;
    private final String version;
    private final String url;
    private final Type type;
    private final FileDownloadTask.IntegrityCheck integrityCheck;
    private final boolean preview;
    private final boolean force;

    public static RemoteVersion fetch(UpdateChannel channel, boolean preview, String url) throws IOException {
        try {
            JsonObject response = JsonUtils.fromNonNullJson(NetworkUtils.doGet(url), JsonObject.class);
            String version = Optional.ofNullable(response.get("version")).map(JsonElement::getAsString).orElseThrow(() -> new IOException("version is missing"));
            String jarUrl = Optional.ofNullable(response.get("jar")).map(JsonElement::getAsString).orElse(null);
            String jarHash = Optional.ofNullable(response.get("jarsha1")).map(JsonElement::getAsString).orElse(null);
            boolean force = Optional.ofNullable(response.get("force")).map(JsonElement::getAsBoolean).orElse(false);
            if (jarUrl != null && jarHash != null) {
                return new RemoteVersion(channel, version, jarUrl, Type.JAR, new FileDownloadTask.IntegrityCheck("SHA-1", jarHash), preview, force);
            }
            throw new IOException("No download url is available");
        }
        catch (JsonParseException e) {
            throw new IOException("Malformed response", e);
        }
    }

    public RemoteVersion(UpdateChannel channel, String version, String url, Type type, FileDownloadTask.IntegrityCheck integrityCheck, boolean preview, boolean force) {
        this.channel = channel;
        this.version = version;
        this.url = url;
        this.type = type;
        this.integrityCheck = integrityCheck;
        this.preview = preview;
        this.force = force;
    }

    public UpdateChannel getChannel() {
        return this.channel;
    }

    public String getVersion() {
        return this.version;
    }

    public String getUrl() {
        return this.url;
    }

    public Type getType() {
        return this.type;
    }

    public FileDownloadTask.IntegrityCheck getIntegrityCheck() {
        return this.integrityCheck;
    }

    public boolean isPreview() {
        return this.preview;
    }

    public boolean isForce() {
        return this.force;
    }

    public String toString() {
        return "[" + this.version + " from " + this.url + "]";
    }

    public static enum Type {
        JAR;

    }
}

