/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.setting;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.event.EventBus;
import org.jackhuang.hmcl.event.EventPriority;
import org.jackhuang.hmcl.event.RefreshedVersionsEvent;
import org.jackhuang.hmcl.game.HMCLCacheRepository;
import org.jackhuang.hmcl.game.HMCLGameRepository;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.setting.DownloadProviders;
import org.jackhuang.hmcl.setting.VersionSetting;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.WeakListenerHolder;
import org.jackhuang.hmcl.util.ToStringBuilder;
import org.jackhuang.hmcl.util.javafx.ObservableHelper;

@JsonAdapter(value=Serializer.class)
public final class Profile
implements Observable {
    private final WeakListenerHolder listenerHolder = new WeakListenerHolder();
    private final HMCLGameRepository repository;
    private final StringProperty selectedVersion = new SimpleStringProperty();
    private final ObjectProperty<Path> gameDir;
    private final ReadOnlyObjectWrapper<VersionSetting> global = new ReadOnlyObjectWrapper((Object)this, "global");
    private final SimpleStringProperty name;
    private final BooleanProperty useRelativePath = new SimpleBooleanProperty((Object)this, "useRelativePath", false);
    private ObservableHelper observableHelper = new ObservableHelper(this);

    public StringProperty selectedVersionProperty() {
        return this.selectedVersion;
    }

    public String getSelectedVersion() {
        return (String)this.selectedVersion.get();
    }

    public void setSelectedVersion(String selectedVersion) {
        this.selectedVersion.set((Object)selectedVersion);
    }

    public ObjectProperty<Path> gameDirProperty() {
        return this.gameDir;
    }

    public Path getGameDir() {
        return (Path)this.gameDir.get();
    }

    public void setGameDir(Path gameDir) {
        this.gameDir.set((Object)gameDir);
    }

    public ReadOnlyObjectProperty<VersionSetting> globalProperty() {
        return this.global.getReadOnlyProperty();
    }

    public VersionSetting getGlobal() {
        return (VersionSetting)this.global.get();
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public String getName() {
        return this.name.get();
    }

    public void setName(String name) {
        this.name.set(name);
    }

    public BooleanProperty useRelativePathProperty() {
        return this.useRelativePath;
    }

    public boolean isUseRelativePath() {
        return this.useRelativePath.get();
    }

    public void setUseRelativePath(boolean useRelativePath) {
        this.useRelativePath.set(useRelativePath);
    }

    public Profile(String name) {
        this(name, Path.of(".minecraft", new String[0]));
    }

    public Profile(String name, Path initialGameDir) {
        this(name, initialGameDir, new VersionSetting());
    }

    public Profile(String name, Path initialGameDir, VersionSetting global) {
        this(name, initialGameDir, global, null, false);
    }

    public Profile(String name, Path initialGameDir, VersionSetting global, String selectedVersion, boolean useRelativePath) {
        this.name = new SimpleStringProperty((Object)this, "name", name);
        this.gameDir = new SimpleObjectProperty((Object)this, "gameDir", (Object)initialGameDir);
        this.repository = new HMCLGameRepository(this, initialGameDir);
        this.global.set((Object)(global == null ? new VersionSetting() : global));
        this.selectedVersion.set((Object)selectedVersion);
        this.useRelativePath.set(useRelativePath);
        this.gameDir.addListener((a, b, newValue) -> this.repository.changeDirectory((Path)newValue));
        this.selectedVersion.addListener(o -> this.checkSelectedVersion());
        this.listenerHolder.add(EventBus.EVENT_BUS.channel(RefreshedVersionsEvent.class).registerWeak(event -> this.checkSelectedVersion(), EventPriority.HIGHEST));
        this.addPropertyChangedListener(FXUtils.onInvalidating(this::invalidate));
    }

    private void checkSelectedVersion() {
        FXUtils.runInFX(() -> {
            if (!this.repository.isLoaded()) {
                return;
            }
            String newValue = (String)this.selectedVersion.get();
            if (!this.repository.hasVersion(newValue)) {
                Optional<String> version = this.repository.getVersions().stream().findFirst().map(Version::getId);
                if (version.isPresent()) {
                    this.selectedVersion.setValue(version.get());
                } else if (newValue != null) {
                    this.selectedVersion.setValue(null);
                }
            }
        });
    }

    public HMCLGameRepository getRepository() {
        return this.repository;
    }

    public DefaultDependencyManager getDependency() {
        return this.getDependency(DownloadProviders.getDownloadProvider());
    }

    public DefaultDependencyManager getDependency(DownloadProvider downloadProvider) {
        return new DefaultDependencyManager(this.repository, downloadProvider, HMCLCacheRepository.REPOSITORY);
    }

    public VersionSetting getVersionSetting(String id) {
        return this.repository.getVersionSetting(id);
    }

    public String toString() {
        return new ToStringBuilder(this).append("gameDir", this.getGameDir()).append("name", this.getName()).append("useRelativePath", this.isUseRelativePath()).toString();
    }

    private void addPropertyChangedListener(InvalidationListener listener) {
        this.name.addListener(listener);
        this.global.addListener(listener);
        this.gameDir.addListener(listener);
        this.useRelativePath.addListener(listener);
        ((VersionSetting)this.global.get()).addListener(listener);
        this.selectedVersion.addListener(listener);
    }

    public void addListener(InvalidationListener listener) {
        this.observableHelper.addListener(listener);
    }

    public void removeListener(InvalidationListener listener) {
        this.observableHelper.removeListener(listener);
    }

    private void invalidate() {
        Platform.runLater(this.observableHelper::invalidate);
    }

    public static final class Serializer
    implements JsonSerializer<Profile>,
    JsonDeserializer<Profile> {
        @Override
        public JsonElement serialize(Profile src, Type typeOfSrc, JsonSerializationContext context) {
            if (src == null) {
                return JsonNull.INSTANCE;
            }
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("global", context.serialize(src.getGlobal()));
            jsonObject.addProperty("gameDir", src.getGameDir().toString());
            jsonObject.addProperty("useRelativePath", src.isUseRelativePath());
            jsonObject.addProperty("selectedMinecraftVersion", src.getSelectedVersion());
            return jsonObject;
        }

        @Override
        public Profile deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (!(json instanceof JsonObject)) {
                return null;
            }
            JsonObject obj = (JsonObject)json;
            String gameDir = Optional.ofNullable(obj.get("gameDir")).map(JsonElement::getAsString).orElse("");
            return new Profile("Default", Path.of(gameDir, new String[0]), (VersionSetting)context.deserialize(obj.get("global"), (Type)((Object)VersionSetting.class)), Optional.ofNullable(obj.get("selectedMinecraftVersion")).map(JsonElement::getAsString).orElse(""), Optional.ofNullable(obj.get("useRelativePath")).map(JsonElement::getAsBoolean).orElse(false));
        }
    }

    public static class ProfileVersion {
        private final Profile profile;
        private final String version;

        public ProfileVersion(Profile profile, String version) {
            this.profile = profile;
            this.version = version;
        }

        public Profile getProfile() {
            return this.profile;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

