/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.account;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDialogLayout;
import com.jfoenix.controls.JFXTextField;
import java.io.IOException;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javax.net.ssl.SSLException;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorServer;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;
import org.jackhuang.hmcl.ui.animation.TransitionPane;
import org.jackhuang.hmcl.ui.construct.DialogAware;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.logging.Logger;

public final class AddAuthlibInjectorServerPane
extends TransitionPane
implements DialogAware {
    private final Label lblServerUrl;
    private final Label lblServerName;
    private final Label lblCreationWarning;
    private final Label lblServerWarning;
    private final JFXTextField txtServerUrl;
    private final JFXDialogLayout addServerPane = new JFXDialogLayout();
    private final JFXDialogLayout confirmServerPane;
    private final SpinnerPane nextPane;
    private final JFXButton btnAddNext;
    private AuthlibInjectorServer serverBeingAdded;

    public AddAuthlibInjectorServerPane(String url) {
        this();
        this.txtServerUrl.setText(url);
        this.onAddNext();
    }

    public AddAuthlibInjectorServerPane() {
        this.addServerPane.setHeading(new Node[]{new Label(I18n.i18n("account.injector.add"))});
        this.txtServerUrl = new JFXTextField();
        this.txtServerUrl.setPromptText(I18n.i18n("account.injector.server_url"));
        this.txtServerUrl.setOnAction(e -> this.onAddNext());
        this.lblCreationWarning = new Label();
        this.lblCreationWarning.setWrapText(true);
        HBox actions = new HBox();
        JFXButton cancel = new JFXButton(I18n.i18n("button.cancel"));
        cancel.getStyleClass().add((Object)"dialog-accept");
        cancel.setOnAction(e -> this.onAddCancel());
        this.nextPane = new SpinnerPane();
        this.nextPane.getStyleClass().add((Object)"small-spinner-pane");
        this.btnAddNext = new JFXButton(I18n.i18n("wizard.next"));
        this.btnAddNext.getStyleClass().add((Object)"dialog-accept");
        this.btnAddNext.setOnAction(e -> this.onAddNext());
        this.nextPane.setContent((Node)this.btnAddNext);
        actions.getChildren().setAll((Object[])new Node[]{cancel, this.nextPane});
        this.addServerPane.setBody(new Node[]{this.txtServerUrl});
        this.addServerPane.setActions(new Node[]{this.lblCreationWarning, actions});
        this.confirmServerPane = new JFXDialogLayout();
        this.confirmServerPane.setHeading(new Node[]{new Label(I18n.i18n("account.injector.add"))});
        GridPane body = new GridPane();
        body.setStyle("-fx-padding: 15 0 0 0;");
        body.setVgap(15.0);
        body.setHgap(15.0);
        body.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{Lang.apply(new ColumnConstraints(), c -> c.setMaxWidth(100.0)), new ColumnConstraints()});
        this.lblServerUrl = new Label();
        GridPane.setColumnIndex((Node)this.lblServerUrl, (Integer)1);
        GridPane.setRowIndex((Node)this.lblServerUrl, (Integer)0);
        this.lblServerName = new Label();
        GridPane.setColumnIndex((Node)this.lblServerName, (Integer)1);
        GridPane.setRowIndex((Node)this.lblServerName, (Integer)1);
        this.lblServerWarning = new Label(I18n.i18n("account.injector.http"));
        this.lblServerWarning.setStyle("-fx-text-fill: red;");
        GridPane.setColumnIndex((Node)this.lblServerWarning, (Integer)0);
        GridPane.setRowIndex((Node)this.lblServerWarning, (Integer)2);
        GridPane.setColumnSpan((Node)this.lblServerWarning, (Integer)2);
        body.getChildren().setAll((Object[])new Node[]{(Node)Lang.apply(new Label(I18n.i18n("account.injector.server_url")), l -> {
            GridPane.setColumnIndex((Node)l, (Integer)0);
            GridPane.setRowIndex((Node)l, (Integer)0);
        }), (Node)Lang.apply(new Label(I18n.i18n("account.injector.server_name")), l -> {
            GridPane.setColumnIndex((Node)l, (Integer)0);
            GridPane.setRowIndex((Node)l, (Integer)1);
        }), this.lblServerUrl, this.lblServerName, this.lblServerWarning});
        JFXButton prevButton = new JFXButton(I18n.i18n("wizard.prev"));
        prevButton.getStyleClass().add((Object)"dialog-cancel");
        prevButton.setOnAction(e -> this.onAddPrev());
        JFXButton cancelButton = new JFXButton(I18n.i18n("button.cancel"));
        cancelButton.getStyleClass().add((Object)"dialog-cancel");
        cancelButton.setOnAction(e -> this.onAddCancel());
        JFXButton finishButton = new JFXButton(I18n.i18n("wizard.finish"));
        finishButton.getStyleClass().add((Object)"dialog-accept");
        finishButton.setOnAction(e -> this.onAddFinish());
        this.confirmServerPane.setBody(new Node[]{body});
        this.confirmServerPane.setActions(new Node[]{prevButton, cancelButton, finishButton});
        this.setContent((Node)this.addServerPane, ContainerAnimations.NONE);
        this.lblCreationWarning.maxWidthProperty().bind((ObservableValue)((FlowPane)this.lblCreationWarning.getParent()).widthProperty());
        this.btnAddNext.disableProperty().bind((ObservableValue)this.txtServerUrl.textProperty().isEmpty());
        this.nextPane.hideSpinner();
        FXUtils.onEscPressed((Node)this, this::onAddCancel);
    }

    @Override
    public void onDialogShown() {
        this.txtServerUrl.requestFocus();
    }

    private String resolveFetchExceptionMessage(Throwable exception) {
        if (exception instanceof SSLException) {
            return I18n.i18n("account.failed.ssl");
        }
        if (exception instanceof IOException) {
            return I18n.i18n("account.failed.connect_injector_server");
        }
        return exception.getClass().getName() + ": " + exception.getLocalizedMessage();
    }

    private void onAddCancel() {
        this.fireEvent(new DialogCloseEvent());
    }

    private void onAddNext() {
        if (this.btnAddNext.isDisabled()) {
            return;
        }
        this.lblCreationWarning.setText("");
        String url = this.txtServerUrl.getText();
        this.nextPane.showSpinner();
        this.addServerPane.setDisable(true);
        Task.runAsync(() -> {
            this.serverBeingAdded = AuthlibInjectorServer.locateServer(url);
        }).whenComplete(Schedulers.javafx(), exception -> {
            this.addServerPane.setDisable(false);
            this.nextPane.hideSpinner();
            if (exception == null) {
                this.lblServerName.setText(this.serverBeingAdded.getName());
                this.lblServerUrl.setText(this.serverBeingAdded.getUrl());
                this.lblServerWarning.setVisible(this.serverBeingAdded.getUrl().startsWith("http://"));
                this.setContent((Node)this.confirmServerPane, ContainerAnimations.SWIPE_LEFT);
            } else {
                Logger.LOG.warning("Failed to resolve auth server: " + url, exception);
                this.lblCreationWarning.setText(this.resolveFetchExceptionMessage(exception));
            }
        }).start();
    }

    private void onAddPrev() {
        this.setContent((Node)this.addServerPane, ContainerAnimations.SWIPE_RIGHT);
    }

    private void onAddFinish() {
        if (!ConfigHolder.config().getAuthlibInjectorServers().contains((Object)this.serverBeingAdded)) {
            ConfigHolder.config().getAuthlibInjectorServers().add((Object)this.serverBeingAdded);
        }
        this.fireEvent(new DialogCloseEvent());
    }
}

