# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: databrew
using AWS.Compat
using AWS.UUIDs

"""
    batch_delete_recipe_version(recipe_versions, name)
    batch_delete_recipe_version(recipe_versions, name, params::Dict{String,<:Any})

Deletes one or more versions of a recipe at a time. The entire request will be rejected if:
  The recipe does not exist.   There is an invalid version identifier in the list of
versions.   The version list is empty.   The version list size exceeds 50.   The version
list contains duplicate entries.   The request will complete successfully, but with partial
failures, if:   A version does not exist.   A version is being used by a job.   You specify
LATEST_WORKING, but it's being used by a project.   The version fails to be deleted.   The
LATEST_WORKING version will only be deleted if the recipe has no other versions. If you try
to delete LATEST_WORKING while other versions exist (or if they can't be deleted), then
LATEST_WORKING will be listed as partial failure in the response.

# Arguments
- `recipe_versions`: An array of version identifiers, for the recipe versions to be
  deleted. You can specify numeric versions (X.Y) or LATEST_WORKING. LATEST_PUBLISHED is not
  supported.
- `name`: The name of the recipe whose versions are to be deleted.

"""
function batch_delete_recipe_version(
    RecipeVersions, name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return databrew(
        "POST",
        "/recipes/$(name)/batchDeleteRecipeVersion",
        Dict{String,Any}("RecipeVersions" => RecipeVersions);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_delete_recipe_version(
    RecipeVersions,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return databrew(
        "POST",
        "/recipes/$(name)/batchDeleteRecipeVersion",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("RecipeVersions" => RecipeVersions), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_dataset(input, name)
    create_dataset(input, name, params::Dict{String,<:Any})

Creates a new DataBrew dataset.

# Arguments
- `input`:
- `name`: The name of the dataset to be created. Valid characters are alphanumeric (A-Z,
  a-z, 0-9), hyphen (-), period (.), and space.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Format"`: The file format of a dataset that is created from an Amazon S3 file or folder.
- `"FormatOptions"`:
- `"PathOptions"`: A set of options that defines how DataBrew interprets an Amazon S3 path
  of the dataset.
- `"Tags"`: Metadata tags to apply to this dataset.
"""
function create_dataset(Input, Name; aws_config::AbstractAWSConfig=current_aws_config())
    return databrew(
        "POST",
        "/datasets",
        Dict{String,Any}("Input" => Input, "Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_dataset(
    Input,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return databrew(
        "POST",
        "/datasets",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Input" => Input, "Name" => Name), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_profile_job(dataset_name, name, output_location, role_arn)
    create_profile_job(dataset_name, name, output_location, role_arn, params::Dict{String,<:Any})

Creates a new job to analyze a dataset and create its data profile.

# Arguments
- `dataset_name`: The name of the dataset that this job is to act upon.
- `name`: The name of the job to be created. Valid characters are alphanumeric (A-Z, a-z,
  0-9), hyphen (-), period (.), and space.
- `output_location`:
- `role_arn`: The Amazon Resource Name (ARN) of the Identity and Access Management (IAM)
  role to be assumed when DataBrew runs the job.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Configuration"`: Configuration for profile jobs. Used to select columns, do
  evaluations, and override default parameters of evaluations. When configuration is null,
  the profile job will run with default settings.
- `"EncryptionKeyArn"`: The Amazon Resource Name (ARN) of an encryption key that is used to
  protect the job.
- `"EncryptionMode"`: The encryption mode for the job, which can be one of the following:
   SSE-KMS - SSE-KMS - Server-side encryption with KMS-managed keys.    SSE-S3 - Server-side
  encryption with keys managed by Amazon S3.
- `"JobSample"`: Sample configuration for profile jobs only. Determines the number of rows
  on which the profile job will be executed. If a JobSample value is not provided, the
  default value will be used. The default value is CUSTOM_ROWS for the mode parameter and
  20000 for the size parameter.
- `"LogSubscription"`: Enables or disables Amazon CloudWatch logging for the job. If
  logging is enabled, CloudWatch writes one log stream for each job run.
- `"MaxCapacity"`: The maximum number of nodes that DataBrew can use when the job processes
  data.
- `"MaxRetries"`: The maximum number of times to retry the job after a job run fails.
- `"Tags"`: Metadata tags to apply to this job.
- `"Timeout"`: The job's timeout in minutes. A job that attempts to run longer than this
  timeout period ends with a status of TIMEOUT.
- `"ValidationConfigurations"`: List of validation configurations that are applied to the
  profile job.
"""
function create_profile_job(
    DatasetName,
    Name,
    OutputLocation,
    RoleArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return databrew(
        "POST",
        "/profileJobs",
        Dict{String,Any}(
            "DatasetName" => DatasetName,
            "Name" => Name,
            "OutputLocation" => OutputLocation,
            "RoleArn" => RoleArn,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_profile_job(
    DatasetName,
    Name,
    OutputLocation,
    RoleArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return databrew(
        "POST",
        "/profileJobs",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DatasetName" => DatasetName,
                    "Name" => Name,
                    "OutputLocation" => OutputLocation,
                    "RoleArn" => RoleArn,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_project(dataset_name, name, recipe_name, role_arn)
    create_project(dataset_name, name, recipe_name, role_arn, params::Dict{String,<:Any})

Creates a new DataBrew project.

# Arguments
- `dataset_name`: The name of an existing dataset to associate this project with.
- `name`: A unique name for the new project. Valid characters are alphanumeric (A-Z, a-z,
  0-9), hyphen (-), period (.), and space.
- `recipe_name`: The name of an existing recipe to associate with the project.
- `role_arn`: The Amazon Resource Name (ARN) of the Identity and Access Management (IAM)
  role to be assumed for this request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Sample"`:
- `"Tags"`: Metadata tags to apply to this project.
"""
function create_project(
    DatasetName,
    Name,
    RecipeName,
    RoleArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return databrew(
        "POST",
        "/projects",
        Dict{String,Any}(
            "DatasetName" => DatasetName,
            "Name" => Name,
            "RecipeName" => RecipeName,
            "RoleArn" => RoleArn,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_project(
    DatasetName,
    Name,
    RecipeName,
    RoleArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return databrew(
        "POST",
        "/projects",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DatasetName" => DatasetName,
                    "Name" => Name,
                    "RecipeName" => RecipeName,
                    "RoleArn" => RoleArn,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_recipe(name, steps)
    create_recipe(name, steps, params::Dict{String,<:Any})

Creates a new DataBrew recipe.

# Arguments
- `name`: A unique name for the recipe. Valid characters are alphanumeric (A-Z, a-z, 0-9),
  hyphen (-), period (.), and space.
- `steps`: An array containing the steps to be performed by the recipe. Each recipe step
  consists of one recipe action and (optionally) an array of condition expressions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A description for the recipe.
- `"Tags"`: Metadata tags to apply to this recipe.
"""
function create_recipe(Name, Steps; aws_config::AbstractAWSConfig=current_aws_config())
    return databrew(
        "POST",
        "/recipes",
        Dict{String,Any}("Name" => Name, "Steps" => Steps);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_recipe(
    Name,
    Steps,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return databrew(
        "POST",
        "/recipes",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Name" => Name, "Steps" => Steps), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_recipe_job(name, role_arn)
    create_recipe_job(name, role_arn, params::Dict{String,<:Any})

Creates a new job to transform input data, using steps defined in an existing Glue DataBrew
recipe

# Arguments
- `name`: A unique name for the job. Valid characters are alphanumeric (A-Z, a-z, 0-9),
  hyphen (-), period (.), and space.
- `role_arn`: The Amazon Resource Name (ARN) of the Identity and Access Management (IAM)
  role to be assumed when DataBrew runs the job.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DataCatalogOutputs"`: One or more artifacts that represent the Glue Data Catalog output
  from running the job.
- `"DatabaseOutputs"`: Represents a list of JDBC database output objects which defines the
  output destination for a DataBrew recipe job to write to.
- `"DatasetName"`: The name of the dataset that this job processes.
- `"EncryptionKeyArn"`: The Amazon Resource Name (ARN) of an encryption key that is used to
  protect the job.
- `"EncryptionMode"`: The encryption mode for the job, which can be one of the following:
   SSE-KMS - Server-side encryption with keys managed by KMS.    SSE-S3 - Server-side
  encryption with keys managed by Amazon S3.
- `"LogSubscription"`: Enables or disables Amazon CloudWatch logging for the job. If
  logging is enabled, CloudWatch writes one log stream for each job run.
- `"MaxCapacity"`: The maximum number of nodes that DataBrew can consume when the job
  processes data.
- `"MaxRetries"`: The maximum number of times to retry the job after a job run fails.
- `"Outputs"`: One or more artifacts that represent the output from running the job.
- `"ProjectName"`: Either the name of an existing project, or a combination of a recipe and
  a dataset to associate with the recipe.
- `"RecipeReference"`:
- `"Tags"`: Metadata tags to apply to this job.
- `"Timeout"`: The job's timeout in minutes. A job that attempts to run longer than this
  timeout period ends with a status of TIMEOUT.
"""
function create_recipe_job(
    Name, RoleArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return databrew(
        "POST",
        "/recipeJobs",
        Dict{String,Any}("Name" => Name, "RoleArn" => RoleArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_recipe_job(
    Name,
    RoleArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return databrew(
        "POST",
        "/recipeJobs",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("Name" => Name, "RoleArn" => RoleArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_ruleset(name, rules, target_arn)
    create_ruleset(name, rules, target_arn, params::Dict{String,<:Any})

Creates a new ruleset that can be used in a profile job to validate the data quality of a
dataset.

# Arguments
- `name`: The name of the ruleset to be created. Valid characters are alphanumeric (A-Z,
  a-z, 0-9), hyphen (-), period (.), and space.
- `rules`: A list of rules that are defined with the ruleset. A rule includes one or more
  checks to be validated on a DataBrew dataset.
- `target_arn`: The Amazon Resource Name (ARN) of a resource (dataset) that the ruleset is
  associated with.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: The description of the ruleset.
- `"Tags"`: Metadata tags to apply to the ruleset.
"""
function create_ruleset(
    Name, Rules, TargetArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return databrew(
        "POST",
        "/rulesets",
        Dict{String,Any}("Name" => Name, "Rules" => Rules, "TargetArn" => TargetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_ruleset(
    Name,
    Rules,
    TargetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return databrew(
        "POST",
        "/rulesets",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Name" => Name, "Rules" => Rules, "TargetArn" => TargetArn
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_schedule(cron_expression, name)
    create_schedule(cron_expression, name, params::Dict{String,<:Any})

Creates a new schedule for one or more DataBrew jobs. Jobs can be run at a specific date
and time, or at regular intervals.

# Arguments
- `cron_expression`: The date or dates and time or times when the jobs are to be run. For
  more information, see Cron expressions in the Glue DataBrew Developer Guide.
- `name`: A unique name for the schedule. Valid characters are alphanumeric (A-Z, a-z,
  0-9), hyphen (-), period (.), and space.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"JobNames"`: The name or names of one or more jobs to be run.
- `"Tags"`: Metadata tags to apply to this schedule.
"""
function create_schedule(
    CronExpression, Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return databrew(
        "POST",
        "/schedules",
        Dict{String,Any}("CronExpression" => CronExpression, "Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_schedule(
    CronExpression,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return databrew(
        "POST",
        "/schedules",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("CronExpression" => CronExpression, "Name" => Name),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_dataset(name)
    delete_dataset(name, params::Dict{String,<:Any})

Deletes a dataset from DataBrew.

# Arguments
- `name`: The name of the dataset to be deleted.

"""
function delete_dataset(name; aws_config::AbstractAWSConfig=current_aws_config())
    return databrew(
        "DELETE",
        "/datasets/$(name)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_dataset(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return databrew(
        "DELETE",
        "/datasets/$(name)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_job(name)
    delete_job(name, params::Dict{String,<:Any})

Deletes the specified DataBrew job.

# Arguments
- `name`: The name of the job to be deleted.

"""
function delete_job(name; aws_config::AbstractAWSConfig=current_aws_config())
    return databrew(
        "DELETE", "/jobs/$(name)"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function delete_job(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return databrew(
        "DELETE",
        "/jobs/$(name)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_project(name)
    delete_project(name, params::Dict{String,<:Any})

Deletes an existing DataBrew project.

# Arguments
- `name`: The name of the project to be deleted.

"""
function delete_project(name; aws_config::AbstractAWSConfig=current_aws_config())
    return databrew(
        "DELETE",
        "/projects/$(name)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_project(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return databrew(
        "DELETE",
        "/projects/$(name)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_recipe_version(name, recipe_version)
    delete_recipe_version(name, recipe_version, params::Dict{String,<:Any})

Deletes a single version of a DataBrew recipe.

# Arguments
- `name`: The name of the recipe.
- `recipe_version`: The version of the recipe to be deleted. You can specify a numeric
  versions (X.Y) or LATEST_WORKING. LATEST_PUBLISHED is not supported.

"""
function delete_recipe_version(
    name, recipeVersion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return databrew(
        "DELETE",
        "/recipes/$(name)/recipeVersion/$(recipeVersion)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_recipe_version(
    name,
    recipeVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return databrew(
        "DELETE",
        "/recipes/$(name)/recipeVersion/$(recipeVersion)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_ruleset(name)
    delete_ruleset(name, params::Dict{String,<:Any})

Deletes a ruleset.

# Arguments
- `name`: The name of the ruleset to be deleted.

"""
function delete_ruleset(name; aws_config::AbstractAWSConfig=current_aws_config())
    return databrew(
        "DELETE",
        "/rulesets/$(name)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_ruleset(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return databrew(
        "DELETE",
        "/rulesets/$(name)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_schedule(name)
    delete_schedule(name, params::Dict{String,<:Any})

Deletes the specified DataBrew schedule.

# Arguments
- `name`: The name of the schedule to be deleted.

"""
function delete_schedule(name; aws_config::AbstractAWSConfig=current_aws_config())
    return databrew(
        "DELETE",
        "/schedules/$(name)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_schedule(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return databrew(
        "DELETE",
        "/schedules/$(name)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_dataset(name)
    describe_dataset(name, params::Dict{String,<:Any})

Returns the definition of a specific DataBrew dataset.

# Arguments
- `name`: The name of the dataset to be described.

"""
function describe_dataset(name; aws_config::AbstractAWSConfig=current_aws_config())
    return databrew(
        "GET", "/datasets/$(name)"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_dataset(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return databrew(
        "GET",
        "/datasets/$(name)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_job(name)
    describe_job(name, params::Dict{String,<:Any})

Returns the definition of a specific DataBrew job.

# Arguments
- `name`: The name of the job to be described.

"""
function describe_job(name; aws_config::AbstractAWSConfig=current_aws_config())
    return databrew(
        "GET", "/jobs/$(name)"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_job(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return databrew(
        "GET",
        "/jobs/$(name)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_job_run(name, run_id)
    describe_job_run(name, run_id, params::Dict{String,<:Any})

Represents one run of a DataBrew job.

# Arguments
- `name`: The name of the job being processed during this run.
- `run_id`: The unique identifier of the job run.

"""
function describe_job_run(name, runId; aws_config::AbstractAWSConfig=current_aws_config())
    return databrew(
        "GET",
        "/jobs/$(name)/jobRun/$(runId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_job_run(
    name,
    runId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return databrew(
        "GET",
        "/jobs/$(name)/jobRun/$(runId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_project(name)
    describe_project(name, params::Dict{String,<:Any})

Returns the definition of a specific DataBrew project.

# Arguments
- `name`: The name of the project to be described.

"""
function describe_project(name; aws_config::AbstractAWSConfig=current_aws_config())
    return databrew(
        "GET", "/projects/$(name)"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_project(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return databrew(
        "GET",
        "/projects/$(name)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_recipe(name)
    describe_recipe(name, params::Dict{String,<:Any})

Returns the definition of a specific DataBrew recipe corresponding to a particular version.

# Arguments
- `name`: The name of the recipe to be described.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"recipeVersion"`: The recipe version identifier. If this parameter isn't specified, then
  the latest published version is returned.
"""
function describe_recipe(name; aws_config::AbstractAWSConfig=current_aws_config())
    return databrew(
        "GET", "/recipes/$(name)"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_recipe(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return databrew(
        "GET",
        "/recipes/$(name)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_ruleset(name)
    describe_ruleset(name, params::Dict{String,<:Any})

Retrieves detailed information about the ruleset.

# Arguments
- `name`: The name of the ruleset to be described.

"""
function describe_ruleset(name; aws_config::AbstractAWSConfig=current_aws_config())
    return databrew(
        "GET", "/rulesets/$(name)"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_ruleset(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return databrew(
        "GET",
        "/rulesets/$(name)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_schedule(name)
    describe_schedule(name, params::Dict{String,<:Any})

Returns the definition of a specific DataBrew schedule.

# Arguments
- `name`: The name of the schedule to be described.

"""
function describe_schedule(name; aws_config::AbstractAWSConfig=current_aws_config())
    return databrew(
        "GET", "/schedules/$(name)"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_schedule(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return databrew(
        "GET",
        "/schedules/$(name)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_datasets()
    list_datasets(params::Dict{String,<:Any})

Lists all of the DataBrew datasets.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return in this request.
- `"nextToken"`: The token returned by a previous call to retrieve the next set of results.
"""
function list_datasets(; aws_config::AbstractAWSConfig=current_aws_config())
    return databrew(
        "GET", "/datasets"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_datasets(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return databrew(
        "GET", "/datasets", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_job_runs(name)
    list_job_runs(name, params::Dict{String,<:Any})

Lists all of the previous runs of a particular DataBrew job.

# Arguments
- `name`: The name of the job.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return in this request.
- `"nextToken"`: The token returned by a previous call to retrieve the next set of results.
"""
function list_job_runs(name; aws_config::AbstractAWSConfig=current_aws_config())
    return databrew(
        "GET",
        "/jobs/$(name)/jobRuns";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_job_runs(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return databrew(
        "GET",
        "/jobs/$(name)/jobRuns",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_jobs()
    list_jobs(params::Dict{String,<:Any})

Lists all of the DataBrew jobs that are defined.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"datasetName"`: The name of a dataset. Using this parameter indicates to return only
  those jobs that act on the specified dataset.
- `"maxResults"`: The maximum number of results to return in this request.
- `"nextToken"`: A token generated by DataBrew that specifies where to continue pagination
  if a previous request was truncated. To get the next set of pages, pass in the NextToken
  value from the response object of the previous page call.
- `"projectName"`: The name of a project. Using this parameter indicates to return only
  those jobs that are associated with the specified project.
"""
function list_jobs(; aws_config::AbstractAWSConfig=current_aws_config())
    return databrew("GET", "/jobs"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_jobs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return databrew(
        "GET", "/jobs", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_projects()
    list_projects(params::Dict{String,<:Any})

Lists all of the DataBrew projects that are defined.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return in this request.
- `"nextToken"`: The token returned by a previous call to retrieve the next set of results.
"""
function list_projects(; aws_config::AbstractAWSConfig=current_aws_config())
    return databrew(
        "GET", "/projects"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_projects(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return databrew(
        "GET", "/projects", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_recipe_versions(name)
    list_recipe_versions(name, params::Dict{String,<:Any})

Lists the versions of a particular DataBrew recipe, except for LATEST_WORKING.

# Arguments
- `name`: The name of the recipe for which to return version information.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return in this request.
- `"nextToken"`: The token returned by a previous call to retrieve the next set of results.
"""
function list_recipe_versions(name; aws_config::AbstractAWSConfig=current_aws_config())
    return databrew(
        "GET",
        "/recipeVersions",
        Dict{String,Any}("name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_recipe_versions(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return databrew(
        "GET",
        "/recipeVersions",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("name" => name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_recipes()
    list_recipes(params::Dict{String,<:Any})

Lists all of the DataBrew recipes that are defined.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return in this request.
- `"nextToken"`: The token returned by a previous call to retrieve the next set of results.
- `"recipeVersion"`: Return only those recipes with a version identifier of LATEST_WORKING
  or LATEST_PUBLISHED. If RecipeVersion is omitted, ListRecipes returns all of the
  LATEST_PUBLISHED recipe versions. Valid values: LATEST_WORKING | LATEST_PUBLISHED
"""
function list_recipes(; aws_config::AbstractAWSConfig=current_aws_config())
    return databrew(
        "GET", "/recipes"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_recipes(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return databrew(
        "GET", "/recipes", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_rulesets()
    list_rulesets(params::Dict{String,<:Any})

List all rulesets available in the current account or rulesets associated with a specific
resource (dataset).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return in this request.
- `"nextToken"`: A token generated by DataBrew that specifies where to continue pagination
  if a previous request was truncated. To get the next set of pages, pass in the NextToken
  value from the response object of the previous page call.
- `"targetArn"`: The Amazon Resource Name (ARN) of a resource (dataset). Using this
  parameter indicates to return only those rulesets that are associated with the specified
  resource.
"""
function list_rulesets(; aws_config::AbstractAWSConfig=current_aws_config())
    return databrew(
        "GET", "/rulesets"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_rulesets(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return databrew(
        "GET", "/rulesets", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_schedules()
    list_schedules(params::Dict{String,<:Any})

Lists the DataBrew schedules that are defined.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"jobName"`: The name of the job that these schedules apply to.
- `"maxResults"`: The maximum number of results to return in this request.
- `"nextToken"`: The token returned by a previous call to retrieve the next set of results.
"""
function list_schedules(; aws_config::AbstractAWSConfig=current_aws_config())
    return databrew(
        "GET", "/schedules"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_schedules(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return databrew(
        "GET", "/schedules", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Lists all the tags for a DataBrew resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) string that uniquely identifies the
  DataBrew resource.

"""
function list_tags_for_resource(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return databrew(
        "GET",
        "/tags/$(ResourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return databrew(
        "GET",
        "/tags/$(ResourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    publish_recipe(name)
    publish_recipe(name, params::Dict{String,<:Any})

Publishes a new version of a DataBrew recipe.

# Arguments
- `name`: The name of the recipe to be published.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A description of the recipe to be published, for this version of the
  recipe.
"""
function publish_recipe(name; aws_config::AbstractAWSConfig=current_aws_config())
    return databrew(
        "POST",
        "/recipes/$(name)/publishRecipe";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function publish_recipe(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return databrew(
        "POST",
        "/recipes/$(name)/publishRecipe",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    send_project_session_action(name)
    send_project_session_action(name, params::Dict{String,<:Any})

Performs a recipe step within an interactive DataBrew session that's currently open.

# Arguments
- `name`: The name of the project to apply the action to.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientSessionId"`: A unique identifier for an interactive session that's currently open
  and ready for work. The action will be performed on this session.
- `"Preview"`: If true, the result of the recipe step will be returned, but not applied.
- `"RecipeStep"`:
- `"StepIndex"`: The index from which to preview a step. This index is used to preview the
  result of steps that have already been applied, so that the resulting view frame is from
  earlier in the view frame stack.
- `"ViewFrame"`:
"""
function send_project_session_action(
    name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return databrew(
        "PUT",
        "/projects/$(name)/sendProjectSessionAction";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function send_project_session_action(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return databrew(
        "PUT",
        "/projects/$(name)/sendProjectSessionAction",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_job_run(name)
    start_job_run(name, params::Dict{String,<:Any})

Runs a DataBrew job.

# Arguments
- `name`: The name of the job to be run.

"""
function start_job_run(name; aws_config::AbstractAWSConfig=current_aws_config())
    return databrew(
        "POST",
        "/jobs/$(name)/startJobRun";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_job_run(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return databrew(
        "POST",
        "/jobs/$(name)/startJobRun",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_project_session(name)
    start_project_session(name, params::Dict{String,<:Any})

Creates an interactive session, enabling you to manipulate data in a DataBrew project.

# Arguments
- `name`: The name of the project to act upon.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AssumeControl"`: A value that, if true, enables you to take control of a session, even
  if a different client is currently accessing the project.
"""
function start_project_session(name; aws_config::AbstractAWSConfig=current_aws_config())
    return databrew(
        "PUT",
        "/projects/$(name)/startProjectSession";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_project_session(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return databrew(
        "PUT",
        "/projects/$(name)/startProjectSession",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_job_run(name, run_id)
    stop_job_run(name, run_id, params::Dict{String,<:Any})

Stops a particular run of a job.

# Arguments
- `name`: The name of the job to be stopped.
- `run_id`: The ID of the job run to be stopped.

"""
function stop_job_run(name, runId; aws_config::AbstractAWSConfig=current_aws_config())
    return databrew(
        "POST",
        "/jobs/$(name)/jobRun/$(runId)/stopJobRun";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_job_run(
    name,
    runId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return databrew(
        "POST",
        "/jobs/$(name)/jobRun/$(runId)/stopJobRun",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Adds metadata tags to a DataBrew resource, such as a dataset, project, recipe, job, or
schedule.

# Arguments
- `resource_arn`: The DataBrew resource to which tags should be added. The value for this
  parameter is an Amazon Resource Name (ARN). For DataBrew, you can tag a dataset, a job, a
  project, or a recipe.
- `tags`: One or more tags to be assigned to the resource.

"""
function tag_resource(ResourceArn, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return databrew(
        "POST",
        "/tags/$(ResourceArn)",
        Dict{String,Any}("Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceArn,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return databrew(
        "POST",
        "/tags/$(ResourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Tags" => Tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes metadata tags from a DataBrew resource.

# Arguments
- `resource_arn`: A DataBrew resource from which you want to remove a tag or tags. The
  value for this parameter is an Amazon Resource Name (ARN).
- `tag_keys`: The tag keys (names) of one or more tags to be removed.

"""
function untag_resource(
    ResourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return databrew(
        "DELETE",
        "/tags/$(ResourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return databrew(
        "DELETE",
        "/tags/$(ResourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_dataset(input, name)
    update_dataset(input, name, params::Dict{String,<:Any})

Modifies the definition of an existing DataBrew dataset.

# Arguments
- `input`:
- `name`: The name of the dataset to be updated.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Format"`: The file format of a dataset that is created from an Amazon S3 file or folder.
- `"FormatOptions"`:
- `"PathOptions"`: A set of options that defines how DataBrew interprets an Amazon S3 path
  of the dataset.
"""
function update_dataset(Input, name; aws_config::AbstractAWSConfig=current_aws_config())
    return databrew(
        "PUT",
        "/datasets/$(name)",
        Dict{String,Any}("Input" => Input);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_dataset(
    Input,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return databrew(
        "PUT",
        "/datasets/$(name)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Input" => Input), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_profile_job(output_location, role_arn, name)
    update_profile_job(output_location, role_arn, name, params::Dict{String,<:Any})

Modifies the definition of an existing profile job.

# Arguments
- `output_location`:
- `role_arn`: The Amazon Resource Name (ARN) of the Identity and Access Management (IAM)
  role to be assumed when DataBrew runs the job.
- `name`: The name of the job to be updated.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Configuration"`: Configuration for profile jobs. Used to select columns, do
  evaluations, and override default parameters of evaluations. When configuration is null,
  the profile job will run with default settings.
- `"EncryptionKeyArn"`: The Amazon Resource Name (ARN) of an encryption key that is used to
  protect the job.
- `"EncryptionMode"`: The encryption mode for the job, which can be one of the following:
   SSE-KMS - Server-side encryption with keys managed by KMS.    SSE-S3 - Server-side
  encryption with keys managed by Amazon S3.
- `"JobSample"`: Sample configuration for Profile Jobs only. Determines the number of rows
  on which the Profile job will be executed. If a JobSample value is not provided for profile
  jobs, the default value will be used. The default value is CUSTOM_ROWS for the mode
  parameter and 20000 for the size parameter.
- `"LogSubscription"`: Enables or disables Amazon CloudWatch logging for the job. If
  logging is enabled, CloudWatch writes one log stream for each job run.
- `"MaxCapacity"`: The maximum number of compute nodes that DataBrew can use when the job
  processes data.
- `"MaxRetries"`: The maximum number of times to retry the job after a job run fails.
- `"Timeout"`: The job's timeout in minutes. A job that attempts to run longer than this
  timeout period ends with a status of TIMEOUT.
- `"ValidationConfigurations"`: List of validation configurations that are applied to the
  profile job.
"""
function update_profile_job(
    OutputLocation, RoleArn, name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return databrew(
        "PUT",
        "/profileJobs/$(name)",
        Dict{String,Any}("OutputLocation" => OutputLocation, "RoleArn" => RoleArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_profile_job(
    OutputLocation,
    RoleArn,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return databrew(
        "PUT",
        "/profileJobs/$(name)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("OutputLocation" => OutputLocation, "RoleArn" => RoleArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_project(role_arn, name)
    update_project(role_arn, name, params::Dict{String,<:Any})

Modifies the definition of an existing DataBrew project.

# Arguments
- `role_arn`: The Amazon Resource Name (ARN) of the IAM role to be assumed for this request.
- `name`: The name of the project to be updated.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Sample"`:
"""
function update_project(RoleArn, name; aws_config::AbstractAWSConfig=current_aws_config())
    return databrew(
        "PUT",
        "/projects/$(name)",
        Dict{String,Any}("RoleArn" => RoleArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_project(
    RoleArn,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return databrew(
        "PUT",
        "/projects/$(name)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("RoleArn" => RoleArn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_recipe(name)
    update_recipe(name, params::Dict{String,<:Any})

Modifies the definition of the LATEST_WORKING version of a DataBrew recipe.

# Arguments
- `name`: The name of the recipe to be updated.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A description of the recipe.
- `"Steps"`: One or more steps to be performed by the recipe. Each step consists of an
  action, and the conditions under which the action should succeed.
"""
function update_recipe(name; aws_config::AbstractAWSConfig=current_aws_config())
    return databrew(
        "PUT", "/recipes/$(name)"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function update_recipe(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return databrew(
        "PUT",
        "/recipes/$(name)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_recipe_job(role_arn, name)
    update_recipe_job(role_arn, name, params::Dict{String,<:Any})

Modifies the definition of an existing DataBrew recipe job.

# Arguments
- `role_arn`: The Amazon Resource Name (ARN) of the Identity and Access Management (IAM)
  role to be assumed when DataBrew runs the job.
- `name`: The name of the job to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DataCatalogOutputs"`: One or more artifacts that represent the Glue Data Catalog output
  from running the job.
- `"DatabaseOutputs"`: Represents a list of JDBC database output objects which defines the
  output destination for a DataBrew recipe job to write into.
- `"EncryptionKeyArn"`: The Amazon Resource Name (ARN) of an encryption key that is used to
  protect the job.
- `"EncryptionMode"`: The encryption mode for the job, which can be one of the following:
   SSE-KMS - Server-side encryption with keys managed by KMS.    SSE-S3 - Server-side
  encryption with keys managed by Amazon S3.
- `"LogSubscription"`: Enables or disables Amazon CloudWatch logging for the job. If
  logging is enabled, CloudWatch writes one log stream for each job run.
- `"MaxCapacity"`: The maximum number of nodes that DataBrew can consume when the job
  processes data.
- `"MaxRetries"`: The maximum number of times to retry the job after a job run fails.
- `"Outputs"`: One or more artifacts that represent the output from running the job.
- `"Timeout"`: The job's timeout in minutes. A job that attempts to run longer than this
  timeout period ends with a status of TIMEOUT.
"""
function update_recipe_job(
    RoleArn, name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return databrew(
        "PUT",
        "/recipeJobs/$(name)",
        Dict{String,Any}("RoleArn" => RoleArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_recipe_job(
    RoleArn,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return databrew(
        "PUT",
        "/recipeJobs/$(name)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("RoleArn" => RoleArn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_ruleset(rules, name)
    update_ruleset(rules, name, params::Dict{String,<:Any})

Updates specified ruleset.

# Arguments
- `rules`: A list of rules that are defined with the ruleset. A rule includes one or more
  checks to be validated on a DataBrew dataset.
- `name`: The name of the ruleset to be updated.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: The description of the ruleset.
"""
function update_ruleset(Rules, name; aws_config::AbstractAWSConfig=current_aws_config())
    return databrew(
        "PUT",
        "/rulesets/$(name)",
        Dict{String,Any}("Rules" => Rules);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_ruleset(
    Rules,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return databrew(
        "PUT",
        "/rulesets/$(name)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Rules" => Rules), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_schedule(cron_expression, name)
    update_schedule(cron_expression, name, params::Dict{String,<:Any})

Modifies the definition of an existing DataBrew schedule.

# Arguments
- `cron_expression`: The date or dates and time or times when the jobs are to be run. For
  more information, see Cron expressions in the Glue DataBrew Developer Guide.
- `name`: The name of the schedule to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"JobNames"`: The name or names of one or more jobs to be run for this schedule.
"""
function update_schedule(
    CronExpression, name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return databrew(
        "PUT",
        "/schedules/$(name)",
        Dict{String,Any}("CronExpression" => CronExpression);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_schedule(
    CronExpression,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return databrew(
        "PUT",
        "/schedules/$(name)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("CronExpression" => CronExpression), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
