# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: detective
using AWS.Compat
using AWS.UUIDs

"""
    accept_invitation(graph_arn)
    accept_invitation(graph_arn, params::Dict{String,<:Any})

Accepts an invitation for the member account to contribute data to a behavior graph. This
operation can only be called by an invited member account.  The request provides the ARN of
behavior graph. The member account status in the graph must be INVITED.

# Arguments
- `graph_arn`: The ARN of the behavior graph that the member account is accepting the
  invitation for. The member account status in the behavior graph must be INVITED.

"""
function accept_invitation(GraphArn; aws_config::AbstractAWSConfig=current_aws_config())
    return detective(
        "PUT",
        "/invitation",
        Dict{String,Any}("GraphArn" => GraphArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function accept_invitation(
    GraphArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return detective(
        "PUT",
        "/invitation",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GraphArn" => GraphArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_get_graph_member_datasources(account_ids, graph_arn)
    batch_get_graph_member_datasources(account_ids, graph_arn, params::Dict{String,<:Any})

Gets data source package information for the behavior graph.

# Arguments
- `account_ids`: The list of Amazon Web Services accounts to get data source package
  information on.
- `graph_arn`: The ARN of the behavior graph.

"""
function batch_get_graph_member_datasources(
    AccountIds, GraphArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return detective(
        "POST",
        "/graph/datasources/get",
        Dict{String,Any}("AccountIds" => AccountIds, "GraphArn" => GraphArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_get_graph_member_datasources(
    AccountIds,
    GraphArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return detective(
        "POST",
        "/graph/datasources/get",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AccountIds" => AccountIds, "GraphArn" => GraphArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_get_membership_datasources(graph_arns)
    batch_get_membership_datasources(graph_arns, params::Dict{String,<:Any})

Gets information on the data source package history for an account.

# Arguments
- `graph_arns`: The ARN of the behavior graph.

"""
function batch_get_membership_datasources(
    GraphArns; aws_config::AbstractAWSConfig=current_aws_config()
)
    return detective(
        "POST",
        "/membership/datasources/get",
        Dict{String,Any}("GraphArns" => GraphArns);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_get_membership_datasources(
    GraphArns,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return detective(
        "POST",
        "/membership/datasources/get",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GraphArns" => GraphArns), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_graph()
    create_graph(params::Dict{String,<:Any})

Creates a new behavior graph for the calling account, and sets that account as the
administrator account. This operation is called by the account that is enabling Detective.
The operation also enables Detective for the calling account in the currently selected
Region. It returns the ARN of the new behavior graph.  CreateGraph triggers a process to
create the corresponding data tables for the new behavior graph. An account can only be the
administrator account for one behavior graph within a Region. If the same account calls
CreateGraph with the same administrator account, it always returns the same behavior graph
ARN. It does not create a new behavior graph.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: The tags to assign to the new behavior graph. You can add up to 50 tags. For
  each tag, you provide the tag key and the tag value. Each tag key can contain up to 128
  characters. Each tag value can contain up to 256 characters.
"""
function create_graph(; aws_config::AbstractAWSConfig=current_aws_config())
    return detective(
        "POST", "/graph"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function create_graph(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return detective(
        "POST", "/graph", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    create_members(accounts, graph_arn)
    create_members(accounts, graph_arn, params::Dict{String,<:Any})

 CreateMembers is used to send invitations to accounts. For the organization behavior
graph, the Detective administrator account uses CreateMembers to enable organization
accounts as member accounts. For invited accounts, CreateMembers sends a request to invite
the specified Amazon Web Services accounts to be member accounts in the behavior graph.
This operation can only be called by the administrator account for a behavior graph.
CreateMembers verifies the accounts and then invites the verified accounts. The
administrator can optionally specify to not send invitation emails to the member accounts.
This would be used when the administrator manages their member accounts centrally. For
organization accounts in the organization behavior graph, CreateMembers attempts to enable
the accounts. The organization accounts do not receive invitations. The request provides
the behavior graph ARN and the list of accounts to invite or to enable. The response
separates the requested accounts into two lists:   The accounts that CreateMembers was able
to process. For invited accounts, includes member accounts that are being verified, that
have passed verification and are to be invited, and that have failed verification. For
organization accounts in the organization behavior graph, includes accounts that can be
enabled and that cannot be enabled.   The accounts that CreateMembers was unable to
process. This list includes accounts that were already invited to be member accounts in the
behavior graph.

# Arguments
- `accounts`: The list of Amazon Web Services accounts to invite or to enable. You can
  invite or enable up to 50 accounts at a time. For each invited account, the account list
  contains the account identifier and the Amazon Web Services account root user email
  address. For organization accounts in the organization behavior graph, the email address is
  not required.
- `graph_arn`: The ARN of the behavior graph.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DisableEmailNotification"`: if set to true, then the invited accounts do not receive
  email notifications. By default, this is set to false, and the invited accounts receive
  email notifications. Organization accounts in the organization behavior graph do not
  receive email notifications.
- `"Message"`: Customized message text to include in the invitation email message to the
  invited member accounts.
"""
function create_members(
    Accounts, GraphArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return detective(
        "POST",
        "/graph/members",
        Dict{String,Any}("Accounts" => Accounts, "GraphArn" => GraphArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_members(
    Accounts,
    GraphArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return detective(
        "POST",
        "/graph/members",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Accounts" => Accounts, "GraphArn" => GraphArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_graph(graph_arn)
    delete_graph(graph_arn, params::Dict{String,<:Any})

Disables the specified behavior graph and queues it to be deleted. This operation removes
the behavior graph from each member account's list of behavior graphs.  DeleteGraph can
only be called by the administrator account for a behavior graph.

# Arguments
- `graph_arn`: The ARN of the behavior graph to disable.

"""
function delete_graph(GraphArn; aws_config::AbstractAWSConfig=current_aws_config())
    return detective(
        "POST",
        "/graph/removal",
        Dict{String,Any}("GraphArn" => GraphArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_graph(
    GraphArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return detective(
        "POST",
        "/graph/removal",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GraphArn" => GraphArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_members(account_ids, graph_arn)
    delete_members(account_ids, graph_arn, params::Dict{String,<:Any})

Removes the specified member accounts from the behavior graph. The removed accounts no
longer contribute data to the behavior graph. This operation can only be called by the
administrator account for the behavior graph. For invited accounts, the removed accounts
are deleted from the list of accounts in the behavior graph. To restore the account, the
administrator account must send another invitation. For organization accounts in the
organization behavior graph, the Detective administrator account can always enable the
organization account again. Organization accounts that are not enabled as member accounts
are not included in the ListMembers results for the organization behavior graph. An
administrator account cannot use DeleteMembers to remove their own account from the
behavior graph. To disable a behavior graph, the administrator account uses the DeleteGraph
API method.

# Arguments
- `account_ids`: The list of Amazon Web Services account identifiers for the member
  accounts to remove from the behavior graph. You can remove up to 50 member accounts at a
  time.
- `graph_arn`: The ARN of the behavior graph to remove members from.

"""
function delete_members(
    AccountIds, GraphArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return detective(
        "POST",
        "/graph/members/removal",
        Dict{String,Any}("AccountIds" => AccountIds, "GraphArn" => GraphArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_members(
    AccountIds,
    GraphArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return detective(
        "POST",
        "/graph/members/removal",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AccountIds" => AccountIds, "GraphArn" => GraphArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_organization_configuration(graph_arn)
    describe_organization_configuration(graph_arn, params::Dict{String,<:Any})

Returns information about the configuration for the organization behavior graph. Currently
indicates whether to automatically enable new organization accounts as member accounts. Can
only be called by the Detective administrator account for the organization.

# Arguments
- `graph_arn`: The ARN of the organization behavior graph.

"""
function describe_organization_configuration(
    GraphArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return detective(
        "POST",
        "/orgs/describeOrganizationConfiguration",
        Dict{String,Any}("GraphArn" => GraphArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_organization_configuration(
    GraphArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return detective(
        "POST",
        "/orgs/describeOrganizationConfiguration",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GraphArn" => GraphArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_organization_admin_account()
    disable_organization_admin_account(params::Dict{String,<:Any})

Removes the Detective administrator account in the current Region. Deletes the organization
behavior graph. Can only be called by the organization management account. Removing the
Detective administrator account does not affect the delegated administrator account for
Detective in Organizations. To remove the delegated administrator account in Organizations,
use the Organizations API. Removing the delegated administrator account also removes the
Detective administrator account in all Regions, except for Regions where the Detective
administrator account is the organization management account.

"""
function disable_organization_admin_account(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return detective(
        "POST",
        "/orgs/disableAdminAccount";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_organization_admin_account(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return detective(
        "POST",
        "/orgs/disableAdminAccount",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_membership(graph_arn)
    disassociate_membership(graph_arn, params::Dict{String,<:Any})

Removes the member account from the specified behavior graph. This operation can only be
called by an invited member account that has the ENABLED status.  DisassociateMembership
cannot be called by an organization account in the organization behavior graph. For the
organization behavior graph, the Detective administrator account determines which
organization accounts to enable or disable as member accounts.

# Arguments
- `graph_arn`: The ARN of the behavior graph to remove the member account from. The member
  account's member status in the behavior graph must be ENABLED.

"""
function disassociate_membership(
    GraphArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return detective(
        "POST",
        "/membership/removal",
        Dict{String,Any}("GraphArn" => GraphArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_membership(
    GraphArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return detective(
        "POST",
        "/membership/removal",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GraphArn" => GraphArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_organization_admin_account(account_id)
    enable_organization_admin_account(account_id, params::Dict{String,<:Any})

Designates the Detective administrator account for the organization in the current Region.
If the account does not have Detective enabled, then enables Detective for that account and
creates a new behavior graph. Can only be called by the organization management account. If
the organization has a delegated administrator account in Organizations, then the Detective
administrator account must be either the delegated administrator account or the
organization management account. If the organization does not have a delegated
administrator account in Organizations, then you can choose any account in the
organization. If you choose an account other than the organization management account,
Detective calls Organizations to make that account the delegated administrator account for
Detective. The organization management account cannot be the delegated administrator
account.

# Arguments
- `account_id`: The Amazon Web Services account identifier of the account to designate as
  the Detective administrator account for the organization.

"""
function enable_organization_admin_account(
    AccountId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return detective(
        "POST",
        "/orgs/enableAdminAccount",
        Dict{String,Any}("AccountId" => AccountId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_organization_admin_account(
    AccountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return detective(
        "POST",
        "/orgs/enableAdminAccount",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("AccountId" => AccountId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_investigation(graph_arn, investigation_id)
    get_investigation(graph_arn, investigation_id, params::Dict{String,<:Any})

Detective investigations lets you investigate IAM users and IAM roles using indicators of
compromise. An indicator of compromise (IOC) is an artifact observed in or on a network,
system, or environment that can (with a high level of confidence) identify malicious
activity or a security incident. GetInvestigation returns the investigation results of an
investigation for a behavior graph.

# Arguments
- `graph_arn`: The Amazon Resource Name (ARN) of the behavior graph.
- `investigation_id`: The investigation ID of the investigation report.

"""
function get_investigation(
    GraphArn, InvestigationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return detective(
        "POST",
        "/investigations/getInvestigation",
        Dict{String,Any}("GraphArn" => GraphArn, "InvestigationId" => InvestigationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_investigation(
    GraphArn,
    InvestigationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return detective(
        "POST",
        "/investigations/getInvestigation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "GraphArn" => GraphArn, "InvestigationId" => InvestigationId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_members(account_ids, graph_arn)
    get_members(account_ids, graph_arn, params::Dict{String,<:Any})

Returns the membership details for specified member accounts for a behavior graph.

# Arguments
- `account_ids`: The list of Amazon Web Services account identifiers for the member account
  for which to return member details. You can request details for up to 50 member accounts at
  a time. You cannot use GetMembers to retrieve information about member accounts that were
  removed from the behavior graph.
- `graph_arn`: The ARN of the behavior graph for which to request the member details.

"""
function get_members(
    AccountIds, GraphArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return detective(
        "POST",
        "/graph/members/get",
        Dict{String,Any}("AccountIds" => AccountIds, "GraphArn" => GraphArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_members(
    AccountIds,
    GraphArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return detective(
        "POST",
        "/graph/members/get",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AccountIds" => AccountIds, "GraphArn" => GraphArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_datasource_packages(graph_arn)
    list_datasource_packages(graph_arn, params::Dict{String,<:Any})

Lists data source packages in the behavior graph.

# Arguments
- `graph_arn`: The ARN of the behavior graph.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of results to return.
- `"NextToken"`: For requests to get the next page of results, the pagination token that
  was returned with the previous set of results. The initial request does not include a
  pagination token.
"""
function list_datasource_packages(
    GraphArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return detective(
        "POST",
        "/graph/datasources/list",
        Dict{String,Any}("GraphArn" => GraphArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_datasource_packages(
    GraphArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return detective(
        "POST",
        "/graph/datasources/list",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GraphArn" => GraphArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_graphs()
    list_graphs(params::Dict{String,<:Any})

Returns the list of behavior graphs that the calling account is an administrator account
of. This operation can only be called by an administrator account. Because an account can
currently only be the administrator of one behavior graph within a Region, the results
always contain a single behavior graph.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of graphs to return at a time. The total must be less
  than the overall limit on the number of results to return, which is currently 200.
- `"NextToken"`: For requests to get the next page of results, the pagination token that
  was returned with the previous set of results. The initial request does not include a
  pagination token.
"""
function list_graphs(; aws_config::AbstractAWSConfig=current_aws_config())
    return detective(
        "POST", "/graphs/list"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_graphs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return detective(
        "POST",
        "/graphs/list",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_indicators(graph_arn, investigation_id)
    list_indicators(graph_arn, investigation_id, params::Dict{String,<:Any})

Gets the indicators from an investigation. You can use the information from the indicators
to determine if an IAM user and/or IAM role is involved in an unusual activity that could
indicate malicious behavior and its impact.

# Arguments
- `graph_arn`: The Amazon Resource Name (ARN) of the behavior graph.
- `investigation_id`: The investigation ID of the investigation report.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"IndicatorType"`: For the list of indicators of compromise that are generated by
  Detective investigations, see Detective investigations.
- `"MaxResults"`: Lists the maximum number of indicators in a page.
- `"NextToken"`: Lists if there are more results available. The value of nextToken is a
  unique pagination token for each page. Repeat the call using the returned token to retrieve
  the next page. Keep all other arguments unchanged. Each pagination token expires after 24
  hours. Using an expired pagination token will return a Validation Exception error.
"""
function list_indicators(
    GraphArn, InvestigationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return detective(
        "POST",
        "/investigations/listIndicators",
        Dict{String,Any}("GraphArn" => GraphArn, "InvestigationId" => InvestigationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_indicators(
    GraphArn,
    InvestigationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return detective(
        "POST",
        "/investigations/listIndicators",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "GraphArn" => GraphArn, "InvestigationId" => InvestigationId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_investigations(graph_arn)
    list_investigations(graph_arn, params::Dict{String,<:Any})

Detective investigations lets you investigate IAM users and IAM roles using indicators of
compromise. An indicator of compromise (IOC) is an artifact observed in or on a network,
system, or environment that can (with a high level of confidence) identify malicious
activity or a security incident. ListInvestigations lists all active Detective
investigations.

# Arguments
- `graph_arn`: The Amazon Resource Name (ARN) of the behavior graph.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"FilterCriteria"`: Filters the investigation results based on a criteria.
- `"MaxResults"`: Lists the maximum number of investigations in a page.
- `"NextToken"`: Lists if there are more results available. The value of nextToken is a
  unique pagination token for each page. Repeat the call using the returned token to retrieve
  the next page. Keep all other arguments unchanged. Each pagination token expires after 24
  hours. Using an expired pagination token will return a Validation Exception error.
- `"SortCriteria"`: Sorts the investigation results based on a criteria.
"""
function list_investigations(GraphArn; aws_config::AbstractAWSConfig=current_aws_config())
    return detective(
        "POST",
        "/investigations/listInvestigations",
        Dict{String,Any}("GraphArn" => GraphArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_investigations(
    GraphArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return detective(
        "POST",
        "/investigations/listInvestigations",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GraphArn" => GraphArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_invitations()
    list_invitations(params::Dict{String,<:Any})

Retrieves the list of open and accepted behavior graph invitations for the member account.
This operation can only be called by an invited member account. Open invitations are
invitations that the member account has not responded to. The results do not include
behavior graphs for which the member account declined the invitation. The results also do
not include behavior graphs that the member account resigned from or was removed from.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of behavior graph invitations to return in the
  response. The total must be less than the overall limit on the number of results to return,
  which is currently 200.
- `"NextToken"`: For requests to retrieve the next page of results, the pagination token
  that was returned with the previous page of results. The initial request does not include a
  pagination token.
"""
function list_invitations(; aws_config::AbstractAWSConfig=current_aws_config())
    return detective(
        "POST", "/invitations/list"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_invitations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return detective(
        "POST",
        "/invitations/list",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_members(graph_arn)
    list_members(graph_arn, params::Dict{String,<:Any})

Retrieves the list of member accounts for a behavior graph. For invited accounts, the
results do not include member accounts that were removed from the behavior graph. For the
organization behavior graph, the results do not include organization accounts that the
Detective administrator account has not enabled as member accounts.

# Arguments
- `graph_arn`: The ARN of the behavior graph for which to retrieve the list of member
  accounts.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of member accounts to include in the response. The
  total must be less than the overall limit on the number of results to return, which is
  currently 200.
- `"NextToken"`: For requests to retrieve the next page of member account results, the
  pagination token that was returned with the previous page of results. The initial request
  does not include a pagination token.
"""
function list_members(GraphArn; aws_config::AbstractAWSConfig=current_aws_config())
    return detective(
        "POST",
        "/graph/members/list",
        Dict{String,Any}("GraphArn" => GraphArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_members(
    GraphArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return detective(
        "POST",
        "/graph/members/list",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GraphArn" => GraphArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_organization_admin_accounts()
    list_organization_admin_accounts(params::Dict{String,<:Any})

Returns information about the Detective administrator account for an organization. Can only
be called by the organization management account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of results to return.
- `"NextToken"`: For requests to get the next page of results, the pagination token that
  was returned with the previous set of results. The initial request does not include a
  pagination token.
"""
function list_organization_admin_accounts(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return detective(
        "POST",
        "/orgs/adminAccountslist";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_organization_admin_accounts(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return detective(
        "POST",
        "/orgs/adminAccountslist",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Returns the tag values that are assigned to a behavior graph.

# Arguments
- `resource_arn`: The ARN of the behavior graph for which to retrieve the tag values.

"""
function list_tags_for_resource(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return detective(
        "GET",
        "/tags/$(ResourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return detective(
        "GET",
        "/tags/$(ResourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    reject_invitation(graph_arn)
    reject_invitation(graph_arn, params::Dict{String,<:Any})

Rejects an invitation to contribute the account data to a behavior graph. This operation
must be called by an invited member account that has the INVITED status.  RejectInvitation
cannot be called by an organization account in the organization behavior graph. In the
organization behavior graph, organization accounts do not receive an invitation.

# Arguments
- `graph_arn`: The ARN of the behavior graph to reject the invitation to. The member
  account's current member status in the behavior graph must be INVITED.

"""
function reject_invitation(GraphArn; aws_config::AbstractAWSConfig=current_aws_config())
    return detective(
        "POST",
        "/invitation/removal",
        Dict{String,Any}("GraphArn" => GraphArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function reject_invitation(
    GraphArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return detective(
        "POST",
        "/invitation/removal",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GraphArn" => GraphArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_investigation(entity_arn, graph_arn, scope_end_time, scope_start_time)
    start_investigation(entity_arn, graph_arn, scope_end_time, scope_start_time, params::Dict{String,<:Any})

Detective investigations lets you investigate IAM users and IAM roles using indicators of
compromise. An indicator of compromise (IOC) is an artifact observed in or on a network,
system, or environment that can (with a high level of confidence) identify malicious
activity or a security incident. StartInvestigation initiates an investigation on an entity
in a behavior graph.

# Arguments
- `entity_arn`: The unique Amazon Resource Name (ARN) of the IAM user and IAM role.
- `graph_arn`: The Amazon Resource Name (ARN) of the behavior graph.
- `scope_end_time`: The data and time when the investigation ended. The value is an UTC
  ISO8601 formatted string. For example, 2021-08-18T16:35:56.284Z.
- `scope_start_time`: The data and time when the investigation began. The value is an UTC
  ISO8601 formatted string. For example, 2021-08-18T16:35:56.284Z.

"""
function start_investigation(
    EntityArn,
    GraphArn,
    ScopeEndTime,
    ScopeStartTime;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return detective(
        "POST",
        "/investigations/startInvestigation",
        Dict{String,Any}(
            "EntityArn" => EntityArn,
            "GraphArn" => GraphArn,
            "ScopeEndTime" => ScopeEndTime,
            "ScopeStartTime" => ScopeStartTime,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_investigation(
    EntityArn,
    GraphArn,
    ScopeEndTime,
    ScopeStartTime,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return detective(
        "POST",
        "/investigations/startInvestigation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "EntityArn" => EntityArn,
                    "GraphArn" => GraphArn,
                    "ScopeEndTime" => ScopeEndTime,
                    "ScopeStartTime" => ScopeStartTime,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_monitoring_member(account_id, graph_arn)
    start_monitoring_member(account_id, graph_arn, params::Dict{String,<:Any})

Sends a request to enable data ingest for a member account that has a status of
ACCEPTED_BUT_DISABLED. For valid member accounts, the status is updated as follows.   If
Detective enabled the member account, then the new status is ENABLED.   If Detective cannot
enable the member account, the status remains ACCEPTED_BUT_DISABLED.

# Arguments
- `account_id`: The account ID of the member account to try to enable. The account must be
  an invited member account with a status of ACCEPTED_BUT_DISABLED.
- `graph_arn`: The ARN of the behavior graph.

"""
function start_monitoring_member(
    AccountId, GraphArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return detective(
        "POST",
        "/graph/member/monitoringstate",
        Dict{String,Any}("AccountId" => AccountId, "GraphArn" => GraphArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_monitoring_member(
    AccountId,
    GraphArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return detective(
        "POST",
        "/graph/member/monitoringstate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AccountId" => AccountId, "GraphArn" => GraphArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Applies tag values to a behavior graph.

# Arguments
- `resource_arn`: The ARN of the behavior graph to assign the tags to.
- `tags`: The tags to assign to the behavior graph. You can add up to 50 tags. For each
  tag, you provide the tag key and the tag value. Each tag key can contain up to 128
  characters. Each tag value can contain up to 256 characters.

"""
function tag_resource(ResourceArn, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return detective(
        "POST",
        "/tags/$(ResourceArn)",
        Dict{String,Any}("Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceArn,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return detective(
        "POST",
        "/tags/$(ResourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Tags" => Tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes tags from a behavior graph.

# Arguments
- `resource_arn`: The ARN of the behavior graph to remove the tags from.
- `tag_keys`: The tag keys of the tags to remove from the behavior graph. You can remove up
  to 50 tags at a time.

"""
function untag_resource(
    ResourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return detective(
        "DELETE",
        "/tags/$(ResourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return detective(
        "DELETE",
        "/tags/$(ResourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_datasource_packages(datasource_packages, graph_arn)
    update_datasource_packages(datasource_packages, graph_arn, params::Dict{String,<:Any})

Starts a data source packages for the behavior graph.

# Arguments
- `datasource_packages`: The data source package start for the behavior graph.
- `graph_arn`: The ARN of the behavior graph.

"""
function update_datasource_packages(
    DatasourcePackages, GraphArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return detective(
        "POST",
        "/graph/datasources/update",
        Dict{String,Any}(
            "DatasourcePackages" => DatasourcePackages, "GraphArn" => GraphArn
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_datasource_packages(
    DatasourcePackages,
    GraphArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return detective(
        "POST",
        "/graph/datasources/update",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DatasourcePackages" => DatasourcePackages, "GraphArn" => GraphArn
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_investigation_state(graph_arn, investigation_id, state)
    update_investigation_state(graph_arn, investigation_id, state, params::Dict{String,<:Any})

Updates the state of an investigation.

# Arguments
- `graph_arn`: The Amazon Resource Name (ARN) of the behavior graph.
- `investigation_id`: The investigation ID of the investigation report.
- `state`: The current state of the investigation. An archived investigation indicates you
  have completed reviewing the investigation.

"""
function update_investigation_state(
    GraphArn, InvestigationId, State; aws_config::AbstractAWSConfig=current_aws_config()
)
    return detective(
        "POST",
        "/investigations/updateInvestigationState",
        Dict{String,Any}(
            "GraphArn" => GraphArn, "InvestigationId" => InvestigationId, "State" => State
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_investigation_state(
    GraphArn,
    InvestigationId,
    State,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return detective(
        "POST",
        "/investigations/updateInvestigationState",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "GraphArn" => GraphArn,
                    "InvestigationId" => InvestigationId,
                    "State" => State,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_organization_configuration(graph_arn)
    update_organization_configuration(graph_arn, params::Dict{String,<:Any})

Updates the configuration for the Organizations integration in the current Region. Can only
be called by the Detective administrator account for the organization.

# Arguments
- `graph_arn`: The ARN of the organization behavior graph.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AutoEnable"`: Indicates whether to automatically enable new organization accounts as
  member accounts in the organization behavior graph.
"""
function update_organization_configuration(
    GraphArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return detective(
        "POST",
        "/orgs/updateOrganizationConfiguration",
        Dict{String,Any}("GraphArn" => GraphArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_organization_configuration(
    GraphArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return detective(
        "POST",
        "/orgs/updateOrganizationConfiguration",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GraphArn" => GraphArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
