# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: iot_events_data
using AWS.Compat
using AWS.UUIDs

"""
    batch_acknowledge_alarm(acknowledge_action_requests)
    batch_acknowledge_alarm(acknowledge_action_requests, params::Dict{String,<:Any})

Acknowledges one or more alarms. The alarms change to the ACKNOWLEDGED state after you
acknowledge them.

# Arguments
- `acknowledge_action_requests`: The list of acknowledge action requests. You can specify
  up to 10 requests per operation.

"""
function batch_acknowledge_alarm(
    acknowledgeActionRequests; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_events_data(
        "POST",
        "/alarms/acknowledge",
        Dict{String,Any}("acknowledgeActionRequests" => acknowledgeActionRequests);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_acknowledge_alarm(
    acknowledgeActionRequests,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_events_data(
        "POST",
        "/alarms/acknowledge",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("acknowledgeActionRequests" => acknowledgeActionRequests),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_delete_detector(detectors)
    batch_delete_detector(detectors, params::Dict{String,<:Any})

Deletes one or more detectors that were created. When a detector is deleted, its state will
be cleared and the detector will be removed from the list of detectors. The deleted
detector will no longer appear if referenced in the ListDetectors API call.

# Arguments
- `detectors`: The list of one or more detectors to be deleted.

"""
function batch_delete_detector(
    detectors; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_events_data(
        "POST",
        "/detectors/delete",
        Dict{String,Any}("detectors" => detectors);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_delete_detector(
    detectors,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_events_data(
        "POST",
        "/detectors/delete",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("detectors" => detectors), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_disable_alarm(disable_action_requests)
    batch_disable_alarm(disable_action_requests, params::Dict{String,<:Any})

Disables one or more alarms. The alarms change to the DISABLED state after you disable them.

# Arguments
- `disable_action_requests`: The list of disable action requests. You can specify up to 10
  requests per operation.

"""
function batch_disable_alarm(
    disableActionRequests; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_events_data(
        "POST",
        "/alarms/disable",
        Dict{String,Any}("disableActionRequests" => disableActionRequests);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_disable_alarm(
    disableActionRequests,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_events_data(
        "POST",
        "/alarms/disable",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("disableActionRequests" => disableActionRequests),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_enable_alarm(enable_action_requests)
    batch_enable_alarm(enable_action_requests, params::Dict{String,<:Any})

Enables one or more alarms. The alarms change to the NORMAL state after you enable them.

# Arguments
- `enable_action_requests`: The list of enable action requests. You can specify up to 10
  requests per operation.

"""
function batch_enable_alarm(
    enableActionRequests; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_events_data(
        "POST",
        "/alarms/enable",
        Dict{String,Any}("enableActionRequests" => enableActionRequests);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_enable_alarm(
    enableActionRequests,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_events_data(
        "POST",
        "/alarms/enable",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("enableActionRequests" => enableActionRequests),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_put_message(messages)
    batch_put_message(messages, params::Dict{String,<:Any})

Sends a set of messages to the IoT Events system. Each message payload is transformed into
the input you specify (\"inputName\") and ingested into any detectors that monitor that
input. If multiple messages are sent, the order in which the messages are processed isn't
guaranteed. To guarantee ordering, you must send messages one at a time and wait for a
successful response.

# Arguments
- `messages`: The list of messages to send. Each message has the following format: '{
  \"messageId\": \"string\", \"inputName\": \"string\", \"payload\": \"string\"}'

"""
function batch_put_message(messages; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_events_data(
        "POST",
        "/inputs/messages",
        Dict{String,Any}("messages" => messages);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_put_message(
    messages,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_events_data(
        "POST",
        "/inputs/messages",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("messages" => messages), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_reset_alarm(reset_action_requests)
    batch_reset_alarm(reset_action_requests, params::Dict{String,<:Any})

Resets one or more alarms. The alarms return to the NORMAL state after you reset them.

# Arguments
- `reset_action_requests`: The list of reset action requests. You can specify up to 10
  requests per operation.

"""
function batch_reset_alarm(
    resetActionRequests; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_events_data(
        "POST",
        "/alarms/reset",
        Dict{String,Any}("resetActionRequests" => resetActionRequests);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_reset_alarm(
    resetActionRequests,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_events_data(
        "POST",
        "/alarms/reset",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("resetActionRequests" => resetActionRequests),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_snooze_alarm(snooze_action_requests)
    batch_snooze_alarm(snooze_action_requests, params::Dict{String,<:Any})

Changes one or more alarms to the snooze mode. The alarms change to the SNOOZE_DISABLED
state after you set them to the snooze mode.

# Arguments
- `snooze_action_requests`: The list of snooze action requests. You can specify up to 10
  requests per operation.

"""
function batch_snooze_alarm(
    snoozeActionRequests; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_events_data(
        "POST",
        "/alarms/snooze",
        Dict{String,Any}("snoozeActionRequests" => snoozeActionRequests);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_snooze_alarm(
    snoozeActionRequests,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_events_data(
        "POST",
        "/alarms/snooze",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("snoozeActionRequests" => snoozeActionRequests),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_update_detector(detectors)
    batch_update_detector(detectors, params::Dict{String,<:Any})

Updates the state, variable values, and timer settings of one or more detectors (instances)
of a specified detector model.

# Arguments
- `detectors`: The list of detectors (instances) to update, along with the values to update.

"""
function batch_update_detector(
    detectors; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_events_data(
        "POST",
        "/detectors",
        Dict{String,Any}("detectors" => detectors);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_update_detector(
    detectors,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_events_data(
        "POST",
        "/detectors",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("detectors" => detectors), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_alarm(alarm_model_name)
    describe_alarm(alarm_model_name, params::Dict{String,<:Any})

Retrieves information about an alarm.

# Arguments
- `alarm_model_name`: The name of the alarm model.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"keyValue"`: The value of the key used as a filter to select only the alarms associated
  with the key.
"""
function describe_alarm(alarmModelName; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_events_data(
        "GET",
        "/alarms/$(alarmModelName)/keyValues/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_alarm(
    alarmModelName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_events_data(
        "GET",
        "/alarms/$(alarmModelName)/keyValues/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_detector(detector_model_name)
    describe_detector(detector_model_name, params::Dict{String,<:Any})

Returns information about the specified detector (instance).

# Arguments
- `detector_model_name`: The name of the detector model whose detectors (instances) you
  want information about.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"keyValue"`: A filter used to limit results to detectors (instances) created because of
  the given key ID.
"""
function describe_detector(
    detectorModelName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_events_data(
        "GET",
        "/detectors/$(detectorModelName)/keyValues/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_detector(
    detectorModelName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_events_data(
        "GET",
        "/detectors/$(detectorModelName)/keyValues/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_alarms(alarm_model_name)
    list_alarms(alarm_model_name, params::Dict{String,<:Any})

Lists one or more alarms. The operation returns only the metadata associated with each
alarm.

# Arguments
- `alarm_model_name`: The name of the alarm model.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to be returned per request.
- `"nextToken"`: The token that you can use to return the next set of results.
"""
function list_alarms(alarmModelName; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_events_data(
        "GET",
        "/alarms/$(alarmModelName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_alarms(
    alarmModelName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_events_data(
        "GET",
        "/alarms/$(alarmModelName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_detectors(detector_model_name)
    list_detectors(detector_model_name, params::Dict{String,<:Any})

Lists detectors (the instances of a detector model).

# Arguments
- `detector_model_name`: The name of the detector model whose detectors (instances) are
  listed.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to be returned per request.
- `"nextToken"`: The token that you can use to return the next set of results.
- `"stateName"`: A filter that limits results to those detectors (instances) in the given
  state.
"""
function list_detectors(
    detectorModelName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_events_data(
        "GET",
        "/detectors/$(detectorModelName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_detectors(
    detectorModelName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_events_data(
        "GET",
        "/detectors/$(detectorModelName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
