# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: launch_wizard
using AWS.Compat
using AWS.UUIDs

"""
    create_deployment(deployment_pattern_name, name, specifications, workload_name)
    create_deployment(deployment_pattern_name, name, specifications, workload_name, params::Dict{String,<:Any})

Creates a deployment for the given workload. Deployments created by this operation are not
available in the Launch Wizard console to use the Clone deployment action on.

# Arguments
- `deployment_pattern_name`: The name of the deployment pattern supported by a given
  workload. You can use the  ListWorkloadDeploymentPatterns  operation to discover supported
  values for this parameter.
- `name`: The name of the deployment.
- `specifications`: The settings specified for the deployment. These settings define how to
  deploy and configure your resources created by the deployment. For more information about
  the specifications required for creating a deployment for a SAP workload, see SAP
  deployment specifications. To retrieve the specifications required to create a deployment
  for other workloads, use the  GetWorkloadDeploymentPattern  operation.
- `workload_name`: The name of the workload. You can use the  ListWorkloads  operation to
  discover supported values for this parameter.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"tags"`: The tags to add to the deployment.
"""
function create_deployment(
    deploymentPatternName,
    name,
    specifications,
    workloadName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return launch_wizard(
        "POST",
        "/createDeployment",
        Dict{String,Any}(
            "deploymentPatternName" => deploymentPatternName,
            "name" => name,
            "specifications" => specifications,
            "workloadName" => workloadName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_deployment(
    deploymentPatternName,
    name,
    specifications,
    workloadName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return launch_wizard(
        "POST",
        "/createDeployment",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "deploymentPatternName" => deploymentPatternName,
                    "name" => name,
                    "specifications" => specifications,
                    "workloadName" => workloadName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_deployment(deployment_id)
    delete_deployment(deployment_id, params::Dict{String,<:Any})

Deletes a deployment.

# Arguments
- `deployment_id`: The ID of the deployment.

"""
function delete_deployment(deploymentId; aws_config::AbstractAWSConfig=current_aws_config())
    return launch_wizard(
        "POST",
        "/deleteDeployment",
        Dict{String,Any}("deploymentId" => deploymentId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_deployment(
    deploymentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return launch_wizard(
        "POST",
        "/deleteDeployment",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("deploymentId" => deploymentId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_deployment(deployment_id)
    get_deployment(deployment_id, params::Dict{String,<:Any})

Returns information about the deployment.

# Arguments
- `deployment_id`: The ID of the deployment.

"""
function get_deployment(deploymentId; aws_config::AbstractAWSConfig=current_aws_config())
    return launch_wizard(
        "POST",
        "/getDeployment",
        Dict{String,Any}("deploymentId" => deploymentId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_deployment(
    deploymentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return launch_wizard(
        "POST",
        "/getDeployment",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("deploymentId" => deploymentId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_workload(workload_name)
    get_workload(workload_name, params::Dict{String,<:Any})

Returns information about a workload.

# Arguments
- `workload_name`: The name of the workload.

"""
function get_workload(workloadName; aws_config::AbstractAWSConfig=current_aws_config())
    return launch_wizard(
        "POST",
        "/getWorkload",
        Dict{String,Any}("workloadName" => workloadName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_workload(
    workloadName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return launch_wizard(
        "POST",
        "/getWorkload",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("workloadName" => workloadName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_workload_deployment_pattern(deployment_pattern_name, workload_name)
    get_workload_deployment_pattern(deployment_pattern_name, workload_name, params::Dict{String,<:Any})

Returns details for a given workload and deployment pattern, including the available
specifications. You can use the ListWorkloads operation to discover the available workload
names and the ListWorkloadDeploymentPatterns operation to discover the available deployment
pattern names of a given workload.

# Arguments
- `deployment_pattern_name`: The name of the deployment pattern.
- `workload_name`: The name of the workload.

"""
function get_workload_deployment_pattern(
    deploymentPatternName, workloadName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return launch_wizard(
        "POST",
        "/getWorkloadDeploymentPattern",
        Dict{String,Any}(
            "deploymentPatternName" => deploymentPatternName, "workloadName" => workloadName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_workload_deployment_pattern(
    deploymentPatternName,
    workloadName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return launch_wizard(
        "POST",
        "/getWorkloadDeploymentPattern",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "deploymentPatternName" => deploymentPatternName,
                    "workloadName" => workloadName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_deployment_events(deployment_id)
    list_deployment_events(deployment_id, params::Dict{String,<:Any})

Lists the events of a deployment.

# Arguments
- `deployment_id`: The ID of the deployment.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output.
- `"nextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
"""
function list_deployment_events(
    deploymentId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return launch_wizard(
        "POST",
        "/listDeploymentEvents",
        Dict{String,Any}("deploymentId" => deploymentId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_deployment_events(
    deploymentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return launch_wizard(
        "POST",
        "/listDeploymentEvents",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("deploymentId" => deploymentId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_deployments()
    list_deployments(params::Dict{String,<:Any})

Lists the deployments that have been created.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filters"`: Filters to scope the results. The following filters are supported:
  WORKLOAD_NAME - The name used in deployments.    DEPLOYMENT_STATUS - COMPLETED | CREATING |
  DELETE_IN_PROGRESS | DELETE_INITIATING | DELETE_FAILED | DELETED | FAILED | IN_PROGRESS |
  VALIDATING
- `"maxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output.
- `"nextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
"""
function list_deployments(; aws_config::AbstractAWSConfig=current_aws_config())
    return launch_wizard(
        "POST", "/listDeployments"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_deployments(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return launch_wizard(
        "POST",
        "/listDeployments",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Lists the tags associated with a specified resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return launch_wizard(
        "GET",
        "/tags/$(resourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return launch_wizard(
        "GET",
        "/tags/$(resourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_workload_deployment_patterns(workload_name)
    list_workload_deployment_patterns(workload_name, params::Dict{String,<:Any})

Lists the workload deployment patterns for a given workload name. You can use the
ListWorkloads operation to discover the available workload names.

# Arguments
- `workload_name`: The name of the workload.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output.
- `"nextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
"""
function list_workload_deployment_patterns(
    workloadName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return launch_wizard(
        "POST",
        "/listWorkloadDeploymentPatterns",
        Dict{String,Any}("workloadName" => workloadName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_workload_deployment_patterns(
    workloadName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return launch_wizard(
        "POST",
        "/listWorkloadDeploymentPatterns",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("workloadName" => workloadName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_workloads()
    list_workloads(params::Dict{String,<:Any})

Lists the available workload names. You can use the ListWorkloadDeploymentPatterns
operation to discover the available deployment patterns for a given workload.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output.
- `"nextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
"""
function list_workloads(; aws_config::AbstractAWSConfig=current_aws_config())
    return launch_wizard(
        "POST", "/listWorkloads"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_workloads(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return launch_wizard(
        "POST",
        "/listWorkloads",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Adds the specified tags to the given resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource.
- `tags`: One or more tags to attach to the resource.

"""
function tag_resource(resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return launch_wizard(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return launch_wizard(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tags" => tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes the specified tags from the given resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource.
- `tag_keys`: Keys identifying the tags to remove.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return launch_wizard(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return launch_wizard(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
