# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: nimble
using AWS.Compat
using AWS.UUIDs

"""
    accept_eulas(studio_id)
    accept_eulas(studio_id, params::Dict{String,<:Any})

Accept EULAs.

# Arguments
- `studio_id`: The studio ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"X-Amz-Client-Token"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don’t specify a client token, the Amazon Web Services
  SDK automatically generates a client token and uses it for the request to ensure
  idempotency.
- `"eulaIds"`: The EULA ID.
"""
function accept_eulas(studioId; aws_config::AbstractAWSConfig=current_aws_config())
    return nimble(
        "POST",
        "/2020-08-01/studios/$(studioId)/eula-acceptances",
        Dict{String,Any}("X-Amz-Client-Token" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function accept_eulas(
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "POST",
        "/2020-08-01/studios/$(studioId)/eula-acceptances",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("X-Amz-Client-Token" => string(uuid4())), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_launch_profile(ec2_subnet_ids, launch_profile_protocol_versions, name, stream_configuration, studio_component_ids, studio_id)
    create_launch_profile(ec2_subnet_ids, launch_profile_protocol_versions, name, stream_configuration, studio_component_ids, studio_id, params::Dict{String,<:Any})

Create a launch profile.

# Arguments
- `ec2_subnet_ids`: Specifies the IDs of the EC2 subnets where streaming sessions will be
  accessible from. These subnets must support the specified instance types.
- `launch_profile_protocol_versions`: The version number of the protocol that is used by
  the launch profile. The only valid version is \"2021-03-31\".
- `name`: The name for the launch profile.
- `stream_configuration`: A configuration for a streaming session.
- `studio_component_ids`: Unique identifiers for a collection of studio components that can
  be used with this launch profile.
- `studio_id`: The studio ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"X-Amz-Client-Token"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don’t specify a client token, the Amazon Web Services
  SDK automatically generates a client token and uses it for the request to ensure
  idempotency.
- `"description"`: The description.
- `"tags"`: A collection of labels, in the form of key-value pairs, that apply to this
  resource.
"""
function create_launch_profile(
    ec2SubnetIds,
    launchProfileProtocolVersions,
    name,
    streamConfiguration,
    studioComponentIds,
    studioId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "POST",
        "/2020-08-01/studios/$(studioId)/launch-profiles",
        Dict{String,Any}(
            "ec2SubnetIds" => ec2SubnetIds,
            "launchProfileProtocolVersions" => launchProfileProtocolVersions,
            "name" => name,
            "streamConfiguration" => streamConfiguration,
            "studioComponentIds" => studioComponentIds,
            "X-Amz-Client-Token" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_launch_profile(
    ec2SubnetIds,
    launchProfileProtocolVersions,
    name,
    streamConfiguration,
    studioComponentIds,
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "POST",
        "/2020-08-01/studios/$(studioId)/launch-profiles",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ec2SubnetIds" => ec2SubnetIds,
                    "launchProfileProtocolVersions" => launchProfileProtocolVersions,
                    "name" => name,
                    "streamConfiguration" => streamConfiguration,
                    "studioComponentIds" => studioComponentIds,
                    "X-Amz-Client-Token" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_streaming_image(ec2_image_id, name, studio_id)
    create_streaming_image(ec2_image_id, name, studio_id, params::Dict{String,<:Any})

Creates a streaming image resource in a studio.

# Arguments
- `ec2_image_id`: The ID of an EC2 machine image with which to create this streaming image.
- `name`: A friendly name for a streaming image resource.
- `studio_id`: The studio ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"X-Amz-Client-Token"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don’t specify a client token, the Amazon Web Services
  SDK automatically generates a client token and uses it for the request to ensure
  idempotency.
- `"description"`: A human-readable description of the streaming image.
- `"tags"`: A collection of labels, in the form of key-value pairs, that apply to this
  resource.
"""
function create_streaming_image(
    ec2ImageId, name, studioId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return nimble(
        "POST",
        "/2020-08-01/studios/$(studioId)/streaming-images",
        Dict{String,Any}(
            "ec2ImageId" => ec2ImageId,
            "name" => name,
            "X-Amz-Client-Token" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_streaming_image(
    ec2ImageId,
    name,
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "POST",
        "/2020-08-01/studios/$(studioId)/streaming-images",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ec2ImageId" => ec2ImageId,
                    "name" => name,
                    "X-Amz-Client-Token" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_streaming_session(launch_profile_id, studio_id)
    create_streaming_session(launch_profile_id, studio_id, params::Dict{String,<:Any})

Creates a streaming session in a studio. After invoking this operation, you must poll
GetStreamingSession until the streaming session is in the READY state.

# Arguments
- `launch_profile_id`: The ID of the launch profile used to control access from the
  streaming session.
- `studio_id`: The studio ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"X-Amz-Client-Token"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don’t specify a client token, the Amazon Web Services
  SDK automatically generates a client token and uses it for the request to ensure
  idempotency.
- `"ec2InstanceType"`: The EC2 Instance type used for the streaming session.
- `"ownedBy"`: The user ID of the user that owns the streaming session. The user that owns
  the session will be logging into the session and interacting with the virtual workstation.
- `"streamingImageId"`: The ID of the streaming image.
- `"tags"`: A collection of labels, in the form of key-value pairs, that apply to this
  resource.
"""
function create_streaming_session(
    launchProfileId, studioId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return nimble(
        "POST",
        "/2020-08-01/studios/$(studioId)/streaming-sessions",
        Dict{String,Any}(
            "launchProfileId" => launchProfileId, "X-Amz-Client-Token" => string(uuid4())
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_streaming_session(
    launchProfileId,
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "POST",
        "/2020-08-01/studios/$(studioId)/streaming-sessions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "launchProfileId" => launchProfileId,
                    "X-Amz-Client-Token" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_streaming_session_stream(session_id, studio_id)
    create_streaming_session_stream(session_id, studio_id, params::Dict{String,<:Any})

Creates a streaming session stream for a streaming session. After invoking this API, invoke
GetStreamingSessionStream with the returned streamId to poll the resource until it is in
the READY state.

# Arguments
- `session_id`: The streaming session ID.
- `studio_id`: The studio ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"X-Amz-Client-Token"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don’t specify a client token, the Amazon Web Services
  SDK automatically generates a client token and uses it for the request to ensure
  idempotency.
- `"expirationInSeconds"`: The expiration time in seconds.
"""
function create_streaming_session_stream(
    sessionId, studioId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return nimble(
        "POST",
        "/2020-08-01/studios/$(studioId)/streaming-sessions/$(sessionId)/streams",
        Dict{String,Any}("X-Amz-Client-Token" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_streaming_session_stream(
    sessionId,
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "POST",
        "/2020-08-01/studios/$(studioId)/streaming-sessions/$(sessionId)/streams",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("X-Amz-Client-Token" => string(uuid4())), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_studio(admin_role_arn, display_name, studio_name, user_role_arn)
    create_studio(admin_role_arn, display_name, studio_name, user_role_arn, params::Dict{String,<:Any})

Create a new studio. When creating a studio, two IAM roles must be provided: the admin role
and the user role. These roles are assumed by your users when they log in to the Nimble
Studio portal. The user role must have the AmazonNimbleStudio-StudioUser managed policy
attached for the portal to function properly. The admin role must have the
AmazonNimbleStudio-StudioAdmin managed policy attached for the portal to function properly.
You may optionally specify a KMS key in the StudioEncryptionConfiguration. In Nimble
Studio, resource names, descriptions, initialization scripts, and other data you provide
are always encrypted at rest using an KMS key. By default, this key is owned by Amazon Web
Services and managed on your behalf. You may provide your own KMS key when calling
CreateStudio to encrypt this data using a key you own and manage. When providing an KMS key
during studio creation, Nimble Studio creates KMS grants in your account to provide your
studio user and admin roles access to these KMS keys. If you delete this grant, the studio
will no longer be accessible to your portal users. If you delete the studio KMS key, your
studio will no longer be accessible.

# Arguments
- `admin_role_arn`: The IAM role that studio admins will assume when logging in to the
  Nimble Studio portal.
- `display_name`: A friendly name for the studio.
- `studio_name`: The studio name that is used in the URL of the Nimble Studio portal when
  accessed by Nimble Studio users.
- `user_role_arn`: The IAM role that studio users will assume when logging in to the Nimble
  Studio portal.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"X-Amz-Client-Token"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don’t specify a client token, the Amazon Web Services
  SDK automatically generates a client token and uses it for the request to ensure
  idempotency.
- `"studioEncryptionConfiguration"`: The studio encryption configuration.
- `"tags"`: A collection of labels, in the form of key-value pairs, that apply to this
  resource.
"""
function create_studio(
    adminRoleArn,
    displayName,
    studioName,
    userRoleArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "POST",
        "/2020-08-01/studios",
        Dict{String,Any}(
            "adminRoleArn" => adminRoleArn,
            "displayName" => displayName,
            "studioName" => studioName,
            "userRoleArn" => userRoleArn,
            "X-Amz-Client-Token" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_studio(
    adminRoleArn,
    displayName,
    studioName,
    userRoleArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "POST",
        "/2020-08-01/studios",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "adminRoleArn" => adminRoleArn,
                    "displayName" => displayName,
                    "studioName" => studioName,
                    "userRoleArn" => userRoleArn,
                    "X-Amz-Client-Token" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_studio_component(name, studio_id, type)
    create_studio_component(name, studio_id, type, params::Dict{String,<:Any})

Creates a studio component resource.

# Arguments
- `name`: The name for the studio component.
- `studio_id`: The studio ID.
- `type`: The type of the studio component.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"X-Amz-Client-Token"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don’t specify a client token, the Amazon Web Services
  SDK automatically generates a client token and uses it for the request to ensure
  idempotency.
- `"configuration"`: The configuration of the studio component, based on component type.
- `"description"`: The description.
- `"ec2SecurityGroupIds"`: The EC2 security groups that control access to the studio
  component.
- `"initializationScripts"`: Initialization scripts for studio components.
- `"runtimeRoleArn"`: An IAM role attached to a Studio Component that gives the studio
  component access to Amazon Web Services resources at anytime while the instance is running.
- `"scriptParameters"`: Parameters for the studio component scripts.
- `"secureInitializationRoleArn"`: An IAM role attached to Studio Component when the system
  initialization script runs which give the studio component access to Amazon Web Services
  resources when the system initialization script runs.
- `"subtype"`: The specific subtype of a studio component.
- `"tags"`: A collection of labels, in the form of key-value pairs, that apply to this
  resource.
"""
function create_studio_component(
    name, studioId, type; aws_config::AbstractAWSConfig=current_aws_config()
)
    return nimble(
        "POST",
        "/2020-08-01/studios/$(studioId)/studio-components",
        Dict{String,Any}(
            "name" => name, "type" => type, "X-Amz-Client-Token" => string(uuid4())
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_studio_component(
    name,
    studioId,
    type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "POST",
        "/2020-08-01/studios/$(studioId)/studio-components",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "name" => name, "type" => type, "X-Amz-Client-Token" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_launch_profile(launch_profile_id, studio_id)
    delete_launch_profile(launch_profile_id, studio_id, params::Dict{String,<:Any})

Permanently delete a launch profile.

# Arguments
- `launch_profile_id`: The ID of the launch profile used to control access from the
  streaming session.
- `studio_id`: The studio ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"X-Amz-Client-Token"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don’t specify a client token, the Amazon Web Services
  SDK automatically generates a client token and uses it for the request to ensure
  idempotency.
"""
function delete_launch_profile(
    launchProfileId, studioId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return nimble(
        "DELETE",
        "/2020-08-01/studios/$(studioId)/launch-profiles/$(launchProfileId)",
        Dict{String,Any}("X-Amz-Client-Token" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_launch_profile(
    launchProfileId,
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "DELETE",
        "/2020-08-01/studios/$(studioId)/launch-profiles/$(launchProfileId)",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("X-Amz-Client-Token" => string(uuid4())), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_launch_profile_member(launch_profile_id, principal_id, studio_id)
    delete_launch_profile_member(launch_profile_id, principal_id, studio_id, params::Dict{String,<:Any})

Delete a user from launch profile membership.

# Arguments
- `launch_profile_id`: The ID of the launch profile used to control access from the
  streaming session.
- `principal_id`: The principal ID. This currently supports a IAM Identity Center UserId.
- `studio_id`: The studio ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"X-Amz-Client-Token"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don’t specify a client token, the Amazon Web Services
  SDK automatically generates a client token and uses it for the request to ensure
  idempotency.
"""
function delete_launch_profile_member(
    launchProfileId,
    principalId,
    studioId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "DELETE",
        "/2020-08-01/studios/$(studioId)/launch-profiles/$(launchProfileId)/membership/$(principalId)",
        Dict{String,Any}("X-Amz-Client-Token" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_launch_profile_member(
    launchProfileId,
    principalId,
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "DELETE",
        "/2020-08-01/studios/$(studioId)/launch-profiles/$(launchProfileId)/membership/$(principalId)",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("X-Amz-Client-Token" => string(uuid4())), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_streaming_image(streaming_image_id, studio_id)
    delete_streaming_image(streaming_image_id, studio_id, params::Dict{String,<:Any})

Delete streaming image.

# Arguments
- `streaming_image_id`: The streaming image ID.
- `studio_id`: The studio ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"X-Amz-Client-Token"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don’t specify a client token, the Amazon Web Services
  SDK automatically generates a client token and uses it for the request to ensure
  idempotency.
"""
function delete_streaming_image(
    streamingImageId, studioId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return nimble(
        "DELETE",
        "/2020-08-01/studios/$(studioId)/streaming-images/$(streamingImageId)",
        Dict{String,Any}("X-Amz-Client-Token" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_streaming_image(
    streamingImageId,
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "DELETE",
        "/2020-08-01/studios/$(studioId)/streaming-images/$(streamingImageId)",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("X-Amz-Client-Token" => string(uuid4())), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_streaming_session(session_id, studio_id)
    delete_streaming_session(session_id, studio_id, params::Dict{String,<:Any})

Deletes streaming session resource. After invoking this operation, use GetStreamingSession
to poll the resource until it transitions to a DELETED state. A streaming session will
count against your streaming session quota until it is marked DELETED.

# Arguments
- `session_id`: The streaming session ID.
- `studio_id`: The studio ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"X-Amz-Client-Token"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don’t specify a client token, the Amazon Web Services
  SDK automatically generates a client token and uses it for the request to ensure
  idempotency.
"""
function delete_streaming_session(
    sessionId, studioId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return nimble(
        "DELETE",
        "/2020-08-01/studios/$(studioId)/streaming-sessions/$(sessionId)",
        Dict{String,Any}("X-Amz-Client-Token" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_streaming_session(
    sessionId,
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "DELETE",
        "/2020-08-01/studios/$(studioId)/streaming-sessions/$(sessionId)",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("X-Amz-Client-Token" => string(uuid4())), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_studio(studio_id)
    delete_studio(studio_id, params::Dict{String,<:Any})

Delete a studio resource.

# Arguments
- `studio_id`: The studio ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"X-Amz-Client-Token"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don’t specify a client token, the Amazon Web Services
  SDK automatically generates a client token and uses it for the request to ensure
  idempotency.
"""
function delete_studio(studioId; aws_config::AbstractAWSConfig=current_aws_config())
    return nimble(
        "DELETE",
        "/2020-08-01/studios/$(studioId)",
        Dict{String,Any}("X-Amz-Client-Token" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_studio(
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "DELETE",
        "/2020-08-01/studios/$(studioId)",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("X-Amz-Client-Token" => string(uuid4())), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_studio_component(studio_component_id, studio_id)
    delete_studio_component(studio_component_id, studio_id, params::Dict{String,<:Any})

Deletes a studio component resource.

# Arguments
- `studio_component_id`: The studio component ID.
- `studio_id`: The studio ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"X-Amz-Client-Token"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don’t specify a client token, the Amazon Web Services
  SDK automatically generates a client token and uses it for the request to ensure
  idempotency.
"""
function delete_studio_component(
    studioComponentId, studioId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return nimble(
        "DELETE",
        "/2020-08-01/studios/$(studioId)/studio-components/$(studioComponentId)",
        Dict{String,Any}("X-Amz-Client-Token" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_studio_component(
    studioComponentId,
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "DELETE",
        "/2020-08-01/studios/$(studioId)/studio-components/$(studioComponentId)",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("X-Amz-Client-Token" => string(uuid4())), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_studio_member(principal_id, studio_id)
    delete_studio_member(principal_id, studio_id, params::Dict{String,<:Any})

Delete a user from studio membership.

# Arguments
- `principal_id`: The principal ID. This currently supports a IAM Identity Center UserId.
- `studio_id`: The studio ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"X-Amz-Client-Token"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don’t specify a client token, the Amazon Web Services
  SDK automatically generates a client token and uses it for the request to ensure
  idempotency.
"""
function delete_studio_member(
    principalId, studioId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return nimble(
        "DELETE",
        "/2020-08-01/studios/$(studioId)/membership/$(principalId)",
        Dict{String,Any}("X-Amz-Client-Token" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_studio_member(
    principalId,
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "DELETE",
        "/2020-08-01/studios/$(studioId)/membership/$(principalId)",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("X-Amz-Client-Token" => string(uuid4())), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_eula(eula_id)
    get_eula(eula_id, params::Dict{String,<:Any})

Get EULA.

# Arguments
- `eula_id`: The EULA ID.

"""
function get_eula(eulaId; aws_config::AbstractAWSConfig=current_aws_config())
    return nimble(
        "GET",
        "/2020-08-01/eulas/$(eulaId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_eula(
    eulaId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return nimble(
        "GET",
        "/2020-08-01/eulas/$(eulaId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_launch_profile(launch_profile_id, studio_id)
    get_launch_profile(launch_profile_id, studio_id, params::Dict{String,<:Any})

Get a launch profile.

# Arguments
- `launch_profile_id`: The ID of the launch profile used to control access from the
  streaming session.
- `studio_id`: The studio ID.

"""
function get_launch_profile(
    launchProfileId, studioId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/launch-profiles/$(launchProfileId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_launch_profile(
    launchProfileId,
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/launch-profiles/$(launchProfileId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_launch_profile_details(launch_profile_id, studio_id)
    get_launch_profile_details(launch_profile_id, studio_id, params::Dict{String,<:Any})

Launch profile details include the launch profile resource and summary information of
resources that are used by, or available to, the launch profile. This includes the name and
description of all studio components used by the launch profiles, and the name and
description of streaming images that can be used with this launch profile.

# Arguments
- `launch_profile_id`: The ID of the launch profile used to control access from the
  streaming session.
- `studio_id`: The studio ID.

"""
function get_launch_profile_details(
    launchProfileId, studioId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/launch-profiles/$(launchProfileId)/details";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_launch_profile_details(
    launchProfileId,
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/launch-profiles/$(launchProfileId)/details",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_launch_profile_initialization(launch_profile_id, launch_profile_protocol_versions, launch_purpose, platform, studio_id)
    get_launch_profile_initialization(launch_profile_id, launch_profile_protocol_versions, launch_purpose, platform, studio_id, params::Dict{String,<:Any})

Get a launch profile initialization.

# Arguments
- `launch_profile_id`: The ID of the launch profile used to control access from the
  streaming session.
- `launch_profile_protocol_versions`: The launch profile protocol versions supported by the
  client.
- `launch_purpose`: The launch purpose.
- `platform`: The platform where this Launch Profile will be used, either Windows or Linux.
- `studio_id`: The studio ID.

"""
function get_launch_profile_initialization(
    launchProfileId,
    launchProfileProtocolVersions,
    launchPurpose,
    platform,
    studioId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/launch-profiles/$(launchProfileId)/init",
        Dict{String,Any}(
            "launchProfileProtocolVersions" => launchProfileProtocolVersions,
            "launchPurpose" => launchPurpose,
            "platform" => platform,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_launch_profile_initialization(
    launchProfileId,
    launchProfileProtocolVersions,
    launchPurpose,
    platform,
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/launch-profiles/$(launchProfileId)/init",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "launchProfileProtocolVersions" => launchProfileProtocolVersions,
                    "launchPurpose" => launchPurpose,
                    "platform" => platform,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_launch_profile_member(launch_profile_id, principal_id, studio_id)
    get_launch_profile_member(launch_profile_id, principal_id, studio_id, params::Dict{String,<:Any})

Get a user persona in launch profile membership.

# Arguments
- `launch_profile_id`: The ID of the launch profile used to control access from the
  streaming session.
- `principal_id`: The principal ID. This currently supports a IAM Identity Center UserId.
- `studio_id`: The studio ID.

"""
function get_launch_profile_member(
    launchProfileId,
    principalId,
    studioId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/launch-profiles/$(launchProfileId)/membership/$(principalId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_launch_profile_member(
    launchProfileId,
    principalId,
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/launch-profiles/$(launchProfileId)/membership/$(principalId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_streaming_image(streaming_image_id, studio_id)
    get_streaming_image(streaming_image_id, studio_id, params::Dict{String,<:Any})

Get streaming image.

# Arguments
- `streaming_image_id`: The streaming image ID.
- `studio_id`: The studio ID.

"""
function get_streaming_image(
    streamingImageId, studioId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/streaming-images/$(streamingImageId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_streaming_image(
    streamingImageId,
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/streaming-images/$(streamingImageId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_streaming_session(session_id, studio_id)
    get_streaming_session(session_id, studio_id, params::Dict{String,<:Any})

Gets StreamingSession resource. Invoke this operation to poll for a streaming session state
while creating or deleting a session.

# Arguments
- `session_id`: The streaming session ID.
- `studio_id`: The studio ID.

"""
function get_streaming_session(
    sessionId, studioId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/streaming-sessions/$(sessionId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_streaming_session(
    sessionId,
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/streaming-sessions/$(sessionId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_streaming_session_backup(backup_id, studio_id)
    get_streaming_session_backup(backup_id, studio_id, params::Dict{String,<:Any})

Gets StreamingSessionBackup resource. Invoke this operation to poll for a streaming session
backup while stopping a streaming session.

# Arguments
- `backup_id`: The ID of the backup.
- `studio_id`: The studio ID.

"""
function get_streaming_session_backup(
    backupId, studioId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/streaming-session-backups/$(backupId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_streaming_session_backup(
    backupId,
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/streaming-session-backups/$(backupId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_streaming_session_stream(session_id, stream_id, studio_id)
    get_streaming_session_stream(session_id, stream_id, studio_id, params::Dict{String,<:Any})

Gets a StreamingSessionStream for a streaming session. Invoke this operation to poll the
resource after invoking CreateStreamingSessionStream. After the StreamingSessionStream
changes to the READY state, the url property will contain a stream to be used with the DCV
streaming client.

# Arguments
- `session_id`: The streaming session ID.
- `stream_id`: The streaming session stream ID.
- `studio_id`: The studio ID.

"""
function get_streaming_session_stream(
    sessionId, streamId, studioId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/streaming-sessions/$(sessionId)/streams/$(streamId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_streaming_session_stream(
    sessionId,
    streamId,
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/streaming-sessions/$(sessionId)/streams/$(streamId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_studio(studio_id)
    get_studio(studio_id, params::Dict{String,<:Any})

Get a studio resource.

# Arguments
- `studio_id`: The studio ID.

"""
function get_studio(studioId; aws_config::AbstractAWSConfig=current_aws_config())
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_studio(
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_studio_component(studio_component_id, studio_id)
    get_studio_component(studio_component_id, studio_id, params::Dict{String,<:Any})

Gets a studio component resource.

# Arguments
- `studio_component_id`: The studio component ID.
- `studio_id`: The studio ID.

"""
function get_studio_component(
    studioComponentId, studioId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/studio-components/$(studioComponentId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_studio_component(
    studioComponentId,
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/studio-components/$(studioComponentId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_studio_member(principal_id, studio_id)
    get_studio_member(principal_id, studio_id, params::Dict{String,<:Any})

Get a user's membership in a studio.

# Arguments
- `principal_id`: The principal ID. This currently supports a IAM Identity Center UserId.
- `studio_id`: The studio ID.

"""
function get_studio_member(
    principalId, studioId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/membership/$(principalId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_studio_member(
    principalId,
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/membership/$(principalId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_eula_acceptances(studio_id)
    list_eula_acceptances(studio_id, params::Dict{String,<:Any})

List EULA acceptances.

# Arguments
- `studio_id`: The studio ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"eulaIds"`: The list of EULA IDs that have been previously accepted.
- `"nextToken"`: The token for the next set of results, or null if there are no more
  results.
"""
function list_eula_acceptances(studioId; aws_config::AbstractAWSConfig=current_aws_config())
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/eula-acceptances";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_eula_acceptances(
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/eula-acceptances",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_eulas()
    list_eulas(params::Dict{String,<:Any})

List EULAs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"eulaIds"`: The list of EULA IDs that should be returned
- `"nextToken"`: The token for the next set of results, or null if there are no more
  results.
"""
function list_eulas(; aws_config::AbstractAWSConfig=current_aws_config())
    return nimble(
        "GET", "/2020-08-01/eulas"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_eulas(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return nimble(
        "GET",
        "/2020-08-01/eulas",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_launch_profile_members(launch_profile_id, studio_id)
    list_launch_profile_members(launch_profile_id, studio_id, params::Dict{String,<:Any})

Get all users in a given launch profile membership.

# Arguments
- `launch_profile_id`: The ID of the launch profile used to control access from the
  streaming session.
- `studio_id`: The studio ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The max number of results to return in the response.
- `"nextToken"`: The token for the next set of results, or null if there are no more
  results.
"""
function list_launch_profile_members(
    launchProfileId, studioId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/launch-profiles/$(launchProfileId)/membership";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_launch_profile_members(
    launchProfileId,
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/launch-profiles/$(launchProfileId)/membership",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_launch_profiles(studio_id)
    list_launch_profiles(studio_id, params::Dict{String,<:Any})

List all the launch profiles a studio.

# Arguments
- `studio_id`: The studio ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The max number of results to return in the response.
- `"nextToken"`: The token for the next set of results, or null if there are no more
  results.
- `"principalId"`: The principal ID. This currently supports a IAM Identity Center UserId.
- `"states"`: Filter this request to launch profiles in any of the given states.
"""
function list_launch_profiles(studioId; aws_config::AbstractAWSConfig=current_aws_config())
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/launch-profiles";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_launch_profiles(
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/launch-profiles",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_streaming_images(studio_id)
    list_streaming_images(studio_id, params::Dict{String,<:Any})

List the streaming image resources available to this studio. This list will contain both
images provided by Amazon Web Services, as well as streaming images that you have created
in your studio.

# Arguments
- `studio_id`: The studio ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: The token for the next set of results, or null if there are no more
  results.
- `"owner"`: Filter this request to streaming images with the given owner
"""
function list_streaming_images(studioId; aws_config::AbstractAWSConfig=current_aws_config())
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/streaming-images";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_streaming_images(
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/streaming-images",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_streaming_session_backups(studio_id)
    list_streaming_session_backups(studio_id, params::Dict{String,<:Any})

Lists the backups of a streaming session in a studio.

# Arguments
- `studio_id`: The studio ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: The token for the next set of results, or null if there are no more
  results.
- `"ownedBy"`: The user ID of the user that owns the streaming session.
"""
function list_streaming_session_backups(
    studioId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/streaming-session-backups";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_streaming_session_backups(
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/streaming-session-backups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_streaming_sessions(studio_id)
    list_streaming_sessions(studio_id, params::Dict{String,<:Any})

Lists the streaming sessions in a studio.

# Arguments
- `studio_id`: The studio ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"createdBy"`: Filters the request to streaming sessions created by the given user.
- `"nextToken"`: The token for the next set of results, or null if there are no more
  results.
- `"ownedBy"`: Filters the request to streaming session owned by the given user
- `"sessionIds"`: Filters the request to only the provided session IDs.
"""
function list_streaming_sessions(
    studioId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/streaming-sessions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_streaming_sessions(
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/streaming-sessions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_studio_components(studio_id)
    list_studio_components(studio_id, params::Dict{String,<:Any})

Lists the StudioComponents in a studio.

# Arguments
- `studio_id`: The studio ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The max number of results to return in the response.
- `"nextToken"`: The token for the next set of results, or null if there are no more
  results.
- `"states"`: Filters the request to studio components that are in one of the given states.
- `"types"`: Filters the request to studio components that are of one of the given types.
"""
function list_studio_components(
    studioId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/studio-components";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_studio_components(
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/studio-components",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_studio_members(studio_id)
    list_studio_members(studio_id, params::Dict{String,<:Any})

Get all users in a given studio membership.   ListStudioMembers only returns admin members.

# Arguments
- `studio_id`: The studio ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The max number of results to return in the response.
- `"nextToken"`: The token for the next set of results, or null if there are no more
  results.
"""
function list_studio_members(studioId; aws_config::AbstractAWSConfig=current_aws_config())
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/membership";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_studio_members(
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "GET",
        "/2020-08-01/studios/$(studioId)/membership",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_studios()
    list_studios(params::Dict{String,<:Any})

List studios in your Amazon Web Services accounts in the requested Amazon Web Services
Region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: The token for the next set of results, or null if there are no more
  results.
"""
function list_studios(; aws_config::AbstractAWSConfig=current_aws_config())
    return nimble(
        "GET", "/2020-08-01/studios"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_studios(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return nimble(
        "GET",
        "/2020-08-01/studios",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Gets the tags for a resource, given its Amazon Resource Names (ARN). This operation
supports ARNs for all resource types in Nimble Studio that support tags, including studio,
studio component, launch profile, streaming image, and streaming session. All resources
that can be tagged will contain an ARN property, so you do not have to create this ARN
yourself.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource for which you want to list
  tags.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return nimble(
        "GET",
        "/2020-08-01/tags/$(resourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "GET",
        "/2020-08-01/tags/$(resourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_launch_profile_members(identity_store_id, launch_profile_id, members, studio_id)
    put_launch_profile_members(identity_store_id, launch_profile_id, members, studio_id, params::Dict{String,<:Any})

Add/update users with given persona to launch profile membership.

# Arguments
- `identity_store_id`: The ID of the identity store.
- `launch_profile_id`: The ID of the launch profile used to control access from the
  streaming session.
- `members`: A list of members.
- `studio_id`: The studio ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"X-Amz-Client-Token"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don’t specify a client token, the Amazon Web Services
  SDK automatically generates a client token and uses it for the request to ensure
  idempotency.
"""
function put_launch_profile_members(
    identityStoreId,
    launchProfileId,
    members,
    studioId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "POST",
        "/2020-08-01/studios/$(studioId)/launch-profiles/$(launchProfileId)/membership",
        Dict{String,Any}(
            "identityStoreId" => identityStoreId,
            "members" => members,
            "X-Amz-Client-Token" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_launch_profile_members(
    identityStoreId,
    launchProfileId,
    members,
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "POST",
        "/2020-08-01/studios/$(studioId)/launch-profiles/$(launchProfileId)/membership",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "identityStoreId" => identityStoreId,
                    "members" => members,
                    "X-Amz-Client-Token" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_studio_members(identity_store_id, members, studio_id)
    put_studio_members(identity_store_id, members, studio_id, params::Dict{String,<:Any})

Add/update users with given persona to studio membership.

# Arguments
- `identity_store_id`: The ID of the identity store.
- `members`: A list of members.
- `studio_id`: The studio ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"X-Amz-Client-Token"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don’t specify a client token, the Amazon Web Services
  SDK automatically generates a client token and uses it for the request to ensure
  idempotency.
"""
function put_studio_members(
    identityStoreId, members, studioId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return nimble(
        "POST",
        "/2020-08-01/studios/$(studioId)/membership",
        Dict{String,Any}(
            "identityStoreId" => identityStoreId,
            "members" => members,
            "X-Amz-Client-Token" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_studio_members(
    identityStoreId,
    members,
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "POST",
        "/2020-08-01/studios/$(studioId)/membership",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "identityStoreId" => identityStoreId,
                    "members" => members,
                    "X-Amz-Client-Token" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_streaming_session(session_id, studio_id)
    start_streaming_session(session_id, studio_id, params::Dict{String,<:Any})

Transitions sessions from the STOPPED state into the READY state. The START_IN_PROGRESS
state is the intermediate state between the STOPPED and READY states.

# Arguments
- `session_id`: The streaming session ID for the StartStreamingSessionRequest.
- `studio_id`: The studio ID for the StartStreamingSessionRequest.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"X-Amz-Client-Token"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don’t specify a client token, the Amazon Web Services
  SDK automatically generates a client token and uses it for the request to ensure
  idempotency.
- `"backupId"`: The ID of the backup.
"""
function start_streaming_session(
    sessionId, studioId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return nimble(
        "POST",
        "/2020-08-01/studios/$(studioId)/streaming-sessions/$(sessionId)/start",
        Dict{String,Any}("X-Amz-Client-Token" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_streaming_session(
    sessionId,
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "POST",
        "/2020-08-01/studios/$(studioId)/streaming-sessions/$(sessionId)/start",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("X-Amz-Client-Token" => string(uuid4())), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_studio_ssoconfiguration_repair(studio_id)
    start_studio_ssoconfiguration_repair(studio_id, params::Dict{String,<:Any})

Repairs the IAM Identity Center configuration for a given studio. If the studio has a valid
IAM Identity Center configuration currently associated with it, this operation will fail
with a validation error. If the studio does not have a valid IAM Identity Center
configuration currently associated with it, then a new IAM Identity Center application is
created for the studio and the studio is changed to the READY state. After the IAM Identity
Center application is repaired, you must use the Amazon Nimble Studio console to add
administrators and users to your studio.

# Arguments
- `studio_id`: The studio ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"X-Amz-Client-Token"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don’t specify a client token, the Amazon Web Services
  SDK automatically generates a client token and uses it for the request to ensure
  idempotency.
"""
function start_studio_ssoconfiguration_repair(
    studioId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return nimble(
        "PUT",
        "/2020-08-01/studios/$(studioId)/sso-configuration",
        Dict{String,Any}("X-Amz-Client-Token" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_studio_ssoconfiguration_repair(
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "PUT",
        "/2020-08-01/studios/$(studioId)/sso-configuration",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("X-Amz-Client-Token" => string(uuid4())), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_streaming_session(session_id, studio_id)
    stop_streaming_session(session_id, studio_id, params::Dict{String,<:Any})

Transitions sessions from the READY state into the STOPPED state. The STOP_IN_PROGRESS
state is the intermediate state between the READY and STOPPED states.

# Arguments
- `session_id`: The streaming session ID for the StopStreamingSessionRequest.
- `studio_id`: The studioId for the StopStreamingSessionRequest.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"X-Amz-Client-Token"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don’t specify a client token, the Amazon Web Services
  SDK automatically generates a client token and uses it for the request to ensure
  idempotency.
- `"volumeRetentionMode"`: Adds additional instructions to a streaming session stop action
  to either retain the EBS volumes or delete the EBS volumes.
"""
function stop_streaming_session(
    sessionId, studioId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return nimble(
        "POST",
        "/2020-08-01/studios/$(studioId)/streaming-sessions/$(sessionId)/stop",
        Dict{String,Any}("X-Amz-Client-Token" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_streaming_session(
    sessionId,
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "POST",
        "/2020-08-01/studios/$(studioId)/streaming-sessions/$(sessionId)/stop",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("X-Amz-Client-Token" => string(uuid4())), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn)
    tag_resource(resource_arn, params::Dict{String,<:Any})

Creates tags for a resource, given its ARN.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource you want to add tags to.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"tags"`: A collection of labels, in the form of key-value pairs, that apply to this
  resource.
"""
function tag_resource(resourceArn; aws_config::AbstractAWSConfig=current_aws_config())
    return nimble(
        "POST",
        "/2020-08-01/tags/$(resourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "POST",
        "/2020-08-01/tags/$(resourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Deletes the tags for a resource.

# Arguments
- `resource_arn`: Identifies the Amazon Resource Name(ARN) key from which you are removing
  tags.
- `tag_keys`: One or more tag keys. Specify only the tag keys, not the tag values.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return nimble(
        "DELETE",
        "/2020-08-01/tags/$(resourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "DELETE",
        "/2020-08-01/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_launch_profile(launch_profile_id, studio_id)
    update_launch_profile(launch_profile_id, studio_id, params::Dict{String,<:Any})

Update a launch profile.

# Arguments
- `launch_profile_id`: The ID of the launch profile used to control access from the
  streaming session.
- `studio_id`: The studio ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"X-Amz-Client-Token"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don’t specify a client token, the Amazon Web Services
  SDK automatically generates a client token and uses it for the request to ensure
  idempotency.
- `"description"`: The description.
- `"launchProfileProtocolVersions"`: The version number of the protocol that is used by the
  launch profile. The only valid version is \"2021-03-31\".
- `"name"`: The name for the launch profile.
- `"streamConfiguration"`: A configuration for a streaming session.
- `"studioComponentIds"`: Unique identifiers for a collection of studio components that can
  be used with this launch profile.
"""
function update_launch_profile(
    launchProfileId, studioId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return nimble(
        "PATCH",
        "/2020-08-01/studios/$(studioId)/launch-profiles/$(launchProfileId)",
        Dict{String,Any}("X-Amz-Client-Token" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_launch_profile(
    launchProfileId,
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "PATCH",
        "/2020-08-01/studios/$(studioId)/launch-profiles/$(launchProfileId)",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("X-Amz-Client-Token" => string(uuid4())), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_launch_profile_member(launch_profile_id, persona, principal_id, studio_id)
    update_launch_profile_member(launch_profile_id, persona, principal_id, studio_id, params::Dict{String,<:Any})

Update a user persona in launch profile membership.

# Arguments
- `launch_profile_id`: The ID of the launch profile used to control access from the
  streaming session.
- `persona`: The persona.
- `principal_id`: The principal ID. This currently supports a IAM Identity Center UserId.
- `studio_id`: The studio ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"X-Amz-Client-Token"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don’t specify a client token, the Amazon Web Services
  SDK automatically generates a client token and uses it for the request to ensure
  idempotency.
"""
function update_launch_profile_member(
    launchProfileId,
    persona,
    principalId,
    studioId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "PATCH",
        "/2020-08-01/studios/$(studioId)/launch-profiles/$(launchProfileId)/membership/$(principalId)",
        Dict{String,Any}("persona" => persona, "X-Amz-Client-Token" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_launch_profile_member(
    launchProfileId,
    persona,
    principalId,
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "PATCH",
        "/2020-08-01/studios/$(studioId)/launch-profiles/$(launchProfileId)/membership/$(principalId)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "persona" => persona, "X-Amz-Client-Token" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_streaming_image(streaming_image_id, studio_id)
    update_streaming_image(streaming_image_id, studio_id, params::Dict{String,<:Any})

Update streaming image.

# Arguments
- `streaming_image_id`: The streaming image ID.
- `studio_id`: The studio ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"X-Amz-Client-Token"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don’t specify a client token, the Amazon Web Services
  SDK automatically generates a client token and uses it for the request to ensure
  idempotency.
- `"description"`: The description.
- `"name"`: The name for the streaming image.
"""
function update_streaming_image(
    streamingImageId, studioId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return nimble(
        "PATCH",
        "/2020-08-01/studios/$(studioId)/streaming-images/$(streamingImageId)",
        Dict{String,Any}("X-Amz-Client-Token" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_streaming_image(
    streamingImageId,
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "PATCH",
        "/2020-08-01/studios/$(studioId)/streaming-images/$(streamingImageId)",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("X-Amz-Client-Token" => string(uuid4())), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_studio(studio_id)
    update_studio(studio_id, params::Dict{String,<:Any})

Update a Studio resource. Currently, this operation only supports updating the displayName
of your studio.

# Arguments
- `studio_id`: The studio ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"X-Amz-Client-Token"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don’t specify a client token, the Amazon Web Services
  SDK automatically generates a client token and uses it for the request to ensure
  idempotency.
- `"adminRoleArn"`: The IAM role that Studio Admins will assume when logging in to the
  Nimble Studio portal.
- `"displayName"`: A friendly name for the studio.
- `"userRoleArn"`: The IAM role that Studio Users will assume when logging in to the Nimble
  Studio portal.
"""
function update_studio(studioId; aws_config::AbstractAWSConfig=current_aws_config())
    return nimble(
        "PATCH",
        "/2020-08-01/studios/$(studioId)",
        Dict{String,Any}("X-Amz-Client-Token" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_studio(
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "PATCH",
        "/2020-08-01/studios/$(studioId)",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("X-Amz-Client-Token" => string(uuid4())), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_studio_component(studio_component_id, studio_id)
    update_studio_component(studio_component_id, studio_id, params::Dict{String,<:Any})

Updates a studio component resource.

# Arguments
- `studio_component_id`: The studio component ID.
- `studio_id`: The studio ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"X-Amz-Client-Token"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you don’t specify a client token, the Amazon Web Services
  SDK automatically generates a client token and uses it for the request to ensure
  idempotency.
- `"configuration"`: The configuration of the studio component, based on component type.
- `"description"`: The description.
- `"ec2SecurityGroupIds"`: The EC2 security groups that control access to the studio
  component.
- `"initializationScripts"`: Initialization scripts for studio components.
- `"name"`: The name for the studio component.
- `"runtimeRoleArn"`: An IAM role attached to a Studio Component that gives the studio
  component access to Amazon Web Services resources at anytime while the instance is running.
- `"scriptParameters"`: Parameters for the studio component scripts.
- `"secureInitializationRoleArn"`: An IAM role attached to Studio Component when the system
  initialization script runs which give the studio component access to Amazon Web Services
  resources when the system initialization script runs.
- `"subtype"`: The specific subtype of a studio component.
- `"type"`: The type of the studio component.
"""
function update_studio_component(
    studioComponentId, studioId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return nimble(
        "PATCH",
        "/2020-08-01/studios/$(studioId)/studio-components/$(studioComponentId)",
        Dict{String,Any}("X-Amz-Client-Token" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_studio_component(
    studioComponentId,
    studioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return nimble(
        "PATCH",
        "/2020-08-01/studios/$(studioId)/studio-components/$(studioComponentId)",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("X-Amz-Client-Token" => string(uuid4())), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
