/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.core.parser;

import java.io.IOException;
import java.io.Reader;
import org.ec4j.core.Resource;
import org.ec4j.core.parser.EditorConfigHandler;
import org.ec4j.core.parser.ErrorEvent;
import org.ec4j.core.parser.ErrorHandler;
import org.ec4j.core.parser.Location;
import org.ec4j.core.parser.ParseContext;

public class EditorConfigParser
implements ParseContext {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private EditorConfigHandler handler;
    private ErrorHandler errorHandler;
    private Reader reader;
    private final char[] buffer;
    private int bufferOffset;
    private int index;
    private int fill;
    private int line;
    private int lineOffset;
    private int last;
    private int current;
    private final StringBuilder captureBuffer;
    private int captureStart;
    private boolean inSection = false;
    private Resource resource;

    public static Builder builder() {
        return new Builder();
    }

    public static EditorConfigParser default_() {
        return new EditorConfigParser(1024);
    }

    EditorConfigParser(int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("buffersize is zero or negative");
        }
        this.buffer = new char[bufferSize];
        this.captureBuffer = new StringBuilder();
    }

    public void parse(Resource resource, EditorConfigHandler handler2, ErrorHandler errorHandler) throws IOException {
        this.resource = resource;
        this.handler = handler2;
        this.errorHandler = errorHandler;
        this.bufferOffset = 0;
        this.index = 0;
        this.fill = 0;
        this.line = 1;
        this.lineOffset = 0;
        this.current = 0;
        this.last = -1;
        this.captureStart = -1;
        try (Reader reader = resource.openReader();){
            this.reader = reader;
            this.readLines();
            if (!this.isEndOfText()) {
                Location location = this.getLocation();
                ErrorEvent e2 = new ErrorEvent(location, location, resource, "Found unexpected character; expected end of input", ErrorEvent.ErrorType.EXPECTED_END_OF_INPUT);
                errorHandler.error(this, e2);
            }
        }
    }

    private void readLines() throws IOException {
        this.handler.startDocument(this);
        int currentLine = 0;
        do {
            this.read();
            if (currentLine == this.line) continue;
            currentLine = this.line;
            this.readLine();
        } while (!this.isEndOfText());
        if (this.inSection) {
            this.handler.endSection(this);
            this.inSection = false;
        }
        this.handler.endDocument(this);
    }

    private void readLine() throws IOException {
        this.skipWhiteSpace();
        if (this.isNewLine()) {
            this.handler.blankLine(this);
            return;
        }
        if (this.current == 65279) {
            return;
        }
        switch (this.current) {
            case 35: 
            case 59: {
                this.readComment();
                break;
            }
            case 91: {
                this.readSection();
                break;
            }
            case -1: {
                break;
            }
            default: {
                this.readProperty();
            }
        }
    }

    private void readComment() throws IOException {
        this.handler.startComment(this);
        this.startCapture();
        do {
            this.read();
        } while (!this.isEndOfText() && !this.isNewLine());
        this.handler.endComment(this, this.endCapture());
    }

    private void readSection() throws IOException {
        if (this.inSection) {
            this.handler.endSection(this);
            this.inSection = false;
        }
        this.handler.startSection(this);
        this.inSection = true;
        this.read();
        if (this.isEndOfText()) {
            this.globNotClosed();
        }
        if (this.readChar(']')) {
            return;
        }
        this.readGlob();
    }

    private void globNotClosed() {
        Location location = this.getLocation();
        ErrorEvent e2 = new ErrorEvent(location, location, this.resource, "Glob pattern not closed. Expected ']'", ErrorEvent.ErrorType.GLOB_NOT_CLOSED);
        this.errorHandler.error(this, e2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readGlob() throws IOException {
        int oldIndex;
        char c2;
        this.handler.startGlob(this);
        String globAndLBracket = this.readString(StopReading.Glob, false);
        int i2 = -1;
        int patLen = globAndLBracket.length();
        for (i2 = patLen - 1; i2 >= 0 && (c2 = globAndLBracket.charAt(i2)) != ']'; --i2) {
            if (EditorConfigParser.isWhiteSpace(c2)) continue;
            oldIndex = this.index;
            this.index -= i2;
            try {
                this.globNotClosed();
                continue;
            }
            finally {
                this.index = oldIndex;
            }
        }
        if (i2 == -1) {
            this.globNotClosed();
        }
        oldIndex = this.index;
        this.index -= patLen - i2;
        try {
            String glob = globAndLBracket.substring(0, i2);
            this.handler.endGlob(this, glob);
            ++this.index;
        }
        finally {
            this.index = oldIndex;
        }
    }

    private String readString(StopReading stop, boolean trimTrailing) throws IOException {
        this.startCapture();
        while (!this.isStopReading(stop)) {
            ErrorEvent e2;
            Location location;
            if (this.isEndOfText()) {
                location = this.getLocation();
                e2 = new ErrorEvent(location, location, this.resource, "Unexpected end of input", ErrorEvent.ErrorType.UNEXPECTED_END_OF_INPUT);
                this.errorHandler.error(this, e2);
                continue;
            }
            if (this.current < 32) {
                location = this.getLocation();
                e2 = new ErrorEvent(location, location, this.resource, "Expected a valid string character", ErrorEvent.ErrorType.EXPECTED_STRING_CHARACTER);
                this.errorHandler.error(this, e2);
                continue;
            }
            this.read();
        }
        return this.endCapture(this.index, trimTrailing);
    }

    private boolean isStopReading(StopReading stop) {
        if (this.isEndOfText() || this.isNewLine()) {
            return true;
        }
        switch (stop) {
            case Glob: {
                return (this.current == 59 || this.current == 35) && EditorConfigParser.isWhiteSpace(this.last);
            }
            case PropertyName: {
                return this.isColonSeparator() || this.isWhiteSpace();
            }
            case PropertyValue: {
                return (this.current == 59 || this.current == 35) && EditorConfigParser.isWhiteSpace(this.last);
            }
        }
        return this.isWhiteSpace();
    }

    private void readProperty() throws IOException {
        if (!this.inSection) {
            this.handler.startSection(this);
            this.inSection = true;
        }
        this.handler.startProperty(this);
        this.skipWhiteSpace();
        this.handler.startPropertyName(this);
        String name2 = EditorConfigParser.preprocessPropertyName(this.readString(StopReading.PropertyName, false));
        this.handler.endPropertyName(this, name2);
        this.skipWhiteSpace();
        if (!this.readChar('=') && !this.readChar(':')) {
            Location location = this.getLocation();
            ErrorEvent e2 = new ErrorEvent(location, location, this.resource, "Equals sign '=' missing after property name '" + name2 + "'", ErrorEvent.ErrorType.PROPERTY_ASSIGNMENT_MISSING);
            this.errorHandler.error(this, e2);
        }
        this.skipWhiteSpace();
        this.handler.startPropertyValue(this);
        String value2 = this.readString(StopReading.PropertyValue, true);
        this.handler.endPropertyValue(this, value2);
        this.handler.endProperty(this);
    }

    private boolean readChar(char ch) throws IOException {
        if (this.current != ch) {
            return false;
        }
        this.read();
        return true;
    }

    private void skipWhiteSpace() throws IOException {
        while (this.isWhiteSpace()) {
            this.read();
        }
    }

    private void read() throws IOException {
        if (this.index == this.fill) {
            if (this.captureStart != -1) {
                this.captureBuffer.append(this.buffer, this.captureStart, this.fill - this.captureStart);
                this.captureStart = 0;
            }
            this.bufferOffset += this.fill;
            this.fill = this.reader.read(this.buffer, 0, this.buffer.length);
            this.index = 0;
            if (this.fill == -1) {
                this.current = -1;
                this.last = -1;
                ++this.index;
                return;
            }
        }
        if (this.current == 10) {
            ++this.line;
            this.lineOffset = this.bufferOffset + this.index;
        }
        this.last = this.current;
        this.current = this.buffer[this.index++];
    }

    private void startCapture() {
        this.captureStart = this.index - 1;
    }

    private String endCapture() {
        return this.endCapture(this.index, false);
    }

    private String endCapture(int index, boolean trimTrailing) {
        int start = this.captureStart;
        int end = index - 1;
        this.captureStart = -1;
        if (trimTrailing) {
            char c2;
            while (end - 1 >= start && EditorConfigParser.isWhiteSpace(c2 = this.buffer[end - 1])) {
                --end;
            }
        }
        int len = end - start;
        if (this.captureBuffer.length() > 0) {
            if (len > 0) {
                this.captureBuffer.append(this.buffer, start, len);
            }
            if (trimTrailing) {
                char c3;
                int i2 = this.captureBuffer.length();
                while (i2 - 1 >= 0 && EditorConfigParser.isWhiteSpace(c3 = this.captureBuffer.charAt(i2 - 1))) {
                    --i2;
                }
                this.captureBuffer.setLength(i2);
            }
            String captured = this.captureBuffer.toString();
            this.captureBuffer.setLength(0);
            return captured;
        }
        if (len > 0) {
            return new String(this.buffer, start, len);
        }
        return "";
    }

    @Override
    public Location getLocation() {
        int offset = this.bufferOffset + this.index - 1;
        int column = offset - this.lineOffset + 1;
        return new Location(offset, this.line, column);
    }

    private boolean isWhiteSpace() {
        return EditorConfigParser.isWhiteSpace(this.current);
    }

    private static boolean isWhiteSpace(int c2) {
        return c2 == 32 || c2 == 9;
    }

    private boolean isNewLine() {
        return this.isNewLine(this.current);
    }

    private boolean isNewLine(int c2) {
        return c2 == 10 || c2 == 13;
    }

    private boolean isEndOfText() {
        return this.current == -1;
    }

    private boolean isColonSeparator() {
        return this.current == 61 || this.current == 58;
    }

    private static String preprocessPropertyName(String name2) {
        if (name2 == null) {
            return name2;
        }
        return name2.toLowerCase();
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    private static enum StopReading {
        Glob,
        PropertyName,
        PropertyValue;

    }

    public static class Builder {
        private int bufferSize = 1024;

        public Builder bufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public EditorConfigParser build() {
            return new EditorConfigParser(this.bufferSize);
        }
    }
}

