/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.konan;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.konan.FileWithMetadata;
import org.jetbrains.kotlin.analysis.decompiler.konan.KlibDecompiledFile;
import org.jetbrains.kotlin.analysis.decompiler.konan.KlibMetadataStubBuilder;
import org.jetbrains.kotlin.analysis.decompiler.psi.KotlinDecompiledFileViewProvider;
import org.jetbrains.kotlin.analysis.decompiler.psi.file.KtDecompiledFile;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.DecompiledText;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.IncompatibleAbiVersionKt;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileTypeRegistry;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.compiled.ClassFileDecompilers;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;
import org.jetbrains.kotlin.serialization.deserialization.FlexibleTypeDeserializer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H$J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH$J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u001c\u001a\u00020\u000eH\u0016J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001bH\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0004J\u0010\u0010#\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0014H\u0002J\u0015\u0010$\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b%R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u000eX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/konan/KlibMetadataDecompiler;", "V", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "Lorg/jetbrains/kotlin/com/intellij/psi/compiled/ClassFileDecompilers$Full;", "fileType", "Lorg/jetbrains/kotlin/com/intellij/openapi/fileTypes/FileType;", "serializerProtocol", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "flexibleTypeDeserializer", "Lorg/jetbrains/kotlin/serialization/deserialization/FlexibleTypeDeserializer;", "<init>", "(Lcom/intellij/openapi/fileTypes/FileType;Lkotlin/jvm/functions/Function0;Lorg/jetbrains/kotlin/serialization/deserialization/FlexibleTypeDeserializer;)V", "metadataStubBuilder", "Lorg/jetbrains/kotlin/analysis/decompiler/konan/KlibMetadataStubBuilder;", "getMetadataStubBuilder", "()Lorg/jetbrains/kotlin/analysis/decompiler/konan/KlibMetadataStubBuilder;", "doReadFile", "Lorg/jetbrains/kotlin/analysis/decompiler/konan/FileWithMetadata;", "file", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "getDecompiledText", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/text/DecompiledText;", "fileWithMetadata", "Lorg/jetbrains/kotlin/analysis/decompiler/konan/FileWithMetadata$Compatible;", "virtualFile", "accepts", "", "getStubBuilder", "createFileViewProvider", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/KotlinDecompiledFileViewProvider;", "manager", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiManager;", "physical", "readFileSafely", "buildDecompiledText", "buildDecompiledTextForTests", "buildDecompiledTextForTests$decompiler_native", "decompiler-native"})
@SourceDebugExtension(value={"SMAP\nKlibMetadataDecompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KlibMetadataDecompiler.kt\norg/jetbrains/kotlin/analysis/decompiler/konan/KlibMetadataDecompiler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
public abstract class KlibMetadataDecompiler<V extends BinaryVersion>
extends ClassFileDecompilers.Full {
    @NotNull
    private final FileType fileType;
    @NotNull
    private final Function0<SerializerExtensionProtocol> serializerProtocol;
    @NotNull
    private final FlexibleTypeDeserializer flexibleTypeDeserializer;

    public KlibMetadataDecompiler(@NotNull FileType fileType, @NotNull Function0<? extends SerializerExtensionProtocol> serializerProtocol, @NotNull FlexibleTypeDeserializer flexibleTypeDeserializer) {
        Intrinsics.checkNotNullParameter(fileType, "fileType");
        Intrinsics.checkNotNullParameter(serializerProtocol, "serializerProtocol");
        Intrinsics.checkNotNullParameter(flexibleTypeDeserializer, "flexibleTypeDeserializer");
        this.fileType = fileType;
        this.serializerProtocol = serializerProtocol;
        this.flexibleTypeDeserializer = flexibleTypeDeserializer;
    }

    @NotNull
    protected abstract KlibMetadataStubBuilder getMetadataStubBuilder();

    @Nullable
    protected abstract FileWithMetadata doReadFile(@NotNull VirtualFile var1);

    @NotNull
    protected abstract DecompiledText getDecompiledText(@NotNull FileWithMetadata.Compatible var1, @NotNull VirtualFile var2, @NotNull SerializerExtensionProtocol var3, @NotNull FlexibleTypeDeserializer var4);

    @Override
    public boolean accepts(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter(file, "file");
        return FileTypeRegistry.getInstance().isFileOfType(file, this.fileType);
    }

    @Override
    @NotNull
    public KlibMetadataStubBuilder getStubBuilder() {
        return this.getMetadataStubBuilder();
    }

    @Override
    @NotNull
    public KotlinDecompiledFileViewProvider createFileViewProvider(@NotNull VirtualFile file, @NotNull PsiManager manager, boolean physical) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(manager, "manager");
        return new KotlinDecompiledFileViewProvider(manager, file, physical, arg_0 -> KlibMetadataDecompiler.createFileViewProvider$lambda$0(this, arg_0));
    }

    @Nullable
    protected final FileWithMetadata readFileSafely(@NotNull VirtualFile file) {
        FileWithMetadata fileWithMetadata;
        Intrinsics.checkNotNullParameter(file, "file");
        if (!file.isValid()) {
            return null;
        }
        try {
            fileWithMetadata = this.doReadFile(file);
        }
        catch (IOException e2) {
            fileWithMetadata = null;
        }
        return fileWithMetadata;
    }

    private final DecompiledText buildDecompiledText(VirtualFile virtualFile) {
        DecompiledText decompiledText;
        boolean bl = FileTypeRegistry.getInstance().isFileOfType(virtualFile, this.fileType);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Unexpected file type " + virtualFile.getFileType();
            throw new AssertionError((Object)string);
        }
        FileWithMetadata fileWithMetadata = this.readFileSafely(virtualFile);
        if (fileWithMetadata instanceof FileWithMetadata.Incompatible) {
            decompiledText = IncompatibleAbiVersionKt.createIncompatibleMetadataVersionDecompiledText((BinaryVersion)MetadataVersion.INSTANCE_NEXT, ((FileWithMetadata.Incompatible)fileWithMetadata).getVersion());
        } else if (fileWithMetadata instanceof FileWithMetadata.Compatible) {
            decompiledText = this.getDecompiledText((FileWithMetadata.Compatible)fileWithMetadata, virtualFile, this.serializerProtocol.invoke(), this.flexibleTypeDeserializer);
        } else if (fileWithMetadata == null) {
            decompiledText = IncompatibleAbiVersionKt.createIncompatibleMetadataVersionDecompiledText((BinaryVersion)MetadataVersion.INSTANCE_NEXT, (BinaryVersion)MetadataVersion.INVALID_VERSION);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return decompiledText;
    }

    @NotNull
    public final DecompiledText buildDecompiledTextForTests$decompiler_native(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter(virtualFile, "virtualFile");
        return this.buildDecompiledText(virtualFile);
    }

    private static final KtDecompiledFile createFileViewProvider$lambda$0(KlibMetadataDecompiler this$0, KotlinDecompiledFileViewProvider provider2) {
        Intrinsics.checkNotNullParameter(provider2, "provider");
        return new KlibDecompiledFile(provider2, (Function1<? super VirtualFile, DecompiledText>)new Function1<VirtualFile, DecompiledText>((Object)this$0){

            public final DecompiledText invoke(VirtualFile p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return KlibMetadataDecompiler.access$buildDecompiledText((KlibMetadataDecompiler)this.receiver, p0);
            }
        });
    }

    public static final /* synthetic */ DecompiledText access$buildDecompiledText(KlibMetadataDecompiler $this, VirtualFile virtualFile) {
        return $this.buildDecompiledText(virtualFile);
    }
}

