/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameIdentifierOwner;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.LightTreeSourceNavigator;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportAlias;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u0004\u0018\u0001H\u0005\"\n\b\u0000\u0010\u0005\u0018\u0001*\u00020\u0006*\u00020\u0007H\u0082\b\u00a2\u0006\u0002\u0010\bJ \u0010\u0004\u001a\u0004\u0018\u0001H\u0005\"\n\b\u0000\u0010\u0005\u0018\u0001*\u00020\u0006*\u00020\tH\u0082\b\u00a2\u0006\u0002\u0010\nJ\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\tH\u0016J\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u0006H\u0002J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0012H\u0016J\f\u0010\u0013\u001a\u00020\f*\u00020\u0014H\u0016J\f\u0010\u0015\u001a\u00020\f*\u00020\rH\u0016J\u0013\u0010\u0016\u001a\u0004\u0018\u00010\f*\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0019\u001a\u0004\u0018\u00010\f*\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/PsiSourceNavigator;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/LightTreeSourceNavigator;", "<init>", "()V", "psi", "P", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/fir/FirElement;", "(Lorg/jetbrains/kotlin/fir/FirElement;)Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/KtSourceElement;", "(Lorg/jetbrains/kotlin/KtSourceElement;)Lcom/intellij/psi/PsiElement;", "isInConstructorCallee", "", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "getRawIdentifier", "", "getRawName", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "isCatchElementParameter", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "isRedundantNullable", "hasBody", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "(Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;)Ljava/lang/Boolean;", "hasInitializer", "checkers"})
@SourceDebugExtension(value={"SMAP\nSourceNavigator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceNavigator.kt\norg/jetbrains/kotlin/fir/analysis/checkers/PsiSourceNavigator\n*L\n1#1,204:1\n162#1,2:205\n159#1,5:207\n162#1,2:212\n159#1,5:214\n162#1,2:219\n*S KotlinDebug\n*F\n+ 1 SourceNavigator.kt\norg/jetbrains/kotlin/fir/analysis/checkers/PsiSourceNavigator\n*L\n159#1:205,2\n166#1:207,5\n168#1:212,2\n180#1:214,5\n184#1:219,2\n*E\n"})
final class PsiSourceNavigator
extends LightTreeSourceNavigator {
    @NotNull
    public static final PsiSourceNavigator INSTANCE = new PsiSourceNavigator();

    private PsiSourceNavigator() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isInConstructorCallee(@NotNull FirTypeRef $this$isInConstructorCallee) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter($this$isInConstructorCallee, "<this>");
        PsiSourceNavigator psiSourceNavigator = this;
        FirElement $this$psi$iv = $this$isInConstructorCallee;
        boolean $i$f$psi = false;
        KtSourceElement ktSourceElement = $this$psi$iv.getSource();
        if (ktSourceElement != null) {
            void this_$iv;
            void var6_6 = this_$iv;
            KtSourceElement $this$psi$iv$iv = ktSourceElement;
            boolean $i$f$psi2 = false;
            KtPsiSourceElement ktPsiSourceElement = $this$psi$iv$iv instanceof KtPsiSourceElement ? (KtPsiSourceElement)$this$psi$iv$iv : null;
            PsiElement psi$iv$iv = ktPsiSourceElement != null ? ktPsiSourceElement.getPsi() : null;
            PsiElement psiElement2 = psi$iv$iv;
            if (!(psiElement2 instanceof KtTypeReference)) {
                psiElement2 = null;
            }
            psiElement = (KtTypeReference)psiElement2;
        } else {
            psiElement = null;
        }
        KtTypeReference ktTypeReference = (KtTypeReference)psiElement;
        return (ktTypeReference != null ? ktTypeReference.getParent() : null) instanceof KtConstructorCalleeExpression;
    }

    @Override
    @Nullable
    public CharSequence getRawIdentifier(@NotNull KtSourceElement $this$getRawIdentifier) {
        Intrinsics.checkNotNullParameter($this$getRawIdentifier, "<this>");
        PsiSourceNavigator psiSourceNavigator = this;
        KtSourceElement $this$psi$iv = $this$getRawIdentifier;
        boolean $i$f$psi = false;
        KtPsiSourceElement ktPsiSourceElement = $this$psi$iv instanceof KtPsiSourceElement ? (KtPsiSourceElement)$this$psi$iv : null;
        PsiElement psi$iv = ktPsiSourceElement != null ? ktPsiSourceElement.getPsi() : null;
        PsiElement psiElement = psi$iv;
        if (!(psiElement instanceof PsiElement)) {
            psiElement = null;
        }
        return psiElement != null ? this.getRawIdentifier(psiElement) : null;
    }

    private final CharSequence getRawIdentifier(PsiElement $this$getRawIdentifier) {
        CharSequence charSequence;
        PsiElement psiElement = $this$getRawIdentifier;
        if (psiElement instanceof KtNameReferenceExpression) {
            charSequence = ((KtNameReferenceExpression)$this$getRawIdentifier).getReferencedNameElement().getNode().getChars();
        } else if (psiElement instanceof KtTypeProjection) {
            KtElement ktElement = ((KtTypeProjection)$this$getRawIdentifier).getTypeReference();
            charSequence = ktElement != null && (ktElement = ((KtTypeReference)ktElement).getTypeElement()) != null ? ktElement.getText() : null;
        } else if (psiElement instanceof LeafPsiElement && Intrinsics.areEqual(((LeafPsiElement)$this$getRawIdentifier).getElementType(), KtTokens.IDENTIFIER)) {
            charSequence = ((LeafPsiElement)$this$getRawIdentifier).getChars();
        } else if (psiElement instanceof KtQualifiedExpression) {
            KtExpression ktExpression = ((KtQualifiedExpression)$this$getRawIdentifier).getSelectorExpression();
            charSequence = ktExpression != null ? this.getRawIdentifier(ktExpression) : null;
        } else {
            charSequence = psiElement instanceof KtImportAlias ? (CharSequence)((KtImportAlias)$this$getRawIdentifier).getName() : null;
        }
        return charSequence;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String getRawName(@NotNull FirDeclaration $this$getRawName) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter($this$getRawName, "<this>");
        PsiSourceNavigator psiSourceNavigator = this;
        FirElement $this$psi$iv = $this$getRawName;
        boolean $i$f$psi = false;
        KtSourceElement ktSourceElement = $this$psi$iv.getSource();
        if (ktSourceElement != null) {
            void this_$iv;
            void var7_6 = this_$iv;
            KtSourceElement $this$psi$iv$iv = ktSourceElement;
            boolean $i$f$psi2 = false;
            KtPsiSourceElement ktPsiSourceElement = $this$psi$iv$iv instanceof KtPsiSourceElement ? (KtPsiSourceElement)$this$psi$iv$iv : null;
            PsiElement psi$iv$iv = ktPsiSourceElement != null ? ktPsiSourceElement.getPsi() : null;
            PsiElement psiElement2 = psi$iv$iv;
            if (!(psiElement2 instanceof PsiNameIdentifierOwner)) {
                psiElement2 = null;
            }
            psiElement = (PsiNameIdentifierOwner)psiElement2;
        } else {
            psiElement = null;
        }
        PsiElement psiElement3 = psiElement;
        PsiElement psiElement4 = psiElement3 instanceof PsiNameIdentifierOwner ? (PsiNameIdentifierOwner)psiElement3 : null;
        return psiElement4 != null && (psiElement4 = psiElement4.getNameIdentifier()) != null ? psiElement4.getText() : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean isCatchElementParameter(@NotNull FirValueParameterSymbol $this$isCatchElementParameter) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter($this$isCatchElementParameter, "<this>");
        KtSourceElement ktSourceElement = $this$isCatchElementParameter.getSource();
        if (ktSourceElement != null) {
            PsiElement psiElement2;
            Object object = this;
            KtSourceElement $this$psi$iv = ktSourceElement;
            boolean $i$f$psi = false;
            KtPsiSourceElement ktPsiSourceElement = $this$psi$iv instanceof KtPsiSourceElement ? (KtPsiSourceElement)$this$psi$iv : null;
            PsiElement psi$iv = ktPsiSourceElement != null ? ktPsiSourceElement.getPsi() : null;
            PsiElement psiElement3 = psi$iv;
            if (!(psiElement3 instanceof PsiElement)) {
                psiElement3 = null;
            }
            if ((psiElement2 = psiElement3) != null && (object = psiElement2.getParent()) != null) {
                psiElement = object.getParent();
                return psiElement instanceof KtCatchClause;
            }
        }
        psiElement = null;
        return psiElement instanceof KtCatchClause;
    }

    @Override
    public boolean isRedundantNullable(@NotNull FirTypeRef $this$isRedundantNullable) {
        Intrinsics.checkNotNullParameter($this$isRedundantNullable, "<this>");
        KtSourceElement ktSourceElement = $this$isRedundantNullable.getSource();
        if (ktSourceElement == null) {
            return false;
        }
        KtSourceElement source = ktSourceElement;
        PsiElement psiElement = KtSourceElementKt.getPsi(source);
        KtTypeReference ktTypeReference = psiElement instanceof KtTypeReference ? (KtTypeReference)psiElement : null;
        if (ktTypeReference == null) {
            return false;
        }
        KtTypeReference typeReference = ktTypeReference;
        KtTypeElement ktTypeElement = typeReference.getTypeElement();
        KtNullableType ktNullableType = ktTypeElement instanceof KtNullableType ? (KtNullableType)ktTypeElement : null;
        if (ktNullableType == null) {
            return false;
        }
        KtNullableType typeElement = ktNullableType;
        return typeElement.getInnerType() instanceof KtNullableType;
    }

    @Override
    @Nullable
    public Boolean hasBody(@NotNull FirEnumEntry $this$hasBody) {
        Intrinsics.checkNotNullParameter($this$hasBody, "<this>");
        KtSourceElement ktSourceElement = $this$hasBody.getSource();
        PsiElement psiElement = ktSourceElement != null ? KtSourceElementKt.getPsi(ktSourceElement) : null;
        KtEnumEntry ktEnumEntry = psiElement instanceof KtEnumEntry ? (KtEnumEntry)psiElement : null;
        if (ktEnumEntry == null) {
            return null;
        }
        KtEnumEntry enumEntryPsi = ktEnumEntry;
        return enumEntryPsi.getBody() != null;
    }

    @Override
    @Nullable
    public Boolean hasInitializer(@NotNull FirEnumEntry $this$hasInitializer) {
        Intrinsics.checkNotNullParameter($this$hasInitializer, "<this>");
        KtSourceElement ktSourceElement = $this$hasInitializer.getSource();
        PsiElement psiElement = ktSourceElement != null ? KtSourceElementKt.getPsi(ktSourceElement) : null;
        KtEnumEntry ktEnumEntry = psiElement instanceof KtEnumEntry ? (KtEnumEntry)psiElement : null;
        if (ktEnumEntry == null) {
            return null;
        }
        KtEnumEntry enumEntryPsi = ktEnumEntry;
        return enumEntryPsi.getInitializerList() != null;
    }
}

