/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPlatformSpecificCastCheckerKt;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.ArgumentInfo;
import org.jetbrains.kotlin.fir.analysis.checkers.FirCastDiagnosticsHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirTypeCompatibilityHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.TypeInfo;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.ExhaustivenessStatusKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001-B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ1\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u0002H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0013J1\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u0002H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0013J)\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0016JA\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u001aJ\u001b\u0010\u001b\u001a\u00020\u000f*\u00020\u000f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001dH\u0082\bJE\u0010\u001e\u001a\u00020\u0007*\u00020\n2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010#J)\u0010$\u001a\u00020%2\u0006\u0010\u0010\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020!H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010&J+\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010)\u001a\u00020!H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010*J\u001b\u0010+\u001a\u0004\u0018\u00010(H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010,\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirCastOperatorsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirTypeOperatorCallChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;)V", "checkIsApplicability", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirCastOperatorsChecker$Applicability;", "l", "Lorg/jetbrains/kotlin/fir/analysis/checkers/TypeInfo;", "r", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/analysis/checkers/TypeInfo;Lorg/jetbrains/kotlin/fir/analysis/checkers/TypeInfo;Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;)Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirCastOperatorsChecker$Applicability;", "checkAsApplicability", "checkCastErased", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/analysis/checkers/TypeInfo;Lorg/jetbrains/kotlin/fir/analysis/checkers/TypeInfo;)Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirCastOperatorsChecker$Applicability;", "checkAnyApplicability", "impossible", "useless", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/analysis/checkers/TypeInfo;Lorg/jetbrains/kotlin/fir/analysis/checkers/TypeInfo;Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirCastOperatorsChecker$Applicability;Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirCastOperatorsChecker$Applicability;)Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirCastOperatorsChecker$Applicability;", "orIfApplicable", "other", "Lkotlin/Function0;", "reportInapplicabilityDiagnostic", "applicability", "Lorg/jetbrains/kotlin/fir/analysis/checkers/ArgumentInfo;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "rUserType", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirCastOperatorsChecker$Applicability;Lorg/jetbrains/kotlin/fir/analysis/checkers/ArgumentInfo;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)V", "isLastBranchOfExhaustiveWhen", "", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/analysis/checkers/ArgumentInfo;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Z", "getImpossibilityDiagnostic", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory0;", "rType", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/analysis/checkers/TypeInfo;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory0;", "getUselessCastDiagnostic", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory0;", "Applicability", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirCastOperatorsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirCastOperatorsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirCastOperatorsChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,195:1\n122#1,3:197\n122#1,3:200\n1#2:196\n*S KotlinDebug\n*F\n+ 1 FirCastOperatorsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirCastOperatorsChecker\n*L\n52#1:197,3\n70#1:200,3\n*E\n"})
public final class FirCastOperatorsChecker
extends FirExpressionChecker<FirTypeOperatorCall> {
    @NotNull
    public static final FirCastOperatorsChecker INSTANCE = new FirCastOperatorsChecker();

    private FirCastOperatorsChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirTypeOperatorCall expression2) {
        Applicability applicability;
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        List<FirExpression> arguments2 = expression2.getArgumentList().getArguments();
        if (!(arguments2.size() == 1)) {
            boolean $i$a$-require-FirCastOperatorsChecker$check$22 = false;
            String $i$a$-require-FirCastOperatorsChecker$check$22 = "Type operator call with non-1 arguments";
            throw new IllegalArgumentException($i$a$-require-FirCastOperatorsChecker$check$22.toString());
        }
        ArgumentInfo l2 = FirTypeCompatibilityHelpersKt.toArgumentInfo(context2, arguments2.get(0));
        TypeInfo r2 = FirTypeCompatibilityHelpersKt.toTypeInfo(FirHelpersKt.finalApproximationOrSelf(context2, TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context2, FirTypeUtilsKt.getConeType(expression2.getConversionTypeRef()))), context2.getSession());
        if (FirOperation.Companion.getTYPES().contains((Object)expression2.getOperation()) && r2.getDirectType() instanceof ConeDynamicType) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getConversionTypeRef().getSource(), FirErrors.INSTANCE.getDYNAMIC_NOT_ALLOWED(), null, 8, null);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[expression2.getOperation().ordinal()]) {
            case 1: 
            case 2: {
                applicability = this.checkIsApplicability(context2, l2.getSmartCastTypeInfo(), r2, expression2);
                break;
            }
            case 3: 
            case 4: {
                applicability = this.checkAsApplicability(context2, l2.getSmartCastTypeInfo(), r2, expression2);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid operator of FirTypeOperatorCall".toString());
            }
        }
        Applicability applicability2 = applicability;
        ConeKotlinType rUserType = FirHelpersKt.finalApproximationOrSelf(context2, FirTypeUtilsKt.getConeType(expression2.getConversionTypeRef()));
        if (applicability2 != Applicability.APPLICABLE) {
            this.reportInapplicabilityDiagnostic(context2, reporter, expression2, applicability2, l2, r2.getType(), rUserType);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Applicability checkIsApplicability(CheckerContext context2, TypeInfo l2, TypeInfo r2, FirTypeOperatorCall expression2) {
        Applicability applicability;
        void $this$orIfApplicable$iv;
        FirCastOperatorsChecker firCastOperatorsChecker = this;
        Applicability applicability2 = this.checkCastErased(context2, l2, r2);
        boolean $i$f$orIfApplicable = false;
        if ($this$orIfApplicable$iv == Applicability.APPLICABLE) {
            boolean bl = false;
            applicability = INSTANCE.checkAnyApplicability(context2, l2, r2, expression2, Applicability.IMPOSSIBLE_IS_CHECK, Applicability.USELESS_IS_CHECK);
        } else {
            applicability = $this$orIfApplicable$iv;
        }
        return applicability;
    }

    /*
     * WARNING - void declaration
     */
    private final Applicability checkAsApplicability(CheckerContext context2, TypeInfo l2, TypeInfo r2, FirTypeOperatorCall expression2) {
        Applicability applicability;
        boolean isNullableNothingWithNotNull = !ConeTypeUtilsKt.isMarkedOrFlexiblyNullable(l2.getType()) && ConeBuiltinTypeUtilsKt.isNullableNothing(r2.getType()) || ConeBuiltinTypeUtilsKt.isNullableNothing(l2.getType()) && !ConeTypeUtilsKt.isMarkedOrFlexiblyNullable(r2.getType());
        if (ConeBuiltinTypeUtilsKt.isNothing(l2.getType())) {
            applicability = Applicability.APPLICABLE;
        } else if (ConeBuiltinTypeUtilsKt.isNothing(r2.getType())) {
            applicability = Applicability.IMPOSSIBLE_CAST;
        } else if (isNullableNothingWithNotNull) {
            applicability = WhenMappings.$EnumSwitchMapping$0[expression2.getOperation().ordinal()] == 4 ? Applicability.USELESS_CAST : Applicability.IMPOSSIBLE_CAST;
        } else {
            void $this$orIfApplicable$iv;
            FirCastOperatorsChecker firCastOperatorsChecker = this;
            Applicability applicability2 = this.checkAnyApplicability(context2, l2, r2, expression2, Applicability.IMPOSSIBLE_CAST, Applicability.USELESS_CAST);
            boolean $i$f$orIfApplicable = false;
            if ($this$orIfApplicable$iv == Applicability.APPLICABLE) {
                boolean bl = false;
                applicability = INSTANCE.checkCastErased(context2, l2, r2);
            } else {
                applicability = $this$orIfApplicable$iv;
            }
        }
        return applicability;
    }

    private final Applicability checkCastErased(CheckerContext context2, TypeInfo l2, TypeInfo r2) {
        return (!context2.isContractBody() || !LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.AllowCheckForErasedTypesInContracts)) && FirCastDiagnosticsHelpersKt.isCastErased(context2, l2.getDirectType(), r2.getDirectType()) ? Applicability.CAST_ERASED : Applicability.APPLICABLE;
    }

    private final Applicability checkAnyApplicability(CheckerContext context2, TypeInfo l2, TypeInfo r2, FirTypeOperatorCall expression2, Applicability impossible, Applicability useless) {
        boolean oneIsNotNull;
        boolean bl = oneIsNotNull = !ConeTypeUtilsKt.isMarkedOrFlexiblyNullable(l2.getType()) || !ConeTypeUtilsKt.isMarkedOrFlexiblyNullable(r2.getType());
        return FirCastDiagnosticsHelpersKt.isRefinementUseless(context2, ConeTypeUtilsKt.upperBoundIfFlexible(l2.getDirectType()), r2.getDirectType(), expression2) ? useless : (FirTypeCompatibilityHelpersKt.shouldReportAsPerRules1(context2, l2, r2) ? (oneIsNotNull ? impossible : useless) : Applicability.APPLICABLE);
    }

    private final void reportInapplicabilityDiagnostic(CheckerContext context2, DiagnosticReporter $this$reportInapplicabilityDiagnostic, FirTypeOperatorCall expression2, Applicability applicability, ArgumentInfo l2, ConeKotlinType r2, ConeKotlinType rUserType) {
        switch (WhenMappings.$EnumSwitchMapping$1[applicability.ordinal()]) {
            case 1: {
                KtDiagnosticFactory0 ktDiagnosticFactory0 = this.getImpossibilityDiagnostic(context2, l2.getOriginalTypeInfo(), r2);
                if (ktDiagnosticFactory0 != null) {
                    KtDiagnosticFactory0 it = ktDiagnosticFactory0;
                    boolean bl = false;
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, $this$reportInapplicabilityDiagnostic, (AbstractKtSourceElement)expression2.getSource(), it, null, 8, null);
                }
                break;
            }
            case 2: {
                KtDiagnosticFactory0 ktDiagnosticFactory0 = this.getUselessCastDiagnostic(context2);
                if (ktDiagnosticFactory0 != null) {
                    KtDiagnosticFactory0 it = ktDiagnosticFactory0;
                    boolean bl = false;
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, $this$reportInapplicabilityDiagnostic, (AbstractKtSourceElement)expression2.getSource(), it, null, 8, null);
                }
                break;
            }
            case 3: {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, $this$reportInapplicabilityDiagnostic, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getUSELESS_IS_CHECK(), (Object)(expression2.getOperation() != FirOperation.IS ? 1 : 0), null, 16, null);
                break;
            }
            case 4: {
                if (this.isLastBranchOfExhaustiveWhen(context2, l2, r2)) break;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, $this$reportInapplicabilityDiagnostic, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getUSELESS_IS_CHECK(), (Object)(expression2.getOperation() == FirOperation.IS ? 1 : 0), null, 16, null);
                break;
            }
            case 5: {
                if (expression2.getOperation() == FirOperation.AS || expression2.getOperation() == FirOperation.SAFE_AS) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, $this$reportInapplicabilityDiagnostic, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getUNCHECKED_CAST(), (Object)l2.getUserType(), (Object)rUserType, null, 32, null);
                    break;
                }
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, $this$reportInapplicabilityDiagnostic, (AbstractKtSourceElement)expression2.getConversionTypeRef().getSource(), FirErrors.INSTANCE.getCANNOT_CHECK_FOR_ERASED(), (Object)rUserType, null, 16, null);
                break;
            }
            default: {
                throw new IllegalStateException("Shouldn't be here".toString());
            }
        }
    }

    private final boolean isLastBranchOfExhaustiveWhen(CheckerContext context2, ArgumentInfo l2, ConeKotlinType r2) {
        if (context2.getContainingElements().size() < 2) {
            return false;
        }
        List<FirElement> list = CollectionsKt.takeLast(CollectionsKt.dropLast(context2.getContainingElements(), 1), 2);
        FirElement whenExpression = list.get(0);
        FirElement whenBranch = list.get(1);
        return whenExpression instanceof FirWhenExpression && whenBranch instanceof FirWhenBranch && ExhaustivenessStatusKt.isExhaustive((FirWhenExpression)whenExpression) && Intrinsics.areEqual(whenBranch, CollectionsKt.lastOrNull(((FirWhenExpression)whenExpression).getBranches())) && !ConeBuiltinTypeUtilsKt.isNothing(FirTypeUtilsKt.getResolvedType(l2.getArgument())) && (((FirWhenExpression)whenExpression).getBranches().size() > 1 || TypeUtilsKt.equalTypes$default(l2.getSmartCastTypeInfo().getType(), r2, context2.getSession(), false, 4, null));
    }

    private final KtDiagnosticFactory0 getImpossibilityDiagnostic(CheckerContext context2, TypeInfo l2, ConeKotlinType rType) {
        return !LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.EnableDfaWarningsInK2) ? null : (FirPlatformSpecificCastCheckerKt.getFirPlatformSpecificCastChecker(context2.getSession()).shouldSuppressImpossibleCast(context2.getSession(), l2.getType(), rType) ? null : FirErrors.INSTANCE.getCAST_NEVER_SUCCEEDS());
    }

    private final KtDiagnosticFactory0 getUselessCastDiagnostic(CheckerContext context2) {
        return !LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.EnableDfaWarningsInK2) ? null : FirErrors.INSTANCE.getUSELESS_CAST();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirCastOperatorsChecker$Applicability;", "", "<init>", "(Ljava/lang/String;I)V", "APPLICABLE", "IMPOSSIBLE_CAST", "IMPOSSIBLE_IS_CHECK", "USELESS_CAST", "USELESS_IS_CHECK", "CAST_ERASED", "checkers"})
    private static final class Applicability
    extends Enum<Applicability> {
        public static final /* enum */ Applicability APPLICABLE = new Applicability();
        public static final /* enum */ Applicability IMPOSSIBLE_CAST = new Applicability();
        public static final /* enum */ Applicability IMPOSSIBLE_IS_CHECK = new Applicability();
        public static final /* enum */ Applicability USELESS_CAST = new Applicability();
        public static final /* enum */ Applicability USELESS_IS_CHECK = new Applicability();
        public static final /* enum */ Applicability CAST_ERASED = new Applicability();
        private static final /* synthetic */ Applicability[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Applicability[] values() {
            return (Applicability[])$VALUES.clone();
        }

        public static Applicability valueOf(String value2) {
            return Enum.valueOf(Applicability.class, value2);
        }

        @NotNull
        public static EnumEntries<Applicability> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = applicabilityArray = new Applicability[]{Applicability.APPLICABLE, Applicability.IMPOSSIBLE_CAST, Applicability.IMPOSSIBLE_IS_CHECK, Applicability.USELESS_CAST, Applicability.USELESS_IS_CHECK, Applicability.CAST_ERASED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[FirOperation.values().length];
            try {
                nArray[FirOperation.IS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.NOT_IS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.AS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.SAFE_AS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Applicability.values().length];
            try {
                nArray[Applicability.IMPOSSIBLE_CAST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Applicability.USELESS_CAST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Applicability.IMPOSSIBLE_IS_CHECK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Applicability.USELESS_IS_CHECK.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Applicability.CAST_ERASED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

