/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtPsiSourceFileLinesMapping;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceFile;
import org.jetbrains.kotlin.KtSourceFileLinesMapping;
import org.jetbrains.kotlin.KtSourceFileLinesMappingFromLineStartOffsets;
import org.jetbrains.kotlin.backend.common.CommonBackendErrors;
import org.jetbrains.kotlin.backend.common.IrSpecialAnnotationsProvider;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.util.containers.MultiMap;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirModuleDataKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrBuiltinSymbolsContainer;
import org.jetbrains.kotlin.fir.backend.Fir2IrClassifierStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponentsStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrConfiguration;
import org.jetbrains.kotlin.fir.backend.Fir2IrConversionScope;
import org.jetbrains.kotlin.fir.backend.Fir2IrDeclarationStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrExtensions;
import org.jetbrains.kotlin.fir.backend.Fir2IrImplicitCastInserter;
import org.jetbrains.kotlin.fir.backend.Fir2IrIrGeneratedDeclarationsRegistrar;
import org.jetbrains.kotlin.fir.backend.Fir2IrSymbolsMappingForLazyClasses;
import org.jetbrains.kotlin.fir.backend.Fir2IrTypeConverter;
import org.jetbrains.kotlin.fir.backend.Fir2IrTypeConverterKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrVisibilityConverter;
import org.jetbrains.kotlin.fir.backend.Fir2IrVisitor;
import org.jetbrains.kotlin.fir.backend.FirProviderWithGeneratedFiles;
import org.jetbrains.kotlin.fir.backend.generators.AdapterGenerator;
import org.jetbrains.kotlin.fir.backend.generators.AnnotationGenerator;
import org.jetbrains.kotlin.fir.backend.generators.CallAndReferenceGenerator;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrCallableDeclarationsGenerator;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrCallableDeclarationsGeneratorKt;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrClassifiersGenerator;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrDataClassMembersGenerator;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrLazyDeclarationsGenerator;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrLazyFakeOverrideGenerator;
import org.jetbrains.kotlin.fir.backend.utils.CodeFragmentConversionData;
import org.jetbrains.kotlin.fir.backend.utils.InjectedValue;
import org.jetbrains.kotlin.fir.backend.utils.IrElementsCreationUtilsKt;
import org.jetbrains.kotlin.fir.backend.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.DestructuringDeclarationAttributesKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirCodeFragment;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyBodyResolveStateKt;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirReplSnippet;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.descriptors.FirModuleDescriptor;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.extensions.FirDeclarationGenerationExtension;
import org.jetbrains.kotlin.fir.extensions.FirDeclarationGenerationExtensionKt;
import org.jetbrains.kotlin.fir.extensions.FirExtensionServiceKt;
import org.jetbrains.kotlin.fir.extensions.GeneratedDeclarationsUtilsKt;
import org.jetbrains.kotlin.fir.java.FirJavaElementFinder;
import org.jetbrains.kotlin.fir.java.FirJavaElementFinderKt;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScopeKt;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.ir.AbstractIrFileEntry;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrLock;
import org.jetbrains.kotlin.ir.IrProvider;
import org.jetbrains.kotlin.ir.KtDiagnosticReporterWithImplicitIrBasedContext;
import org.jetbrains.kotlin.ir.PsiIrFileEntry;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.impl.IrFactoryImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrFileImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrFileImplKt;
import org.jetbrains.kotlin.ir.declarations.impl.IrModuleFragmentImpl;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreter;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterConfiguration;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.checker.EvaluationMode;
import org.jetbrains.kotlin.ir.interpreter.transformer.IrConstTransformerKt;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrConstructorSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrSimpleFunctionSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrSymbolWithSignature;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.KotlinMangler;
import org.jetbrains.kotlin.ir.util.NaiveSourceBasedFileEntryImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00d4\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00a8\u00012\u00020\u0001:\u0002\u00a8\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ&\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J\u0010\u0010 \u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J\u0016\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0015J\u001d\u0010%\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b&J\u0018\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020)2\u0006\u0010$\u001a\u00020\u0015H\u0002J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\n2\u0006\u0010$\u001a\u00020\u0015H\u0002J\u001c\u0010,\u001a\b\u0012\u0004\u0012\u00020+0-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020+0-H\u0002J\u0018\u0010/\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u00100\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u0015H\u0002J\u0010\u00101\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u00102\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J8\u00103\u001a\u00020\r2\u0006\u00104\u001a\u00020+2\b\u00105\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0014\u00106\u001a\u0010\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u000209\u0018\u000107H\u0002J\u001e\u0010:\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010.\u001a\b\u0012\u0004\u0012\u00020+0\nH\u0002J\u0016\u0010;\u001a\u0004\u0018\u000108*\u0002092\u0006\u0010<\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010=\u001a\u00020>X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b?\u0010@R\u0012\u0010A\u001a\u00020BX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bC\u0010DR\u0012\u0010E\u001a\u00020FX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bG\u0010HR\u0012\u0010I\u001a\u00020JX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bK\u0010LR\u0012\u0010M\u001a\u00020NX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bO\u0010PR\u0012\u0010Q\u001a\u00020RX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bS\u0010TR\u0012\u0010U\u001a\u00020VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bW\u0010XR\u0012\u0010Y\u001a\u00020ZX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b[\u0010\\R\u0012\u0010]\u001a\u00020^X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b_\u0010`R\u0012\u0010a\u001a\u00020\u0000X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bb\u0010cR\u0012\u0010d\u001a\u00020eX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bf\u0010gR\u0012\u0010h\u001a\u00020iX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bj\u0010kR\u0012\u0010l\u001a\u00020mX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bn\u0010oR\u001a\u0010p\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010qX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\br\u0010sR\u0012\u0010t\u001a\u00020uX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bv\u0010wR\u0012\u0010x\u001a\u00020yX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bz\u0010{R\u0012\u0010|\u001a\u00020}X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b~\u0010\u007fR\u001c\u0010\u0080\u0001\u001a\t\u0012\u0005\u0012\u00030\u0081\u00010\nX\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u0082\u0001\u0010\u0083\u0001R\u0016\u0010\u0084\u0001\u001a\u00030\u0085\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u0086\u0001\u0010\u0087\u0001R\u0016\u0010\u0088\u0001\u001a\u00030\u0089\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u008a\u0001\u0010\u008b\u0001R\u0016\u0010\u008c\u0001\u001a\u00030\u008d\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u008e\u0001\u0010\u008f\u0001R\u0016\u0010\u0090\u0001\u001a\u00030\u0091\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u0092\u0001\u0010\u0093\u0001R\u0016\u0010\u0094\u0001\u001a\u00030\u0095\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u0096\u0001\u0010\u0097\u0001R\u0018\u0010\u0098\u0001\u001a\u0005\u0018\u00010\u0099\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u009a\u0001\u0010\u009b\u0001R\u0016\u0010\u009c\u0001\u001a\u00030\u009d\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u009e\u0001\u0010\u009f\u0001R\u0016\u0010\u00a0\u0001\u001a\u00030\u00a1\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00a2\u0001\u0010\u00a3\u0001R\u0016\u0010\u00a4\u0001\u001a\u00030\u00a5\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00a6\u0001\u0010\u00a7\u0001\u00a8\u0006\u00a9\u0001"}, d2={"Lorg/jetbrains/kotlin/fir/backend/Fir2IrConverter;", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "moduleDescriptor", "Lorg/jetbrains/kotlin/fir/descriptors/FirModuleDescriptor;", "c", "conversionScope", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrConversionScope;", "<init>", "(Lorg/jetbrains/kotlin/fir/descriptors/FirModuleDescriptor;Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;Lorg/jetbrains/kotlin/fir/backend/Fir2IrConversionScope;)V", "generatorExtensions", "", "Lorg/jetbrains/kotlin/fir/extensions/FirDeclarationGenerationExtension;", "runSourcesConversion", "", "allFirFiles", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "irModuleFragment", "Lorg/jetbrains/kotlin/ir/declarations/impl/IrModuleFragmentImpl;", "fir2irVisitor", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisitor;", "processLocalClassAndNestedClassesOnTheFly", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "parent", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "processLocalClassAndNestedClasses", "registerFileAndClasses", "file", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "processClassHeaders", "processFileAndClassMembers", "processAnonymousObjectHeaders", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "irClass", "processClassMembers", "processClassMembers$fir2ir", "processCodeFragmentMembers", "codeFragment", "Lorg/jetbrains/kotlin/fir/declarations/FirCodeFragment;", "delegatedMembers", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "syntheticPropertiesLast", "", "declarations", "registerClassAndNestedClasses", "registerNestedClasses", "processClassAndNestedClassHeaders", "processNestedClassHeaders", "processMemberDeclaration", "declaration", "containingClass", "delegateFieldToPropertyMap", "Lorg/jetbrains/kotlin/com/intellij/util/containers/MultiMap;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "processScriptLikeDeclaration", "findCorrespondingDelegateProperty", "owner", "adapterGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/AdapterGenerator;", "getAdapterGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/AdapterGenerator;", "annotationGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/AnnotationGenerator;", "getAnnotationGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/AnnotationGenerator;", "annotationsFromPluginRegistrar", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrIrGeneratedDeclarationsRegistrar;", "getAnnotationsFromPluginRegistrar", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrIrGeneratedDeclarationsRegistrar;", "builtins", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrBuiltinSymbolsContainer;", "getBuiltins", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrBuiltinSymbolsContainer;", "callGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/CallAndReferenceGenerator;", "getCallGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/CallAndReferenceGenerator;", "callablesGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrCallableDeclarationsGenerator;", "getCallablesGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrCallableDeclarationsGenerator;", "classifierStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "getClassifierStorage", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "classifiersGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrClassifiersGenerator;", "getClassifiersGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrClassifiersGenerator;", "configuration", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrConfiguration;", "getConfiguration", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrConfiguration;", "converter", "getConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrConverter;", "dataClassMembersGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrDataClassMembersGenerator;", "getDataClassMembersGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrDataClassMembersGenerator;", "declarationStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "getDeclarationStorage", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "extensions", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "getExtensions", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "filesBeingCompiled", "", "getFilesBeingCompiled", "()Ljava/util/Set;", "firProvider", "Lorg/jetbrains/kotlin/fir/backend/FirProviderWithGeneratedFiles;", "getFirProvider", "()Lorg/jetbrains/kotlin/fir/backend/FirProviderWithGeneratedFiles;", "implicitCastInserter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrImplicitCastInserter;", "getImplicitCastInserter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrImplicitCastInserter;", "irMangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "getIrMangler", "()Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "irProviders", "Lorg/jetbrains/kotlin/ir/IrProvider;", "getIrProviders", "()Ljava/util/List;", "lazyDeclarationsGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrLazyDeclarationsGenerator;", "getLazyDeclarationsGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrLazyDeclarationsGenerator;", "lazyFakeOverrideGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrLazyFakeOverrideGenerator;", "getLazyFakeOverrideGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrLazyFakeOverrideGenerator;", "lock", "Lorg/jetbrains/kotlin/ir/IrLock;", "getLock", "()Lorg/jetbrains/kotlin/ir/IrLock;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "specialAnnotationsProvider", "Lorg/jetbrains/kotlin/backend/common/IrSpecialAnnotationsProvider;", "getSpecialAnnotationsProvider", "()Lorg/jetbrains/kotlin/backend/common/IrSpecialAnnotationsProvider;", "symbolsMappingForLazyClasses", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrSymbolsMappingForLazyClasses;", "getSymbolsMappingForLazyClasses", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrSymbolsMappingForLazyClasses;", "typeConverter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "getTypeConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "visibilityConverter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "getVisibilityConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "Companion", "fir2ir"})
@SourceDebugExtension(value={"SMAP\nFir2IrConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fir2IrConverter.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrConverter\n+ 2 Utils.kt\norg/jetbrains/kotlin/fir/UtilsKt\n+ 3 Fir2IrConversionScope.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrConversionScope\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 7 Fir2IrDeclarationStorage.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage\n+ 8 FirDeclarationUtil.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirDeclarationUtilKt\n*L\n1#1,706:1\n247#2,4:707\n74#3,7:711\n74#3,7:718\n1#4:725\n1#4:747\n1869#5,2:726\n1573#5:729\n1604#5,4:730\n774#5:734\n865#5,2:735\n1617#5,9:737\n1869#5:746\n1870#5:748\n1626#5:749\n1056#5:750\n1869#5,2:751\n1869#5,2:753\n1869#5,2:755\n1869#5,2:757\n808#5,11:765\n808#5,11:778\n63#6:728\n63#6:759\n63#6:776\n90#6:777\n1339#7,4:760\n53#8:764\n*S KotlinDebug\n*F\n+ 1 Fir2IrConverter.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrConverter\n*L\n105#1:707,4\n119#1:711,7\n127#1:718,7\n362#1:747\n170#1:726,2\n331#1:729\n331#1:730,4\n360#1:734\n360#1:735,2\n362#1:737,9\n362#1:746\n362#1:748\n362#1:749\n371#1:750\n394#1:751,2\n400#1:753,2\n425#1:755,2\n431#1:757,2\n560#1:765,11\n596#1:778,11\n240#1:728\n467#1:759\n581#1:776\n582#1:777\n479#1:760,4\n510#1:764\n*E\n"})
public final class Fir2IrConverter
implements Fir2IrComponents {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirModuleDescriptor moduleDescriptor;
    @NotNull
    private final Fir2IrComponents c;
    @NotNull
    private final Fir2IrConversionScope conversionScope;
    @NotNull
    private final List<FirDeclarationGenerationExtension> generatorExtensions;

    public Fir2IrConverter(@NotNull FirModuleDescriptor moduleDescriptor, @NotNull Fir2IrComponents c2, @NotNull Fir2IrConversionScope conversionScope) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkNotNullParameter(c2, "c");
        Intrinsics.checkNotNullParameter(conversionScope, "conversionScope");
        this.moduleDescriptor = moduleDescriptor;
        this.c = c2;
        this.conversionScope = conversionScope;
        this.generatorExtensions = FirDeclarationGenerationExtensionKt.getDeclarationGenerators(FirExtensionServiceKt.getExtensionService(this.getSession()));
    }

    private final void runSourcesConversion(List<? extends FirFile> allFirFiles, IrModuleFragmentImpl irModuleFragment, Fir2IrVisitor fir2irVisitor) {
        for (FirFile firFile : allFirFiles) {
            this.registerFileAndClasses(firFile, irModuleFragment);
        }
        for (FirFile firFile : allFirFiles) {
            this.processClassHeaders(firFile);
        }
        for (FirFile firFile : allFirFiles) {
            this.processFileAndClassMembers(firFile);
        }
        this.getClassifierStorage().processMembersOfClassesCreatedOnTheFly();
        Iterator<? extends FirFile> iterator2 = allFirFiles.iterator();
        while (iterator2.hasNext()) {
            FirFile firFile;
            FirFile file$iv = firFile = iterator2.next();
            boolean $i$f$withFileAnalysisExceptionWrapping = false;
            try {
                boolean bl = false;
                IrElement irElement = (IrElement)firFile.accept(fir2irVisitor, null);
            }
            catch (Throwable throwable$iv) {
                UtilsKt.getExceptionHandler(file$iv.getModuleData().getSession()).handleExceptionOnFileAnalysis(file$iv, throwable$iv);
                throw new KotlinNothingValueException();
            }
        }
        if (this.getConfiguration().getAllowNonCachedDeclarations()) {
            this.getDeclarationStorage().fillUnboundSymbols$fir2ir();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final IrClass processLocalClassAndNestedClassesOnTheFly(@NotNull FirClass klass, @NotNull IrDeclarationParent parent2) {
        void this_$iv;
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(parent2, "parent");
        IrClass irClass = this.registerClassAndNestedClasses(klass, parent2);
        Fir2IrConversionScope fir2IrConversionScope = this.conversionScope;
        FirClass containingFirClass$iv = klass;
        boolean $i$f$withContainingFirClass = false;
        ((Collection)this_$iv.getContainingFirClassStack()).add(containingFirClass$iv);
        try {
            boolean bl = false;
            this.processClassAndNestedClassHeaders(klass);
        }
        finally {
            this_$iv.getContainingFirClassStack().remove(this_$iv.getContainingFirClassStack().size() - 1);
        }
        return irClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final IrClass processLocalClassAndNestedClasses(@NotNull FirClass klass, @NotNull IrDeclarationParent parent2) {
        void this_$iv;
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(parent2, "parent");
        IrClass irClass = this.registerClassAndNestedClasses(klass, parent2);
        Fir2IrConversionScope fir2IrConversionScope = this.conversionScope;
        FirClass containingFirClass$iv = klass;
        boolean $i$f$withContainingFirClass = false;
        ((Collection)this_$iv.getContainingFirClassStack()).add(containingFirClass$iv);
        try {
            boolean bl = false;
            this.processClassAndNestedClassHeaders(klass);
            this.processClassMembers$fir2ir(klass, irClass);
        }
        finally {
            this_$iv.getContainingFirClassStack().remove(this_$iv.getContainingFirClassStack().size() - 1);
        }
        return irClass;
    }

    private final void registerFileAndClasses(FirFile file, IrModuleFragment moduleFragment) {
        AbstractIrFileEntry abstractIrFileEntry;
        FirDeclarationOrigin firDeclarationOrigin = file.getOrigin();
        if (Intrinsics.areEqual(firDeclarationOrigin, FirDeclarationOrigin.Source.INSTANCE)) {
            PsiElement psiElement = UtilsKt.getPsi(file);
            if (psiElement != null) {
                PsiElement it = psiElement;
                boolean bl = false;
                abstractIrFileEntry = new PsiIrFileEntry((KtFile)it);
            } else {
                KtSourceFileLinesMapping linesMapping = file.getSourceFileLinesMapping();
                if (linesMapping instanceof KtSourceFileLinesMappingFromLineStartOffsets) {
                    Object object = file.getSourceFile();
                    if (object == null || (object = object.getPath()) == null) {
                        KtSourceFile ktSourceFile = file.getSourceFile();
                        object = ktSourceFile != null ? ktSourceFile.getName() : file.getName();
                    }
                    abstractIrFileEntry = new NaiveSourceBasedFileEntryImpl((String)object, ((KtSourceFileLinesMappingFromLineStartOffsets)linesMapping).getLineStartOffsets(), ((KtSourceFileLinesMappingFromLineStartOffsets)linesMapping).getLastOffset(), 0, 8, null);
                } else if (linesMapping instanceof KtPsiSourceFileLinesMapping) {
                    abstractIrFileEntry = new PsiIrFileEntry(((KtPsiSourceFileLinesMapping)linesMapping).getPsiFile());
                } else {
                    Object object = file.getSourceFile();
                    if (object == null || (object = object.getPath()) == null) {
                        KtSourceFile ktSourceFile = file.getSourceFile();
                        object = ktSourceFile != null ? ktSourceFile.getName() : file.getName();
                    }
                    abstractIrFileEntry = new NaiveSourceBasedFileEntryImpl((String)object, null, 0, 0, 14, null);
                }
            }
        } else if (firDeclarationOrigin instanceof FirDeclarationOrigin.Synthetic) {
            abstractIrFileEntry = new NaiveSourceBasedFileEntryImpl(file.getName(), null, 0, 0, 14, null);
        } else {
            throw new IllegalStateException(("Unsupported file origin " + file.getOrigin() + "; file: " + file.getName()).toString());
        }
        AbstractIrFileEntry fileEntry = abstractIrFileEntry;
        IrFileImpl irFile = IrFileImplKt.IrFileImpl(fileEntry, CollectionsKt.first(this.moduleDescriptor.getPackage(UtilsKt.getPackageFqName(file)).getFragments()), moduleFragment);
        this.getDeclarationStorage().registerFile(file, irFile);
        for (FirDeclaration declaration : file.getDeclarations()) {
            FirDeclaration firDeclaration = declaration;
            Object object = firDeclaration instanceof FirRegularClass ? this.registerClassAndNestedClasses((FirClass)declaration, irFile) : (firDeclaration instanceof FirCodeFragment ? this.getClassifierStorage().createAndCacheCodeFragmentClass((FirCodeFragment)declaration, irFile) : Unit.INSTANCE);
        }
        ((Collection)moduleFragment.getFiles()).add(irFile);
    }

    private final void processClassHeaders(FirFile file) {
        IrFile irFile = this.getDeclarationStorage().getIrFile(file);
        Iterable $this$forEach$iv = file.getDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirDeclaration it = (FirDeclaration)element$iv;
            boolean bl = false;
            FirDeclaration firDeclaration = it;
            if (firDeclaration instanceof FirRegularClass) {
                this.processClassAndNestedClassHeaders((FirClass)it);
                continue;
            }
            if (!(firDeclaration instanceof FirTypeAlias)) continue;
            this.getClassifierStorage().createAndCacheIrTypeAlias((FirTypeAlias)it, irFile);
        }
        irFile.getDeclarations().clear();
    }

    private final void processFileAndClassMembers(FirFile file) {
        IrFile irFile = this.getDeclarationStorage().getIrFile(file);
        for (FirDeclaration declaration : file.getDeclarations()) {
            this.processMemberDeclaration(declaration, null, irFile, null);
        }
    }

    public final void processAnonymousObjectHeaders(@NotNull FirAnonymousObject anonymousObject, @NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter(anonymousObject, "anonymousObject");
        Intrinsics.checkNotNullParameter(irClass, "irClass");
        this.registerNestedClasses(anonymousObject, irClass);
        this.processNestedClassHeaders(anonymousObject);
        irClass.getDeclarations().clear();
    }

    @NotNull
    public final IrClass processClassMembers$fir2ir(@NotNull FirClass klass, @NotNull IrClass irClass) {
        IrConstructor irConstructor;
        List list;
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(irClass, "irClass");
        List $this$processClassMembers_u24lambda_u240 = list = (List)new ArrayList();
        boolean bl = false;
        $this$processClassMembers_u24lambda_u240.addAll((Collection)klass.getDeclarations());
        if (klass instanceof FirRegularClass && !((Collection)this.generatorExtensions).isEmpty()) {
            $this$processClassMembers_u24lambda_u240.addAll((Collection)GeneratedDeclarationsUtilsKt.generatedMembers((FirRegularClass)klass, this.getSession()));
            $this$processClassMembers_u24lambda_u240.addAll((Collection)GeneratedDeclarationsUtilsKt.generatedNestedClassifiers((FirRegularClass)klass, this.getSession()));
        }
        if (JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(FirDeclarationUtilKt.getClassId(klass).asSingleFqName().toUnsafe()) != null) {
            FirContainingNamesAwareScopeKt.processAllFunctions(ScopeUtilsKt.unsubstitutedScope((Fir2IrComponents)this, klass), arg_0 -> Fir2IrConverter.processClassMembers$lambda$0$0(klass, $this$processClassMembers_u24lambda_u240, arg_0));
        }
        List allDeclarations = list;
        irClass.getDeclarations().addAll((Collection<IrDeclaration>)this.getClassifierStorage().getFieldsWithContextReceiversForClass(irClass, klass));
        FirConstructorSymbol firConstructorSymbol = DeclarationUtilsKt.primaryConstructorIfAny(klass, this.getSession());
        if (firConstructorSymbol != null) {
            FirConstructorSymbol it = firConstructorSymbol;
            boolean bl2 = false;
            FirClassLikeDeclaration $this$isLocal$iv = klass;
            boolean $i$f$isLocal = false;
            irConstructor = Fir2IrDeclarationStorage.createAndCacheIrConstructor$default(this.getDeclarationStorage(), (FirConstructor)it.getFir(), () -> Fir2IrConverter.processClassMembers$lambda$1$0(irClass), null, $this$isLocal$iv.getSymbol().getClassId().isLocal(), 4, null);
        } else {
            irConstructor = null;
        }
        IrConstructor irConstructor2 = irConstructor;
        MultiMap<FirProperty, FirField> delegateFieldToPropertyMap = new MultiMap<FirProperty, FirField>();
        for (FirDeclaration declaration : this.syntheticPropertiesLast(allDeclarations)) {
            this.processMemberDeclaration(declaration, klass, irClass, delegateFieldToPropertyMap);
        }
        CollectionsKt.addAll((Collection)allDeclarations, (Iterable)this.delegatedMembers(irClass));
        if (klass instanceof FirRegularClass && irConstructor2 != null && (irClass.isValue() || irClass.isData())) {
            this.getDeclarationStorage().enterScope(irConstructor2.getSymbol());
            if (IrDeclarationsKt.isSingleFieldValueClass(irClass)) {
                CollectionsKt.addAll((Collection)allDeclarations, (Iterable)this.getDataClassMembersGenerator().generateSingleFieldValueClassMembers((FirRegularClass)klass, irClass));
            }
            if (IrDeclarationsKt.isMultiFieldValueClass(irClass)) {
                CollectionsKt.addAll((Collection)allDeclarations, (Iterable)this.getDataClassMembersGenerator().generateMultiFieldValueClassMembers((FirRegularClass)klass, irClass));
            }
            if (irClass.isData()) {
                CollectionsKt.addAll((Collection)allDeclarations, (Iterable)this.getDataClassMembersGenerator().generateDataClassMembers((FirRegularClass)klass, irClass));
            }
            this.getDeclarationStorage().leaveScope(irConstructor2.getSymbol());
        }
        return irClass;
    }

    /*
     * WARNING - void declaration
     */
    private final IrClass processCodeFragmentMembers(FirCodeFragment codeFragment, IrClass irClass) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        void $this$processCodeFragmentMembers_u24lambda_u240_u240_u240;
        Object object;
        CodeFragmentConversionData conversionData = this.getExtensions().codeFragmentConversionData(codeFragment);
        this.getDeclarationStorage().enterScope(irClass.getSymbol());
        IrSymbolWithSignature irSymbol = new IrConstructorSymbolImpl(null, null, 3, null);
        boolean bl = false;
        Object object2 = IrFactoryImpl.INSTANCE;
        Object object3 = IrDeclarationOrigin.Companion.getDEFINED();
        Name name2 = Name.special("<init>");
        Intrinsics.checkNotNullExpressionValue(name2, "special(...)");
        Name name3 = name2;
        DescriptorVisibility descriptorVisibility = irClass.getVisibility();
        IrSimpleType irSimpleType = IrUtilsKt.getDefaultType(irClass);
        Object $this$processCodeFragmentMembers_u24lambda_u240_u240 = object2 = IrFactory.createConstructor$default((IrFactory)object2, -1, -1, (IrDeclarationOrigin)object3, name3, descriptorVisibility, false, false, irSimpleType, irSymbol, true, false, null, 2048, null);
        boolean bl2 = false;
        Fir2IrCallableDeclarationsGeneratorKt.setParent((IrDeclaration)$this$processCodeFragmentMembers_u24lambda_u240_u240, irClass);
        Fir2IrCallableDeclarationsGeneratorKt.addDeclarationToParent((IrDeclaration)$this$processCodeFragmentMembers_u24lambda_u240_u240, irClass);
        FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol(this.getSession().getBuiltinTypes().getAnyType(), this.getSession());
        Intrinsics.checkNotNull(firRegularClassSymbol);
        FirConstructorSymbol firConstructorSymbol = DeclarationUtilsKt.primaryConstructorIfAny((FirClass)firRegularClassSymbol.getFir(), this.getSession());
        Intrinsics.checkNotNull(firConstructorSymbol);
        Object firAnyConstructor = firConstructorSymbol;
        IrConstructorSymbol irAnyConstructor = Fir2IrDeclarationStorage.getIrConstructorSymbol$default(this.getDeclarationStorage(), (FirConstructorSymbol)firAnyConstructor, false, 2, null);
        Object object4 = object = IrFactoryImpl.INSTANCE.createBlockBody(-1, -1);
        Object object5 = $this$processCodeFragmentMembers_u24lambda_u240_u240;
        boolean $i$a$-apply-Fir2IrConverter$processCodeFragmentMembers$1$1$22 = false;
        ((Collection)$this$processCodeFragmentMembers_u24lambda_u240_u240_u240.getStatements()).add(BuildersKt.IrDelegatingConstructorCallImplWithShape$default(-1, -1, this.getBuiltins().getUnitType(), irAnyConstructor, 0, 0, 0, false, false, null, 512, null));
        ((IrFunction)object5).setBody((IrBody)object);
        irSymbol = new IrSimpleFunctionSymbolImpl(null, null, 3, null);
        boolean bl3 = false;
        FirStatement lastStatement = CollectionsKt.lastOrNull(codeFragment.getBlock().getStatements());
        object3 = lastStatement instanceof FirExpression ? (FirExpression)lastStatement : null;
        IrType returnType = object3 != null && (bl2 = FirTypeUtilsKt.getResolvedType((FirExpression)object3)) != null && (firAnyConstructor = Fir2IrTypeConverterKt.toIrType$default((Fir2IrComponents)this, bl2, null, 2, null)) != null ? firAnyConstructor : this.getBuiltins().getUnitType();
        IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.Companion.getDEFINED();
        Name name4 = conversionData.getMethodName();
        DescriptorVisibility descriptorVisibility2 = DescriptorVisibilities.PUBLIC;
        Intrinsics.checkNotNullExpressionValue(descriptorVisibility2, "PUBLIC");
        Object $this$processCodeFragmentMembers_u24lambda_u241_u240 = object3 = IrFactoryImpl.INSTANCE.createSimpleFunction(-1, -1, irDeclarationOrigin, name4, descriptorVisibility2, false, false, returnType, Modality.FINAL, (IrSimpleFunctionSymbol)((Object)irSymbol), false, false, false, false, false, null, false);
        boolean bl4 = false;
        Fir2IrCallableDeclarationsGeneratorKt.setParent((IrDeclaration)$this$processCodeFragmentMembers_u24lambda_u241_u240, irClass);
        Fir2IrCallableDeclarationsGeneratorKt.addDeclarationToParent((IrDeclaration)$this$processCodeFragmentMembers_u24lambda_u241_u240, irClass);
        object = conversionData.getInjectedValues();
        object4 = $this$processCodeFragmentMembers_u24lambda_u241_u240;
        boolean $i$f$mapIndexed = false;
        void $i$a$-apply-Fir2IrConverter$processCodeFragmentMembers$1$1$22 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            IrValueParameter irValueParameter;
            void index;
            void injectedValue;
            int n2;
            if ((n2 = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            InjectedValue injectedValue2 = (InjectedValue)item$iv$iv;
            int n3 = n2;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            boolean isMutated = injectedValue.isMutated();
            IrDeclarationOrigin irDeclarationOrigin2 = isMutated ? IrDeclarationOrigin.Companion.getSHARED_VARIABLE_IN_EVALUATOR_FRAGMENT() : IrDeclarationOrigin.Companion.getDEFINED();
            Name name5 = Name.identifier("" + 'p' + (int)index);
            Intrinsics.checkNotNullExpressionValue(name5, "identifier(...)");
            IrValueParameter $this$processCodeFragmentMembers_u24lambda_u241_u240_u240_u240 = irValueParameter = IrFactoryImpl.INSTANCE.createValueParameter(-1, -1, irDeclarationOrigin2, IrParameterKind.Regular, name5, Fir2IrTypeConverterKt.toIrType$default((Fir2IrComponents)this, injectedValue.getTypeRef(), null, 2, null), isMutated, injectedValue.getIrParameterSymbol(), null, false, false, false);
            boolean bl6 = false;
            $this$processCodeFragmentMembers_u24lambda_u241_u240_u240_u240.setParent((IrDeclarationParent)$this$processCodeFragmentMembers_u24lambda_u241_u240);
            collection.add(irValueParameter);
        }
        ((IrFunction)object4).setParameters((List)destination$iv$iv);
        this.getDeclarationStorage().leaveScope(irClass.getSymbol());
        return irClass;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirDeclaration> delegatedMembers(IrClass irClass) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = irClass.getDeclarations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrDeclaration it = (IrDeclaration)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getOrigin(), IrDeclarationOrigin.Companion.getDELEGATED_MEMBER())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FirDeclaration it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrDeclaration it = (IrDeclaration)element$iv$iv;
            boolean bl2 = false;
            if (this.c.getDeclarationStorage().originalDeclarationForDelegated(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Iterable<FirDeclaration> syntheticPropertiesLast(Iterable<? extends FirDeclaration> declarations2) {
        Iterable<? extends FirDeclaration> $this$sortedBy$iv = declarations2;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a2, T b2) {
                boolean bl;
                boolean bl2;
                FirDeclaration it = (FirDeclaration)a2;
                boolean bl3 = false;
                FirDeclaration $this$isSynthetic$iv = it;
                boolean $i$f$isSynthetic = false;
                if (!($this$isSynthetic$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic)) {
                    bl2 = false;
                } else {
                    KtSourceElement ktSourceElement = it.getSource();
                    bl2 = !((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.ClassDelegationField);
                }
                it = (FirDeclaration)b2;
                Comparable comparable = Boolean.valueOf(bl2);
                bl3 = false;
                $this$isSynthetic$iv = it;
                $i$f$isSynthetic = false;
                if (!($this$isSynthetic$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic)) {
                    bl = false;
                } else {
                    KtSourceElement ktSourceElement = it.getSource();
                    bl = !((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.ClassDelegationField);
                }
                return ComparisonsKt.compareValues(comparable, bl);
            }
        });
    }

    private final IrClass registerClassAndNestedClasses(FirClass klass, IrDeclarationParent parent2) {
        Object object;
        Object object2;
        IrClass irClass = this.getClassifierStorage().getCachedIrLocalClass(klass);
        if (irClass != null) {
            object2 = irClass;
            IrClass $this$registerClassAndNestedClasses_u24lambda_u240 = object2;
            boolean bl = false;
            $this$registerClassAndNestedClasses_u24lambda_u240.setParent(parent2);
            object = object2;
        } else {
            object2 = klass;
            if (object2 instanceof FirRegularClass) {
                object = Fir2IrClassifierStorage.createAndCacheIrClass$default(this.getClassifierStorage(), (FirRegularClass)klass, parent2, null, 4, null);
            } else if (object2 instanceof FirAnonymousObject) {
                object = Fir2IrClassifierStorage.createAndCacheAnonymousObject$default(this.getClassifierStorage(), (FirAnonymousObject)klass, null, null, parent2, 6, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        Object irClass2 = object;
        this.registerNestedClasses(klass, (IrClass)irClass2);
        return irClass2;
    }

    private final void registerNestedClasses(FirClass klass, IrClass irClass) {
        FirDeclaration it;
        Iterable $this$forEach$iv = klass.getDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (FirDeclaration)element$iv;
            boolean bl = false;
            if (!(it instanceof FirRegularClass)) continue;
            this.registerClassAndNestedClasses((FirClass)it, irClass);
        }
        if (klass instanceof FirRegularClass && !((Collection)this.generatorExtensions).isEmpty()) {
            $this$forEach$iv = GeneratedDeclarationsUtilsKt.generatedNestedClassifiers((FirRegularClass)klass, this.getSession());
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FirClassLikeDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof FirRegularClass)) continue;
                this.registerClassAndNestedClasses((FirClass)it, irClass);
            }
        }
    }

    private final void processClassAndNestedClassHeaders(FirClass klass) {
        Fir2IrClassifiersGenerator.processClassHeader$default(this.getClassifiersGenerator(), klass, null, 2, null);
        this.processNestedClassHeaders(klass);
        IrClass irClass = this.getClassifierStorage().getIrClass(klass);
        irClass.getDeclarations().clear();
    }

    private final void processNestedClassHeaders(FirClass klass) {
        FirDeclaration it;
        Iterable $this$forEach$iv = klass.getDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (FirDeclaration)element$iv;
            boolean bl = false;
            if (!(it instanceof FirRegularClass)) continue;
            this.processClassAndNestedClassHeaders((FirClass)it);
        }
        if (klass instanceof FirRegularClass && !((Collection)this.generatorExtensions).isEmpty()) {
            $this$forEach$iv = GeneratedDeclarationsUtilsKt.generatedNestedClassifiers((FirRegularClass)klass, this.getSession());
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FirClassLikeDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof FirRegularClass)) continue;
                this.processClassAndNestedClassHeaders((FirClass)it);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void processMemberDeclaration(FirDeclaration declaration, FirClass containingClass, IrDeclarationParent parent, MultiMap<FirProperty, FirField> delegateFieldToPropertyMap) {
        if (containingClass == null) ** GOTO lbl-1000
        if (!(containingClass instanceof FirRegularClass)) ** GOTO lbl-1000
        $this$isLocal$iv = containingClass;
        $i$f$isLocal = false;
        if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        isInLocalClass = v0;
        var6_5 = declaration;
        if (var6_5 instanceof FirRegularClass) {
            irClass = this.getClassifierStorage().getIrClass((FirClass)declaration);
            Fir2IrConverter.processMemberDeclaration$addDeclarationToParentIfNeeded(parent, irClass);
            this.processClassMembers$fir2ir((FirClass)declaration, irClass);
        } else if (var6_5 instanceof FirScript) {
            if (!(parent instanceof IrFile)) {
                var8_14 = "Failed requirement.";
                throw new IllegalArgumentException(var8_14.toString());
            }
            irScript = this.getDeclarationStorage().createIrScript((FirScript)declaration);
            Fir2IrConverter.processMemberDeclaration$addDeclarationToParentIfNeeded(parent, irScript);
            irScript.setParent(parent);
            var8_15 = this.getDeclarationStorage();
            symbol$iv = irScript.getSymbol();
            $i$f$withScope = false;
            this_$iv.enterScope(symbol$iv);
            $i$a$-withScope-Fir2IrConverter$processMemberDeclaration$1 = false;
            Fir2IrConverter.access$processScriptLikeDeclaration(this, irScript, ((FirScript)declaration).getDeclarations());
            this_$iv.leaveScope(symbol$iv);
        } else if (var6_5 instanceof FirReplSnippet) {
            if (!(parent instanceof IrFile)) {
                this_$iv = "Failed requirement.";
                throw new IllegalArgumentException(this_$iv.toString());
            }
            irSnippet = this.getDeclarationStorage().createIrReplSnippet((FirReplSnippet)declaration);
            Fir2IrConverter.processMemberDeclaration$addDeclarationToParentIfNeeded(parent, irSnippet);
            irSnippet.setParent(parent);
        } else if (var6_5 instanceof FirSimpleFunction) {
            Fir2IrDeclarationStorage.createAndCacheIrFunction$default(this.getDeclarationStorage(), (FirFunction)declaration, parent, null, isInLocalClass, null, false, 52, null);
        } else if (var6_5 instanceof FirProperty) {
            if (containingClass == null || !UtilsKt.isEnumEntries((FirVariable)declaration, containingClass) || LanguageVersionUtilsKt.isEnabled(this, LanguageFeature.EnumEntries)) {
                irProperty = Fir2IrDeclarationStorage.createAndCacheIrProperty$default(this.getDeclarationStorage(), (FirProperty)declaration, parent, null, null, false, 28, null);
                v1 = delegateFieldToPropertyMap;
                if (v1 != null && (v1 = v1.remove((FirProperty)declaration)) != null) {
                    delegateFields = v1;
                    $i$a$-let-Fir2IrConverter$processMemberDeclaration$2 = false;
                    v2 = irProperty.getBackingField();
                    Intrinsics.checkNotNull(v2);
                    backingField = v2;
                    var13_29 = delegateFields.iterator();
                    while (var13_29.hasNext()) {
                        delegateField = (FirField)var13_29.next();
                        v3 = this.getDeclarationStorage();
                        Intrinsics.checkNotNull(delegateField);
                        v3.recordSupertypeDelegateFieldMappedToBackingField(delegateField, backingField.getSymbol());
                    }
                }
            }
        } else if (var6_5 instanceof FirField) {
            $this$isSynthetic$iv = declaration;
            $i$f$isSynthetic = false;
            if (!($this$isSynthetic$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic)) {
                throw new IllegalStateException(("Unexpected non-synthetic field: " + UtilsKt.render(declaration)).toString());
            }
            if (containingClass == null) {
                $this$isSynthetic$iv = "Required value was null.";
                throw new IllegalArgumentException($this$isSynthetic$iv.toString());
            }
            if (delegateFieldToPropertyMap == null) {
                $this$isSynthetic$iv = "Required value was null.";
                throw new IllegalArgumentException($this$isSynthetic$iv.toString());
            }
            if (!(parent instanceof IrClass)) {
                $i$f$isSynthetic = "Failed requirement.";
                throw new IllegalArgumentException($i$f$isSynthetic.toString());
            }
            correspondingClassProperty = this.findCorrespondingDelegateProperty((FirField)declaration, containingClass);
            if (correspondingClassProperty == null || correspondingClassProperty.isVar()) {
                v4 = this.getDeclarationStorage().createSupertypeDelegateIrField$fir2ir((FirField)declaration, (IrClass)parent).getSymbol();
            } else {
                delegateFieldToPropertyMap.putValue(correspondingClassProperty, (FirField)declaration);
                correspondingIrProperty = Fir2IrDeclarationStorage.getIrPropertySymbol$default(this.getDeclarationStorage(), correspondingClassProperty.getSymbol(), null, 2, null);
                v5 = this.getDeclarationStorage();
                Intrinsics.checkNotNull(correspondingIrProperty, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrPropertySymbol");
                v4 = v5.findBackingFieldOfProperty((IrPropertySymbol)correspondingIrProperty);
                if (v4 == null) {
                    throw new IllegalStateException(("Backing field not found for property " + correspondingClassProperty.getReturnTypeRef()).toString());
                }
            }
            irFieldSymbol = v4;
            delegationTargetType = Fir2IrTypeConverterKt.toIrType$default((Fir2IrComponents)this, ((FirField)declaration).getReturnTypeRef(), null, 2, null);
            this.getDeclarationStorage().recordSupertypeDelegationInformation(containingClass, (IrClass)parent, delegationTargetType, irFieldSymbol);
        } else if (var6_5 instanceof FirConstructor) {
            if (!((FirConstructor)declaration).isPrimary()) {
                Fir2IrDeclarationStorage.createAndCacheIrConstructor$default(this.getDeclarationStorage(), (FirConstructor)declaration, (Function0<IrClass>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, processMemberDeclaration$lambda$2(org.jetbrains.kotlin.ir.declarations.IrDeclarationParent ), ()Lorg/jetbrains/kotlin/ir/declarations/IrClass;)((IrDeclarationParent)parent), null, isInLocalClass, 4, null);
            }
        } else if (var6_5 instanceof FirEnumEntry) {
            v6 = this.getClassifierStorage();
            v7 = (FirEnumEntry)declaration;
            Intrinsics.checkNotNull(parent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            Fir2IrClassifierStorage.createAndCacheIrEnumEntry$default(v6, v7, (IrClass)parent, null, 4, null);
        } else if (var6_5 instanceof FirAnonymousInitializer) {
            v8 = this.getDeclarationStorage();
            v9 = (FirAnonymousInitializer)declaration;
            Intrinsics.checkNotNull(parent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            v8.createIrAnonymousInitializer(v9, (IrClass)parent);
        } else if (var6_5 instanceof FirTypeAlias) {
            v10 = this.getClassifierStorage().getCachedTypeAlias$fir2ir((FirTypeAlias)declaration);
            if (v10 != null) {
                irTypeAlias = v10;
                $i$a$-let-Fir2IrConverter$processMemberDeclaration$4 = false;
                Fir2IrConverter.processMemberDeclaration$addDeclarationToParentIfNeeded(parent, irTypeAlias);
            }
        } else if (var6_5 instanceof FirCodeFragment) {
            v11 = this.getClassifierStorage().getCachedIrCodeFragment((FirCodeFragment)declaration);
            Intrinsics.checkNotNull(v11);
            codeFragmentClass = v11;
            this.processCodeFragmentMembers((FirCodeFragment)declaration, codeFragmentClass);
            Fir2IrConverter.processMemberDeclaration$addDeclarationToParentIfNeeded(parent, codeFragmentClass);
        } else {
            throw new IllegalStateException(("Unexpected member: " + UtilsKt.render(declaration)).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processScriptLikeDeclaration(IrDeclarationParent parent2, List<? extends FirDeclaration> declarations2) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable iterable = declarations2;
        boolean $i$f$filterIsInstance22 = false;
        Object object = iterable;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirRegularClass)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (FirRegularClass firRegularClass : (List)destination$iv$iv) {
            this.registerClassAndNestedClasses(firRegularClass, parent2);
        }
        for (FirDeclaration firDeclaration : declarations2) {
            FirDeclaration $i$f$filterIsInstance22 = firDeclaration;
            if ($i$f$filterIsInstance22 instanceof FirRegularClass) {
                this.processClassAndNestedClassHeaders((FirClass)firDeclaration);
                continue;
            }
            if (!($i$f$filterIsInstance22 instanceof FirTypeAlias)) continue;
            this.getClassifierStorage().createAndCacheIrTypeAlias((FirTypeAlias)firDeclaration, parent2);
        }
        for (FirDeclaration firDeclaration : declarations2) {
            boolean needProcessMember;
            boolean $i$f$isLocal;
            FirMemberDeclaration $this$isLocal$iv;
            boolean bl;
            object = firDeclaration;
            if (object instanceof FirAnonymousInitializer) {
                bl = false;
            } else if (object instanceof FirProperty) {
                bl = !(FirPropertyBodyResolveStateKt.isLocal((FirProperty)firDeclaration) || Intrinsics.areEqual(((FirProperty)firDeclaration).getName(), SpecialNames.UNDERSCORE_FOR_UNUSED_VAR) && DestructuringDeclarationAttributesKt.getDestructuringDeclarationContainerVariable((FirProperty)firDeclaration) != null);
            } else if (object instanceof FirClassLikeDeclaration) {
                $this$isLocal$iv = (FirClassLikeDeclaration)firDeclaration;
                $i$f$isLocal = false;
                bl = !((FirClassLikeDeclaration)$this$isLocal$iv).getSymbol().getClassId().isLocal();
            } else if (object instanceof FirSimpleFunction) {
                $this$isLocal$iv = (FirSimpleFunction)firDeclaration;
                $i$f$isLocal = false;
                bl = !Intrinsics.areEqual(((FirSimpleFunction)$this$isLocal$iv).getStatus().getVisibility(), Visibilities.Local.INSTANCE);
            } else {
                bl = true;
            }
            if (!(needProcessMember = bl)) continue;
            this.processMemberDeclaration(firDeclaration, null, parent2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final FirProperty findCorrespondingDelegateProperty(FirField $this$findCorrespondingDelegateProperty, FirClass owner) {
        Object v1;
        block5: {
            void $this$filterIsInstanceTo$iv$iv;
            FirExpression initializer = $this$findCorrespondingDelegateProperty.getInitializer();
            if (!(initializer instanceof FirQualifiedAccessExpression)) {
                return null;
            }
            if (((FirQualifiedAccessExpression)initializer).getExplicitReceiver() != null) {
                return null;
            }
            FirValueParameterSymbol firValueParameterSymbol = FirReferenceUtilsKt.toResolvedValueParameterSymbol$default(((FirQualifiedAccessExpression)initializer).getCalleeReference(), false, 1, null);
            if (firValueParameterSymbol == null) {
                return null;
            }
            FirValueParameterSymbol resolvedSymbol = firValueParameterSymbol;
            Iterable $this$filterIsInstance$iv = owner.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof FirProperty)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            for (Object e2 : iterable2) {
                FirProperty it = (FirProperty)e2;
                boolean bl = false;
                if (!Intrinsics.areEqual(DeclarationAttributesKt.getCorrespondingValueParameterFromPrimaryConstructor(it), resolvedSymbol)) continue;
                v1 = e2;
                break block5;
            }
            v1 = null;
        }
        return v1;
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.c.getSession();
    }

    @Override
    @NotNull
    public ScopeSession getScopeSession() {
        return this.c.getScopeSession();
    }

    @Override
    @NotNull
    public FirProviderWithGeneratedFiles getFirProvider() {
        return this.c.getFirProvider();
    }

    @Override
    @NotNull
    public Fir2IrConverter getConverter() {
        return this.c.getConverter();
    }

    @Override
    @NotNull
    public Fir2IrBuiltinSymbolsContainer getBuiltins() {
        return this.c.getBuiltins();
    }

    @Override
    @Nullable
    public IrSpecialAnnotationsProvider getSpecialAnnotationsProvider() {
        return this.c.getSpecialAnnotationsProvider();
    }

    @Override
    @NotNull
    public KotlinMangler.IrMangler getIrMangler() {
        return this.c.getIrMangler();
    }

    @Override
    @NotNull
    public List<IrProvider> getIrProviders() {
        return this.c.getIrProviders();
    }

    @Override
    @NotNull
    public IrLock getLock() {
        return this.c.getLock();
    }

    @Override
    @NotNull
    public Fir2IrClassifierStorage getClassifierStorage() {
        return this.c.getClassifierStorage();
    }

    @Override
    @NotNull
    public Fir2IrDeclarationStorage getDeclarationStorage() {
        return this.c.getDeclarationStorage();
    }

    @Override
    @NotNull
    public Fir2IrTypeConverter getTypeConverter() {
        return this.c.getTypeConverter();
    }

    @Override
    @NotNull
    public Fir2IrVisibilityConverter getVisibilityConverter() {
        return this.c.getVisibilityConverter();
    }

    @Override
    @NotNull
    public Fir2IrCallableDeclarationsGenerator getCallablesGenerator() {
        return this.c.getCallablesGenerator();
    }

    @Override
    @NotNull
    public Fir2IrClassifiersGenerator getClassifiersGenerator() {
        return this.c.getClassifiersGenerator();
    }

    @Override
    @NotNull
    public Fir2IrLazyDeclarationsGenerator getLazyDeclarationsGenerator() {
        return this.c.getLazyDeclarationsGenerator();
    }

    @Override
    @NotNull
    public Fir2IrDataClassMembersGenerator getDataClassMembersGenerator() {
        return this.c.getDataClassMembersGenerator();
    }

    @Override
    @NotNull
    public AnnotationGenerator getAnnotationGenerator() {
        return this.c.getAnnotationGenerator();
    }

    @Override
    @NotNull
    public CallAndReferenceGenerator getCallGenerator() {
        return this.c.getCallGenerator();
    }

    @Override
    @NotNull
    public Fir2IrLazyFakeOverrideGenerator getLazyFakeOverrideGenerator() {
        return this.c.getLazyFakeOverrideGenerator();
    }

    @Override
    @NotNull
    public Fir2IrSymbolsMappingForLazyClasses getSymbolsMappingForLazyClasses() {
        return this.c.getSymbolsMappingForLazyClasses();
    }

    @Override
    @NotNull
    public Fir2IrExtensions getExtensions() {
        return this.c.getExtensions();
    }

    @Override
    @NotNull
    public Fir2IrConfiguration getConfiguration() {
        return this.c.getConfiguration();
    }

    @Override
    @NotNull
    public Fir2IrIrGeneratedDeclarationsRegistrar getAnnotationsFromPluginRegistrar() {
        return this.c.getAnnotationsFromPluginRegistrar();
    }

    @Override
    @NotNull
    public AdapterGenerator getAdapterGenerator() {
        return this.c.getAdapterGenerator();
    }

    @Override
    @NotNull
    public Fir2IrImplicitCastInserter getImplicitCastInserter() {
        return this.c.getImplicitCastInserter();
    }

    @Override
    @Nullable
    public Set<FirFile> getFilesBeingCompiled() {
        return this.c.getFilesBeingCompiled();
    }

    private static final Unit processClassMembers$lambda$0$0(FirClass $klass, List $this_apply, FirNamedFunctionSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (Intrinsics.areEqual(it.getOrigin(), FirDeclarationOrigin.Enhancement.INSTANCE) && Intrinsics.areEqual(it.getCallableId().getClassId(), FirDeclarationUtilKt.getClassId($klass))) {
            $this_apply.add(it.getFir());
        }
        return Unit.INSTANCE;
    }

    private static final IrClass processClassMembers$lambda$1$0(IrClass $irClass) {
        return $irClass;
    }

    private static final void processMemberDeclaration$addDeclarationToParentIfNeeded(IrDeclarationParent $parent, IrDeclaration irDeclaration) {
        IrDeclarationParent irDeclarationParent = $parent;
        if (irDeclarationParent instanceof IrFile) {
            ((Collection)((IrFile)$parent).getDeclarations()).add(irDeclaration);
        } else if (irDeclarationParent instanceof IrClass) {
            ((Collection)((IrClass)$parent).getDeclarations()).add(irDeclaration);
        }
    }

    private static final IrClass processMemberDeclaration$lambda$2(IrDeclarationParent $parent) {
        Intrinsics.checkNotNull($parent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        return (IrClass)$parent;
    }

    public static final /* synthetic */ void access$processScriptLikeDeclaration(Fir2IrConverter $this, IrDeclarationParent parent2, List declarations2) {
        $this.processScriptLikeDeclaration(parent2, declarations2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ&\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017J\u001c\u0010\u0018\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0015\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/backend/Fir2IrConverter$Companion;", "", "<init>", "()V", "evaluateConstants", "", "irModuleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "components", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "evaluate", "", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "interpreter", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "mode", "Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "friendModulesMap", "", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "generateIrModuleFragment", "Lorg/jetbrains/kotlin/ir/declarations/impl/IrModuleFragmentImpl;", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponentsStorage;", "firFiles", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "fir2ir"})
    @SourceDebugExtension(value={"SMAP\nFir2IrConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fir2IrConverter.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrConverter$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,706:1\n1869#2,2:707\n1563#2:710\n1634#2,3:711\n1193#2,2:714\n1267#2,4:716\n1869#2,2:720\n1#3:709\n*S KotlinDebug\n*F\n+ 1 Fir2IrConverter.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrConverter$Companion\n*L\n623#1:707,2\n681#1:710\n681#1:711,3\n682#1:714,2\n682#1:716,4\n697#1:720,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void evaluateConstants(@NotNull IrModuleFragment irModuleFragment, @NotNull Fir2IrComponents components, @NotNull IrBuiltIns irBuiltIns) {
            FirModuleDescriptor firModuleDescriptor;
            Intrinsics.checkNotNullParameter(irModuleFragment, "irModuleFragment");
            Intrinsics.checkNotNullParameter(components, "components");
            Intrinsics.checkNotNullParameter(irBuiltIns, "irBuiltIns");
            Fir2IrConfiguration fir2IrConfiguration = components.getConfiguration();
            ModuleDescriptor moduleDescriptor = irModuleFragment.getDescriptor();
            FirModuleDescriptor firModuleDescriptor2 = firModuleDescriptor = moduleDescriptor instanceof FirModuleDescriptor ? (FirModuleDescriptor)moduleDescriptor : null;
            TargetPlatform targetPlatform = firModuleDescriptor2 != null ? firModuleDescriptor2.getPlatform() : null;
            Object object = firModuleDescriptor;
            if (object == null || (object = ((FirModuleDescriptor)object).getSession()) == null || (object = FirLanguageSettingsComponentKt.getLanguageVersionSettings((FirSession)object)) == null) {
                return;
            }
            Object languageVersionSettings = object;
            boolean intrinsicConstEvaluation = languageVersionSettings.supportsFeature(LanguageFeature.IntrinsicConstEvaluation);
            IrInterpreterConfiguration configuration2 = new IrInterpreterConfiguration(targetPlatform, 0, 0, false, true, false, 46, null);
            IrInterpreter interpreter2 = new IrInterpreter(new IrInterpreterEnvironment(irBuiltIns, configuration2), null, 2, null);
            EvaluationMode mode = intrinsicConstEvaluation ? (EvaluationMode)new EvaluationMode.OnlyIntrinsicConst(false, 1, null) : (EvaluationMode)EvaluationMode.OnlyBuiltins.INSTANCE;
            FirJavaElementFinder firJavaElementFinder = FirJavaElementFinderKt.getJavaElementFinder(components.getSession());
            if (firJavaElementFinder != null) {
                firJavaElementFinder.setPropertyEvaluator(arg_0 -> Companion.evaluateConstants$lambda$0(components, interpreter2, mode, arg_0));
            }
            KtDiagnosticReporterWithImplicitIrBasedContext ktDiagnosticReporter = new KtDiagnosticReporterWithImplicitIrBasedContext(fir2IrConfiguration.getDiagnosticReporter(), (LanguageVersionSettings)languageVersionSettings);
            Iterable $this$forEach$iv = irModuleFragment.getFiles();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrFile it = (IrFile)element$iv;
                boolean bl = false;
                IrConstTransformerKt.transformConst$default(it, it, interpreter2, mode, fir2IrConfiguration.getEvaluatedConstTracker(), fir2IrConfiguration.getInlineConstTracker(), null, (arg_0, arg_1, arg_2) -> Companion.evaluateConstants$lambda$1$0(ktDiagnosticReporter, arg_0, arg_1, arg_2), false, 160, null);
            }
        }

        private final String evaluate(FirProperty $this$evaluate, Fir2IrComponents components, IrInterpreter interpreter2, EvaluationMode mode) {
            IrProperty irProperty;
            Object object = components.getDeclarationStorage().getCachedIrPropertySymbol($this$evaluate, null);
            if (object == null || (irProperty = (IrProperty)object.getOwner()) == null) {
                return null;
            }
            IrProperty irProperty2 = irProperty;
            object = org.jetbrains.kotlin.fir.backend.Fir2IrConverter$Companion.evaluate$tryToGetConst(irProperty2);
            if (object != null) {
                Object it = object;
                boolean bl = false;
                return org.jetbrains.kotlin.fir.backend.Fir2IrConverter$Companion.evaluate$asString((IrConst)it);
            }
            IrFile irFile = IrUtilsKt.getFileOrNull(irProperty2);
            if (irFile == null) {
                return null;
            }
            IrFile irFile2 = irFile;
            IrElement evaluated = IrConstTransformerKt.transformConst$default(irProperty2, irFile2, interpreter2, mode, components.getConfiguration().getEvaluatedConstTracker(), components.getConfiguration().getInlineConstTracker(), null, null, false, 224, null);
            IrElementBase irElementBase = evaluated instanceof IrProperty ? (IrProperty)evaluated : null;
            return irElementBase != null && (irElementBase = org.jetbrains.kotlin.fir.backend.Fir2IrConverter$Companion.evaluate$tryToGetConst(irElementBase)) != null ? org.jetbrains.kotlin.fir.backend.Fir2IrConverter$Companion.evaluate$asString((IrConst)irElementBase) : null;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<String, List<String>> friendModulesMap(@NotNull FirSession session) {
            void $this$associateTo$iv$iv;
            void $this$mapTo$iv$iv;
            Set<FirModuleData> set;
            Intrinsics.checkNotNullParameter(session, "session");
            FirModuleData moduleData2 = FirModuleDataKt.getModuleData(session);
            Set<FirModuleData> $this$friendModulesMap_u24lambda_u240 = set = SetsKt.createSetBuilder();
            boolean bl = false;
            org.jetbrains.kotlin.fir.backend.Fir2IrConverter$Companion.friendModulesMap$collectDependsOnRecursive(moduleData2, $this$friendModulesMap_u24lambda_u240);
            Set<FirModuleData> dependsOnTransitive = SetsKt.build(set);
            Iterable $this$map$iv = CollectionsKt.plus((Collection)moduleData2.getFriendDependencies(), (Iterable)dependsOnTransitive);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirModuleData firModuleData = (FirModuleData)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(org.jetbrains.kotlin.fir.backend.Fir2IrConverter$Companion.friendModulesMap$friendsMapName((FirModuleData)it));
            }
            List friendNames = (List)destination$iv$iv;
            Iterable $this$associate$iv = dependsOnTransitive;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv2;
                FirModuleData it = (FirModuleData)element$iv$iv;
                boolean bl3 = false;
                Pair<String, List> pair = TuplesKt.to(org.jetbrains.kotlin.fir.backend.Fir2IrConverter$Companion.friendModulesMap$friendsMapName(it), friendNames);
                map2.put(pair.getFirst(), pair.getSecond());
            }
            return destination$iv$iv2;
        }

        @NotNull
        public final IrModuleFragmentImpl generateIrModuleFragment(@NotNull Fir2IrComponentsStorage components, @NotNull List<? extends FirFile> firFiles) {
            List list;
            Intrinsics.checkNotNullParameter(components, "components");
            Intrinsics.checkNotNullParameter(firFiles, "firFiles");
            FirSession session = components.getSession();
            FirLazyDeclarationResolverKt.getLazyDeclarationResolver(session).disableLazyResolveContractChecks();
            IrModuleFragmentImpl irModuleFragment = new IrModuleFragmentImpl(components.getModuleDescriptor());
            List $this$generateIrModuleFragment_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$generateIrModuleFragment_u24lambda_u240.addAll(IrElementsCreationUtilsKt.createFilesWithBuiltinsSyntheticDeclarationsIfNeeded(session));
            $this$generateIrModuleFragment_u24lambda_u240.addAll(firFiles);
            List<FirFile> generatedFiles = IrElementsCreationUtilsKt.createFilesWithGeneratedDeclarations(session);
            $this$generateIrModuleFragment_u24lambda_u240.addAll(generatedFiles);
            Iterable $this$forEach$iv = generatedFiles;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirFile it = (FirFile)element$iv;
                boolean bl2 = false;
                components.getFirProvider().recordFile(it);
            }
            List allFirFiles = CollectionsKt.build(list);
            components.getConverter().runSourcesConversion(allFirFiles, irModuleFragment, components.getFir2IrVisitor());
            return irModuleFragment;
        }

        private static final String evaluateConstants$lambda$0(Fir2IrComponents $components, IrInterpreter $interpreter, EvaluationMode $mode, FirProperty it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return Companion.evaluate(it, $components, $interpreter, $mode);
        }

        private static final Unit evaluateConstants$lambda$1$0(KtDiagnosticReporterWithImplicitIrBasedContext $ktDiagnosticReporter, IrFile irFile, IrElement element, IrErrorExpression error) {
            Intrinsics.checkNotNullParameter(irFile, "irFile");
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(error, "error");
            $ktDiagnosticReporter.at(IrUtilsKt.sourceElement(element), element, irFile).report(CommonBackendErrors.INSTANCE.getEVALUATION_ERROR(), error.getDescription());
            return Unit.INSTANCE;
        }

        private static final IrConst evaluate$tryToGetConst(IrProperty $this$evaluate_u24tryToGetConst) {
            IrElementBase irElementBase = $this$evaluate_u24tryToGetConst.getBackingField();
            IrExpression irExpression = irElementBase != null && (irElementBase = ((IrField)irElementBase).getInitializer()) != null ? ((IrExpressionBody)irElementBase).getExpression() : null;
            return irExpression instanceof IrConst ? (IrConst)irExpression : null;
        }

        private static final String evaluate$asString(IrConst $this$evaluate_u24asString) {
            Object constVal = $this$evaluate_u24asString.getValue();
            return constVal instanceof Character ? String.valueOf((int)((Character)constVal).charValue()) : (constVal instanceof String ? '\"' + (String)constVal + '\"' : String.valueOf(constVal));
        }

        private static final String friendModulesMap$friendsMapName(FirModuleData $this$friendModulesMap_u24friendsMapName) {
            String string = $this$friendModulesMap_u24friendsMapName.getName().asStringStripSpecialMarkers();
            Intrinsics.checkNotNullExpressionValue(string, "asStringStripSpecialMarkers(...)");
            return string;
        }

        private static final void friendModulesMap$collectDependsOnRecursive(FirModuleData $this$friendModulesMap_u24collectDependsOnRecursive, Set<FirModuleData> set) {
            if (!set.add($this$friendModulesMap_u24collectDependsOnRecursive)) {
                return;
            }
            for (FirModuleData dep : $this$friendModulesMap_u24collectDependsOnRecursive.getDependsOnDependencies()) {
                org.jetbrains.kotlin.fir.backend.Fir2IrConverter$Companion.friendModulesMap$collectDependsOnRecursive(dep, set);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

