/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import java.io.File;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.io.DataExternalizer;
import org.jetbrains.kotlin.com.intellij.util.io.KeyDescriptor;
import org.jetbrains.kotlin.incremental.IncrementalCompilationContext;
import org.jetbrains.kotlin.incremental.storage.AppendablePersistentStorage;
import org.jetbrains.kotlin.incremental.storage.BasicMap;
import org.jetbrains.kotlin.incremental.storage.LazyStorageKt;
import org.jetbrains.kotlin.incremental.storage.PersistentStorage;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\f\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00040\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00040\u0005B3\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001aJ\u001e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00042\u0006\u0010\u0019\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001cJ$\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00028\u00002\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004H\u0096\u0002\u00a2\u0006\u0002\u0010 J\u0015\u0010!\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020\u001eH\u0016J\b\u0010$\u001a\u00020\u001eH\u0016J\u001b\u0010%\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010&\u001a\u00028\u0001\u00a2\u0006\u0002\u0010'J!\u0010%\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00028\u00002\f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\u0002\u0010 J\b\u0010)\u001a\u00020\u001eH\u0016R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/AppendableSetBasicMap;", "KEY", "E", "Lorg/jetbrains/kotlin/incremental/storage/PersistentStorage;", "", "Lorg/jetbrains/kotlin/incremental/storage/BasicMap;", "storageFile", "Ljava/io/File;", "keyDescriptor", "Lorg/jetbrains/kotlin/com/intellij/util/io/KeyDescriptor;", "elementExternalizer", "Lorg/jetbrains/kotlin/com/intellij/util/io/DataExternalizer;", "icContext", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "<init>", "(Ljava/io/File;Lcom/intellij/util/io/KeyDescriptor;Lcom/intellij/util/io/DataExternalizer;Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;)V", "storage", "Lorg/jetbrains/kotlin/incremental/storage/AppendablePersistentStorage;", "getStorageFile", "()Ljava/io/File;", "keys", "getKeys", "()Ljava/util/Set;", "contains", "", "key", "(Ljava/lang/Object;)Z", "get", "(Ljava/lang/Object;)Ljava/util/Set;", "set", "", "value", "(Ljava/lang/Object;Ljava/util/Set;)V", "remove", "(Ljava/lang/Object;)V", "flush", "close", "append", "element", "(Ljava/lang/Object;Ljava/lang/Object;)V", "elements", "clean", "kotlin-build-common"})
public abstract class AppendableSetBasicMap<KEY, E>
implements BasicMap<KEY, Set<? extends E>>,
PersistentStorage<KEY, Set<? extends E>> {
    @NotNull
    private final AppendablePersistentStorage<KEY, E> storage;
    @NotNull
    private final File storageFile;

    public AppendableSetBasicMap(@NotNull File storageFile, @NotNull KeyDescriptor<KEY> keyDescriptor, @NotNull DataExternalizer<E> elementExternalizer, @NotNull IncrementalCompilationContext icContext) {
        Intrinsics.checkNotNullParameter(storageFile, "storageFile");
        Intrinsics.checkNotNullParameter(keyDescriptor, "keyDescriptor");
        Intrinsics.checkNotNullParameter(elementExternalizer, "elementExternalizer");
        Intrinsics.checkNotNullParameter(icContext, "icContext");
        this.storage = LazyStorageKt.createAppendablePersistentStorage(storageFile, keyDescriptor, elementExternalizer, icContext);
        this.storageFile = this.storage.getStorageFile();
    }

    @Override
    @NotNull
    public File getStorageFile() {
        return this.storageFile;
    }

    @Override
    @NotNull
    public synchronized Set<KEY> getKeys() {
        return this.storage.getKeys();
    }

    @Override
    public synchronized boolean contains(KEY key) {
        return this.storage.contains(key);
    }

    @Override
    @Nullable
    public synchronized Set<E> get(KEY key) {
        Collection collection = (Collection)this.storage.get(key);
        return collection != null ? CollectionsKt.toSet(collection) : null;
    }

    @Override
    public synchronized void set(KEY key, @NotNull Set<? extends E> value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        this.storage.set(key, value2);
    }

    @Override
    public synchronized void remove(KEY key) {
        this.storage.remove(key);
    }

    @Override
    public synchronized void flush() {
        this.storage.flush();
    }

    @Override
    public synchronized void close() {
        this.storage.close();
    }

    public final synchronized void append(KEY key, E element) {
        this.storage.append(key, SetsKt.setOf(element));
    }

    public final synchronized void append(KEY key, @NotNull Set<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        this.storage.append(key, elements);
    }

    @Override
    public synchronized void clean() {
        this.storage.clean();
    }
}

