/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.UpgradeCallableReferences;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.backend.js.JsCommonBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.TestGenerator$instance$;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFactoryHelpersKt;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrRichFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrTryImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ&\u0010\f\u001a\u00020\t*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0017H\u0002J\f\u0010\u0018\u001a\u00020\u0012*\u00020\u0019H\u0002J\f\u0010\u001a\u001a\u00020\u0012*\u00020\u0019H\u0002J\f\u0010\u001b\u001a\u00020\u0012*\u00020\u0016H\u0002J<\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\t2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0\u001f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\tH\u0002J\f\u0010!\u001a\u00020\"*\u00020\u0016H\u0002J\u0014\u0010)\u001a\u00020\u0012*\u00020$2\u0006\u0010*\u001a\u00020\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010#\u001a\u00020\u0012*\u00020$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010%R\u0018\u0010&\u001a\u00020\u0012*\u00020$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010%R\u0018\u0010'\u001a\u00020\u0012*\u00020$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010%R\u0018\u0010(\u001a\u00020\u0012*\u00020$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010%R\u0018\u0010+\u001a\u00020\u0012*\u00020,8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010-\u00a8\u0006.\u00b2\u0006\n\u0010/\u001a\u00020\tX\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/TestGenerator;", "", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "createTestContainer", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "createInvocation", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "name", "", "parentFunction", "ignored", "", "generateTestCalls", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lkotlin/Function0;", "isVisibleFromTests", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithVisibility;", "isEffectivelyVisibleFromTests", "canBeInstantiated", "generateCodeForTestMethod", "testFun", "beforeFuns", "", "afterFuns", "instance", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "isTest", "Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;", "(Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;)Z", "isIgnored", "isBefore", "isAfter", "hasAnnotation", "fqName", "isPromise", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "(Lorg/jetbrains/kotlin/ir/types/IrSimpleType;)Z", "backend.js", "suiteFunBody"})
@SourceDebugExtension(value={"SMAP\nTestGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestGenerator.kt\norg/jetbrains/kotlin/ir/backend/js/lower/TestGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 4 CollectionUtil.kt\norg/jetbrains/kotlin/utils/CollectionUtilKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 MemoryOptimizedCollectionUtil.kt\norg/jetbrains/kotlin/utils/MemoryOptimizedCollectionUtilKt\n*L\n1#1,320:1\n1869#2,2:321\n1869#2,2:343\n1563#2:349\n1634#2,3:350\n1634#2,3:358\n1563#2:367\n1634#2,3:368\n1761#2,3:374\n269#3,4:323\n269#3,4:353\n275#3:377\n269#3,10:378\n32#4,2:327\n9#4,6:329\n32#4,2:335\n9#4,6:337\n1232#5,2:345\n1255#5,2:347\n477#5:371\n127#5,2:372\n16#6:357\n135#6,6:361\n*S KotlinDebug\n*F\n+ 1 TestGenerator.kt\norg/jetbrains/kotlin/ir/backend/js/lower/TestGenerator\n*L\n66#1:321,2\n126#1:343,2\n188#1:349\n188#1:350,3\n232#1:358,3\n274#1:367\n274#1:368,3\n311#1:374,3\n86#1:323,4\n223#1:353,4\n56#1:377\n56#1:378,10\n123#1:327,2\n123#1:329,6\n124#1:335,2\n124#1:337,6\n141#1:345,2\n151#1:347,2\n287#1:371\n287#1:372,2\n232#1:357\n253#1:361,6\n*E\n"})
public final class TestGenerator {
    @NotNull
    private final JsCommonBackendContext context;

    public TestGenerator(@NotNull JsCommonBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }

    @NotNull
    public final JsCommonBackendContext getContext() {
        return this.context;
    }

    @Nullable
    public final IrSimpleFunction createTestContainer(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        if (irFile.getDeclarations().isEmpty()) {
            return null;
        }
        Lazy<IrSimpleFunction> testContainer = LazyKt.lazy(() -> TestGenerator.createTestContainer$lambda$0(this, irFile));
        Iterable $this$forEach$iv = new ArrayList(irFile.getDeclarations());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrDeclaration it = (IrDeclaration)element$iv;
            boolean bl = false;
            if (!(it instanceof IrClass)) continue;
            this.context.getIrFactory().getStageController().restrictTo(it, () -> TestGenerator.createTestContainer$lambda$1$0(this, it, testContainer));
        }
        return testContainer.isInitialized() ? testContainer.getValue() : null;
    }

    private final IrSimpleFunction createInvocation(IrSimpleFunctionSymbol $this$createInvocation, String name2, IrSimpleFunction parentFunction, boolean ignored) {
        IrCall irCall;
        IrBlockBody body = IrFactoryHelpersKt.createBlockBody(this.context.getIrFactory(), -1, -1, kotlin.collections.CollectionsKt.emptyList());
        IrFactory $this$buildFun$iv = this.context.getIrFactory();
        boolean $i$f$buildFun22 = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u240$iv = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$createInvocation_u24lambda_u240 = $this$buildFun_u24lambda_u240$iv;
        boolean bl2 = false;
        Name name3 = Name.identifier(name2 + " test fun");
        Intrinsics.checkNotNullExpressionValue(name3, "identifier(...)");
        $this$createInvocation_u24lambda_u240.setName(name3);
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.context.getSuiteFun();
        Intrinsics.checkNotNull(irSimpleFunctionSymbol);
        $this$createInvocation_u24lambda_u240.setReturnType(Intrinsics.areEqual($this$createInvocation, irSimpleFunctionSymbol) ? this.context.getIrBuiltIns().getUnitType() : this.context.getIrBuiltIns().getAnyNType());
        $this$createInvocation_u24lambda_u240.setOrigin(JsIrBuilder.INSTANCE.getSYNTHESIZED_DECLARATION());
        IrSimpleFunction function2 = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u240$iv);
        function2.setParent(parentFunction);
        function2.setBody(body);
        IrType[] $i$f$buildFun22 = new IrType[]{function2.getReturnType()};
        IrSimpleType refType = IrTypesKt.typeWith((IrClassifierSymbol)this.context.getSymbols().functionN(0), $i$f$buildFun22);
        IrRichFunctionReferenceImpl testFunReference = BuildersKt.IrRichFunctionReferenceImpl$default(-1, -1, refType, null, UpgradeCallableReferences.Companion.selectSAMOverriddenFunction(refType), function2, null, false, false, false, false, 896, null);
        IrBody irBody = parentFunction.getBody();
        Intrinsics.checkNotNull(irBody, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
        Collection collection = ((IrBlockBody)irBody).getStatements();
        IrCall $this$createInvocation_u24lambda_u241 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, $this$createInvocation, null, null, null, null, 0, 0, 126, null);
        boolean bl3 = false;
        $this$createInvocation_u24lambda_u241.getArguments().set(0, JsIrBuilder.INSTANCE.buildString(this.context.getIrBuiltIns().getStringType(), name2));
        $this$createInvocation_u24lambda_u241.getArguments().set(1, JsIrBuilder.INSTANCE.buildBoolean(this.context.getIrBuiltIns().getBooleanType(), ignored));
        $this$createInvocation_u24lambda_u241.getArguments().set(2, testFunReference);
        collection.add(irCall);
        return function2;
    }

    /*
     * WARNING - void declaration
     */
    private final void generateTestCalls(IrClass irClass, Function0<? extends IrSimpleFunction> parentFunction) {
        List list;
        Iterable<Object> destination$iv$iv;
        List list2;
        if (irClass.getModality() == Modality.ABSTRACT || IrUtilsKt.isEffectivelyExternal(irClass) || irClass.isExpect()) {
            return;
        }
        Lazy<IrSimpleFunction> suiteFunBody$delegate = LazyKt.lazy(LazyThreadSafetyMode.NONE, () -> TestGenerator.generateTestCalls$lambda$0(this, irClass, parentFunction));
        Collection $this$filterIsInstanceAnd$iv = irClass.getDeclarations();
        boolean $i$f$filterIsInstanceAnd = false;
        if ($this$filterIsInstanceAnd$iv.isEmpty()) {
            list2 = kotlin.collections.CollectionsKt.emptyList();
        } else {
            void $this$filterIsInstanceAndTo$iv$iv;
            Iterable iterable = $this$filterIsInstanceAnd$iv;
            destination$iv$iv = new SmartList();
            boolean $i$f$filterIsInstanceAndTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceAndTo$iv$iv) {
                if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
                IrSimpleFunction it = (IrSimpleFunction)element$iv$iv;
                boolean bl = false;
                if (!this.isBefore(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        }
        List beforeFunctions = list2;
        Collection $this$filterIsInstanceAnd$iv2 = irClass.getDeclarations();
        boolean $i$f$filterIsInstanceAnd2 = false;
        if ($this$filterIsInstanceAnd$iv2.isEmpty()) {
            list = kotlin.collections.CollectionsKt.emptyList();
        } else {
            void $this$filterIsInstanceAndTo$iv$iv;
            destination$iv$iv = $this$filterIsInstanceAnd$iv2;
            Collection destination$iv$iv2 = new SmartList();
            boolean $i$f$filterIsInstanceAndTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceAndTo$iv$iv) {
                if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
                IrSimpleFunction it = (IrSimpleFunction)element$iv$iv;
                boolean bl = false;
                if (!this.isAfter(it)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            list = (List)destination$iv$iv2;
        }
        List afterFunctions = list;
        Iterable $this$forEach$iv = irClass.getDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrDeclaration it = (IrDeclaration)element$iv;
            boolean bl = false;
            if (it instanceof IrClass) {
                this.generateTestCalls((IrClass)it, () -> TestGenerator.generateTestCalls$lambda$4$0(suiteFunBody$delegate));
                continue;
            }
            if (!(it instanceof IrSimpleFunction) || !this.isTest(it)) continue;
            this.generateCodeForTestMethod((IrSimpleFunction)it, beforeFunctions, afterFunctions, irClass, TestGenerator.generateTestCalls$lambda$1(suiteFunBody$delegate));
        }
    }

    private final boolean isVisibleFromTests(IrDeclarationWithVisibility $this$isVisibleFromTests) {
        return Intrinsics.areEqual($this$isVisibleFromTests.getVisibility(), DescriptorVisibilities.PUBLIC) || Intrinsics.areEqual($this$isVisibleFromTests.getVisibility(), DescriptorVisibilities.INTERNAL);
    }

    private final boolean isEffectivelyVisibleFromTests(IrDeclarationWithVisibility $this$isEffectivelyVisibleFromTests) {
        boolean bl;
        block1: {
            Sequence<IrDeclarationWithVisibility> $this$all$iv = SequencesKt.generateSequence($this$isEffectivelyVisibleFromTests, TestGenerator::isEffectivelyVisibleFromTests$lambda$0);
            boolean $i$f$all = false;
            Iterator<IrDeclarationWithVisibility> iterator2 = $this$all$iv.iterator();
            while (iterator2.hasNext()) {
                IrDeclarationWithVisibility element$iv;
                IrDeclarationWithVisibility it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (this.isVisibleFromTests(it)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canBeInstantiated(IrClass $this$canBeInstantiated) {
        boolean isClassReachable = this.isEffectivelyVisibleFromTests($this$canBeInstantiated);
        if (!IrUtilsKt.isObject($this$canBeInstantiated)) {
            boolean bl;
            if (!isClassReachable) return false;
            Sequence<IrConstructor> $this$any$iv = IrUtilsKt.getConstructors($this$canBeInstantiated);
            boolean $i$f$any = false;
            Iterator<IrConstructor> iterator2 = $this$any$iv.iterator();
            do {
                IrConstructor element$iv;
                if (!iterator2.hasNext()) return false;
                IrConstructor it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (this.isVisibleFromTests(it) && it.getParameters().size() == ($this$canBeInstantiated.isInner() ? 1 : 0)) {
                    return true;
                }
                bl = false;
            } while (!bl);
            return true;
        }
        boolean bl = isClassReachable;
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final void generateCodeForTestMethod(IrSimpleFunction testFun, List<? extends IrSimpleFunction> beforeFuns, List<? extends IrSimpleFunction> afterFuns, IrClass irClass, IrSimpleFunction parentFunction) {
        void $this$generateCodeForTestMethod_u24lambda_u247_u240;
        IrCompositeImpl irCompositeImpl;
        IrTryImpl irTryImpl;
        IrType $this$generateCodeForTestMethod_u24lambda_u242;
        Object $this$generateCodeForTestMethod_u24lambda_u241_u240;
        Object object;
        void $this$mapTo$iv$iv;
        String exceptionMessage;
        String string;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.context.getTestFun();
        Intrinsics.checkNotNull(irSimpleFunctionSymbol);
        String string2 = testFun.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        IrSimpleFunction fn = this.createInvocation(irSimpleFunctionSymbol, string2, parentFunction, this.isIgnored(testFun));
        IrBody irBody = fn.getBody();
        Intrinsics.checkNotNull(irBody, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
        IrBlockBody body = (IrBlockBody)irBody;
        if (!((Collection)IrUtilsKt.getNonDispatchParameters(testFun)).isEmpty() || !this.isEffectivelyVisibleFromTests(testFun)) {
            StringBuilder stringBuilder = new StringBuilder().append("Test method ");
            Object object2 = IrUtilsKt.getFqNameWhenAvailable(irClass);
            if (object2 == null) {
                object2 = irClass.getName();
            }
            string = stringBuilder.append(object2).append("::").append(testFun.getName()).append(" should have public or internal visibility, can not have parameters").toString();
        } else if (!this.canBeInstantiated(irClass)) {
            StringBuilder stringBuilder = new StringBuilder().append("Test class ");
            Object object3 = IrUtilsKt.getFqNameWhenAvailable(irClass);
            if (object3 == null) {
                object3 = irClass.getName();
            }
            string = stringBuilder.append(object3).append(" must declare a public or internal constructor with no explicit parameters").toString();
        } else {
            string = exceptionMessage = null;
        }
        if (exceptionMessage != null) {
            IrCall irCall;
            DeclarationIrBuilder irBuilder = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)fn.getSymbol(), 0, 0, 6, null);
            Collection collection = body.getStatements();
            IrCall $this$generateCodeForTestMethod_u24lambda_u240 = irCall = ExpressionHelpersKt.irCall((IrBuilder)irBuilder, this.context.getIrBuiltIns().getIllegalArgumentExceptionSymbol());
            boolean bl = false;
            $this$generateCodeForTestMethod_u24lambda_u240.getArguments().set(0, ExpressionHelpersKt.irString(irBuilder, exceptionMessage));
            collection.add(irCall);
            return;
        }
        IrVariable classVal = JsIrBuilder.buildVar$default(JsIrBuilder.INSTANCE, IrUtilsKt.getDefaultType(irClass), fn, null, false, false, false, this.instance(irClass), null, 188, null);
        ((Collection)body.getStatements()).add(classVal);
        Collection collection = body.getStatements();
        Object $this$map$iv = beforeFuns;
        boolean $i$f$map22 = false;
        Iterable bl = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrSimpleFunction irSimpleFunction = (IrSimpleFunction)item$iv$iv;
            object = destination$iv$iv;
            boolean bl2 = false;
            IrCall irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, it.getSymbol(), null, null, null, null, 0, 0, 126, null);
            $this$generateCodeForTestMethod_u24lambda_u241_u240 = irCall;
            boolean bl3 = false;
            ((IrMemberAccessExpression)$this$generateCodeForTestMethod_u24lambda_u241_u240).setDispatchReceiver(JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, classVal.getSymbol(), null, 2, null));
            object.add(irCall);
        }
        $this$map$iv = (List)destination$iv$iv;
        kotlin.collections.CollectionsKt.addAll(collection, $this$map$iv);
        Object $i$f$map22 = $this$map$iv = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, testFun.getSymbol(), null, null, null, null, 0, 0, 126, null);
        IrFunctionSymbol irFunctionSymbol = fn.getSymbol();
        object = JsIrBuilder.INSTANCE;
        boolean bl4 = false;
        ((IrMemberAccessExpression)((Object)$this$generateCodeForTestMethod_u24lambda_u242)).setDispatchReceiver(JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, classVal.getSymbol(), null, 2, null));
        Unit unit = Unit.INSTANCE;
        IrReturnImpl returnStatement = ((JsIrBuilder)object).buildReturn(irFunctionSymbol, (IrExpression)$this$map$iv, this.context.getIrBuiltIns().getUnitType());
        if (afterFuns.isEmpty()) {
            ((Collection)body.getStatements()).add(returnStatement);
            return;
        }
        $this$generateCodeForTestMethod_u24lambda_u242 = testFun.getReturnType();
        IrSimpleType returnType = $this$generateCodeForTestMethod_u24lambda_u242 instanceof IrSimpleType ? (IrSimpleType)$this$generateCodeForTestMethod_u24lambda_u242 : null;
        IrClassSymbol promiseSymbol = this.context.getJsPromiseSymbol();
        if (promiseSymbol != null && returnType != null && this.isPromise(returnType)) {
            IrCall irCall;
            Object v9;
            IrRichFunctionReferenceImpl finallyLambda;
            IrExpression promiseCastedIfNeeded;
            block13: {
                void $this$findIsInstanceAnd$iv;
                Collection<Object> collection2;
                void $this$mapTo$iv$iv2;
                Iterable $this$memoryOptimizedMap$iv;
                promiseCastedIfNeeded = Intrinsics.areEqual(returnType.getClassifier(), this.context.getJsPromiseSymbol()) ? returnStatement.getValue() : (IrExpression)BuildersKt.IrTypeOperatorCallImpl(-1, -1, testFun.getReturnType(), IrTypeOperator.CAST, IrTypesKt.getDefaultType(promiseSymbol), returnStatement.getValue());
                IrType[] $this$buildFun$iv = this.context.getIrFactory();
                boolean $i$f$buildFun = false;
                IrFunctionBuilder $this$buildFun_u24lambda_u240$iv = new IrFunctionBuilder();
                boolean $i$a$-run-DeclarationBuildersKt$buildFun$1$iv22 = false;
                IrFunctionBuilder $this$generateCodeForTestMethod_u24lambda_u2452 = $this$buildFun_u24lambda_u240$iv;
                int n2 = 0;
                Name name2 = Name.identifier(irClass.getName().asString() + " after test fun");
                Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
                $this$generateCodeForTestMethod_u24lambda_u2452.setName(name2);
                $this$generateCodeForTestMethod_u24lambda_u2452.setReturnType(this.context.getIrBuiltIns().getUnitType());
                $this$generateCodeForTestMethod_u24lambda_u2452.setOrigin(JsIrBuilder.INSTANCE.getSYNTHESIZED_DECLARATION());
                IrType[] $this$generateCodeForTestMethod_u24lambda_u244 = $this$buildFun$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv, $this$buildFun_u24lambda_u240$iv);
                boolean bl5 = false;
                $this$generateCodeForTestMethod_u24lambda_u244.setParent(fn);
                Collection $i$a$-run-DeclarationBuildersKt$buildFun$1$iv22 = afterFuns;
                int $this$generateCodeForTestMethod_u24lambda_u2452 = -1;
                n2 = -1;
                $this$generateCodeForTestMethod_u24lambda_u241_u240 = this.context.getIrFactory();
                IrType[] bl3 = $this$generateCodeForTestMethod_u24lambda_u244;
                boolean $i$f$memoryOptimizedMap = false;
                Iterable iterable = $this$memoryOptimizedMap$iv;
                Collection destination$iv$iv2 = new ArrayList($this$memoryOptimizedMap$iv.size());
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    IrCall irCall2;
                    IrSimpleFunction irSimpleFunction = (IrSimpleFunction)item$iv$iv;
                    collection2 = destination$iv$iv2;
                    boolean bl6 = false;
                    IrCall $this$generateCodeForTestMethod_u24lambda_u244_u240_u240 = irCall2 = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, it.getSymbol(), null, null, null, null, 0, 0, 126, null);
                    boolean bl7 = false;
                    $this$generateCodeForTestMethod_u24lambda_u244_u240_u240.setDispatchReceiver(JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, classVal.getSymbol(), null, 2, null));
                    collection2.add(irCall2);
                }
                collection2 = CollectionsKt.compactIfPossible((List)destination$iv$iv2);
                bl3.setBody(IrFactoryHelpersKt.createBlockBody((IrFactory)$this$generateCodeForTestMethod_u24lambda_u241_u240, n2, $this$generateCodeForTestMethod_u24lambda_u2452, collection2));
                IrType[] afterFunction = $this$buildFun$iv;
                $this$generateCodeForTestMethod_u24lambda_u244 = new IrType[]{afterFunction.getReturnType()};
                IrSimpleType refType = IrTypesKt.typeWith((IrClassifierSymbol)this.context.getSymbols().functionN(0), $this$generateCodeForTestMethod_u24lambda_u244);
                finallyLambda = BuildersKt.IrRichFunctionReferenceImpl$default(-1, -1, refType, null, UpgradeCallableReferences.Companion.selectSAMOverriddenFunction(refType), (IrSimpleFunction)afterFunction, null, false, false, false, false, 896, null);
                $this$memoryOptimizedMap$iv = ((IrClass)promiseSymbol.getOwner()).getDeclarations();
                boolean $i$f$findIsInstanceAnd = false;
                for (Object element$iv : $this$findIsInstanceAnd$iv) {
                    if (!(element$iv instanceof IrSimpleFunction)) continue;
                    IrSimpleFunction it = (IrSimpleFunction)element$iv;
                    boolean bl8 = false;
                    if (!Intrinsics.areEqual(it.getName().asString(), "finally")) continue;
                    v9 = element$iv;
                    break block13;
                }
                v9 = null;
            }
            Intrinsics.checkNotNull(v9);
            IrSimpleFunction irSimpleFunction = v9;
            IrCall $this$generateCodeForTestMethod_u24lambda_u246 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, irSimpleFunction.getSymbol(), null, null, null, null, 0, 0, 126, null);
            boolean bl9 = false;
            $this$generateCodeForTestMethod_u24lambda_u246.getArguments().set(0, promiseCastedIfNeeded);
            $this$generateCodeForTestMethod_u24lambda_u246.getArguments().set(1, finallyLambda);
            IrCall returnValue = irCall;
            ((Collection)body.getStatements()).add(JsIrBuilder.INSTANCE.buildReturn(fn.getSymbol(), returnValue, fn.getReturnType()));
            return;
        }
        Collection collection3 = body.getStatements();
        IrTryImpl $this$generateCodeForTestMethod_u24lambda_u247 = irTryImpl = JsIrBuilder.INSTANCE.buildTry(this.context.getIrBuiltIns().getUnitType());
        boolean bl10 = false;
        $this$generateCodeForTestMethod_u24lambda_u247.setTryResult(returnStatement);
        IrCompositeImpl returnValue = irCompositeImpl = JsIrBuilder.buildComposite$default(JsIrBuilder.INSTANCE, this.context.getIrBuiltIns().getUnitType(), null, 2, null);
        IrTryImpl irTryImpl2 = $this$generateCodeForTestMethod_u24lambda_u247;
        boolean bl11 = false;
        Collection collection4 = $this$generateCodeForTestMethod_u24lambda_u247_u240.getStatements();
        Iterable $this$map$iv2 = afterFuns;
        boolean $i$f$map = false;
        Iterable $this$mapTo$iv$iv2 = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            IrCall irCall;
            IrSimpleFunction it = (IrSimpleFunction)item$iv$iv;
            Collection collection5 = destination$iv$iv3;
            boolean bl12 = false;
            IrCall $this$generateCodeForTestMethod_u24lambda_u247_u240_u240_u240 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, it.getSymbol(), null, null, null, null, 0, 0, 126, null);
            boolean bl13 = false;
            $this$generateCodeForTestMethod_u24lambda_u247_u240_u240_u240.setDispatchReceiver(JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, classVal.getSymbol(), null, 2, null));
            collection5.add(irCall);
        }
        Iterable iterable = (List)destination$iv$iv3;
        kotlin.collections.CollectionsKt.addAll(collection4, iterable);
        irTryImpl2.setFinallyExpression(irCompositeImpl);
        collection3.add(irTryImpl);
    }

    private final IrExpression instance(IrClass $this$instance) {
        IrExpression irExpression;
        if ($this$instance.getKind() == ClassKind.OBJECT) {
            irExpression = JsIrBuilder.INSTANCE.buildGetObjectValue(IrUtilsKt.getDefaultType($this$instance), $this$instance.getSymbol());
        } else {
            IrElementBase it;
            Object element$iv;
            block4: {
                Sequence $this$filterIsInstance$iv = kotlin.collections.CollectionsKt.asSequence((Iterable)$this$instance.getDeclarations());
                boolean $i$f$filterIsInstance = false;
                Sequence sequence2 = SequencesKt.filter($this$filterIsInstance$iv, instance$$inlined$filterIsInstance$1.INSTANCE);
                Intrinsics.checkNotNull(sequence2, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                Sequence $this$first$iv = sequence2;
                boolean $i$f$first = false;
                Iterator iterator2 = $this$first$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv = iterator2.next();
                    it = (IrConstructor)element$iv;
                    boolean bl = false;
                    if (!(((IrFunction)it).getParameters().size() == ($this$instance.isInner() ? 1 : 0))) continue;
                    break block4;
                }
                throw new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            IrConstructor constructor = (IrConstructor)element$iv;
            boolean bl = false;
            IrConstructorCallImpl irConstructorCallImpl = BuildersKt.fromSymbolOwner$default(IrConstructorCallImpl.Companion, IrUtilsKt.getDefaultType($this$instance), constructor.getSymbol(), null, 4, null);
            it = irConstructorCallImpl;
            boolean bl2 = false;
            if ($this$instance.isInner()) {
                IrDeclarationParent irDeclarationParent = $this$instance.getParent();
                Intrinsics.checkNotNull(irDeclarationParent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                ((IrMemberAccessExpression)it).setDispatchReceiver(this.instance((IrClass)irDeclarationParent));
            }
            irExpression = irConstructorCallImpl;
        }
        return irExpression;
    }

    private final boolean isTest(IrAnnotationContainer $this$isTest) {
        return this.hasAnnotation($this$isTest, "kotlin.test.Test");
    }

    private final boolean isIgnored(IrAnnotationContainer $this$isIgnored) {
        return this.hasAnnotation($this$isIgnored, "kotlin.test.Ignore");
    }

    private final boolean isBefore(IrAnnotationContainer $this$isBefore) {
        return this.hasAnnotation($this$isBefore, "kotlin.test.BeforeTest");
    }

    private final boolean isAfter(IrAnnotationContainer $this$isAfter) {
        return this.hasAnnotation($this$isAfter, "kotlin.test.AfterTest");
    }

    private final boolean hasAnnotation(IrAnnotationContainer $this$hasAnnotation, String fqName2) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $this$hasAnnotation.getAnnotations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrConstructorCall it = (IrConstructorCall)element$iv;
                    boolean bl2 = false;
                    FqName fqName3 = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)it.getSymbol().getOwner());
                    if (!Intrinsics.areEqual(fqName3 != null && (fqName3 = fqName3.parent()) != null ? fqName3.asString() : null, fqName2)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isPromise(IrSimpleType $this$isPromise) {
        if (Intrinsics.areEqual($this$isPromise.getClassifier(), this.context.getJsPromiseSymbol())) {
            return true;
        }
        IrSymbolOwner irSymbolOwner = $this$isPromise.getClassifier().getOwner();
        IrClass irClass = irSymbolOwner instanceof IrClass ? (IrClass)irSymbolOwner : null;
        if (irClass == null) {
            return false;
        }
        IrClass klass = irClass;
        return klass.isExternal() && AnnotationUtilsKt.getJsModule(klass) == null && Intrinsics.areEqual(AnnotationUtilsKt.getJsNameOrKotlinName(klass).asString(), "Promise");
    }

    /*
     * WARNING - void declaration
     */
    private static final IrSimpleFunction createTestContainer$lambda$0(TestGenerator this$0, IrFile $irFile) {
        IrSimpleFunction irSimpleFunction;
        void $this$addFunction$iv;
        Object object = this$0.context.getIrFactory();
        IrDeclarationContainer klass$iv = $irFile;
        boolean $i$f$addFunction = false;
        void $this$buildFun$iv$iv = $this$addFunction$iv;
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u240$iv$iv = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$createTestContainer_u24lambda_u240_u240 = $this$buildFun_u24lambda_u240$iv$iv;
        boolean bl2 = false;
        Name name2 = Name.identifier("test fun");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        $this$createTestContainer_u24lambda_u240_u240.setName(name2);
        $this$createTestContainer_u24lambda_u240_u240.setReturnType(this$0.context.getIrBuiltIns().getUnitType());
        $this$createTestContainer_u24lambda_u240_u240.setOrigin(JsIrBuilder.INSTANCE.getSYNTHESIZED_DECLARATION());
        IrSimpleFunction function$iv = irSimpleFunction = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv, $this$buildFun_u24lambda_u240$iv$iv);
        boolean bl3 = false;
        klass$iv.getDeclarations().add(function$iv);
        function$iv.setParent(klass$iv);
        Object $this$createTestContainer_u24lambda_u240_u241 = object = irSimpleFunction;
        boolean bl4 = false;
        ((IrFunction)$this$createTestContainer_u24lambda_u240_u241).setBody(IrFactoryHelpersKt.createBlockBody(this$0.context.getIrFactory(), -1, -1, kotlin.collections.CollectionsKt.emptyList()));
        return object;
    }

    private static final Unit createTestContainer$lambda$1$0(TestGenerator this$0, IrDeclaration $it, Lazy $testContainer) {
        this$0.generateTestCalls((IrClass)$it, () -> TestGenerator.createTestContainer$lambda$1$0$0($testContainer));
        return Unit.INSTANCE;
    }

    private static final IrSimpleFunction createTestContainer$lambda$1$0$0(Lazy $testContainer) {
        return (IrSimpleFunction)$testContainer.getValue();
    }

    private static final IrSimpleFunction generateTestCalls$lambda$0(TestGenerator this$0, IrClass $irClass, Function0 $parentFunction) {
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = this$0.context.getSuiteFun();
        Intrinsics.checkNotNull(irSimpleFunctionSymbol);
        String string = $irClass.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
        return this$0.createInvocation(irSimpleFunctionSymbol, string, (IrSimpleFunction)$parentFunction.invoke(), this$0.isIgnored($irClass));
    }

    private static final IrSimpleFunction generateTestCalls$lambda$1(Lazy<? extends IrSimpleFunction> $suiteFunBody$delegate) {
        Lazy<? extends IrSimpleFunction> lazy = $suiteFunBody$delegate;
        return lazy.getValue();
    }

    private static final IrSimpleFunction generateTestCalls$lambda$4$0(Lazy $suiteFunBody$delegate) {
        return TestGenerator.generateTestCalls$lambda$1($suiteFunBody$delegate);
    }

    private static final IrDeclarationWithVisibility isEffectivelyVisibleFromTests$lambda$0(IrDeclarationWithVisibility it) {
        Intrinsics.checkNotNullParameter(it, "it");
        IrDeclarationParent irDeclarationParent = it.getParent();
        return irDeclarationParent instanceof IrDeclarationWithVisibility ? (IrDeclarationWithVisibility)((Object)irDeclarationParent) : null;
    }
}

