/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.rule.engine.core.api.editorconfig;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.ec4j.core.model.PropertyType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/SafeEnumValueParser;", "T", "", "Lorg/ec4j/core/model/PropertyType$PropertyValueParser;", "enumType", "Ljava/lang/Class;", "<init>", "(Ljava/lang/Class;)V", "parse", "Lorg/ec4j/core/model/PropertyType$PropertyValue;", "name", "", "value", "ktlint-rule-engine-core"})
public final class SafeEnumValueParser<T extends Enum<T>>
implements PropertyType.PropertyValueParser<T> {
    @NotNull
    private final Class<T> enumType;

    public SafeEnumValueParser(@NotNull Class<T> enumType) {
        Intrinsics.checkNotNullParameter(enumType, "enumType");
        this.enumType = enumType;
    }

    @Override
    @NotNull
    public PropertyType.PropertyValue<T> parse(@Nullable String name2, @Nullable String value2) {
        PropertyType.PropertyValue propertyValue;
        if (value2 == null) {
            PropertyType.PropertyValue propertyValue2 = PropertyType.PropertyValue.invalid(null, "Cannot make enum " + this.enumType.getName() + " out of null");
            Intrinsics.checkNotNull(propertyValue2);
            propertyValue = propertyValue2;
        } else {
            PropertyType.PropertyValue<Object> propertyValue3;
            try {
                String string = ((Object)StringsKt.trim((CharSequence)value2)).toString();
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
                String string2 = string.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
                propertyValue3 = Enum.valueOf(this.enumType, string2);
                Intrinsics.checkNotNull(propertyValue3, "null cannot be cast to non-null type T of com.pinterest.ktlint.rule.engine.core.api.editorconfig.SafeEnumValueParser");
                propertyValue3 = PropertyType.PropertyValue.valid(value2, propertyValue3);
            }
            catch (IllegalArgumentException e2) {
                propertyValue3 = PropertyType.PropertyValue.invalid(value2, "Unexpected parsed \"" + value2 + "\" for enum " + this.enumType.getName());
            }
            PropertyType.PropertyValue propertyValue4 = propertyValue3;
            Intrinsics.checkNotNull(propertyValue4);
            propertyValue = propertyValue4;
        }
        return propertyValue;
    }
}

