/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.extapi.psi.StubBasedPsiElementBase;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.cache.TypeInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaClassElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiClassStub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubBase;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.util.BitUtil;

public class PsiClassStubImpl<T extends PsiClass>
extends StubBase<T>
implements PsiClassStub<T> {
    @NotNull
    private final TypeInfo myTypeInfo;
    private final String myQualifiedName;
    private final String myName;
    private final String myBaseRefText;
    private final short myFlags;
    private String mySourceFileName;

    public PsiClassStubImpl(@NotNull JavaClassElementType type2, StubElement parent2, @Nullable String qualifiedName2, @Nullable String name2, @Nullable String baseRefText, short flags) {
        if (type2 == null) {
            PsiClassStubImpl.$$$reportNull$$$0(0);
        }
        this(type2, parent2, TypeInfo.fromString(qualifiedName2), name2, baseRefText, flags);
    }

    public PsiClassStubImpl(@NotNull JavaClassElementType type2, StubElement parent2, @NotNull TypeInfo typeInfo, @Nullable String name2, @Nullable String baseRefText, short flags) {
        if (type2 == null) {
            PsiClassStubImpl.$$$reportNull$$$0(1);
        }
        if (typeInfo == null) {
            PsiClassStubImpl.$$$reportNull$$$0(2);
        }
        super(parent2, type2);
        this.myTypeInfo = typeInfo;
        this.myQualifiedName = typeInfo.text();
        this.myName = name2;
        this.myBaseRefText = baseRefText;
        this.myFlags = flags;
        if (StubBasedPsiElementBase.ourTraceStubAstBinding) {
            String creationTrace = "Stub creation thread: " + Thread.currentThread() + "\n" + DebugUtil.currentStackTrace();
            this.putUserData(StubBasedPsiElementBase.CREATION_TRACE, creationTrace);
        }
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @NotNull
    public TypeInfo getQualifiedNameTypeInfo() {
        TypeInfo typeInfo = this.myTypeInfo;
        if (typeInfo == null) {
            PsiClassStubImpl.$$$reportNull$$$0(3);
        }
        return typeInfo;
    }

    @Override
    public String getQualifiedName() {
        return this.myQualifiedName;
    }

    @Override
    public String getBaseClassReferenceText() {
        return this.myBaseRefText;
    }

    @Override
    public boolean isDeprecated() {
        return BitUtil.isSet(this.myFlags, 1);
    }

    @Override
    public boolean hasDeprecatedAnnotation() {
        return BitUtil.isSet(this.myFlags, 128);
    }

    @Override
    public boolean isInterface() {
        return BitUtil.isSet(this.myFlags, 2);
    }

    @Override
    public boolean isEnum() {
        return BitUtil.isSet(this.myFlags, 4);
    }

    @Override
    public boolean isRecord() {
        return BitUtil.isSet(this.myFlags, 2048);
    }

    @Override
    public boolean isImplicit() {
        return BitUtil.isSet(this.myFlags, 4096);
    }

    @Override
    public boolean isEnumConstantInitializer() {
        return PsiClassStubImpl.isEnumConstInitializer(this.myFlags);
    }

    public static boolean isEnumConstInitializer(short flags) {
        return BitUtil.isSet(flags, 8);
    }

    public static boolean isImplicit(short flags) {
        return BitUtil.isSet(flags, 4096);
    }

    @Override
    public boolean isAnonymous() {
        return PsiClassStubImpl.isAnonymous(this.myFlags);
    }

    public static boolean isAnonymous(short flags) {
        return BitUtil.isSet(flags, 16);
    }

    @Override
    public boolean isAnnotationType() {
        return BitUtil.isSet(this.myFlags, 32);
    }

    @Override
    public boolean hasDocComment() {
        return BitUtil.isSet(this.myFlags, 1024);
    }

    @Override
    public String getSourceFileName() {
        return this.mySourceFileName;
    }

    public void setSourceFileName(String sourceFileName) {
        this.mySourceFileName = sourceFileName;
    }

    @Override
    public boolean isAnonymousInQualifiedNew() {
        return BitUtil.isSet(this.myFlags, 64);
    }

    public short getFlags() {
        return this.myFlags;
    }

    public static short packFlags(boolean isDeprecated, boolean isInterface, boolean isEnum, boolean isEnumConstantInitializer, boolean isAnonymous, boolean isAnnotationType, boolean isInQualifiedNew, boolean hasDeprecatedAnnotation, boolean anonymousInner, boolean localClassInner, boolean hasDocComment) {
        return PsiClassStubImpl.packFlags(isDeprecated, isInterface, isEnum, isEnumConstantInitializer, isAnonymous, isAnnotationType, isInQualifiedNew, hasDeprecatedAnnotation, anonymousInner, localClassInner, hasDocComment, false, false);
    }

    public static short packFlags(boolean isDeprecated, boolean isInterface, boolean isEnum, boolean isEnumConstantInitializer, boolean isAnonymous, boolean isAnnotationType, boolean isInQualifiedNew, boolean hasDeprecatedAnnotation, boolean anonymousInner, boolean localClassInner, boolean hasDocComment, boolean isRecord, boolean isImplicit) {
        short flags = 0;
        if (isDeprecated) {
            flags = (short)(flags | 1);
        }
        if (isInterface) {
            flags = (short)(flags | 2);
        }
        if (isEnum) {
            flags = (short)(flags | 4);
        }
        if (isEnumConstantInitializer) {
            flags = (short)(flags | 8);
        }
        if (isAnonymous) {
            flags = (short)(flags | 0x10);
        }
        if (isAnnotationType) {
            flags = (short)(flags | 0x20);
        }
        if (isInQualifiedNew) {
            flags = (short)(flags | 0x40);
        }
        if (hasDeprecatedAnnotation) {
            flags = (short)(flags | 0x80);
        }
        if (anonymousInner) {
            flags = (short)(flags | 0x100);
        }
        if (localClassInner) {
            flags = (short)(flags | 0x200);
        }
        if (hasDocComment) {
            flags = (short)(flags | 0x400);
        }
        if (isRecord) {
            flags = (short)(flags | 0x800);
        }
        if (isImplicit) {
            flags = (short)(flags | 0x1000);
        }
        return flags;
    }

    public boolean isAnonymousInner() {
        return BitUtil.isSet(this.myFlags, 256);
    }

    public boolean isLocalClassInner() {
        return BitUtil.isSet(this.myFlags, 512);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PsiClassStub[");
        if (this.isInterface()) {
            builder.append("interface ");
        }
        if (this.isAnonymous()) {
            builder.append("anonymous ");
        }
        if (this.isEnum()) {
            builder.append("enum ");
        }
        if (this.isRecord()) {
            builder.append("record ");
        }
        if (this.isAnnotationType()) {
            builder.append("annotation ");
        }
        if (this.isEnumConstantInitializer()) {
            builder.append("enumInit ");
        }
        if (this.isDeprecated()) {
            builder.append("deprecated ");
        }
        if (this.hasDeprecatedAnnotation()) {
            builder.append("deprecatedA ");
        }
        builder.append("name=").append(this.getName()).append(" fqn=").append(this.getQualifiedName());
        if (this.getBaseClassReferenceText() != null) {
            builder.append(" baseref=").append(this.getBaseClassReferenceText());
        }
        if (this.isAnonymousInQualifiedNew()) {
            builder.append(" inqualifnew");
        }
        if (this.isAnonymousInner()) {
            builder.append(" jvmAnonymousInner");
        }
        if (this.isLocalClassInner()) {
            builder.append(" jvmLocalClassInner");
        }
        builder.append("]");
        return builder.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/impl/PsiClassStubImpl";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/impl/PsiClassStubImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedNameTypeInfo";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

