/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.injected;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.LiteralTextEscaper;
import org.jetbrains.kotlin.com.intellij.psi.PsiFragment;
import org.jetbrains.kotlin.com.intellij.psi.PsiLanguageInjectionHost;
import org.jetbrains.kotlin.com.intellij.psi.PsiLiteralExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.PsiLiteralExpressionImpl;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

public class StringLiteralEscaper<T extends PsiLanguageInjectionHost>
extends LiteralTextEscaper<T> {
    private int[] outSourceOffsets;

    public StringLiteralEscaper(T host) {
        super(host);
    }

    @Override
    public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
        if (rangeInsideHost == null) {
            StringLiteralEscaper.$$$reportNull$$$0(0);
        }
        if (outChars == null) {
            StringLiteralEscaper.$$$reportNull$$$0(1);
        }
        String subText = rangeInsideHost.substring(this.myHost.getText());
        this.outSourceOffsets = new int[subText.length() + 1];
        return PsiLiteralExpressionImpl.parseStringCharacters(subText, outChars, this.outSourceOffsets);
    }

    @Override
    public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
        int result2;
        if (rangeInsideHost == null) {
            StringLiteralEscaper.$$$reportNull$$$0(2);
        }
        int n2 = result2 = offsetInDecoded < this.outSourceOffsets.length ? this.outSourceOffsets[offsetInDecoded] : -1;
        if (result2 == -1) {
            return -1;
        }
        return Math.min(result2, rangeInsideHost.getLength()) + rangeInsideHost.getStartOffset();
    }

    @Override
    public boolean isOneLine() {
        boolean textBlock = this.myHost instanceof PsiFragment && ((PsiFragment)this.myHost).isTextBlock() || this.myHost instanceof PsiLiteralExpression && ((PsiLiteralExpression)((Object)this.myHost)).isTextBlock();
        return !textBlock;
    }

    @Override
    @NotNull
    public TextRange getRelevantTextRange() {
        if (this.myHost instanceof PsiFragment) {
            PsiFragment fragment = (PsiFragment)this.myHost;
            int length = fragment.getTextLength();
            IElementType tokenType = fragment.getTokenType();
            if (tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_BEGIN) {
                String text = fragment.getText();
                int startOffset = StringLiteralEscaper.findBlockStart(text);
                return startOffset < 0 ? new TextRange(0, length) : new TextRange(startOffset, length - 2);
            }
            if (tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_MID) {
                return new TextRange(1, Math.max(1, length - 2));
            }
            if (tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_END) {
                String text = fragment.getText();
                if (text.endsWith("\"\"\"")) {
                    return new TextRange(1, Math.max(1, length - 3));
                }
                return new TextRange(1, length);
            }
            if (tokenType == JavaTokenType.STRING_TEMPLATE_BEGIN || tokenType == JavaTokenType.STRING_TEMPLATE_MID) {
                return new TextRange(1, Math.max(1, length - 2));
            }
            if (tokenType == JavaTokenType.STRING_TEMPLATE_END) {
                String text = fragment.getText();
                if (text.endsWith("\"")) {
                    return new TextRange(1, Math.max(1, length - 1));
                }
                return new TextRange(1, length);
            }
            throw new IllegalStateException("Unexpected tokenType: " + tokenType);
        }
        if (this.myHost instanceof PsiLiteralExpression) {
            PsiLiteralExpression expression2 = (PsiLiteralExpression)((Object)this.myHost);
            int length = expression2.getTextLength();
            if (expression2.isTextBlock()) {
                String text = expression2.getText();
                int startOffset = StringLiteralEscaper.findBlockStart(text);
                return startOffset < 0 ? new TextRange(0, length) : new TextRange(startOffset, length - (text.endsWith("\"\"\"") ? 3 : 0));
            }
            PsiType type2 = expression2.getType();
            boolean isQuoted = PsiTypes.charType().equals(type2) || type2 != null && type2.equalsToText("java.lang.String");
            TextRange textRange = isQuoted ? new TextRange(1, Math.max(1, length - 1)) : TextRange.from(0, length);
            if (textRange == null) {
                StringLiteralEscaper.$$$reportNull$$$0(3);
            }
            return textRange;
        }
        int textLength = this.myHost.getTextLength();
        if (textLength >= 2) {
            TextRange textRange = TextRange.from(1, textLength - 2);
            if (textRange == null) {
                StringLiteralEscaper.$$$reportNull$$$0(4);
            }
            return textRange;
        }
        TextRange textRange = super.getRelevantTextRange();
        if (textRange == null) {
            StringLiteralEscaper.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    static int findBlockStart(String text) {
        if (!text.startsWith("\"\"\"")) {
            return -1;
        }
        int length = text.length();
        for (int i2 = 3; i2 < length; ++i2) {
            char c2 = text.charAt(i2);
            if (c2 == '\n') {
                return i2 + 1;
            }
            if (Character.isWhitespace(c2)) continue;
            return -1;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInsideHost";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outChars";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/injected/StringLiteralEscaper";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/injected/StringLiteralEscaper";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelevantTextRange";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "decode";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOffsetInHost";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

