/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategyKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.util.LightTreeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\n\u001a\u00020\u000b*\u00060\u0004j\u0002`\u00052\u0010\u0010\f\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\rJ<\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u000f*\u00060\u0004j\u0002`\u00052\u0010\u0010\u0010\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\r2\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\rJ0\u0010\u0012\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u000f*\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u000f2\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\rJ\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000f*\b\u0012\u0004\u0012\u00020\u00150\u000fR\u001b\u0010\u0002\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/diagnostics/UnreachableCodeLightTreeHelper;", "", "tree", "Lorg/jetbrains/kotlin/com/intellij/util/diff/FlyweightCapableTreeStructure;", "Lorg/jetbrains/kotlin/com/intellij/lang/LighterASTNode;", "Lorg/jetbrains/kotlin/diagnostics/Node;", "<init>", "(Lcom/intellij/util/diff/FlyweightCapableTreeStructure;)V", "getTree", "()Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "hasChildrenInSet", "", "set", "", "getLeavesOrReachableChildren", "", "reachable", "unreachable", "removeReachableElementsWithMeaninglessSiblings", "reachableElements", "mergeAdjacentTextRanges", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/TextRange;", "frontend.common-psi"})
@SourceDebugExtension(value={"SMAP\nUnreachableCodeLightTreeHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnreachableCodeLightTreeHelper.kt\norg/jetbrains/kotlin/diagnostics/UnreachableCodeLightTreeHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n774#2:88\n865#2,2:89\n1803#2,3:91\n*S KotlinDebug\n*F\n+ 1 UnreachableCodeLightTreeHelper.kt\norg/jetbrains/kotlin/diagnostics/UnreachableCodeLightTreeHelper\n*L\n62#1:88\n62#1:89,2\n67#1:91,3\n*E\n"})
public final class UnreachableCodeLightTreeHelper {
    @NotNull
    private final FlyweightCapableTreeStructure<LighterASTNode> tree;

    public UnreachableCodeLightTreeHelper(@NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
        Intrinsics.checkNotNullParameter(tree, "tree");
        this.tree = tree;
    }

    @NotNull
    public final FlyweightCapableTreeStructure<LighterASTNode> getTree() {
        return this.tree;
    }

    public final boolean hasChildrenInSet(@NotNull LighterASTNode $this$hasChildrenInSet, @NotNull Set<? extends LighterASTNode> set) {
        Intrinsics.checkNotNullParameter($this$hasChildrenInSet, "<this>");
        Intrinsics.checkNotNullParameter(set, "set");
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        LightTreePositioningStrategiesKt.traverseDescendants(this.tree, $this$hasChildrenInSet, arg_0 -> UnreachableCodeLightTreeHelper.hasChildrenInSet$lambda$0(result2, $this$hasChildrenInSet, set, arg_0));
        return result2.element;
    }

    @NotNull
    public final List<LighterASTNode> getLeavesOrReachableChildren(@NotNull LighterASTNode $this$getLeavesOrReachableChildren, @NotNull Set<? extends LighterASTNode> reachable, @NotNull Set<? extends LighterASTNode> unreachable) {
        Intrinsics.checkNotNullParameter($this$getLeavesOrReachableChildren, "<this>");
        Intrinsics.checkNotNullParameter(reachable, "reachable");
        Intrinsics.checkNotNullParameter(unreachable, "unreachable");
        List result2 = new ArrayList();
        LightTreePositioningStrategiesKt.traverseDescendants(this.tree, $this$getLeavesOrReachableChildren, arg_0 -> UnreachableCodeLightTreeHelper.getLeavesOrReachableChildren$lambda$0(reachable, this, unreachable, result2, arg_0));
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LighterASTNode> removeReachableElementsWithMeaninglessSiblings(@NotNull List<? extends LighterASTNode> $this$removeReachableElementsWithMeaninglessSiblings, @NotNull Set<? extends LighterASTNode> reachableElements) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$removeReachableElementsWithMeaninglessSiblings, "<this>");
        Intrinsics.checkNotNullParameter(reachableElements, "reachableElements");
        Set childrenToRemove = new LinkedHashSet();
        Iterator iterator2 = ((Iterable)$this$removeReachableElementsWithMeaninglessSiblings).iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            int index = n2++;
            LighterASTNode element = (LighterASTNode)iterator2.next();
            if (!reachableElements.contains(element)) continue;
            childrenToRemove.add(element);
            UnreachableCodeLightTreeHelper.removeReachableElementsWithMeaninglessSiblings$collectSiblingsIfMeaningless($this$removeReachableElementsWithMeaninglessSiblings, childrenToRemove, index, -1);
            UnreachableCodeLightTreeHelper.removeReachableElementsWithMeaninglessSiblings$collectSiblingsIfMeaningless($this$removeReachableElementsWithMeaninglessSiblings, childrenToRemove, index, 1);
        }
        Iterable $this$filter$iv = $this$removeReachableElementsWithMeaninglessSiblings;
        boolean $i$f$filter = false;
        Iterable index = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LighterASTNode it = (LighterASTNode)element$iv$iv;
            boolean bl = false;
            if (!(!childrenToRemove.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TextRange> mergeAdjacentTextRanges(@NotNull List<? extends TextRange> $this$mergeAdjacentTextRanges) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter($this$mergeAdjacentTextRanges, "<this>");
        ArrayList<TextRange> result2 = new ArrayList<TextRange>();
        Iterable iterable = $this$mergeAdjacentTextRanges;
        TextRange initial$iv = null;
        boolean $i$f$fold = false;
        TextRange accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            TextRange textRange;
            void elementRange;
            TextRange textRange2 = (TextRange)element$iv;
            TextRange currentTextRange = accumulator$iv;
            boolean bl = false;
            if (currentTextRange == null) {
                textRange = elementRange;
            } else if (currentTextRange.getEndOffset() == elementRange.getStartOffset()) {
                textRange = currentTextRange.union((TextRange)elementRange);
            } else {
                result2.add(currentTextRange);
                textRange = elementRange;
            }
            accumulator$iv = textRange;
        }
        TextRange lastRange = accumulator$iv;
        if (lastRange != null) {
            result2.add(lastRange);
        }
        return result2;
    }

    private static final boolean hasChildrenInSet$lambda$0(Ref.BooleanRef $result, LighterASTNode $this_hasChildrenInSet, Set $set, LighterASTNode it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (!$result.element && !Intrinsics.areEqual(it, $this_hasChildrenInSet) && $set.contains(it)) {
            $result.element = true;
        }
        return !$result.element;
    }

    private static final boolean getLeavesOrReachableChildren$lambda$0(Set $reachable, UnreachableCodeLightTreeHelper this$0, Set $unreachable, List $result, LighterASTNode element) {
        boolean bl;
        boolean isReachable2;
        Intrinsics.checkNotNullParameter(element, "element");
        boolean bl2 = isReachable2 = $reachable.contains(element) && !this$0.hasChildrenInSet(element, $unreachable);
        if (isReachable2 || LightTreeUtilsKt.getChildren(element, this$0.tree).isEmpty()) {
            $result.add(element);
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    private static final void removeReachableElementsWithMeaninglessSiblings$collectSiblingsIfMeaningless(List<? extends LighterASTNode> $this_removeReachableElementsWithMeaninglessSiblings, Set<LighterASTNode> childrenToRemove, int elementIndex, int direction) {
        int index = elementIndex + direction;
        if (!(0 <= index ? index < $this_removeReachableElementsWithMeaninglessSiblings.size() : false)) {
            return;
        }
        LighterASTNode element = $this_removeReachableElementsWithMeaninglessSiblings.get(index);
        if (LightTreePositioningStrategyKt.isFiller(element) || Intrinsics.areEqual(element.getTokenType(), KtTokens.COMMA)) {
            childrenToRemove.add(element);
            UnreachableCodeLightTreeHelper.removeReachableElementsWithMeaninglessSiblings$collectSiblingsIfMeaningless($this_removeReachableElementsWithMeaninglessSiblings, childrenToRemove, index, direction);
        }
    }
}

