/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirImplicitInvokeCall;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirImplicitInvokeCallBuilder;
import org.jetbrains.kotlin.fir.extensions.FirExtensionServiceKt;
import org.jetbrains.kotlin.fir.extensions.FirTypeAttributeExtension;
import org.jetbrains.kotlin.fir.extensions.FirTypeAttributeExtensionKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeAttribute;
import org.jetbrains.kotlin.fir.types.ConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.CustomAnnotationTypeAttribute;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;
import org.jetbrains.kotlin.fir.types.ParameterNameTypeAttribute;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u001a)\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0017\u0010\u0003\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\b\u0007H\u0086\b\u00f8\u0001\u0000\u001a\u001c\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u001a>\u0010\u000f\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0012\b\u0002\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u00112\b\b\u0002\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018\u001a\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u001e\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001f"}, d2={"copyAsImplicitInvokeCall", "Lorg/jetbrains/kotlin/fir/expressions/FirImplicitInvokeCall;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "setupCopy", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/expressions/builder/FirImplicitInvokeCallBuilder;", "", "Lkotlin/ExtensionFunctionType;", "resolvedTypeFromPrototype", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "fallbackSource", "Lorg/jetbrains/kotlin/KtSourceElement;", "computeTypeAttributes", "Lorg/jetbrains/kotlin/fir/types/ConeAttributes;", "", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "predefined", "Lorg/jetbrains/kotlin/fir/types/ConeAttribute;", "allowExtensionFunctionType", "", "shouldExpandTypeAliases", "tryExpandClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "extractContextParameterCount", "", "(Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;)Ljava/lang/Integer;", "providers"})
@SourceDebugExtension(value={"SMAP\nCopyUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CopyUtils.kt\norg/jetbrains/kotlin/fir/CopyUtilsKt\n+ 2 FirImplicitInvokeCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirImplicitInvokeCallBuilderKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,132:1\n71#2:133\n1#3:134\n35#4:135\n35#4:136\n*S KotlinDebug\n*F\n+ 1 CopyUtils.kt\norg/jetbrains/kotlin/fir/CopyUtilsKt\n*L\n28#1:133\n124#1:135\n125#1:136\n*E\n"})
public final class CopyUtilsKt {
    @NotNull
    public static final FirImplicitInvokeCall copyAsImplicitInvokeCall(@NotNull FirFunctionCall $this$copyAsImplicitInvokeCall, @NotNull Function1<? super FirImplicitInvokeCallBuilder, Unit> setupCopy) {
        FirImplicitInvokeCallBuilder firImplicitInvokeCallBuilder;
        Intrinsics.checkNotNullParameter($this$copyAsImplicitInvokeCall, "<this>");
        Intrinsics.checkNotNullParameter(setupCopy, "setupCopy");
        boolean $i$f$copyAsImplicitInvokeCall = false;
        FirFunctionCall original = $this$copyAsImplicitInvokeCall;
        boolean $i$f$buildImplicitInvokeCall = false;
        FirImplicitInvokeCallBuilder $this$copyAsImplicitInvokeCall_u24lambda_u240 = firImplicitInvokeCallBuilder = new FirImplicitInvokeCallBuilder();
        boolean bl = false;
        $this$copyAsImplicitInvokeCall_u24lambda_u240.setSource(original.getSource());
        $this$copyAsImplicitInvokeCall_u24lambda_u240.getAnnotations().addAll((Collection<FirAnnotation>)original.getAnnotations());
        $this$copyAsImplicitInvokeCall_u24lambda_u240.getTypeArguments().addAll((Collection<FirTypeProjection>)original.getTypeArguments());
        $this$copyAsImplicitInvokeCall_u24lambda_u240.setExplicitReceiver(original.getExplicitReceiver());
        $this$copyAsImplicitInvokeCall_u24lambda_u240.setDispatchReceiver(original.getDispatchReceiver());
        $this$copyAsImplicitInvokeCall_u24lambda_u240.setExtensionReceiver(original.getExtensionReceiver());
        $this$copyAsImplicitInvokeCall_u24lambda_u240.setArgumentList(original.getArgumentList());
        $this$copyAsImplicitInvokeCall_u24lambda_u240.setCalleeReference(original.getCalleeReference());
        setupCopy.invoke($this$copyAsImplicitInvokeCall_u24lambda_u240);
        return firImplicitInvokeCallBuilder.build();
    }

    @NotNull
    public static final FirResolvedTypeRef resolvedTypeFromPrototype(@NotNull FirTypeRef $this$resolvedTypeFromPrototype, @NotNull ConeKotlinType type2, @Nullable KtSourceElement fallbackSource) {
        Intrinsics.checkNotNullParameter($this$resolvedTypeFromPrototype, "<this>");
        Intrinsics.checkNotNullParameter(type2, "type");
        if ($this$resolvedTypeFromPrototype instanceof FirResolvedTypeRef) {
            FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)$this$resolvedTypeFromPrototype;
            KtSourceElement ktSourceElement = ((FirResolvedTypeRef)$this$resolvedTypeFromPrototype).getSource();
            if (ktSourceElement == null) {
                ktSourceElement = fallbackSource;
            }
            return TypeUtilsKt.withReplacedSourceAndType(firResolvedTypeRef, ktSourceElement, type2);
        }
        KtSourceElement ktSourceElement = $this$resolvedTypeFromPrototype.getSource();
        if (ktSourceElement == null) {
            ktSourceElement = fallbackSource;
        }
        return UtilsKt.toFirResolvedTypeRef(type2, ktSourceElement, $this$resolvedTypeFromPrototype instanceof FirUserTypeRef ? (FirUserTypeRef)$this$resolvedTypeFromPrototype : null);
    }

    @NotNull
    public static final ConeAttributes computeTypeAttributes(@NotNull List<? extends FirAnnotation> $this$computeTypeAttributes, @NotNull FirSession session, @NotNull List<? extends ConeAttribute<?>> predefined, boolean allowExtensionFunctionType, boolean shouldExpandTypeAliases) {
        Intrinsics.checkNotNullParameter($this$computeTypeAttributes, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(predefined, "predefined");
        if ($this$computeTypeAttributes.isEmpty()) {
            if (predefined.isEmpty()) {
                return ConeAttributes.Companion.getEmpty();
            }
            return ConeAttributes.Companion.create(predefined);
        }
        List attributes = new ArrayList();
        ParameterNameTypeAttribute parameterName = null;
        CollectionsKt.addAll((Collection)attributes, (Iterable)predefined);
        List customAnnotations = new ArrayList();
        for (FirAnnotation firAnnotation : $this$computeTypeAttributes) {
            ConeAttribute<?> attributeFromPlugin;
            block21: {
                ConeAttribute<?> coneAttribute;
                ClassId classId;
                ClassId classId2;
                boolean bl = shouldExpandTypeAliases;
                if (bl) {
                    classId2 = CopyUtilsKt.tryExpandClassId(firAnnotation, session);
                } else if (!bl) {
                    classId2 = ConeTypeUtilsKt.getClassId(FirTypeUtilsKt.getResolvedType(firAnnotation));
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                ClassId classId3 = classId = classId2;
                if (Intrinsics.areEqual(classId3, CompilerConeAttributes.Exact.INSTANCE.getANNOTATION_CLASS_ID())) {
                    ((Collection)attributes).add(CompilerConeAttributes.Exact.INSTANCE);
                    continue;
                }
                if (Intrinsics.areEqual(classId3, CompilerConeAttributes.NoInfer.INSTANCE.getANNOTATION_CLASS_ID())) {
                    ((Collection)attributes).add(CompilerConeAttributes.NoInfer.INSTANCE);
                    continue;
                }
                if (Intrinsics.areEqual(classId3, CompilerConeAttributes.ExtensionFunctionType.INSTANCE.getANNOTATION_CLASS_ID())) {
                    if (!allowExtensionFunctionType) continue;
                    ((Collection)attributes).add(CompilerConeAttributes.ExtensionFunctionType.INSTANCE);
                    continue;
                }
                if (Intrinsics.areEqual(classId3, CompilerConeAttributes.ContextFunctionTypeParams.Companion.getANNOTATION_CLASS_ID())) {
                    Collection collection = attributes;
                    Integer n2 = CopyUtilsKt.extractContextParameterCount(firAnnotation);
                    CompilerConeAttributes.ContextFunctionTypeParams contextFunctionTypeParams = new CompilerConeAttributes.ContextFunctionTypeParams(n2 != null ? n2 : 0);
                    collection.add(contextFunctionTypeParams);
                    continue;
                }
                if (Intrinsics.areEqual(classId3, ParameterNameTypeAttribute.Companion.getANNOTATION_CLASS_ID())) {
                    if (parameterName == null) {
                        Name name2;
                        if (FirAnnotationUtilsKt.getStringArgument(firAnnotation, StandardNames.NAME, session) != null) {
                            Object it;
                            boolean bl2 = false;
                            name2 = Name.identifier((String)it);
                        } else {
                            name2 = null;
                        }
                        Name knownName = name2;
                        parameterName = new ParameterNameTypeAttribute(knownName, CollectionsKt.listOf(firAnnotation));
                        continue;
                    }
                    parameterName = new ParameterNameTypeAttribute(parameterName.getName(), CollectionsKt.plus((Collection)parameterName.getAnnotations(), firAnnotation));
                    continue;
                }
                if (Intrinsics.areEqual(classId3, CompilerConeAttributes.UnsafeVariance.INSTANCE.getANNOTATION_CLASS_ID())) {
                    ((Collection)attributes).add(CompilerConeAttributes.UnsafeVariance.INSTANCE);
                    continue;
                }
                if (Intrinsics.areEqual(classId3, CompilerConeAttributes.EnhancedNullability.INSTANCE.getANNOTATION_CLASS_ID())) {
                    ((Collection)attributes).add(CompilerConeAttributes.EnhancedNullability.INSTANCE);
                    continue;
                }
                for (Object it : (Iterable)FirTypeAttributeExtensionKt.getTypeAttributeExtensions(FirExtensionServiceKt.getExtensionService(session))) {
                    boolean bl3 = false;
                    ConeAttribute<?> coneAttribute2 = ((FirTypeAttributeExtension)it).extractAttributeFromAnnotation(firAnnotation);
                    if (coneAttribute2 == null) continue;
                    coneAttribute = coneAttribute2;
                    break block21;
                }
                coneAttribute = attributeFromPlugin = null;
            }
            if (attributeFromPlugin != null) {
                ((Collection)attributes).add(attributeFromPlugin);
                continue;
            }
            ((Collection)customAnnotations).add(firAnnotation);
        }
        if (parameterName != null) {
            ((Collection)attributes).add(parameterName);
        }
        if (!((Collection)customAnnotations).isEmpty()) {
            ((Collection)attributes).add(new CustomAnnotationTypeAttribute(customAnnotations));
        }
        return ConeAttributes.Companion.create(attributes);
    }

    public static /* synthetic */ ConeAttributes computeTypeAttributes$default(List list, FirSession firSession, List list2, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return CopyUtilsKt.computeTypeAttributes(list, firSession, list2, bl, bl2);
    }

    private static final ClassId tryExpandClassId(FirAnnotation $this$tryExpandClassId, FirSession session) {
        ClassId classId;
        ConeClassLikeType directlyExpanded;
        FirAnnotation $this$unexpandedConeClassLikeType$iv = $this$tryExpandClassId;
        boolean $i$f$getUnexpandedConeClassLikeType = false;
        FirTypeRef firTypeRef = $this$unexpandedConeClassLikeType$iv.getAnnotationTypeRef();
        FirResolvedTypeRef firResolvedTypeRef = firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getConeType() : null;
        ConeClassLikeType coneClassLikeType = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
        ConeClassLikeType coneClassLikeType2 = directlyExpanded = coneClassLikeType != null ? TypeExpansionUtilsKt.directExpansionType(coneClassLikeType, session, CopyUtilsKt::tryExpandClassId$lambda$0) : null;
        if (directlyExpanded == null) {
            $this$unexpandedConeClassLikeType$iv = $this$tryExpandClassId;
            $i$f$getUnexpandedConeClassLikeType = false;
            firTypeRef = $this$unexpandedConeClassLikeType$iv.getAnnotationTypeRef();
            FirResolvedTypeRef firResolvedTypeRef2 = firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null;
            coneKotlinType = firResolvedTypeRef2 != null ? firResolvedTypeRef2.getConeType() : null;
            ConeClassLikeType coneClassLikeType3 = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
            classId = coneClassLikeType3 != null ? ConeTypeUtilsKt.getClassId(coneClassLikeType3) : null;
        } else {
            classId = ConeTypeUtilsKt.getClassId(TypeExpansionUtilsKt.fullyExpandedType$default(directlyExpanded, session, null, 2, null));
        }
        return classId;
    }

    private static final Integer extractContextParameterCount(FirAnnotation $this$extractContextParameterCount) {
        FirExpression firExpression = $this$extractContextParameterCount.getArgumentMapping().getMapping().get(StandardNames.CONTEXT_FUNCTION_TYPE_PARAMETER_COUNT_NAME);
        FirLiteralExpression firLiteralExpression = firExpression instanceof FirLiteralExpression ? (FirLiteralExpression)firExpression : null;
        Object object = firLiteralExpression != null ? firLiteralExpression.getValue() : null;
        return object instanceof Integer ? (Integer)object : null;
    }

    private static final ConeClassLikeType tryExpandClassId$lambda$0(FirTypeAlias it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return FirDeclarationUtilKt.getExpandedConeType(it);
    }
}

