/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.io.opentelemetry.api.metrics;

import java.util.function.Consumer;
import org.jetbrains.kotlin.io.opentelemetry.api.common.Attributes;
import org.jetbrains.kotlin.io.opentelemetry.api.metrics.BatchCallback;
import org.jetbrains.kotlin.io.opentelemetry.api.metrics.DoubleCounter;
import org.jetbrains.kotlin.io.opentelemetry.api.metrics.DoubleCounterBuilder;
import org.jetbrains.kotlin.io.opentelemetry.api.metrics.DoubleGaugeBuilder;
import org.jetbrains.kotlin.io.opentelemetry.api.metrics.DoubleHistogram;
import org.jetbrains.kotlin.io.opentelemetry.api.metrics.DoubleHistogramBuilder;
import org.jetbrains.kotlin.io.opentelemetry.api.metrics.DoubleUpDownCounter;
import org.jetbrains.kotlin.io.opentelemetry.api.metrics.DoubleUpDownCounterBuilder;
import org.jetbrains.kotlin.io.opentelemetry.api.metrics.LongCounter;
import org.jetbrains.kotlin.io.opentelemetry.api.metrics.LongCounterBuilder;
import org.jetbrains.kotlin.io.opentelemetry.api.metrics.LongGaugeBuilder;
import org.jetbrains.kotlin.io.opentelemetry.api.metrics.LongHistogram;
import org.jetbrains.kotlin.io.opentelemetry.api.metrics.LongHistogramBuilder;
import org.jetbrains.kotlin.io.opentelemetry.api.metrics.LongUpDownCounter;
import org.jetbrains.kotlin.io.opentelemetry.api.metrics.LongUpDownCounterBuilder;
import org.jetbrains.kotlin.io.opentelemetry.api.metrics.Meter;
import org.jetbrains.kotlin.io.opentelemetry.api.metrics.ObservableDoubleCounter;
import org.jetbrains.kotlin.io.opentelemetry.api.metrics.ObservableDoubleGauge;
import org.jetbrains.kotlin.io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import org.jetbrains.kotlin.io.opentelemetry.api.metrics.ObservableDoubleUpDownCounter;
import org.jetbrains.kotlin.io.opentelemetry.api.metrics.ObservableLongCounter;
import org.jetbrains.kotlin.io.opentelemetry.api.metrics.ObservableLongGauge;
import org.jetbrains.kotlin.io.opentelemetry.api.metrics.ObservableLongMeasurement;
import org.jetbrains.kotlin.io.opentelemetry.api.metrics.ObservableLongUpDownCounter;
import org.jetbrains.kotlin.io.opentelemetry.api.metrics.ObservableMeasurement;
import org.jetbrains.kotlin.io.opentelemetry.context.Context;

class DefaultMeter
implements Meter {
    private static final Meter INSTANCE = new DefaultMeter();
    private static final LongCounterBuilder NOOP_LONG_COUNTER_BUILDER = new NoopLongCounterBuilder();
    private static final LongUpDownCounterBuilder NOOP_LONG_UP_DOWN_COUNTER_BUILDER = new NoopLongUpDownCounterBuilder();
    private static final DoubleHistogramBuilder NOOP_DOUBLE_HISTOGRAM_BUILDER = new NoopDoubleHistogramBuilder();
    private static final DoubleGaugeBuilder NOOP_DOUBLE_GAUGE_BUILDER = new NoopDoubleGaugeBuilder();
    private static final BatchCallback NOOP_BATCH_CALLBACK = new BatchCallback(){};
    private static final ObservableDoubleMeasurement NOOP_OBSERVABLE_DOUBLE_MEASUREMENT = new NoopObservableDoubleMeasurement();
    private static final ObservableLongMeasurement NOOP_OBSERVABLE_LONG_MEASUREMENT = new NoopObservableLongMeasurement();

    static Meter getInstance() {
        return INSTANCE;
    }

    @Override
    public LongCounterBuilder counterBuilder(String name2) {
        return NOOP_LONG_COUNTER_BUILDER;
    }

    @Override
    public LongUpDownCounterBuilder upDownCounterBuilder(String name2) {
        return NOOP_LONG_UP_DOWN_COUNTER_BUILDER;
    }

    @Override
    public DoubleHistogramBuilder histogramBuilder(String name2) {
        return NOOP_DOUBLE_HISTOGRAM_BUILDER;
    }

    @Override
    public DoubleGaugeBuilder gaugeBuilder(String name2) {
        return NOOP_DOUBLE_GAUGE_BUILDER;
    }

    @Override
    public BatchCallback batchCallback(Runnable callback, ObservableMeasurement observableMeasurement, ObservableMeasurement ... additionalMeasurements) {
        return NOOP_BATCH_CALLBACK;
    }

    private DefaultMeter() {
    }

    private static class NoopLongCounterBuilder
    implements LongCounterBuilder {
        private static final LongCounter NOOP_COUNTER = new NoopLongCounter();
        private static final ObservableLongCounter NOOP_OBSERVABLE_COUNTER = new ObservableLongCounter(){};
        private static final DoubleCounterBuilder NOOP_DOUBLE_COUNTER_BUILDER = new NoopDoubleCounterBuilder();

        private NoopLongCounterBuilder() {
        }

        @Override
        public LongCounterBuilder setDescription(String description2) {
            return this;
        }

        @Override
        public LongCounterBuilder setUnit(String unit) {
            return this;
        }

        @Override
        public DoubleCounterBuilder ofDoubles() {
            return NOOP_DOUBLE_COUNTER_BUILDER;
        }

        @Override
        public LongCounter build() {
            return NOOP_COUNTER;
        }

        @Override
        public ObservableLongCounter buildWithCallback(Consumer<ObservableLongMeasurement> callback) {
            return NOOP_OBSERVABLE_COUNTER;
        }

        @Override
        public ObservableLongMeasurement buildObserver() {
            return NOOP_OBSERVABLE_LONG_MEASUREMENT;
        }
    }

    private static class NoopLongUpDownCounterBuilder
    implements LongUpDownCounterBuilder {
        private static final LongUpDownCounter NOOP_UP_DOWN_COUNTER = new NoopLongUpDownCounter(){};
        private static final ObservableLongUpDownCounter NOOP_OBSERVABLE_UP_DOWN_COUNTER = new ObservableLongUpDownCounter(){};
        private static final DoubleUpDownCounterBuilder NOOP_DOUBLE_UP_DOWN_COUNTER_BUILDER = new NoopDoubleUpDownCounterBuilder();

        private NoopLongUpDownCounterBuilder() {
        }
    }

    private static class NoopDoubleHistogramBuilder
    implements DoubleHistogramBuilder {
        private static final DoubleHistogram NOOP = new NoopDoubleHistogram();
        private static final LongHistogramBuilder NOOP_LONG_HISTOGRAM_BUILDER = new NoopLongHistogramBuilder();

        private NoopDoubleHistogramBuilder() {
        }
    }

    private static class NoopDoubleGaugeBuilder
    implements DoubleGaugeBuilder {
        private static final ObservableDoubleGauge NOOP_OBSERVABLE_GAUGE = new ObservableDoubleGauge(){};
        private static final LongGaugeBuilder NOOP_LONG_GAUGE_BUILDER = new NoopLongGaugeBuilder();
        private static final NoopDoubleGauge NOOP_GAUGE = new NoopDoubleGauge();

        private NoopDoubleGaugeBuilder() {
        }
    }

    private static class NoopObservableDoubleMeasurement
    implements ObservableDoubleMeasurement {
        private NoopObservableDoubleMeasurement() {
        }
    }

    private static class NoopObservableLongMeasurement
    implements ObservableLongMeasurement {
        private NoopObservableLongMeasurement() {
        }
    }

    private static class NoopLongGauge {
        private NoopLongGauge() {
        }
    }

    private static class NoopLongGaugeBuilder
    implements LongGaugeBuilder {
        private static final ObservableLongGauge NOOP_OBSERVABLE_GAUGE = new ObservableLongGauge(){};
        private static final NoopLongGauge NOOP_GAUGE = new NoopLongGauge();

        private NoopLongGaugeBuilder() {
        }
    }

    private static class NoopDoubleGauge {
        private NoopDoubleGauge() {
        }
    }

    private static class NoopLongHistogramBuilder
    implements LongHistogramBuilder {
        private static final LongHistogram NOOP = new NoopLongHistogram();

        private NoopLongHistogramBuilder() {
        }
    }

    private static class NoopLongHistogram
    implements LongHistogram {
        private NoopLongHistogram() {
        }
    }

    private static class NoopDoubleHistogram
    implements DoubleHistogram {
        private NoopDoubleHistogram() {
        }
    }

    private static class NoopDoubleUpDownCounterBuilder
    implements DoubleUpDownCounterBuilder {
        private static final DoubleUpDownCounter NOOP_UP_DOWN_COUNTER = new NoopDoubleUpDownCounter(){};
        private static final ObservableDoubleUpDownCounter NOOP_OBSERVABLE_UP_DOWN_COUNTER = new ObservableDoubleUpDownCounter(){};

        private NoopDoubleUpDownCounterBuilder() {
        }
    }

    private static class NoopDoubleUpDownCounter
    implements DoubleUpDownCounter {
        private NoopDoubleUpDownCounter() {
        }
    }

    private static class NoopLongUpDownCounter
    implements LongUpDownCounter {
        private NoopLongUpDownCounter() {
        }
    }

    private static class NoopDoubleCounterBuilder
    implements DoubleCounterBuilder {
        private static final DoubleCounter NOOP_COUNTER = new NoopDoubleCounter();
        private static final ObservableDoubleCounter NOOP_OBSERVABLE_COUNTER = new ObservableDoubleCounter(){};

        private NoopDoubleCounterBuilder() {
        }
    }

    private static class NoopDoubleCounter
    implements DoubleCounter {
        private NoopDoubleCounter() {
        }
    }

    private static class NoopLongCounter
    implements LongCounter {
        private NoopLongCounter() {
        }

        @Override
        public void add(long value2, Attributes attributes, Context context2) {
        }

        @Override
        public void add(long value2, Attributes attributes) {
        }

        @Override
        public void add(long value2) {
        }
    }
}

