/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.contracts.description.AbstractContractProvider;
import org.jetbrains.kotlin.contracts.description.CallsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.ConditionalEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.ContractDescription;
import org.jetbrains.kotlin.contracts.description.ContractDescriptionElement;
import org.jetbrains.kotlin.contracts.description.ContractDescriptionVisitor;
import org.jetbrains.kotlin.contracts.description.ContractProviderKey;
import org.jetbrains.kotlin.contracts.description.EffectDeclaration;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.contracts.description.ReturnsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.expressions.BooleanConstantReference;
import org.jetbrains.kotlin.contracts.description.expressions.ConstantReference;
import org.jetbrains.kotlin.contracts.description.expressions.IsInstancePredicate;
import org.jetbrains.kotlin.contracts.description.expressions.IsNullPredicate;
import org.jetbrains.kotlin.contracts.description.expressions.LogicalAnd;
import org.jetbrains.kotlin.contracts.description.expressions.LogicalNot;
import org.jetbrains.kotlin.contracts.description.expressions.LogicalOr;
import org.jetbrains.kotlin.contracts.description.expressions.VariableReference;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/serialization/ContractSerializer;", "", "<init>", "()V", "serializeContractOfFunctionIfAny", "", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Function$Builder;", "parentSerializer", "Lorg/jetbrains/kotlin/serialization/DescriptorSerializer;", "ContractSerializerWorker", "serialization"})
public final class ContractSerializer {
    public final void serializeContractOfFunctionIfAny(@NotNull FunctionDescriptor functionDescriptor, @NotNull ProtoBuf.Function.Builder proto, @NotNull DescriptorSerializer parentSerializer) {
        ContractDescription contractDescription2;
        Intrinsics.checkNotNullParameter(functionDescriptor, "functionDescriptor");
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(parentSerializer, "parentSerializer");
        AbstractContractProvider abstractContractProvider = (AbstractContractProvider)functionDescriptor.getUserData(ContractProviderKey.INSTANCE);
        ContractDescription contractDescription3 = contractDescription2 = abstractContractProvider != null ? abstractContractProvider.getContractDescription() : null;
        if (contractDescription2 != null) {
            ContractSerializerWorker worker = new ContractSerializerWorker(parentSerializer);
            proto.setContract(worker.contractProto(contractDescription2));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\u0015\u001a\u00020\u000f*\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/serialization/ContractSerializer$ContractSerializerWorker;", "", "parentSerializer", "Lorg/jetbrains/kotlin/serialization/DescriptorSerializer;", "<init>", "(Lorg/jetbrains/kotlin/serialization/DescriptorSerializer;)V", "contractProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Contract$Builder;", "contractDescription", "Lorg/jetbrains/kotlin/contracts/description/ContractDescription;", "effectProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Effect$Builder;", "effectDeclaration", "Lorg/jetbrains/kotlin/contracts/description/EffectDeclaration;", "fillEffectProto", "", "builder", "contractExpressionProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Expression$Builder;", "contractDescriptionElement", "Lorg/jetbrains/kotlin/contracts/description/ContractDescriptionElement;", "writeFlags", "newFlagsValue", "", "invocationKindProtobufEnum", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Effect$InvocationKind;", "kind", "Lorg/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "constantValueProtobufEnum", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Expression$ConstantValue;", "constantReference", "Lorg/jetbrains/kotlin/contracts/description/expressions/ConstantReference;", "serialization"})
    @SourceDebugExtension(value={"SMAP\nContractSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContractSerializer.kt\norg/jetbrains/kotlin/serialization/ContractSerializer$ContractSerializerWorker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,211:1\n1869#2,2:212\n*S KotlinDebug\n*F\n+ 1 ContractSerializer.kt\norg/jetbrains/kotlin/serialization/ContractSerializer$ContractSerializerWorker\n*L\n43#1:212,2\n*E\n"})
    private static final class ContractSerializerWorker {
        @NotNull
        private final DescriptorSerializer parentSerializer;

        public ContractSerializerWorker(@NotNull DescriptorSerializer parentSerializer) {
            Intrinsics.checkNotNullParameter(parentSerializer, "parentSerializer");
            this.parentSerializer = parentSerializer;
        }

        @NotNull
        public final ProtoBuf.Contract.Builder contractProto(@NotNull ContractDescription contractDescription2) {
            ProtoBuf.Contract.Builder builder;
            Intrinsics.checkNotNullParameter(contractDescription2, "contractDescription");
            ProtoBuf.Contract.Builder $this$contractProto_u24lambda_u240 = builder = ProtoBuf.Contract.newBuilder();
            boolean bl = false;
            Iterable $this$forEach$iv = contractDescription2.getEffects();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EffectDeclaration it = (EffectDeclaration)element$iv;
                boolean bl2 = false;
                $this$contractProto_u24lambda_u240.addEffect(this.effectProto(it, contractDescription2));
            }
            ProtoBuf.Contract.Builder builder2 = builder;
            Intrinsics.checkNotNullExpressionValue(builder2, "apply(...)");
            return builder2;
        }

        private final ProtoBuf.Effect.Builder effectProto(EffectDeclaration effectDeclaration, ContractDescription contractDescription2) {
            ProtoBuf.Effect.Builder builder;
            ProtoBuf.Effect.Builder $this$effectProto_u24lambda_u240 = builder = ProtoBuf.Effect.newBuilder();
            boolean bl = false;
            Intrinsics.checkNotNull($this$effectProto_u24lambda_u240);
            this.fillEffectProto($this$effectProto_u24lambda_u240, effectDeclaration, contractDescription2);
            ProtoBuf.Effect.Builder builder2 = builder;
            Intrinsics.checkNotNullExpressionValue(builder2, "apply(...)");
            return builder2;
        }

        private final void fillEffectProto(ProtoBuf.Effect.Builder builder, EffectDeclaration effectDeclaration, ContractDescription contractDescription2) {
            EffectDeclaration effectDeclaration2 = effectDeclaration;
            if (effectDeclaration2 instanceof ConditionalEffectDeclaration) {
                builder.setConclusionOfConditionalEffect(this.contractExpressionProto(((ConditionalEffectDeclaration)effectDeclaration).getCondition(), contractDescription2));
                this.fillEffectProto(builder, ((ConditionalEffectDeclaration)effectDeclaration).getEffect(), contractDescription2);
            } else if (effectDeclaration2 instanceof ReturnsEffectDeclaration) {
                if (Intrinsics.areEqual(((ReturnsEffectDeclaration)effectDeclaration).getValue(), ConstantReference.Companion.getNOT_NULL())) {
                    builder.setEffectType(ProtoBuf.Effect.EffectType.RETURNS_NOT_NULL);
                } else if (Intrinsics.areEqual(((ReturnsEffectDeclaration)effectDeclaration).getValue(), ConstantReference.Companion.getWILDCARD())) {
                    builder.setEffectType(ProtoBuf.Effect.EffectType.RETURNS_CONSTANT);
                } else {
                    builder.setEffectType(ProtoBuf.Effect.EffectType.RETURNS_CONSTANT);
                    builder.addEffectConstructorArgument(this.contractExpressionProto(((ReturnsEffectDeclaration)effectDeclaration).getValue(), contractDescription2));
                }
            } else if (effectDeclaration2 instanceof CallsEffectDeclaration) {
                builder.setEffectType(ProtoBuf.Effect.EffectType.CALLS);
                builder.addEffectConstructorArgument(this.contractExpressionProto(((CallsEffectDeclaration)effectDeclaration).getVariableReference(), contractDescription2));
                ProtoBuf.Effect.InvocationKind invocationKindProtobufEnum = this.invocationKindProtobufEnum(((CallsEffectDeclaration)effectDeclaration).getKind());
                if (invocationKindProtobufEnum != null) {
                    builder.setKind(invocationKindProtobufEnum);
                }
            }
        }

        private final ProtoBuf.Expression.Builder contractExpressionProto(ContractDescriptionElement contractDescriptionElement, ContractDescription contractDescription2) {
            return (ProtoBuf.Expression.Builder)contractDescriptionElement.accept((ContractDescriptionVisitor)new ContractDescriptionVisitor<ProtoBuf.Expression.Builder, Unit>(this, contractDescription2){
                final /* synthetic */ ContractSerializerWorker this$0;
                final /* synthetic */ ContractDescription $contractDescription;
                {
                    this.this$0 = $receiver;
                    this.$contractDescription = $contractDescription;
                }

                public ProtoBuf.Expression.Builder visitLogicalOr(LogicalOr logicalOr, Unit data2) {
                    ProtoBuf.Expression.Builder builder;
                    Intrinsics.checkNotNullParameter(logicalOr, "logicalOr");
                    Intrinsics.checkNotNullParameter(data2, "data");
                    ProtoBuf.Expression.Builder leftBuilder = (ProtoBuf.Expression.Builder)logicalOr.getLeft().accept(this, data2);
                    if (leftBuilder.getAndArgumentCount() != 0) {
                        ProtoBuf.Expression.Builder builder2 = ProtoBuf.Expression.newBuilder();
                        ContractSerializerWorker contractSerializerWorker = this.this$0;
                        ContractDescription contractDescription2 = this.$contractDescription;
                        ProtoBuf.Expression.Builder $this$visitLogicalOr_u24lambda_u240 = builder2;
                        boolean bl = false;
                        $this$visitLogicalOr_u24lambda_u240.addOrArgument(leftBuilder);
                        $this$visitLogicalOr_u24lambda_u240.addOrArgument(ContractSerializerWorker.access$contractExpressionProto(contractSerializerWorker, logicalOr.getRight(), contractDescription2));
                        ProtoBuf.Expression.Builder builder3 = builder2;
                        Intrinsics.checkNotNull(builder3);
                        builder = builder3;
                    } else {
                        ProtoBuf.Expression.Builder builder4 = leftBuilder;
                        ContractSerializerWorker contractSerializerWorker = this.this$0;
                        ContractDescription contractDescription3 = this.$contractDescription;
                        ProtoBuf.Expression.Builder $this$visitLogicalOr_u24lambda_u241 = builder4;
                        boolean bl = false;
                        $this$visitLogicalOr_u24lambda_u241.addOrArgument(ContractSerializerWorker.access$contractExpressionProto(contractSerializerWorker, logicalOr.getRight(), contractDescription3));
                        builder = builder4;
                    }
                    return builder;
                }

                public ProtoBuf.Expression.Builder visitLogicalAnd(LogicalAnd logicalAnd, Unit data2) {
                    ProtoBuf.Expression.Builder builder;
                    Intrinsics.checkNotNullParameter(logicalAnd, "logicalAnd");
                    Intrinsics.checkNotNullParameter(data2, "data");
                    ProtoBuf.Expression.Builder leftBuilder = (ProtoBuf.Expression.Builder)logicalAnd.getLeft().accept(this, data2);
                    if (leftBuilder.getOrArgumentCount() != 0) {
                        ProtoBuf.Expression.Builder builder2 = ProtoBuf.Expression.newBuilder();
                        ContractSerializerWorker contractSerializerWorker = this.this$0;
                        ContractDescription contractDescription2 = this.$contractDescription;
                        ProtoBuf.Expression.Builder $this$visitLogicalAnd_u24lambda_u242 = builder2;
                        boolean bl = false;
                        $this$visitLogicalAnd_u24lambda_u242.addAndArgument(leftBuilder);
                        $this$visitLogicalAnd_u24lambda_u242.addAndArgument(ContractSerializerWorker.access$contractExpressionProto(contractSerializerWorker, logicalAnd.getRight(), contractDescription2));
                        ProtoBuf.Expression.Builder builder3 = builder2;
                        Intrinsics.checkNotNull(builder3);
                        builder = builder3;
                    } else {
                        ProtoBuf.Expression.Builder builder4 = leftBuilder;
                        ContractSerializerWorker contractSerializerWorker = this.this$0;
                        ContractDescription contractDescription3 = this.$contractDescription;
                        ProtoBuf.Expression.Builder $this$visitLogicalAnd_u24lambda_u243 = builder4;
                        boolean bl = false;
                        $this$visitLogicalAnd_u24lambda_u243.addAndArgument(ContractSerializerWorker.access$contractExpressionProto(contractSerializerWorker, logicalAnd.getRight(), contractDescription3));
                        builder = builder4;
                    }
                    return builder;
                }

                public ProtoBuf.Expression.Builder visitLogicalNot(LogicalNot logicalNot, Unit data2) {
                    Intrinsics.checkNotNullParameter(logicalNot, "logicalNot");
                    Intrinsics.checkNotNullParameter(data2, "data");
                    R r2 = logicalNot.getArg().accept(this, data2);
                    ContractSerializerWorker contractSerializerWorker = this.this$0;
                    ProtoBuf.Expression.Builder $this$visitLogicalNot_u24lambda_u244 = (ProtoBuf.Expression.Builder)r2;
                    boolean bl = false;
                    ContractSerializerWorker.access$writeFlags(contractSerializerWorker, $this$visitLogicalNot_u24lambda_u244, Flags.IS_NEGATED.invert($this$visitLogicalNot_u24lambda_u244.getFlags()));
                    return (ProtoBuf.Expression.Builder)r2;
                }

                public ProtoBuf.Expression.Builder visitIsInstancePredicate(IsInstancePredicate isInstancePredicate, Unit data2) {
                    Intrinsics.checkNotNullParameter(isInstancePredicate, "isInstancePredicate");
                    Intrinsics.checkNotNullParameter(data2, "data");
                    ProtoBuf.Expression.Builder builder = this.visitVariableReference(isInstancePredicate.getArg(), data2);
                    builder.setIsInstanceTypeId(ContractSerializerWorker.access$getParentSerializer$p(this.this$0).typeId(isInstancePredicate.getType()));
                    ContractSerializerWorker.access$writeFlags(this.this$0, builder, Flags.getContractExpressionFlags(isInstancePredicate.isNegated(), false));
                    return builder;
                }

                public ProtoBuf.Expression.Builder visitIsNullPredicate(IsNullPredicate isNullPredicate, Unit data2) {
                    Intrinsics.checkNotNullParameter(isNullPredicate, "isNullPredicate");
                    Intrinsics.checkNotNullParameter(data2, "data");
                    ProtoBuf.Expression.Builder builder = this.visitVariableReference(isNullPredicate.getArg(), data2);
                    ContractSerializerWorker.access$writeFlags(this.this$0, builder, Flags.getContractExpressionFlags(isNullPredicate.isNegated(), true));
                    return builder;
                }

                public ProtoBuf.Expression.Builder visitConstantDescriptor(ConstantReference constantReference, Unit data2) {
                    Intrinsics.checkNotNullParameter(constantReference, "constantReference");
                    Intrinsics.checkNotNullParameter(data2, "data");
                    ProtoBuf.Expression.Builder builder = ProtoBuf.Expression.newBuilder();
                    ProtoBuf.Expression.ConstantValue constantValueProtobufEnum = ContractSerializerWorker.access$constantValueProtobufEnum(this.this$0, constantReference);
                    if (constantValueProtobufEnum != null) {
                        builder.setConstantValue(constantValueProtobufEnum);
                    }
                    Intrinsics.checkNotNull(builder);
                    return builder;
                }

                public ProtoBuf.Expression.Builder visitVariableReference(VariableReference variableReference, Unit data2) {
                    Integer indexOfParameter;
                    Integer n2;
                    ParameterDescriptor descriptor2;
                    Intrinsics.checkNotNullParameter(variableReference, "variableReference");
                    Intrinsics.checkNotNullParameter(data2, "data");
                    ProtoBuf.Expression.Builder builder = ProtoBuf.Expression.newBuilder();
                    ParameterDescriptor parameterDescriptor = descriptor2 = variableReference.getDescriptor();
                    if (parameterDescriptor instanceof ReceiverParameterDescriptor) {
                        n2 = 0;
                    } else if (parameterDescriptor instanceof ValueParameterDescriptor) {
                        Integer n3 = this.$contractDescription.getOwnerFunction().getValueParameters().indexOf(descriptor2);
                        int it = ((Number)n3).intValue();
                        boolean bl = false;
                        Integer n4 = it != -1 ? n3 : null;
                        n2 = n4 != null ? Integer.valueOf(n4 + 1) : null;
                    } else {
                        n2 = null;
                    }
                    Integer n5 = indexOfParameter = n2;
                    if (n5 == null) {
                        Intrinsics.checkNotNull(builder);
                        return builder;
                    }
                    builder.setValueParameterReference(n5);
                    Intrinsics.checkNotNull(builder);
                    return builder;
                }
            }, Unit.INSTANCE);
        }

        private final void writeFlags(ProtoBuf.Expression.Builder $this$writeFlags, int newFlagsValue) {
            if ($this$writeFlags.getFlags() != newFlagsValue) {
                $this$writeFlags.setFlags(newFlagsValue);
            }
        }

        private final ProtoBuf.Effect.InvocationKind invocationKindProtobufEnum(EventOccurrencesRange kind) {
            ProtoBuf.Effect.InvocationKind invocationKind;
            switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                case 1: {
                    invocationKind = ProtoBuf.Effect.InvocationKind.AT_MOST_ONCE;
                    break;
                }
                case 2: {
                    invocationKind = ProtoBuf.Effect.InvocationKind.EXACTLY_ONCE;
                    break;
                }
                case 3: {
                    invocationKind = ProtoBuf.Effect.InvocationKind.AT_LEAST_ONCE;
                    break;
                }
                default: {
                    invocationKind = null;
                }
            }
            return invocationKind;
        }

        private final ProtoBuf.Expression.ConstantValue constantValueProtobufEnum(ConstantReference constantReference) {
            ProtoBuf.Expression.ConstantValue constantValue;
            ConstantReference constantReference2 = constantReference;
            if (Intrinsics.areEqual(constantReference2, BooleanConstantReference.Companion.getTRUE())) {
                constantValue = ProtoBuf.Expression.ConstantValue.TRUE;
            } else if (Intrinsics.areEqual(constantReference2, BooleanConstantReference.Companion.getFALSE())) {
                constantValue = ProtoBuf.Expression.ConstantValue.FALSE;
            } else if (Intrinsics.areEqual(constantReference2, ConstantReference.Companion.getNULL())) {
                constantValue = ProtoBuf.Expression.ConstantValue.NULL;
            } else {
                if (Intrinsics.areEqual(constantReference2, ConstantReference.Companion.getNOT_NULL())) {
                    throw new IllegalStateException("Internal error during serialization of function contract: NOT_NULL constant isn't denotable in protobuf format. Its serialization should be handled at higher level");
                }
                if (Intrinsics.areEqual(constantReference2, ConstantReference.Companion.getWILDCARD())) {
                    constantValue = null;
                } else {
                    throw new IllegalArgumentException("Unknown constant: " + constantReference);
                }
            }
            return constantValue;
        }

        public static final /* synthetic */ DescriptorSerializer access$getParentSerializer$p(ContractSerializerWorker $this) {
            return $this.parentSerializer;
        }

        public static final /* synthetic */ void access$writeFlags(ContractSerializerWorker $this, ProtoBuf.Expression.Builder $receiver, int newFlagsValue) {
            $this.writeFlags($receiver, newFlagsValue);
        }

        public static final /* synthetic */ ProtoBuf.Expression.ConstantValue access$constantValueProtobufEnum(ContractSerializerWorker $this, ConstantReference constantReference) {
            return $this.constantValueProtobufEnum(constantReference);
        }

        public static final /* synthetic */ ProtoBuf.Expression.Builder access$contractExpressionProto(ContractSerializerWorker $this, ContractDescriptionElement contractDescriptionElement, ContractDescription contractDescription2) {
            return $this.contractExpressionProto(contractDescriptionElement, contractDescription2);
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[EventOccurrencesRange.values().length];
                try {
                    nArray[EventOccurrencesRange.AT_MOST_ONCE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EventOccurrencesRange.EXACTLY_ONCE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EventOccurrencesRange.AT_LEAST_ONCE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

