/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcDimension;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcTimeAxis;
import gov.nasa.giss.data.nc.NcUtils;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.gridder.NcGridder;
import gov.nasa.giss.data.nc.gridder.NcGridder1D;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.time.UnixTimeFormatter;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Dimension;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.VariableDS;

public class NcArray1D
extends NcArray {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected NcAxis axis_;
    private int axDimIndex_ = -1;
    private int axLength_ = -1;
    private int aveDimIndex_ = -1;
    private int numAves_ = -1;
    private double[] averages_;

    public NcArray1D(NcVariable ncvar, Object axisInfo) throws NcException {
        super(ncvar);
        this.createAxis(axisInfo);
        this.measureAxis();
        if (this.aveDimIndex_ > -1) {
            this.setSliceIndex(this.aveDimIndex_, -1);
        }
        this.needsSlice_ = true;
        this.valueAt(0);
    }

    private void createAxis(Object axisInfo) {
        Dimension d;
        int i;
        LOGGER.trace("info class {}", (Object)axisInfo.getClass().getSimpleName());
        Dimension axDim = null;
        VariableDS axCV = null;
        boolean usesIndirectTimeAxis = false;
        if (axisInfo == null) {
            for (int i2 = 0; i2 < this.rank_; ++i2) {
                if (this.shape_[i2] <= 1) continue;
                this.axDimIndex_ = i2;
                break;
            }
        } else if (axisInfo instanceof Integer) {
            this.axDimIndex_ = (Integer)axisInfo;
            LOGGER.trace("axDimIndex_ {}", (Object)this.axDimIndex_);
            if (this.axDimIndex_ < 0 || this.axDimIndex_ > this.rank_) {
                throw new IndexOutOfBoundsException("AxisInfo is out-of-range integer.");
            }
        } else if (axisInfo instanceof NcDimension) {
            Dimension dd = ((NcDimension)axisInfo).getNjDimension();
            for (i = 0; i < this.rank_; ++i) {
                d = this.getDimension(i);
                if (!d.equals(dd)) continue;
                axDim = d;
                this.axDimIndex_ = i;
                break;
            }
        } else if (axisInfo instanceof NcVariable || axisInfo instanceof VariableDS) {
            VariableDS axvarDS = null;
            if (axisInfo instanceof NcVariable) {
                NcVariable axvar = (NcVariable)axisInfo;
                axvarDS = (VariableDS)axvar.getObject();
            } else {
                axvarDS = (VariableDS)axisInfo;
            }
            int axrank = axvarDS.getRank();
            if (axrank == 1 && NcUtils.isUnixTime(axvarDS)) {
                Dimension dd = axvarDS.getDimension(0);
                for (int i3 = 0; i3 < this.rank_; ++i3) {
                    Dimension d2 = this.getDimension(i3);
                    if (!d2.equals(dd)) continue;
                    usesIndirectTimeAxis = true;
                    axCV = axvarDS;
                    axDim = d2;
                    this.axDimIndex_ = i3;
                    break;
                }
            } else {
                LOGGER.trace("AxisInfo is NcVariable but apparently not 1D time.");
            }
        } else if (axisInfo instanceof String) {
            String dname = (String)axisInfo;
            for (i = 0; i < this.rank_; ++i) {
                d = this.getDimension(i);
                String sname = d.getShortName();
                String fname = d.getFullName();
                if (!dname.equals(sname) && !dname.equals(fname)) continue;
                axDim = d;
                this.axDimIndex_ = i;
                break;
            }
        } else {
            throw new IllegalArgumentException("Unintelligible axis info.");
        }
        LOGGER.trace("axDimNum  {}", (Object)this.axDimIndex_);
        if (this.axDimIndex_ < 0) {
            throw new NcException("No matching axis dimension found.");
        }
        if (this.shape_[this.axDimIndex_] < 2) {
            throw new NcException("Axis dimension is too short.");
        }
        if (axDim == null) {
            axDim = this.getDimension(this.axDimIndex_);
        }
        if (axCV == null) {
            axCV = this.dataset_.getCoordinateVariable(axDim);
        }
        if (axCV == null) {
            LOGGER.trace("Axis CV not found.");
            String fname = axDim.getShortName();
            int length = axDim.getLength();
            this.axis_ = new NcAxis(NcAxisType.GEOX, fname, length);
        } else if (usesIndirectTimeAxis) {
            LOGGER.trace("CV {}", (Object)axCV.getShortName());
            LOGGER.trace("Axis CV looks like secondary time.");
            try {
                this.axis_ = new NcTimeAxis(this.dataset_, axCV);
            }
            catch (Exception exc) {
                String excStr = exc.toString();
                LOGGER.warn("Exception creating secondary NcTimeAxis: {}", (Object)excStr);
                if (excStr.contains("unique values") || excStr.contains("NaN value")) {
                    throw exc;
                }
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
            }
        } else {
            LOGGER.trace("CV {}", (Object)axCV.getShortName());
            if (NcUtils.isUnixTime(axCV)) {
                LOGGER.trace("Axis CV looks like time.");
                try {
                    CoordinateAxis ca = NcUtils.getCoordinateAxisOfType(axCV, AxisType.Time);
                    this.axis_ = new NcTimeAxis(this.dataset_, ca);
                }
                catch (Exception exc) {
                    LOGGER.warn("Exception getting time CoordinateAxis: {}", (Object)exc.toString());
                    if (LOGGER.isTraceEnabled()) {
                        exc.printStackTrace();
                    }
                }
            } else if (NcUtils.isPressure(axCV) || NcUtils.isHeight(axCV) || NcUtils.isDepth(axCV)) {
                LOGGER.trace("Axis CV looks like vert.");
                this.axis_ = new NcAxis(NcAxisType.VERT, this.dataset_, axCV);
            }
            if (this.axis_ == null) {
                LOGGER.trace("Not clear what axis CV type is. Calling it GEOX.");
                this.axis_ = new NcAxis(NcAxisType.GEOX, this.dataset_, axCV);
            }
        }
        LOGGER.trace("axis_ {}", (Object)this.axis_.getClass());
        CoordinateAxis lonaxis = NcUtils.getCoordinateAxisOfType(this.ncvar_, NcAxisType.LON);
        LOGGER.trace("lonaxis {}", (Object)(lonaxis != null ? 1 : 0));
        if (lonaxis instanceof CoordinateAxis1D && lonaxis.getRank() == 1 && lonaxis.getShape()[0] > 0) {
            this.aveDimIndex_ = this.findDimensionIndex(lonaxis);
            if (this.aveDimIndex_ == this.axDimIndex_) {
                this.aveDimIndex_ = -1;
            } else {
                Dimension dd = this.getDimension(this.aveDimIndex_);
                if (dd == null) {
                    this.aveDimIndex_ = -1;
                } else {
                    VariableDS dimVar = this.dataset_.getCoordinateVariable(dd);
                    if (!lonaxis.equals(dimVar)) {
                        this.aveDimIndex_ = -1;
                    }
                }
            }
        }
        LOGGER.trace("aveDimNum {}", (Object)this.aveDimIndex_);
    }

    private void measureAxis() {
        if (this.axDimIndex_ < 0) {
            throw new NcException("X-dimension index is not set.");
        }
        this.axLength_ = this.shape_[this.axDimIndex_];
        if (this.aveDimIndex_ > -1) {
            this.numAves_ = this.shape_[this.aveDimIndex_];
        }
    }

    @Override
    protected void createFreeDimensions() {
        if (this.dimensions_ != null) {
            return;
        }
        this.dimensions_ = new NcDimension[this.rank_];
        for (int i = 0; i < this.rank_; ++i) {
            this.dimensions_[i] = i == this.axDimIndex_ ? null : this.ncvar_.getDimension(i);
        }
    }

    public int getLength() {
        return this.axLength_;
    }

    public NcAxis getAxis() {
        return this.axis_;
    }

    public int getDimensionIndex() {
        return this.axDimIndex_;
    }

    public boolean isAxisUnixTime() {
        if (this.axis_ instanceof NcTimeAxis) {
            NcTimeAxis tax = (NcTimeAxis)this.axis_;
            return tax.isUnixTime();
        }
        return false;
    }

    public boolean isAxisPressure() {
        return this.axis_.isPressure();
    }

    public String getAxisFormatPattern() {
        if (this.axis_ instanceof NcTimeAxis) {
            NcTimeAxis tax = (NcTimeAxis)this.axis_;
            UnixTimeFormatter tt = (UnixTimeFormatter)tax.getFormatter();
            return tt.getPattern();
        }
        return null;
    }

    public void setAxisFormatPattern(String pattern) {
        NcTimeAxis tax;
        if (this.axis_ instanceof NcTimeAxis && (tax = (NcTimeAxis)this.axis_).isUnixTime()) {
            UnixTimeFormatter tt = (UnixTimeFormatter)tax.getFormatter();
            tt.applyPattern(pattern);
            return;
        }
        LOGGER.debug("Axis does not accept a time pattern");
    }

    @Override
    public boolean isAveragingDimension(int dimIndex) {
        return dimIndex == this.aveDimIndex_;
    }

    public double valueAt(int index) {
        if (index < 0 || index >= this.axLength_) {
            throw new IndexOutOfBoundsException(String.format("Index out of range: %d : %d", index, this.axLength_));
        }
        if (this.aveDimIndex_ > -1 && this.sIndex_[this.aveDimIndex_] == -1) {
            return this.dimensionAverageAt(index);
        }
        if (this.needsSlice_ || this.slice_ == null) {
            this.doSlice();
        }
        try {
            double dd = this.getDoubleFromSlice(index, -1);
            if (Double.isNaN(dd) || this.isMissingOrInvalid(dd)) {
                return Double.NaN;
            }
            return dd;
        }
        catch (Exception exc) {
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            throw new NcException(exc.toString());
        }
    }

    public double dimensionAverageAt(int index) throws NcException {
        if (this.aveDimIndex_ == -1) {
            throw new NcException("Dimension averaging not set up for this array.");
        }
        if (this.averages_ == null) {
            this.doAverage();
        }
        return this.averages_[index];
    }

    private synchronized void doSlice() throws NcException {
        int[] sOrigin = new int[this.rank_];
        int[] sShape = new int[this.rank_];
        try {
            this.needsSlice_ = true;
            for (int i = 0; i < this.rank_; ++i) {
                sOrigin[i] = this.sIndex_[i];
                sShape[i] = 1;
            }
            sOrigin[this.axDimIndex_] = 0;
            sShape[this.axDimIndex_] = this.axLength_;
            LOGGER.trace("axDimNum {}", (Object)this.axDimIndex_);
            if (this.rank_ > 1) {
                LOGGER.trace("sOrigin  {}, {}", (Object)sOrigin[0], (Object)sOrigin[1]);
                LOGGER.trace("sShape   {}, {}", (Object)sShape[0], (Object)sShape[1]);
            } else {
                LOGGER.trace("sOrigin  {}", (Object)sOrigin[0]);
                LOGGER.trace("sShape   {}", (Object)sShape[0]);
            }
            this.slice_ = this.read(sOrigin, sShape);
            this.sliceIdx_ = this.slice_.getIndex();
            this.needsSlice_ = false;
        }
        catch (Exception exc) {
            LOGGER.warn("Exception doing slice: {}, {}", (Object)exc.getClass().getSimpleName(), (Object)exc.getMessage());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            throw new NcException(String.format("Do slice - %s", exc.getMessage()));
        }
    }

    private void doAverage() throws NcException {
        int i;
        LOGGER.trace("aveDimNum {}", (Object)this.aveDimIndex_);
        if (this.aveDimIndex_ < 0) {
            throw new NcException("Array has no averaging dimension.");
        }
        this.slice_ = null;
        if (this.averages_ == null) {
            this.averages_ = new double[this.axLength_];
        }
        int[] sOrigin = new int[this.rank_];
        int[] sShape = new int[this.rank_];
        int[] aveCount = new int[this.axLength_];
        for (i = 0; i < this.axLength_; ++i) {
            this.averages_[i] = 0.0;
            aveCount[i] = 0;
        }
        try {
            for (i = 0; i < this.rank_; ++i) {
                sOrigin[i] = this.sIndex_[i];
                sShape[i] = 1;
            }
            sOrigin[this.axDimIndex_] = 0;
            sShape[this.axDimIndex_] = this.axLength_;
            for (int iave = 0; iave < this.numAves_; iave += this.numAves_) {
                sOrigin[this.aveDimIndex_] = iave;
                sShape[this.aveDimIndex_] = this.numAves_;
                this.slice_ = this.read(sOrigin, sShape);
                this.sliceIdx_ = this.slice_.getIndex();
                for (int mm = 0; mm < this.numAves_; ++mm) {
                    for (int j = 0; j < this.axLength_; ++j) {
                        double dval = this.getDoubleFromSlice(j, mm);
                        if (this.isMissingOrInvalid(dval)) continue;
                        int n = j;
                        this.averages_[n] = this.averages_[n] + dval;
                        int n2 = j;
                        aveCount[n2] = aveCount[n2] + 1;
                    }
                }
                this.slice_ = null;
            }
        }
        catch (Exception exc) {
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            throw new NcException(String.format("Do Average: %s", exc.toString()));
        }
        for (int j = 0; j < this.axLength_; ++j) {
            if (aveCount[j] == 0) {
                this.averages_[j] = Double.NaN;
                continue;
            }
            if (aveCount[j] <= 1) continue;
            int n = j;
            this.averages_[n] = this.averages_[n] / (double)aveCount[j];
        }
        this.needsSlice_ = false;
    }

    @Override
    public void setSliceIndex(int dimNum, int index) {
        if (dimNum != this.aveDimIndex_ || index == -1) {
            this.averages_ = null;
        }
        super.setSliceIndex(dimNum, index);
    }

    @Override
    protected void findExtremaImpl() {
        if (this.rank_ < 3) {
            LOGGER.trace("rank_ < 3");
            double[] range = this.getActualRangeAttrValues();
            if (range != null) {
                this.minimum_ = range[0];
                this.maximum_ = range[1];
                this.needsExtrema_ = false;
                return;
            }
        }
        for (int j = 0; j < this.axLength_; ++j) {
            this.findExtremaTestValue(this.valueAt(j));
        }
    }

    private double getDoubleFromSlice(int index, int ave) {
        int[] ss = new int[this.rank_];
        for (int i = 0; i < this.rank_; ++i) {
            ss[i] = 0;
        }
        ss[this.axDimIndex_] = index;
        if (ave > -1) {
            ss[this.aveDimIndex_] = ave;
        }
        this.sliceIdx_.set(ss);
        return this.slice_.getDouble(this.sliceIdx_);
    }

    @Override
    public NcGridder getGridder() {
        return new NcGridder1D();
    }

    @Override
    public void describeCell(StringBuilder sb, PrintfFormat valFormat, int ... index) {
    }
}

