/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalCylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class BSAMCylindrical
extends GlobalCylindric {
    public static final String PROJECTION_NAME = "BSAM Cylindrical";
    private static final double COS_PHI_SP = 0.8660254037844386;
    private static final double ONE_PLUS_COS_PHI_SP = 1.8660254037844386;
    private static final double ONE_OVER_COS_PHI_SP = 1.1547005383792517;
    private static final double MAX_X_OVER_RS = 2.7206990463513265;
    private static final double MAX_Y_OVER_RS = 1.8660254037844386;

    public BSAMCylindrical(int width, int height) {
        this(width, height, 0, 0);
    }

    public BSAMCylindrical(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, 2.7206990463513265, 1.8660254037844386);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double x = 0.8660254037844386 * this.lonToLambdaRad(lon);
        double y = 1.8660254037844386 * Math.tan(0.5 * Math.toRadians(lat));
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absx = Math.abs(x);
        double absy = Math.abs(y);
        if (absx > (double)this.dxMax_ || absy > (double)this.dyMax_) {
            return null;
        }
        double absXOverRS = absx * this.invRS_;
        double absYOverRS = absy * this.invRS_;
        double phiRad = 2.0 * Math.atan(absYOverRS / 1.8660254037844386);
        if (phiRad > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = absXOverRS * 1.1547005383792517;
        if (lambdaRad > Math.PI) {
            return null;
        }
        double phi = Math.signum(y) * Math.toDegrees(phiRad);
        double lambda = Math.signum(x) * Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        BSAMCylindrical bSAMCylindrical = this;
        synchronized (bSAMCylindrical) {
            double y;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = 2.0 * Math.atan((y = (double)iy + 0.5) * this.invRS_ / 1.8660254037844386)) > 1.5707963267948966); ++iy) {
                double x;
                double lambdaRad;
                double phi = Math.toDegrees(phiRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * this.invRS_ * 1.1547005383792517) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

