/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToblerHyperellipticalX
extends GlobalPseudocylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Tobler Hyperelliptical X";
    private static final double DEFAULT_ALPHA = 0.0;
    private static final double DEFAULT_GAMMA = 1.183136;
    private static final double DEFAULT_K = 2.5;
    private double alpha_ = 0.0;
    private double gamma_ = 1.183136;
    private double kterm_ = 2.5;
    private double alphaM1_ = this.alpha_ - 1.0;
    private double invGamma_ = 1.0 / this.gamma_;
    private double invK_ = 1.0 / this.kterm_;
    private double alphaM1OverGamma_ = this.alphaM1_ * this.invGamma_;
    private double gammaToTheK_ = Math.pow(this.gamma_, this.kterm_);
    private double affineSq_ = 1.0;
    private double invaffineSq_ = 1.0;
    private int adaptFailures_;
    private final ProjDoubleParameter ceaParam_ = new ProjDoubleParameter("Weighting of CEA projection", "CEA Wgt", "(0\u2264\u03b1\u22641)", 0.0, 0.0, 1.0, true, true);
    private final ProjDoubleParameter gammaParam_ = new ProjDoubleParameter("Gamma parameter", "\u03b3", "", 1.183136, 0.1, 10.0, true, true);
    private final ProjDoubleParameter kParam_ = new ProjDoubleParameter("k parameter", "k", "", 2.5, 0.1, 10.0, true, true);

    public ToblerHyperellipticalX(int width, int height) {
        this(width, height, 0, 0);
    }

    public ToblerHyperellipticalX(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
        this.addParameter(this.ceaParam_);
        this.addParameter(this.gammaParam_);
        this.addParameter(this.kParam_);
        this.finishConstruction();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null) {
            this.setCEAWeight(this.ceaParam_.getValue());
            this.setGamma(this.gammaParam_.getValue());
            this.setK(this.kParam_.getValue());
        } else if (p.equals(this.ceaParam_)) {
            this.setCEAWeight(this.ceaParam_.getValue());
        } else if (p == this.gammaParam_) {
            this.setGamma(this.gammaParam_.getValue());
        } else if (p == this.kParam_) {
            this.setK(this.kParam_.getValue());
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
    }

    private void setCEAWeight(double ceaWgt) {
        if (ceaWgt < 0.0 || ceaWgt > 1.0) {
            throw new IllegalArgumentException("CEA weight must be in range [1,1].");
        }
        this.alpha_ = ceaWgt;
        this.autoscale();
    }

    private void setGamma(double gamma) {
        this.gamma_ = gamma;
        this.autoscale();
    }

    private void setK(double k) {
        this.kterm_ = k;
        this.autoscale();
    }

    @Override
    protected void prepareScaling() {
        this.alphaM1_ = this.alpha_ - 1.0;
        this.invGamma_ = 1.0 / this.gamma_;
        this.invK_ = 1.0 / this.kterm_;
        this.alphaM1OverGamma_ = this.alphaM1_ * this.invGamma_;
        this.gammaToTheK_ = Math.pow(this.gamma_, this.kterm_);
        double yf = this.iterateYOverRS(90.0, false);
        if (Double.isNaN(yf) || Double.isInfinite(yf)) {
            yf = this.iterateYOverRS(89.99999, false);
        }
        if (Double.isNaN(yf) || Double.isInfinite(yf)) {
            LOGGER.warn("Bad yf calculated");
            this.affineSq_ = 1.0;
        } else {
            this.affineSq_ = 1.5707963267948966 / yf;
        }
        this.invaffineSq_ = 1.0 / this.affineSq_;
        LOGGER.trace("yf {}, yf*a2 {}", (Object)yf, (Object)(yf * this.affineSq_));
    }

    @Override
    protected final void finishScaling() {
        LOGGER.trace("dxMax {}, dyMax {}", (Object)this.dxMax_, (Object)this.dyMax_);
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        double x;
        double absLat = Math.abs(lat);
        double lambdaRad = this.lonToLambdaRad(lon);
        if (absLat < 1.0E-10) {
            x = lambdaRad;
            y = 0.0;
        } else if (this.alpha_ == 1.0) {
            double phiRad = Math.toRadians(absLat);
            double sinPhi = Math.sin(phiRad);
            x = lambdaRad;
            y = sinPhi;
        } else if (this.alpha_ == 0.0 && absLat > 89.99999) {
            y = this.gamma_;
            x = 0.0;
        } else {
            y = this.iterateYOverRS(absLat, false);
            if (Double.isNaN(y) || Double.isInfinite(y)) {
                return null;
            }
            x = Math.abs(lambdaRad) < 1.0E-10 ? 0.0 : lambdaRad * (this.alpha_ - this.alphaM1OverGamma_ * this.hyperelliptic(y, false));
        }
        y *= this.affineSq_;
        if (lat < 0.0) {
            y = -y;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double sinPhi;
        double lambdaRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absY = Math.abs(y);
        if (Math.abs(x) > (double)this.dxMax_ || absY > (double)this.dyMax_) {
            return null;
        }
        if (absY > this.ymRS_) {
            return null;
        }
        double xOverRS = x * this.invRS_;
        double yOverRS = absY * this.invRS_ * this.invaffineSq_;
        if (absY < 1.0E-5) {
            lambdaRad = xOverRS;
            sinPhi = 0.0;
        } else if (this.alpha_ == 1.0) {
            lambdaRad = xOverRS;
            sinPhi = yOverRS;
        } else {
            lambdaRad = xOverRS / (this.alpha_ - this.alphaM1OverGamma_ * this.hyperelliptic(yOverRS, false));
            sinPhi = this.alpha_ * yOverRS - this.alphaM1OverGamma_ * this.integral(yOverRS);
        }
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        if (Double.isNaN(sinPhi)) {
            return null;
        }
        double phiRad = Math.asin(sinPhi);
        if (Double.isNaN(phiRad)) {
            return null;
        }
        if (x < 0.0) {
            phiRad = -phiRad;
        }
        if (y < 0.0) {
            phiRad = -phiRad;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        ToblerHyperellipticalX toblerHyperellipticalX = this;
        synchronized (toblerHyperellipticalX) {
            double y;
            double phiRad = 0.0;
            for (int iy = 0; iy < this.dyMax_ && !((y = (double)iy + 0.5) > this.ymRS_); ++iy) {
                double x;
                double xOverRS;
                double lambdaRad;
                double xTerm;
                double yOverRS = y * this.invRS_ * this.invaffineSq_;
                if (this.alpha_ == 1.0) {
                    phiRad = Math.asin(yOverRS);
                    xTerm = 1.0;
                } else {
                    double sinPhi = this.alpha_ * yOverRS - this.alphaM1OverGamma_ * this.integral(yOverRS);
                    phiRad = Math.asin(sinPhi);
                    xTerm = 1.0 / (this.alpha_ - this.alphaM1OverGamma_ * this.hyperelliptic(yOverRS, false));
                }
                double phi = Math.toDegrees(phiRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (xOverRS = (x = (double)ix + 0.5) * this.invRS_) * xTerm) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }

    private double iterateYOverRS(double absphi, boolean debug) {
        if (this.alpha_ == 0.0 && absphi > 89.99999) {
            return this.gamma_;
        }
        double phiRad = Math.toRadians(absphi);
        double sinPhi = Math.sin(phiRad);
        if (this.alpha_ == 1.0) {
            return sinPhi;
        }
        double y = (this.alpha_ + this.gamma_ * (1.0 - this.alpha_)) * phiRad / 1.5707963267948966;
        if (y > this.gamma_) {
            y *= 0.5;
        }
        for (int iter = 0; iter < 33; ++iter) {
            double integral = this.integral(y);
            double hyper = this.hyperelliptic(y, debug);
            double func = sinPhi - this.alpha_ * y + this.alphaM1OverGamma_ * integral;
            double dfunc = -this.alpha_ + this.alphaM1OverGamma_ * hyper;
            double dy = -func / dfunc;
            if (debug) {
                LOGGER.debug("Iteration {} for {}", (Object)iter, (Object)absphi);
                LOGGER.debug(" -- hyper {}, integral {}", (Object)hyper, (Object)integral);
                LOGGER.debug(" -- func {}, dfunc {}", (Object)func, (Object)dfunc);
                LOGGER.debug(" -- y {}, dy {}, y {}", y, dy, y + dy);
            }
            if ((y += dy) > this.gamma_) {
                y = this.gamma_ - 1.0E-5;
            }
            if (Math.abs(dy) < 1.0E-5) break;
        }
        return y;
    }

    private double hyperelliptic(double y, boolean debug) {
        double yToTheK = Math.pow(y, this.kterm_);
        double diff = this.gammaToTheK_ - yToTheK;
        double result = Math.pow(diff, this.invK_);
        if (debug && (Double.isNaN(result) || Double.isInfinite(result))) {
            LOGGER.debug("   y {}, y^k {}", (Object)y, (Object)yToTheK);
            LOGGER.debug("   g {}, g^k {}", (Object)this.gamma_, (Object)this.gammaToTheK_);
            LOGGER.debug("   diff {}, result {}", (Object)diff, (Object)result);
        }
        return result;
    }

    private double integral(double y) {
        return this.adaptive(0.0, y, 1.0E-5);
    }

    private double adaptive(double a, double b, double epsilon) {
        double q1;
        double fe;
        double h = b - a;
        double c = 0.5 * (a + b);
        double d = 0.5 * (a + c);
        double e = 0.5 * (b + c);
        double fa = this.hyperelliptic(a, false);
        double fb = this.hyperelliptic(b, false);
        double fc = this.hyperelliptic(c, false);
        double fd = this.hyperelliptic(d, false);
        double q2 = h * (fa + 4.0 * fd + 2.0 * fc + 4.0 * (fe = this.hyperelliptic(e, false)) + fb) / 12.0;
        if (Math.abs(q2 - (q1 = h * (fa + 4.0 * fc + fb) / 6.0)) > epsilon) {
            try {
                return this.adaptive(a, c, epsilon) + this.adaptive(c, b, epsilon);
            }
            catch (Exception exc) {
                LOGGER.trace("failure {}", (Object)(++this.adaptFailures_));
            }
        }
        return q2 + (q2 - q1) / 15.0;
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        if (this.alpha_ < 1.0) {
            super.drawBorderLines(g2d);
        } else {
            ProjGraphicUtils.drawRectBorder(g2d, this.outCenterX_ - this.dxMax_, this.outCenterY_ - this.dyMax_, 2.0 * (double)this.dxMax_, 2.0 * (double)this.dyMax_);
        }
    }

    @Override
    protected void drawMeridianNoLabel(Graphics2D g2d, double lon, double maxLat) {
        if (this.alpha_ < 1.0) {
            super.drawMeridianNoLabel(g2d, lon, maxLat);
        } else {
            Point2D.Double dot = this.transformLL2XY(lon, 0.0);
            if (dot == null) {
                return;
            }
            float top = this.outCenterY_ - this.dyMax_;
            float bottom = this.outCenterY_ + this.dyMax_;
            GraphicUtils.drawLine(g2d, dot.x, top, dot.x, bottom);
        }
    }
}

