/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.BiSymmetricProjection;
import gov.nasa.giss.map.proj.BonneCommon;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StabiusWerner3
extends BiSymmetricProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Stabius-Werner III";
    public static final int PROPERTIES = 512;
    private static final double SW_SCALING = 1.0471975511965976;
    private static final double MAX_X_OVER_RS;
    private static final double MAX_Y_OVER_RS;
    private static final double PHI1 = 90.0;
    private static final double COT_PHI1 = 0.0;
    private static final double COT_PHI1_PLUS_PHI1 = 1.5707963267948966;
    private static final double Y_SHIFT;

    public StabiusWerner3(int width, int height) {
        this(width, height, 0, 0);
    }

    public StabiusWerner3(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 512, width, height, xmargin, ymargin, MAX_X_OVER_RS, MAX_Y_OVER_RS);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        double x;
        double lambdaRad = this.lonToLambdaRad(lon);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phiRad = Math.toRadians(lat);
        double alphaRad = 1.5707963267948966 - phiRad;
        if (lambdaRad == 0.0 || Math.abs(phiRad) == 1.5707963267948966) {
            x = 0.0;
            y = 0.0 - alphaRad + Y_SHIFT;
        } else {
            double betaRad = 1.0471975511965976 * lambdaRad * Math.cos(phiRad) / alphaRad;
            x = alphaRad * Math.sin(betaRad);
            y = 0.0 - alphaRad * Math.cos(betaRad) + Y_SHIFT;
        }
        if (lat > 60.0) {
            if (lambdaRad > 0.0 && x < 0.0) {
                return null;
            }
            if (lambdaRad < 0.0 && x > 0.0) {
                return null;
            }
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double xOverRS = x * this.invRS_;
        double yOverRS = y * this.invRS_ - Y_SHIFT;
        double y1 = 0.0 - yOverRS;
        double pmFac = 1.0;
        double alphaRad = 1.0 * Math.hypot(xOverRS, y1);
        double phiRad = 1.5707963267948966 - alphaRad;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double betaRad = Math.atan2(1.0 * xOverRS, 1.0 * y1);
        double lambdaRad = betaRad * alphaRad / Math.cos(phiRad) / 1.0471975511965976;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double lambda = Math.toDegrees(lambdaRad);
        double phi = Math.toDegrees(phiRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        StabiusWerner3 stabiusWerner3 = this;
        synchronized (stabiusWerner3) {
            double pmFac = 1.0;
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_ - Y_SHIFT;
                double y1 = 0.0 - yOverRS;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double betaRad;
                    double lambdaRad;
                    double x = (double)ix + 0.5;
                    double xOverRS = x * this.invRS_;
                    double alphaRad = 1.0 * Math.hypot(xOverRS, y1);
                    double phiRad = 1.5707963267948966 - alphaRad;
                    if (Math.abs(phiRad) > 1.5707963267948966 || (lambdaRad = (betaRad = Math.atan2(1.0 * xOverRS, 1.0 * y1)) * alphaRad / Math.cos(phiRad) / 1.0471975511965976) > Math.PI) continue;
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        Bezier bcurve = this.makeMeridianBezier(this.lambdaC_ + 179.99999, 90.0);
        if (bcurve != null) {
            bcurve.draw(g2d);
        }
        if ((bcurve = this.makeMeridianBezier(this.lambdaC_ - 179.99999, 90.0)) != null) {
            bcurve.draw(g2d);
        }
        Point2D.Double dot1 = this.transformLL2XY(this.lambdaC_ + 180.0, 60.0);
        Point2D.Double dot2 = this.transformLL2XY(this.lambdaC_ + 180.0, 90.0);
        GraphicUtils.drawLine(g2d, dot1, dot2);
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        Point2D.Double dot3;
        Point2D.Double dot1;
        double lon2 = this.lambdaC_;
        double lon1 = this.lambdaC_ - 179.99999;
        double lon3 = this.lambdaC_ + 179.99999;
        Point2D.Double dot2 = this.transformLL2XY(lon2, lat);
        if (lat >= 60.0) {
            double phiRad = Math.toRadians(lat);
            double lambdaRad = Math.PI * (1.5707963267948966 - phiRad) / (1.0471975511965976 * Math.cos(phiRad));
            lambdaRad = Math.abs(lambdaRad);
            double gapRad = Math.abs(lambdaRad - Math.PI);
            double lambda = Math.toDegrees(Math.PI - gapRad);
            lon1 = this.lambdaC_ - lambda + 1.0E-5;
            lon3 = this.lambdaC_ + lambda - 1.0E-5;
            dot1 = this.transformLL2XY(lon1, lat);
            dot3 = this.transformLL2XY(lon3, lat);
        } else {
            dot1 = this.transformLL2XY(lon1, lat);
            dot3 = this.transformLL2XY(lon3, lat);
            if (dot1 == null) {
                return;
            }
        }
        GraphicUtils.drawCircularArc(g2d, dot1, dot2, dot3);
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        double dlon = MapUtils.normalize360(lon - this.lambdaC_);
        if (Math.abs(dlon - 180.0) < 1.0E-5) {
            return;
        }
        Bezier bcurve = this.makeMeridianBezier(lon, maxLat);
        if (bcurve != null) {
            bcurve.draw(g2d);
        }
    }

    private Bezier makeMeridianBezier(double lon, double maxLat) {
        Point2D.Double dot;
        ArrayList<Point2D.Double> ptlist = new ArrayList<Point2D.Double>(400);
        double lat = -maxLat;
        double lastLat = -maxLat;
        while (lat < maxLat) {
            dot = this.transformLL2XY(lon, lat);
            if (dot == null) {
                if (lat > 60.0 && lastLat < 60.0) {
                    lat = 60.0;
                    continue;
                }
                return new Bezier(false, ptlist);
            }
            ptlist.add(new Point2D.Double(dot.x, dot.y));
            double nextlat = 0.0;
            nextlat = Math.abs(lat) >= maxLat - 1.0 ? lat + 0.1 : (Math.abs(lat) >= 85.0 ? lat + 0.25 : lat + 0.5);
            lastLat = lat;
            lat = nextlat;
        }
        dot = this.transformLL2XY(lon, maxLat);
        ptlist.add(new Point2D.Double(dot.x, dot.y));
        return new Bezier(false, ptlist);
    }

    static {
        double latXMax = BonneCommon.latitudeOfMaxX(1.0471975511965976, 90.0, Math.PI);
        LOGGER.trace("latXMax {}", (Object)latXMax);
        double phiRad = Math.toRadians(latXMax);
        double alphaRad = 1.5707963267948966 - phiRad;
        double betaRad = 3.2898681336964524 * Math.cos(phiRad) / alphaRad;
        MAX_X_OVER_RS = alphaRad * Math.sin(betaRad);
        double latYMax = BonneCommon.latitudeOfLobeMaxY(1.0471975511965976, 90.0, Math.PI);
        LOGGER.trace("latYMax {}", (Object)latYMax);
        phiRad = Math.toRadians(latYMax);
        alphaRad = 1.5707963267948966 - phiRad;
        betaRad = 3.2898681336964524 * Math.cos(phiRad) / alphaRad;
        double yLobe = 0.0 - alphaRad * Math.cos(betaRad);
        double yS = -Math.PI;
        MAX_Y_OVER_RS = 0.5 * Math.abs(yLobe - -Math.PI);
        Y_SHIFT = -0.5 * (yLobe + -Math.PI);
    }
}

