/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.panoply.dialog.PanSaveSettingsGroupDialog;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.prefs.PanSavedSettings;
import gov.nasa.giss.panoply.prefs.PanSavedSettingsHandler;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.SlowMessage;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanSaveSettingsAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String ACTION_NAME = PanProperties.MENU_PROPS.getString("save-settings");
    private final PanPlotFrame parent_;

    public PanSaveSettingsAction(PanPlotFrame parent) {
        super(ACTION_NAME);
        this.parent_ = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PanSaveSettingsGroupDialog dlog = null;
        try {
            dlog = new PanSaveSettingsGroupDialog(this.parent_);
        }
        catch (Exception exc) {
            LOGGER.debug("Exception creating save-settings dialog: {}", (Object)exc.toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            return;
        }
        dlog.setVisible(true);
        if (!dlog.isSuccessful()) {
            return;
        }
        String name = dlog.getName();
        if (name.isEmpty()) {
            SlowMessage.show((Component)this.parent_, "Save Error", "Settings must be given a name.");
            return;
        }
        PanSavedSettings already = PanSavedSettingsHandler.getSharedInstance().get(name);
        if (already != null) {
            Object[] options = new String[]{"Yes", "No"};
            int choice = JOptionPane.showOptionDialog(this.parent_, "Save settings named \"" + name + "\" already exist. Do you want to\nreplace them?", "Save Settings", 0, 3, null, options, options[0]);
            if (choice != 0) {
                return;
            }
        }
        PanPlotMeta pmeta = this.parent_.getMeta();
        PanSavedSettingsHandler.getSharedInstance().add(name, pmeta);
    }
}

