/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanScaleMethodComboBox;
import gov.nasa.giss.panoply.util.PanScaleMethod;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.ui.FloatComboBox;
import gov.nasa.giss.ui.GTextField;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.StringComboBox;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.Box;
import javax.swing.JLabel;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanScalePrefsPanel
extends PanAbstractPrefsPanel {
    private PanCheckBox autoFitCB_;
    private PanScaleMethodComboBox methodCombo_;
    protected GTextField coeffTF_;
    private PanIntSpinner expSpinner_;
    private PanIntSpinner majorDivSpinner_;
    private PanIntSpinner minorDivSpinner_;
    private StringComboBox tickFormatCombo_;
    private FloatComboBox tickSizeCombo_;
    private PanCheckBox minmaxCB_;
    private StringComboBox minmaxFormatCombo_;
    private boolean refreshing_;

    public PanScalePrefsPanel() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("Plot Scale"));
        this.setOpaque(false);
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        JLabel topText = new JLabel("When creating a plot, set\u2026");
        this.setOpaque(false);
        this.autoFitCB_ = PanCheckBox.create("Always fit to data range");
        this.methodCombo_ = PanScaleMethodComboBox.create("plot:scale.method");
        this.coeffTF_ = GTextField.createDoubleField(1.0, 4);
        this.coeffTF_.setName("plot:scale.coefficient");
        this.expSpinner_ = PanIntSpinner.create("plot:scale.exponent", 0, -50, 50, 1);
        this.majorDivSpinner_ = PanIntSpinner.create(2, 1, 20, 1);
        this.minorDivSpinner_ = PanIntSpinner.create(2, 1, 20, 1);
        this.tickSizeCombo_ = FloatComboBox.create(5.0f, 24.0f);
        this.tickFormatCombo_ = StringComboBox.createNumberPformat();
        this.minmaxCB_ = PanCheckBox.create("Show min-max footnote");
        this.minmaxFormatCombo_ = StringComboBox.createNumberPformat();
        this.minmaxFormatCombo_.setName("plot:footnote.minmax.format");
        this.minmaxFormatCombo_.insertItemAt("Same as scale ticks", 0);
        FlexingGridLayout fgl = new FlexingGridLayout(4, 8, 0, 2);
        fgl.setColumnWeight(3, 9999.0f);
        fgl.setRigidHeight(true);
        this.setLayout(fgl);
        int row = 0;
        this.add((Component)topText, new FGConstraint(0, row, 4, 1));
        this.add((Component)new JLabel("Scale Method:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)this.methodCombo_, new FGConstraint(1, row));
        this.add((Component)new JLabel("Min/Max:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)this.autoFitCB_, new FGConstraint(1, row));
        this.add((Component)new JLabel("Scaling:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(this.coeffTF_, new JLabel("\u00d710^"), this.expSpinner_), new FGConstraint(1, row));
        this.add((Component)new JLabel("Divisions:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(new JLabel("Major:\u2009"), this.majorDivSpinner_, new JLabel(", Minor:\u2009"), this.minorDivSpinner_), new FGConstraint(1, row));
        this.add((Component)new JLabel("Tick Labels:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(new JLabel("Format:\u2009"), this.tickFormatCombo_, new JLabel("\u2014 Size:\u2009"), this.tickSizeCombo_), new FGConstraint(1, row));
        this.add((Component)new JLabel("Footnote:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)this.minmaxCB_, new FGConstraint(1, row));
        this.add((Component)QuickBox.createLeftBox(Box.createHorizontalStrut(12), new JLabel("Format:\u2009"), this.minmaxFormatCombo_), new FGConstraint(1, ++row));
    }

    private void attachListeners() {
        this.autoFitCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setBoolean("plot:scale.autofit", this.autoFitCB_.isSelected());
        });
        this.methodCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:scale.method", ((PanScaleMethod)this.methodCombo_.getSelectedItem()).name());
        });
        FocusAdapter coeffFL = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PanScalePrefsPanel.this.validateCoeff();
            }
        };
        this.coeffTF_.addFocusListener(coeffFL);
        this.coeffTF_.addActionListener(e -> this.validateCoeff());
        this.expSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setInt("plot:scale.exponent", this.expSpinner_.getIntValue());
        });
        this.majorDivSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setInt("plot:scale.div.major", this.majorDivSpinner_.getIntValue());
        });
        this.minorDivSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setInt("plot:scale.div.minor", this.minorDivSpinner_.getIntValue());
        });
        this.tickFormatCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:scale.tick.format", this.tickFormatCombo_.getSelectedString());
        });
        this.tickSizeCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            float value = this.tickSizeCombo_.getValue();
            prefs_.setFloat("plot:scale.tick.size", value);
        });
        this.minmaxCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setBoolean("plot:footnote.minmax.vis", this.minmaxCB_.isSelected());
        });
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        PanScaleMethod smethod = PanScaleMethod.matching(prefs_.getString("plot:scale.method"));
        this.autoFitCB_.setSelected(prefs_.getBoolean("plot:scale.autofit"));
        this.methodCombo_.setSelectedItem(smethod);
        PrintfFormat format7G = new PrintfFormat("%.7g");
        this.coeffTF_.setText(format7G.sprintfx(prefs_.getDouble("plot:scale.coefficient")));
        this.expSpinner_.setValue(prefs_.getInt("plot:scale.exponent"));
        this.validateCoeff();
        this.majorDivSpinner_.setValue(prefs_.getInt("plot:scale.div.major"));
        this.minorDivSpinner_.setValue(prefs_.getInt("plot:scale.div.minor"));
        this.tickFormatCombo_.setSelectedItem(prefs_.getString("plot:scale.tick.format"));
        this.tickSizeCombo_.setSelectedItem(prefs_.getFloat("plot:scale.tick.size"));
        this.minmaxCB_.setSelected(prefs_.getBoolean("plot:footnote.minmax.vis"));
        this.minmaxFormatCombo_.setEnabled(this.minmaxCB_.isSelected());
        String mmf = prefs_.getString("plot:footnote.minmax.format");
        if (mmf == null || mmf.isEmpty() || mmf.toLowerCase().startsWith("same")) {
            this.minmaxFormatCombo_.setSelectedIndex(0);
        } else {
            this.minmaxFormatCombo_.setSelectedItem(mmf);
        }
        this.refreshing_ = false;
    }

    private synchronized void validateCoeff() {
        double oldcoeff;
        if (this.coeffTF_ == null || prefs_ == null) {
            return;
        }
        double coeff = oldcoeff = prefs_.getDouble("plot:scale.coefficient");
        boolean fixit = false;
        try {
            coeff = StringUtils.parseDouble(this.coeffTF_.getText());
        }
        catch (Exception exc) {
            coeff = oldcoeff;
            fixit = true;
        }
        if (Double.isNaN(coeff) || Math.abs(coeff) == 0.0) {
            coeff = 1.0;
            fixit = true;
        } else if (Math.abs(coeff) > 1000.0) {
            coeff = 1000.0 * Math.signum(coeff);
            fixit = true;
        }
        if (fixit) {
            PrintfFormat pformat = new PrintfFormat("%.0f");
            this.coeffTF_.setText(pformat.sprintfx(coeff));
        }
        prefs_.setDouble("plot:scale.coefficient", coeff);
    }
}

