/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.ui;

import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.ui.SizeVariant;
import javax.swing.Action;
import javax.swing.JCheckBox;

public final class PanCheckBox
extends JCheckBox {
    private PanCheckBox(SizeVariant size, String name, String text) {
        this(size, name, text, false);
    }

    private PanCheckBox(SizeVariant size, String name, String text, boolean selected) {
        super(text, selected);
        if (name != null) {
            this.setName(name);
        }
        PanGuiUtils.setSizeVariant(this, size);
    }

    private PanCheckBox(SizeVariant size, String name, Action action) {
        super(action);
        if (name != null) {
            this.setName(name);
        }
        PanGuiUtils.setSizeVariant(this, size);
        this.setVerticalAlignment(0);
        this.setVerticalTextPosition(0);
    }

    public static PanCheckBox create(String text) {
        return new PanCheckBox(SizeVariant.REGULAR, null, text, false);
    }

    public static PanCheckBox create(String name, String text) {
        return new PanCheckBox(SizeVariant.REGULAR, name, text, false);
    }

    public static PanCheckBox create(String name, String text, boolean selected) {
        return new PanCheckBox(SizeVariant.REGULAR, name, text, selected);
    }

    public static PanCheckBox create(String text, boolean selected) {
        return new PanCheckBox(SizeVariant.REGULAR, null, text, selected);
    }

    public static PanCheckBox small(String name, String text) {
        return new PanCheckBox(SizeVariant.SMALL, name, text, false);
    }

    public static PanCheckBox small(String text) {
        return new PanCheckBox(SizeVariant.SMALL, null, text, false);
    }

    public static PanCheckBox small(String name, String text, boolean selected) {
        return new PanCheckBox(SizeVariant.SMALL, name, text, selected);
    }

    public static PanCheckBox small(String text, boolean selected) {
        return new PanCheckBox(SizeVariant.SMALL, null, text, selected);
    }

    public static PanCheckBox small(String name, Action action) {
        return new PanCheckBox(SizeVariant.SMALL, name, action);
    }

    public static PanCheckBox small(String name, String text, Action action) {
        PanCheckBox pcb = new PanCheckBox(SizeVariant.SMALL, name, action);
        pcb.setText(text);
        return pcb;
    }
}

