/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.text.PrintfFormat;

public class PanLLGridSpacing {
    private static final PrintfFormat PFORMAT_3G = new PrintfFormat("%.3g");
    public static final PanLLGridSpacing NONE = new PanLLGridSpacing(0);
    public static final PanLLGridSpacing[] DEFAULT_CHOICES = new PanLLGridSpacing[]{NONE, new PanLLGridSpacing(90), new PanLLGridSpacing(60), new PanLLGridSpacing(45), new PanLLGridSpacing(30), new PanLLGridSpacing(20), new PanLLGridSpacing(15), new PanLLGridSpacing(10), new PanLLGridSpacing(8), new PanLLGridSpacing(6), new PanLLGridSpacing(5), new PanLLGridSpacing(4), new PanLLGridSpacing(3), new PanLLGridSpacing(2, 30), new PanLLGridSpacing(2), new PanLLGridSpacing(1), new PanLLGridSpacing(0, 40), new PanLLGridSpacing(0, 30), new PanLLGridSpacing(0, 20), new PanLLGridSpacing(0, 15), new PanLLGridSpacing(0, 12), new PanLLGridSpacing(0, 10), new PanLLGridSpacing(0, 6)};
    public static final PanLLGridSpacing[] EXTRA_CHOICES = new PanLLGridSpacing[]{new PanLLGridSpacing(0, 5), new PanLLGridSpacing(0, 2)};
    private final float spacing_;
    private final String desc1_;
    private final String desc2_;

    private PanLLGridSpacing(int deg) {
        this(deg, 0);
    }

    private PanLLGridSpacing(int deg, int min) {
        this.spacing_ = (float)deg + (float)min / 60.0f;
        if (deg == 0 && min == 0) {
            this.desc1_ = "None";
            this.desc2_ = "None";
        } else {
            this.desc1_ = min == 0 ? deg + "\u00b0" : deg + "\u00b0\u2009" + min + "\u00b0";
            this.desc2_ = PFORMAT_3G.sprintfx(Float.valueOf(this.spacing_));
        }
    }

    public String getDescription() {
        return this.desc1_;
    }

    public String toString() {
        return this.desc1_;
    }

    public float getSpacing() {
        return this.spacing_;
    }

    public boolean matches(String text) {
        if (text == null) {
            return false;
        }
        return this.desc1_.equalsIgnoreCase(text) || this.desc2_.equalsIgnoreCase(text);
    }

    public static PanLLGridSpacing matching(String str) {
        for (PanLLGridSpacing item : DEFAULT_CHOICES) {
            if (!item.matches(str)) continue;
            return item;
        }
        for (PanLLGridSpacing item : EXTRA_CHOICES) {
            if (!item.matches(str)) continue;
            return item;
        }
        return NONE;
    }
}

