/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.util.DescribedItem;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Rectangle;

public enum PanPlotSizeFactor implements DescribedItem
{
    SIZE_080(80, "Size 80 - Extra Small", "size-080"),
    SIZE_085(85, "Size 85", null),
    SIZE_090(90, "Size 90", "size-090"),
    SIZE_095(95, "Size 95", null),
    SIZE_100(100, "Size 100 - Small", "size-100"),
    SIZE_105(105, "Size 105", null),
    SIZE_110(110, "Size 110", "size-110"),
    SIZE_115(115, "Size 115", null),
    SIZE_120(120, "Size 120 - Standard", "size-120"),
    SIZE_130(130, "Size 130", "size-130"),
    SIZE_140(140, "Size 140 - Large", "size-140"),
    SIZE_150(150, "Size 150", "size-150"),
    SIZE_160(160, "Size 160 - Extra Large", "size-160"),
    SIZE_170(170, "Size 170", "size-170"),
    SIZE_180(180, "Size 180 - Jumbo", "size-180"),
    SIZE_190(190, "Size 190", "size-190"),
    SIZE_200(200, "Size 200 - Super Jumbo", "size-200"),
    SIZE_210(210, "Size 210", null),
    SIZE_220(220, "Size 220", "size-220"),
    SIZE_230(230, "Size 230", null),
    SIZE_240(240, "Size 240 - King", "size-240"),
    SIZE_250(250, "Size 250", null),
    SIZE_260(260, "Size 260", "size-260"),
    SIZE_270(270, "Size 270", null),
    SIZE_280(280, "Size 280", "size-280"),
    SIZE_290(290, "Size 290", null),
    SIZE_300(300, "Size 300 - Maximum", "size_300");

    private int factor_;
    private String description_;
    private String actionID_;

    private PanPlotSizeFactor(int factor, String description, String actionID) {
        this.factor_ = factor;
        this.description_ = description;
        this.actionID_ = actionID;
    }

    @Override
    public String getDescription() {
        return this.description_;
    }

    public String toString() {
        return this.description_;
    }

    public int getSizeFactor() {
        return this.factor_;
    }

    public String getActionID() {
        return this.actionID_;
    }

    @Override
    public boolean matches(String text) {
        return this.name().equalsIgnoreCase(text) || this.description_.equalsIgnoreCase(text) || this.actionID_ != null && this.actionID_.equalsIgnoreCase(text);
    }

    public static PanPlotSizeFactor matching(String str) {
        for (PanPlotSizeFactor item : PanPlotSizeFactor.values()) {
            if (!item.matches(str)) continue;
            return item;
        }
        return null;
    }

    public static PanPlotSizeFactor matching(int sizeFactor) {
        for (PanPlotSizeFactor item : PanPlotSizeFactor.values()) {
            if (item.getSizeFactor() != sizeFactor) continue;
            return item;
        }
        return null;
    }

    public static boolean fitsDisplay(int factor) {
        if (PlatformUtils.isHeadless()) {
            return true;
        }
        Rectangle screenSize = GuiUtils.getActiveScreenBounds();
        int vertical = screenSize.height;
        if (PlatformUtils.isMacintosh()) {
            vertical -= 22;
            vertical -= 268;
        } else if (PlatformUtils.isWindows()) {
            vertical -= 40;
            vertical -= 278;
        } else {
            vertical -= 290;
        }
        int needed = (int)(496.0 * ((double)factor * 0.01)) - 4;
        return vertical > needed;
    }

    public static PanPlotSizeFactor getStandardSize() {
        return SIZE_120;
    }
}

