/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.hint;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.TypeReference;

public abstract class AbstractTypeReference
implements TypeReference {
    private final String packageName;
    private final String simpleName;
    private final @Nullable TypeReference enclosingType;

    protected AbstractTypeReference(String packageName, String simpleName, @Nullable TypeReference enclosingType) {
        this.packageName = packageName;
        this.simpleName = simpleName;
        this.enclosingType = enclosingType;
    }

    @Override
    public String getName() {
        TypeReference enclosingType = this.getEnclosingType();
        String simpleName = this.getSimpleName();
        return enclosingType != null ? enclosingType.getName() + "$" + simpleName : this.addPackageIfNecessary(simpleName);
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public String getSimpleName() {
        return this.simpleName;
    }

    @Override
    public @Nullable TypeReference getEnclosingType() {
        return this.enclosingType;
    }

    protected String addPackageIfNecessary(String part) {
        if (this.packageName.isEmpty() || this.packageName.equals("java.lang") && this.isPrimitive()) {
            return part;
        }
        return this.packageName + "." + part;
    }

    protected abstract boolean isPrimitive();

    @Override
    public int compareTo(TypeReference other) {
        return this.getCanonicalName().compareToIgnoreCase(other.getCanonicalName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof TypeReference)) return false;
        TypeReference that = (TypeReference)other;
        if (!this.getCanonicalName().equals(that.getCanonicalName())) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.getCanonicalName());
    }

    public String toString() {
        return this.getCanonicalName();
    }
}

