/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.database.dao.impl;

import com.ghostchu.peerbanhelper.database.dao.AbstractPBHDao;
import com.ghostchu.peerbanhelper.database.table.TorrentEntity;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class TorrentDao
extends AbstractPBHDao<TorrentEntity, Long> {
    public TorrentDao(@Autowired ConnectionSource database) throws SQLException {
        super(database, TorrentEntity.class);
        this.setObjectCache(true);
    }

    public Optional<TorrentEntity> queryByInfoHash(String infoHash) throws SQLException {
        TorrentEntity torrent = (TorrentEntity)this.queryBuilder().limit(Long.valueOf(1L)).where().eq("infoHash", (Object)new SelectArg((Object)infoHash)).queryForFirst();
        return Optional.ofNullable(torrent);
    }

    public synchronized TorrentEntity createIfNotExists(TorrentEntity data) throws SQLException {
        TorrentEntity entity = (TorrentEntity)this.queryBuilder().where().eq("infoHash", (Object)new SelectArg((Object)data.getInfoHash())).queryForFirst();
        if (entity == null) {
            this.create(data);
            return data;
        }
        boolean anyUpdated = false;
        if (!entity.getName().equals(data.getName())) {
            entity.setName(data.getName());
            anyUpdated = true;
        }
        if (!Objects.equals(entity.getSize(), data.getSize())) {
            entity.setSize(data.getSize());
            anyUpdated = true;
        }
        if (entity.getPrivateTorrent() == null && data.getPrivateTorrent() != null) {
            entity.setPrivateTorrent(data.getPrivateTorrent());
            anyUpdated = true;
        }
        if (anyUpdated) {
            this.update(entity);
        }
        return entity;
    }
}

