/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.platform;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.exchange.ExchangeMap;
import com.ghostchu.peerbanhelper.platform.win32.ecoqos.EcoMode;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import java.util.Locale;
import lombok.Generated;
import org.bspfsystems.yamlconfiguration.file.YamlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public final class WindowsEcoQosAPI {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WindowsEcoQosAPI.class);
    private final YamlConfiguration config = Main.getMainConfig();

    public WindowsEcoQosAPI() {
        if (this.config.getBoolean("performance.windows-ecoqos-api")) {
            this.installEcoQosApi();
        }
    }

    private void installEcoQosApi() {
        try {
            String os = System.getProperty("os.name").toLowerCase(Locale.ROOT);
            if (os.startsWith("win")) {
                EcoMode ecoMode = new EcoMode();
                ecoMode.setPriority(6);
                String result = ecoMode.setEcoMode(true);
                if (!"SUCCESS".equalsIgnoreCase(result)) {
                    throw new IllegalStateException(result);
                }
                log.info(TextManager.tlUI(Lang.IN_ECOMODE_DESCRIPTION, new Object[0]));
                ExchangeMap.GUI_DISPLAY_FLAGS.add(new ExchangeMap.DisplayFlag("eco-mode", 10, TextManager.tlUI(Lang.IN_ECOMODE_SHORT, new Object[0])));
            }
        }
        catch (Exception e) {
            log.warn(TextManager.tlUI(Lang.ECOMODE_FAILED, e.getClass().getName() + ": " + e.getMessage()));
        }
    }
}

