/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.ui.images.ImageGetter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/unciv/logic/civilization/NotificationIcon;", "", "<init>", "()V", "Barbarians", "", "City", "CityState", "Crosshair", "Culture", "Construction", "Death", "Diplomacy", "Faith", "Food", "Gold", "Growth", "Happiness", "Population", "Production", "Question", "Ruins", "Science", "Scout", "Spy", "Trade", "War", "getImage", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "icon", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "iconSize", "", "core"})
public final class NotificationIcon {
    @NotNull
    public static final NotificationIcon INSTANCE = new NotificationIcon();
    @NotNull
    public static final String Barbarians = "ImprovementIcons/Barbarian encampment";
    @NotNull
    public static final String City = "ImprovementIcons/City center";
    @NotNull
    public static final String CityState = "OtherIcons/CityState";
    @NotNull
    public static final String Crosshair = "OtherIcons/CrosshairB";
    @NotNull
    public static final String Culture = "StatIcons/Culture";
    @NotNull
    public static final String Construction = "StatIcons/Production";
    @NotNull
    public static final String Death = "OtherIcons/DisbandUnit";
    @NotNull
    public static final String Diplomacy = "OtherIcons/Diplomacy";
    @NotNull
    public static final String Faith = "StatIcons/Faith";
    @NotNull
    public static final String Food = "StatIcons/Food";
    @NotNull
    public static final String Gold = "StatIcons/Gold";
    @NotNull
    public static final String Growth = "StatIcons/Population";
    @NotNull
    public static final String Happiness = "StatIcons/Happiness";
    @NotNull
    public static final String Population = "StatIcons/Population";
    @NotNull
    public static final String Production = "StatIcons/Production";
    @NotNull
    public static final String Question = "OtherIcons/Question";
    @NotNull
    public static final String Ruins = "ImprovementIcons/Ancient ruins";
    @NotNull
    public static final String Science = "StatIcons/Science";
    @NotNull
    public static final String Scout = "UnitIcons/Scout";
    @NotNull
    public static final String Spy = "OtherIcons/Spy";
    @NotNull
    public static final String Trade = "StatIcons/Acquire";
    @NotNull
    public static final String War = "OtherIcons/Pillage";

    private NotificationIcon() {
    }

    @NotNull
    public final Actor getImage(@NotNull String icon, @NotNull Ruleset ruleset, float iconSize) {
        Actor actor;
        Intrinsics.checkNotNullParameter(icon, "icon");
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        if (ruleset.getTechnologies().containsKey(icon)) {
            actor = ImageGetter.INSTANCE.getTechIconPortrait(icon, iconSize);
        } else if (ruleset.getNations().containsKey(icon)) {
            Nation nation = ruleset.getNations().get(icon);
            Intrinsics.checkNotNull(nation);
            actor = ImageGetter.INSTANCE.getNationPortrait(nation, iconSize);
        } else if (ruleset.getUnits().containsKey(icon)) {
            BaseUnit baseUnit = ruleset.getUnits().get(icon);
            Intrinsics.checkNotNull(baseUnit);
            actor = ImageGetter.getUnitIcon$default(ImageGetter.INSTANCE, baseUnit, null, 2, null);
        } else {
            actor = ruleset.getUnitPromotions().containsKey(icon) ? (Actor)ImageGetter.INSTANCE.getPromotionPortrait(icon, iconSize) : (ruleset.getTileResources().containsKey(icon) ? (Actor)ImageGetter.getResourcePortrait$default(ImageGetter.INSTANCE, icon, iconSize, 0, 4, null) : (Actor)ImageGetter.getImage$default(ImageGetter.INSTANCE, icon, null, 2, null));
        }
        return actor;
    }
}

