/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map;

import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.map.HexCoord;
import com.unciv.logic.map.HexMath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 #2\u00020\u0001:\u0002\"#B)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tB\t\b\u0012\u00a2\u0006\u0004\b\b\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\b\u0010\rB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\u000eB\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\u000fB\u0019\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\u0010J\u0006\u0010\u001a\u001a\u00020\u0000J\b\u0010\u001b\u001a\u00020\fH\u0007J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010!\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u000fR\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0014\"\u0004\b\u0017\u0010\u000fR\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u000f\u00a8\u0006$"}, d2={"Lcom/unciv/logic/map/MapSize;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "name", "", "radius", "", "width", "height", "<init>", "(Ljava/lang/String;III)V", "()V", "size", "Lcom/unciv/logic/map/MapSize$Predefined;", "(Lcom/unciv/logic/map/MapSize$Predefined;)V", "(Ljava/lang/String;)V", "(I)V", "(II)V", "getName", "()Ljava/lang/String;", "getRadius", "()I", "setRadius", "getWidth", "setWidth", "getHeight", "setHeight", "clone", "getPredefinedOrNextSmaller", "fixUndesiredSizes", "worldWrap", "", "setNewRadius", "", "toString", "Predefined", "Companion", "core"})
public final class MapSize
implements IsPartOfGameInfoSerialization {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    private int radius;
    private int width;
    private int height;
    @NotNull
    public static final String custom = "Custom";

    private MapSize(String name, int radius, int width, int height) {
        this.name = name;
        this.radius = radius;
        this.width = width;
        this.height = height;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getRadius() {
        return this.radius;
    }

    public final void setRadius(int n) {
        this.radius = n;
    }

    public final int getWidth() {
        return this.width;
    }

    public final void setWidth(int n) {
        this.width = n;
    }

    public final int getHeight() {
        return this.height;
    }

    public final void setHeight(int n) {
        this.height = n;
    }

    private MapSize() {
        this("", 0, 0, 0);
    }

    public MapSize(@NotNull Predefined size) {
        Intrinsics.checkNotNullParameter((Object)size, "size");
        this(size.name(), size.getRadius(), size.getWidth(), size.getHeight());
    }

    public MapSize(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        this(Predefined.Companion.safeValueOf(name));
    }

    public MapSize(int radius) {
        this(custom, radius, 0, 0);
        this.setNewRadius(radius);
    }

    public MapSize(int width, int height) {
        this(custom, HexMath.INSTANCE.getEquivalentHexagonalRadius(width, height), width, height);
    }

    @NotNull
    public final MapSize clone() {
        return new MapSize(this.name, this.radius, this.width, this.height);
    }

    @Readonly
    @NotNull
    public final Predefined getPredefinedOrNextSmaller() {
        if (!Intrinsics.areEqual(this.name, custom)) {
            return Predefined.Companion.safeValueOf(this.name);
        }
        for (Predefined predef : CollectionsKt.reversed((Iterable)Predefined.getEntries())) {
            if (this.radius < predef.getRadius()) continue;
            return predef;
        }
        return Predefined.Tiny;
    }

    @Nullable
    public final String fixUndesiredSizes(boolean worldWrap) {
        if (!Intrinsics.areEqual(this.name, custom)) {
            return null;
        }
        if (worldWrap && this.width % 2 != 0) {
            int n = this.width;
            this.width = n + -1;
        }
        String string = worldWrap && this.width < 32 ? "World wrap requires a minimum width of 32 tiles" : (this.width < 3 || this.height < 3 || this.radius < 2 ? "The provided map dimensions were too small" : (this.radius > 500 ? "The provided map dimensions were too big" : (this.height * 16 < this.width || this.width * 16 < this.height ? "The provided map dimensions had an unacceptable aspect ratio" : null)));
        if (string == null) {
            return null;
        }
        String message = string;
        this.setNewRadius(this.radius < 2 ? 2 : (this.radius > 500 ? 500 : (worldWrap && this.radius < 15 ? 15 : this.radius)));
        return message;
    }

    private final void setNewRadius(int radius) {
        this.radius = radius;
        HexCoord size = HexMath.getEquivalentRectangularSize$default(HexMath.INSTANCE, radius, 0.0f, 2, null);
        this.width = size.getX();
        this.height = size.getY();
    }

    @NotNull
    public String toString() {
        return Intrinsics.areEqual(this.name, custom) ? "" + this.width + 'x' + this.height : this.name;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0011\u0010\u000e\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\tR\u0011\u0010\u0010\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/unciv/logic/map/MapSize$Companion;", "", "<init>", "()V", "custom", "", "Tiny", "Lcom/unciv/logic/map/MapSize;", "getTiny", "()Lcom/unciv/logic/map/MapSize;", "Small", "getSmall", "Medium", "getMedium", "Large", "getLarge", "Huge", "getHuge", "names", "", "core"})
    @SourceDebugExtension(value={"SMAP\nMapSize.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapSize.kt\ncom/unciv/logic/map/MapSize$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n1563#2:142\n1634#2,3:143\n*S KotlinDebug\n*F\n+ 1 MapSize.kt\ncom/unciv/logic/map/MapSize$Companion\n*L\n84#1:142\n84#1:143,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MapSize getTiny() {
            return new MapSize(Predefined.Tiny);
        }

        @NotNull
        public final MapSize getSmall() {
            return new MapSize(Predefined.Small);
        }

        @NotNull
        public final MapSize getMedium() {
            return new MapSize(Predefined.Medium);
        }

        @NotNull
        public final MapSize getLarge() {
            return new MapSize(Predefined.Large);
        }

        @NotNull
        public final MapSize getHuge() {
            return new MapSize(Predefined.Huge);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> names() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = Predefined.getEntries();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Predefined predefined = (Predefined)((Object)item$iv$iv);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.name());
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0013\b\u0086\u0081\u0002\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0019B?\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018\u00a8\u0006\u001a"}, d2={"Lcom/unciv/logic/map/MapSize$Predefined;", "", "radius", "", "width", "height", "techCostMultiplier", "", "techCostPerCityModifier", "policyCostPerCityModifier", "<init>", "(Ljava/lang/String;IIIIFFF)V", "getRadius", "()I", "getWidth", "getHeight", "getTechCostMultiplier", "()F", "getTechCostPerCityModifier", "getPolicyCostPerCityModifier", "Tiny", "Small", "Medium", "Large", "Huge", "Companion", "core"})
    public static final class Predefined
    extends Enum<Predefined> {
        @NotNull
        public static final Companion Companion;
        private final int radius;
        private final int width;
        private final int height;
        private final float techCostMultiplier;
        private final float techCostPerCityModifier;
        private final float policyCostPerCityModifier;
        public static final /* enum */ Predefined Tiny;
        public static final /* enum */ Predefined Small;
        public static final /* enum */ Predefined Medium;
        public static final /* enum */ Predefined Large;
        public static final /* enum */ Predefined Huge;
        private static final /* synthetic */ Predefined[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Predefined(int radius, int width, int height, float techCostMultiplier, float techCostPerCityModifier, float policyCostPerCityModifier) {
            this.radius = radius;
            this.width = width;
            this.height = height;
            this.techCostMultiplier = techCostMultiplier;
            this.techCostPerCityModifier = techCostPerCityModifier;
            this.policyCostPerCityModifier = policyCostPerCityModifier;
        }

        /* synthetic */ Predefined(String string, int n, int n2, int n3, int n4, float f, float f2, float f3, int n5, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n5 & 8) != 0) {
                f = 1.0f;
            }
            if ((n5 & 0x10) != 0) {
                f2 = 0.05f;
            }
            if ((n5 & 0x20) != 0) {
                f3 = 0.1f;
            }
            this(n2, n3, n4, f, f2, f3);
        }

        public final int getRadius() {
            return this.radius;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        public final float getTechCostMultiplier() {
            return this.techCostMultiplier;
        }

        public final float getTechCostPerCityModifier() {
            return this.techCostPerCityModifier;
        }

        public final float getPolicyCostPerCityModifier() {
            return this.policyCostPerCityModifier;
        }

        public static Predefined[] values() {
            return (Predefined[])$VALUES.clone();
        }

        public static Predefined valueOf(String value) {
            return Enum.valueOf(Predefined.class, value);
        }

        @NotNull
        public static EnumEntries<Predefined> getEntries() {
            return $ENTRIES;
        }

        static {
            Tiny = new Predefined("Tiny", 0, 10, 23, 15, 0.0f, 0.0f, 0.0f, 56, null);
            Small = new Predefined("Small", 1, 15, 33, 21, 0.0f, 0.0f, 0.0f, 56, null);
            Medium = new Predefined("Medium", 2, 20, 44, 29, 1.1f, 0.0f, 0.0f, 48, null);
            Large = new Predefined(30, 66, 43, 1.2f, 0.0375f, 0.075f);
            Huge = new Predefined(40, 87, 57, 1.3f, 0.025f, 0.05f);
            $VALUES = predefinedArray = new Predefined[]{Predefined.Tiny, Predefined.Small, Predefined.Medium, Predefined.Large, Predefined.Huge};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/unciv/logic/map/MapSize$Predefined$Companion;", "", "<init>", "()V", "safeValueOf", "Lcom/unciv/logic/map/MapSize$Predefined;", "name", "", "core"})
        @SourceDebugExtension(value={"SMAP\nMapSize.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapSize.kt\ncom/unciv/logic/map/MapSize$Predefined$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n295#2,2:142\n*S KotlinDebug\n*F\n+ 1 MapSize.kt\ncom/unciv/logic/map/MapSize$Predefined$Companion\n*L\n70#1:142,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @Readonly
            @NotNull
            public final Predefined safeValueOf(@NotNull String name) {
                Predefined predefined;
                Object v0;
                block2: {
                    Intrinsics.checkNotNullParameter(name, "name");
                    Iterable $this$firstOrNull$iv = Predefined.getEntries();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Predefined it = (Predefined)((Object)element$iv);
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.name(), name)) continue;
                        v0 = element$iv;
                        break block2;
                    }
                    v0 = null;
                }
                if ((predefined = (Predefined)v0) == null) {
                    predefined = Tiny;
                }
                return predefined;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

