/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.chat;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.UncivGame;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.multiplayer.chat.Chat;
import com.unciv.logic.multiplayer.chat.ChatStore;
import com.unciv.models.ImmutableColor;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.UncivTextField;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.chat.ChatPopupKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0010\u001a\u00020\u0011J,\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00142\b\b\u0002\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\u0011H\u0002J\b\u0010\u001a\u001a\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/unciv/ui/screens/worldscreen/chat/ChatPopup;", "Lcom/unciv/ui/popups/Popup;", "chat", "Lcom/unciv/logic/multiplayer/chat/Chat;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "<init>", "(Lcom/unciv/logic/multiplayer/chat/Chat;Lcom/unciv/ui/screens/worldscreen/WorldScreen;)V", "getChat", "()Lcom/unciv/logic/multiplayer/chat/Chat;", "chatTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "scrollPane", "Lcom/badlogic/gdx/scenes/scene2d/ui/ScrollPane;", "messageField", "Lcom/unciv/ui/components/widgets/UncivTextField;", "sendMessage", "", "addMessage", "senderCivName", "", "message", "suffix", "scroll", "", "populateChat", "scrollToBottom", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nChatPopup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatPopup.kt\ncom/unciv/ui/screens/worldscreen/chat/ChatPopup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,163:1\n295#2,2:164\n*S KotlinDebug\n*F\n+ 1 ChatPopup.kt\ncom/unciv/ui/screens/worldscreen/chat/ChatPopup\n*L\n111#1:164,2\n*E\n"})
public final class ChatPopup
extends Popup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Chat chat;
    @NotNull
    private final WorldScreen worldScreen;
    @NotNull
    private final Table chatTable;
    @NotNull
    private final ScrollPane scrollPane;
    @NotNull
    private final UncivTextField messageField;
    public static final float CIVNAME_COLOR_MIN_LIGHTNESS = 0.55f;

    public ChatPopup(@NotNull Chat chat, @NotNull WorldScreen worldScreen) {
        Intrinsics.checkNotNullParameter(chat, "chat");
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        super(worldScreen, Popup.Scrollability.None, 0.0f, 4, null);
        this.chat = chat;
        this.worldScreen = worldScreen;
        this.chatTable = new Table(this.getSkin());
        this.scrollPane = new ScrollPane((Actor)this.chatTable, this.getSkin());
        this.messageField = new UncivTextField("Type something...", null, null, 6, null);
        ChatStore.INSTANCE.setChatPopup(this);
        this.chatTable.defaults().growX().pad(5.0f).center();
        Table chatHeader = new Table(this.getSkin());
        Label chatLabel = Scene2dExtensionsKt.toLabel$default("Chat", null, 30, 1, false, 9, null);
        Image chatIcon = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Chat", null, 2, null);
        chatHeader.add((Actor)chatIcon).size(chatLabel.getHeight() * 1.6f).padRight(chatLabel.getHeight() / (float)3).padBottom(chatLabel.getHeight() / (float)4);
        chatHeader.add((Actor)chatLabel).expandX();
        this.add((Actor)chatHeader).left().pad(5.0f).expandX();
        this.add(ActivationExtensionsKt.onClick(new ImageButton(ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Close", null, 2, null).getDrawable()), () -> ChatPopup._init_$lambda$0(this))).size(chatLabel.getHeight() * 1.3f).right().row();
        this.scrollPane.setFadeScrollBars(false);
        this.scrollPane.setScrollingDisabled(true, false);
        this.add((Actor)this.scrollPane).colspan(2).size(0.5f * this.worldScreen.getStage().getWidth(), 0.5f * this.worldScreen.getStage().getHeight()).expand().fill().row();
        this.add((Actor)this.messageField).expandX().fillX();
        Button sendButton = new Button(this.getSkin());
        sendButton.add((Actor)ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Send", null, 2, null));
        this.add((Actor)sendButton).size(this.messageField.getHeight() * 1.2f, this.messageField.getHeight()).padLeft(1.0f).row();
        this.populateChat();
        ActivationExtensionsKt.onClick(sendButton, () -> ChatPopup._init_$lambda$1(this));
        this.messageField.addListener(new InputListener(){

            @Override
            public boolean keyDown(InputEvent event, int keycode) {
                switch (keycode) {
                    case 66: 
                    case 160: {
                        this.sendMessage();
                    }
                }
                return true;
            }
        });
    }

    @NotNull
    public final Chat getChat() {
        return this.chat;
    }

    public final void sendMessage() {
        String civName;
        Object object;
        String string = this.messageField.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        String message = ((Object)StringsKt.trim((CharSequence)string)).toString();
        String userId = UncivGame.Companion.getCurrent().getSettings().getMultiplayer().getUserId();
        Civilization currentPlayerCiv = this.worldScreen.getGameInfo().getCurrentPlayerCiv();
        if (Intrinsics.areEqual(currentPlayerCiv.getPlayerId(), userId)) {
            object = currentPlayerCiv.getCivName();
        } else {
            Object v2;
            block5: {
                Iterable $this$firstOrNull$iv = this.worldScreen.getGameInfo().getCivilizations();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Civilization civ = (Civilization)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(civ.getPlayerId(), userId)) continue;
                    v2 = element$iv;
                    break block5;
                }
                v2 = null;
            }
            if ((object = (Civilization)v2) == null || (object = ((Civilization)object).getCivName()) == null) {
                object = civName = "Unknown";
            }
        }
        if (((CharSequence)message).length() > 0) {
            this.chat.requestMessageSend(civName, message);
            this.messageField.setText("");
        }
    }

    public final void addMessage(@NotNull String senderCivName, @NotNull String message, @Nullable String suffix, boolean scroll) {
        Label label;
        Intrinsics.checkNotNullParameter(senderCivName, "senderCivName");
        Intrinsics.checkNotNullParameter(message, "message");
        Label $this$addMessage_u24lambda_u240 = label = new Label((CharSequence)(TranslationsKt.tr$default(senderCivName, false, false, 3, null) + (suffix != null ? " [" + TranslationsKt.tr$default(suffix, false, false, 3, null) + ']' : "") + ": " + TranslationsKt.tr$default(message, false, false, 3, null)), this.getSkin());
        boolean bl = false;
        $this$addMessage_u24lambda_u240.setWrap(true);
        Color color = (Color)ChatPopupKt.access$getCivChatColorsMap$p().get(senderCivName);
        if (color == null) {
            Object object = this.worldScreen.getGameInfo().getCivilizationOrNull(senderCivName);
            ImmutableColor immutableColor = object != null && (object = ((Civilization)object).getNation()) != null ? ((Nation)object).getOuterColor() : null;
            color = immutableColor != null ? (Color)immutableColor : Color.BLACK;
        }
        Color civNameColor = color;
        Intrinsics.checkNotNull(civNameColor);
        $this$addMessage_u24lambda_u240.setColor(Scene2dExtensionsKt.coerceLightnessAtLeast(civNameColor, 0.55f));
        Label line = label;
        this.chatTable.add((Actor)line).row();
        if (scroll) {
            this.scrollToBottom();
        }
    }

    public static /* synthetic */ void addMessage$default(ChatPopup chatPopup, String string, String string2, String string3, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        chatPopup.addMessage(string, string2, string3, bl);
    }

    private final void populateChat() {
        this.chatTable.clearChildren();
        this.chat.forEachMessage((arg_0, arg_1) -> ChatPopup.populateChat$lambda$0(this, arg_0, arg_1));
        ChatStore.INSTANCE.pollGlobalMessages((arg_0, arg_1) -> ChatPopup.populateChat$lambda$1(this, arg_0, arg_1));
        this.scrollToBottom();
    }

    private final void scrollToBottom() {
        this.chatTable.invalidate();
        this.scrollPane.layout();
        this.scrollPane.setScrollY(0.0f);
        this.scrollPane.setScrollPercentY(1.0f);
    }

    private static final Unit _init_$lambda$0(ChatPopup this$0) {
        ChatStore.INSTANCE.setChatPopup(null);
        this$0.close();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(ChatPopup this$0) {
        this$0.sendMessage();
        return Unit.INSTANCE;
    }

    private static final Unit populateChat$lambda$0(ChatPopup this$0, String civName, String message) {
        Intrinsics.checkNotNullParameter(civName, "civName");
        Intrinsics.checkNotNullParameter(message, "message");
        ChatPopup.addMessage$default(this$0, civName, message, null, false, 12, null);
        return Unit.INSTANCE;
    }

    private static final Unit populateChat$lambda$1(ChatPopup this$0, String civName, String message) {
        Intrinsics.checkNotNullParameter(civName, "civName");
        Intrinsics.checkNotNullParameter(message, "message");
        ChatPopup.addMessage$default(this$0, civName, message, "one time", false, 8, null);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/unciv/ui/screens/worldscreen/chat/ChatPopup$Companion;", "", "<init>", "()V", "CIVNAME_COLOR_MIN_LIGHTNESS", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

