/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.status;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.utils.Disposable;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyShortcutDispatcher;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.status.AutoPlayMenu;
import com.unciv.ui.screens.worldscreen.status.NextTurnButton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\fH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/unciv/ui/screens/worldscreen/status/AutoPlayStatusButton;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Button;", "Lcom/badlogic/gdx/utils/Disposable;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "nextTurnButton", "Lcom/unciv/ui/screens/worldscreen/status/NextTurnButton;", "<init>", "(Lcom/unciv/ui/screens/worldscreen/WorldScreen;Lcom/unciv/ui/screens/worldscreen/status/NextTurnButton;)V", "getWorldScreen", "()Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "autoPlayImage", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "createAutoplayImage", "dispose", "", "core"})
public final class AutoPlayStatusButton
extends Button
implements Disposable {
    @NotNull
    private final WorldScreen worldScreen;
    @NotNull
    private final Image autoPlayImage;

    public AutoPlayStatusButton(@NotNull WorldScreen worldScreen, @NotNull NextTurnButton nextTurnButton) {
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        Intrinsics.checkNotNullParameter(nextTurnButton, "nextTurnButton");
        super(BaseScreen.Companion.getSkin());
        this.worldScreen = worldScreen;
        this.autoPlayImage = this.createAutoplayImage();
        Actor[] actorArray = new Actor[]{this.autoPlayImage};
        this.add((Actor)new Stack(actorArray)).pad(5.0f);
        ActivationExtensionsKt.onActivation$default(this, null, KeyboardBinding.AutoPlayMenu, () -> AutoPlayStatusButton._init_$lambda$0(this, nextTurnButton), 1, null);
        Function0<Unit> directAutoPlay = () -> AutoPlayStatusButton._init_$lambda$1(this, nextTurnButton);
        ActivationExtensionsKt.onRightClick$default(this, null, directAutoPlay, 1, null);
        KeyShortcutDispatcher.add$default(ActivationExtensionsKt.getKeyShortcuts(this), KeyboardBinding.AutoPlay, 0, directAutoPlay, 2, null);
    }

    @NotNull
    public final WorldScreen getWorldScreen() {
        return this.worldScreen;
    }

    private final Image createAutoplayImage() {
        Image img = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/NationSwap", null, 2, null);
        Scene2dExtensionsKt.setSize(img, 40.0f);
        return img;
    }

    @Override
    public void dispose() {
        if (this.isPressed() && this.worldScreen.getAutoPlay().isAutoPlaying()) {
            this.worldScreen.getAutoPlay().stopAutoPlay();
        }
    }

    private static final Unit _init_$lambda$0(AutoPlayStatusButton this$0, NextTurnButton $nextTurnButton) {
        if (this$0.worldScreen.getAutoPlay().isAutoPlaying()) {
            this$0.worldScreen.getAutoPlay().stopAutoPlay();
        } else if (this$0.worldScreen.isPlayersTurn()) {
            Stage stage = this$0.getStage();
            Intrinsics.checkNotNullExpressionValue(stage, "getStage(...)");
            new AutoPlayMenu(stage, (Actor)this$0, $nextTurnButton, this$0.worldScreen);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(AutoPlayStatusButton this$0, NextTurnButton $nextTurnButton) {
        if (!this$0.worldScreen.getGameInfo().getGameParameters().isOnlineMultiplayer() && Intrinsics.areEqual(this$0.worldScreen.getViewingCiv(), this$0.worldScreen.getGameInfo().getCurrentPlayerCiv())) {
            this$0.worldScreen.getAutoPlay().startMultiturnAutoPlay();
            $nextTurnButton.update();
        }
        return Unit.INSTANCE;
    }
}

