"use strict";
// Copyright 2022 The Matrix.org Foundation C.I.C.
//
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.PgDataStore = void 0;
const matrix_appservice_bridge_1 = require("matrix-appservice-bridge");
function getSchema() {
    const nSchema = 2;
    const schema = [];
    for (let schemaID = 1; schemaID < nSchema + 1; schemaID++) {
        // eslint-disable-next-line @typescript-eslint/no-var-requires
        schema.push(require(`./schema/v${schemaID}`).runSchema);
    }
    return schema;
}
class PgDataStore extends matrix_appservice_bridge_1.PostgresStore {
    constructor(connectionString) {
        super(getSchema(), { url: connectionString });
    }
    async init() {
        await this.ensureSchema();
    }
    async close() {
        await this.destroy();
    }
    async list() {
        const result = await this
            .sql `SELECT local_part, owner, management_room FROM draupnir`;
        if (!result.count) {
            return [];
        }
        return result.flat();
    }
    async store(mjolnirRecord) {
        await this.sql `INSERT INTO draupnir (local_part, owner, management_room)
        VALUES (${mjolnirRecord.local_part}, ${mjolnirRecord.owner}, ${mjolnirRecord.management_room})`;
    }
    async lookupByOwner(owner) {
        const result = await this
            .sql `SELECT local_part, owner, management_room FROM draupnir
        WHERE owner = ${owner}`;
        return result.flat();
    }
    async lookupByLocalPart(localPart) {
        const result = await this
            .sql `SELECT local_part, owner, management_room FROM draupnir
        WHERE local_part = ${localPart}`;
        return result.flat();
    }
}
exports.PgDataStore = PgDataStore;
//# sourceMappingURL=PgDataStore.js.map