import { Result } from "@gnuxie/typescript-result";
import { CommandDescription } from "./CommandDescription";
import { CommandMeta, KeywordsMeta } from "./CommandMeta";
import { Presentation } from "./Presentation";
import { CommandTable } from "./CommandTable";
export type CommandExecutorHelperOptions<TInvocationInformation, TRestArgumentObjectType, TKeywordsMeta extends KeywordsMeta> = {
    info?: TInvocationInformation | undefined;
    rest?: TRestArgumentObjectType[] | undefined;
    keywords?: Partial<TKeywordsMeta> | undefined;
};
type CommandExecutorHelperParseOptions<TInvocationInformation, TRestArgumentObjectType, TKeywordsMeta extends KeywordsMeta> = {
    info?: TInvocationInformation | undefined;
    rest?: Presentation<TRestArgumentObjectType>[] | undefined;
    keywords?: Partial<{
        [I in keyof TKeywordsMeta]: Presentation<TKeywordsMeta[I]>;
    }> | undefined;
};
export declare const CommandExecutorHelper: Readonly<{
    execute<TCommandContext, TInvocationInformation, TCommandResult, TImmediateArgumentsObjectTypes extends unknown[], TRestArgumentObjectType, TKeywordsMeta extends KeywordsMeta>(command: CommandDescription<CommandMeta<TCommandContext, TInvocationInformation, TCommandResult, TImmediateArgumentsObjectTypes, TRestArgumentObjectType, TKeywordsMeta>>, context: TCommandContext, options: CommandExecutorHelperOptions<TInvocationInformation, TRestArgumentObjectType, TKeywordsMeta>, ...args: TImmediateArgumentsObjectTypes): Promise<Result<TCommandResult>>;
    parseAndInvoke<TCommandContext, TInvocationInformation, TCommandResult, TImmediateArgumentsObjectTypes extends unknown[], TRestArgumentObjectType, TKeywordsMeta extends KeywordsMeta>(commandTable: CommandTable, command: CommandDescription<CommandMeta<TCommandContext, TInvocationInformation, TCommandResult, TImmediateArgumentsObjectTypes, TRestArgumentObjectType, TKeywordsMeta>>, context: TCommandContext, options: CommandExecutorHelperParseOptions<TInvocationInformation, TRestArgumentObjectType, TKeywordsMeta>, ...args: { [I in keyof TImmediateArgumentsObjectTypes]: Presentation<TImmediateArgumentsObjectTypes[I]> | undefined; }): Promise<Result<TCommandResult>>;
}>;
export {};
//# sourceMappingURL=CommandExecutorHelper.d.ts.map