"use strict";
// Copyright 2023 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeadDocumentJSX = void 0;
const DeadDocument_1 = require("./DeadDocument");
// We need to use a namespace here for the JSXFactory, at least i think.
// eslint-disable-next-line @typescript-eslint/no-namespace
var DeadDocumentJSX;
(function (DeadDocumentJSX) {
    function JSXFactory(tag, properties, ...rawChildren) {
        const node = (0, DeadDocument_1.makeDocumentNode)(tag);
        if (properties) {
            for (const [key, value] of Object.entries(properties)) {
                node.attributeMap.set(key, value);
            }
        }
        const ensureChild = (rawChild) => {
            if (typeof rawChild === "string") {
                (0, DeadDocument_1.makeLeafNode)(DeadDocument_1.NodeTag.TextNode, node, rawChild);
            }
            else if (typeof rawChild === "number") {
                (0, DeadDocument_1.makeLeafNode)(DeadDocument_1.NodeTag.TextNode, node, rawChild.toString());
            }
            else if (Array.isArray(rawChild)) {
                rawChild.forEach(ensureChild);
                // Then it's a DocumentNode|LeafNode
            }
            else if (typeof rawChild.leafNode === "boolean") {
                if (rawChild.tag === DeadDocument_1.NodeTag.Fragment) {
                    rawChild
                        .getChildren()
                        .forEach(node.addChild.bind(node));
                }
                else {
                    node.addChild(rawChild);
                }
            }
        };
        rawChildren.forEach(ensureChild);
        return node;
    }
    DeadDocumentJSX.JSXFactory = JSXFactory;
})(DeadDocumentJSX || (exports.DeadDocumentJSX = DeadDocumentJSX = {}));
//# sourceMappingURL=JSXFactory.js.map