import { StringEventID, StringRoomID } from '@the-draupnir-project/matrix-basic-types';
import { RoomEvent } from '../MatrixTypes/Events';
import { MatrixPaginator } from './Pagination/MatrixPaginator';
import { PaginationOptions } from './Pagination/PaginationOptions';
import { PaginationIterator } from './Pagination/PaginationIteration';
export interface RoomEventRelationsOptions extends PaginationOptions {
    relationType?: string;
    eventType?: string;
}
export interface RoomEventRelationsPaginator<TEvent extends RoomEvent = RoomEvent> extends MatrixPaginator<TEvent, RoomEventRelationsOptions> {
}
export interface RoomEventRelations {
    toRoomEventRelationsPaginator<TEvent extends RoomEvent = RoomEvent>(roomID: StringRoomID, eventID: StringEventID): RoomEventRelationsPaginator<TEvent>;
    toRoomEventRelationsIterator<TEvent extends RoomEvent = RoomEvent>(roomID: StringRoomID, eventID: StringEventID, options: RoomEventRelationsOptions): PaginationIterator<TEvent>;
}
export declare const RoomEventRelationsResponse: import("@sinclair/typebox").TObject<{
    chunk: import("@sinclair/typebox").TArray<import("@sinclair/typebox").TUnknown>;
    next_batch: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnsafe<import("./Pagination/PaginationToken").StringPaginationToken>>;
    prev_batch: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnsafe<import("./Pagination/PaginationToken").StringPaginationToken>>;
}>;
//# sourceMappingURL=RoomEventRelations.d.ts.map