export interface TimedGate {
    enqueueOpen(): void;
    destroy(): void;
}
/**
 * A linear gate around a background task.
 * 1. If it's been longer than the delayMS since the task was last run,
 *   it will run the task immediately (open the gate).
 * 2. If it's been less than the delayMS since the task was last run,
 *  the task will be scheduled to run after the remaining delayMS has elapsed.
 * 3. If the task is already running, we will not run it again until it finishes,
 *   but we will enqueue a follow-up task to run immediately after the current task finishes.
 *
 * This means that there will only ever be 1 task running and one task enqueued to
 * follow up. With no chains of follow-up tasks.
 */
export declare class StandardTimedGate implements TimedGate {
    private readonly cb;
    private readonly delayMS;
    private gateLastOpenAt;
    private batch;
    private backgroundTask;
    constructor(cb: GatedBackgroundTaskFactory, delayMS?: number);
    enqueueOpen(): void;
    destroy(): void;
}
export interface GatedBackgroundTask {
    isFinished(): boolean;
    enqueueFollowUp(): void;
    cancel(): void;
    isCancelled(): boolean;
}
export type GatedBackgroundTaskFactory = (taskTracker: GatedBackgroundTask) => Promise<void>;
export declare class StandardGatedBackgroundTask implements GatedBackgroundTask {
    #private;
    private enqueueCalledWhileTaskActive;
    constructor(taskFactory: GatedBackgroundTaskFactory, parentGate: TimedGate);
    isFinished(): boolean;
    isCancelled(): boolean;
    enqueueFollowUp(): void;
    cancel(): void;
}
//# sourceMappingURL=TimedGate.d.ts.map