"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MatrixException = void 0;
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
const Action_1 = require("./Action");
const ActionException_1 = require("./ActionException");
class MatrixException extends ActionException_1.ActionException {
    constructor(exception, matrixErrorCode, matrixErrorMessage, message = matrixErrorMessage, kind = ActionException_1.ActionExceptionKind.Unknown) {
        super(kind, exception, message);
        this.matrixErrorCode = matrixErrorCode;
        this.matrixErrorMessage = matrixErrorMessage;
    }
    /**
     * Result wrapper, @see ActionError.
     * Named because of https://github.com/microsoft/TypeScript/issues/4628.
     */
    static R(options) {
        return (0, Action_1.ResultError)(new MatrixException(options.exceptionKind, options.matrixErrorCode, options.matrixErrorMessage, options.message, options.exceptionKind));
    }
}
exports.MatrixException = MatrixException;
//# sourceMappingURL=MatrixException.js.map