"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JoinRulesEvent = exports.JoinRulesEventContent = void 0;
// Copyright 2024 Gnuxie <Gnuxie@protonmail.com>
// Copyright 2018 New Vector Ltd
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from matrix-spec
// https://github.com/matrix-org/matrix-spec
// </text>
const typebox_1 = require("@sinclair/typebox");
const Events_1 = require("./Events");
exports.JoinRulesEventContent = typebox_1.Type.Object({
    join_rule: typebox_1.Type.Union([
        typebox_1.Type.Literal('public'),
        typebox_1.Type.Literal('knock'),
        typebox_1.Type.Literal('invite'),
        typebox_1.Type.Literal('private'),
        typebox_1.Type.Literal('restricted'),
        typebox_1.Type.Literal('knock_restricted'),
    ]),
    allow: typebox_1.Type.Optional(typebox_1.Type.Array(typebox_1.Type.Object({
        type: typebox_1.Type.Union([typebox_1.Type.Literal('m.room_membership')]),
        room_id: typebox_1.Type.Optional(typebox_1.Type.String({
            description: "Required if `type` is `m.room_membership`. The room ID to check the\nuser's membership against. If the user is joined to this room, they\nsatisfy the condition and thus are permitted to join the `restricted`\nroom.",
        })),
    }), {
        description: 'For `restricted` rooms, the conditions the user will be tested against. The\nuser needs only to satisfy one of the conditions to join the `restricted`\nroom. If the user fails to meet any condition, or the condition is unable\nto be confirmed as satisfied, then the user requires an invite to join the\nroom. Improper or no `allow` conditions on a `restricted` join rule imply\nthe room is effectively invite-only (no conditions can be satisfied).',
    })),
});
exports.JoinRulesEvent = typebox_1.Type.Intersect([
    typebox_1.Type.Omit((0, Events_1.StateEvent)(exports.JoinRulesEventContent), ['state_key', 'type']),
    typebox_1.Type.Object({
        state_key: typebox_1.Type.String({
            description: 'A zero-length string.',
            pattern: '^$',
        }),
        type: typebox_1.Type.Union([typebox_1.Type.Literal('m.room.join_rules')]),
    }),
]);
//# sourceMappingURL=JoinRules.js.map