"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReactionEvent = exports.ReactionContent = void 0;
// Copyright 2023 Gnuxie <Gnuxie@protonmail.com>
// Copyright 2018 New Vector Ltd
//
// SPDX-License-Identifier: AFL-3.0 AND Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from matrix-spec
// https://github.com/matrix-org/matrix-spec
// </text>
const typebox_1 = require("@sinclair/typebox");
const StringlyTypedMatrix_1 = require("./StringlyTypedMatrix");
const Events_1 = require("./Events");
exports.ReactionContent = typebox_1.Type.Object({
    ['m.relates_to']: typebox_1.Type.Optional(typebox_1.Type.Object({
        rel_type: typebox_1.Type.Optional(typebox_1.Type.Union([typebox_1.Type.Literal('m.annotation')])),
        event_id: StringlyTypedMatrix_1.StringEventIDSchema,
        key: typebox_1.Type.Optional(typebox_1.Type.String({
            description: 'The reaction being made, usually an emoji.\n\nIf this is an emoji, it should include the unicode emoji\npresentation selector (`\\uFE0F`) for codepoints which allow it\n(see the [emoji variation sequences\nlist](https://www.unicode.org/Public/UCD/latest/ucd/emoji/emoji-variation-sequences.txt)).',
            example: '👍',
        })),
    })),
});
exports.ReactionEvent = typebox_1.Type.Intersect([
    typebox_1.Type.Omit((0, Events_1.RoomEvent)(typebox_1.Type.Unknown()), ['content', 'type']),
    typebox_1.Type.Object({
        content: typebox_1.Type.Union([exports.ReactionContent, Events_1.EmptyContent]),
        type: typebox_1.Type.Literal('m.reaction'),
    }),
]);
//# sourceMappingURL=ReactionEvent.js.map