import { ServerACLContent } from './ServerACL';
export declare class ServerACLBuilder {
    readonly homeserver: string;
    private allowedServers;
    private deniedServers;
    private allowIps;
    constructor(homeserver: string);
    /**
     * Checks the ACL for any entries that might ban ourself.
     * @returns A list of deny entries that will not ban our own homeserver.
     */
    safeDeniedServers(): string[];
    safeAllowedServers(): string[];
    allowIpAddresses(): this;
    denyIpAddresses(): this;
    allowServer(glob: string): this;
    setAllowedServers(globs: string[]): this;
    denyServer(glob: string): this;
    setDeniedServers(globs: string[]): this;
    literalAclContent(): ServerACLContent;
    safeAclContent(): ServerACLContent;
    matches(acl: ServerACLContent): boolean;
}
//# sourceMappingURL=ServerACLBuilder.d.ts.map