"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StandardSetMembershipRevisionIssuer = void 0;
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
const events_1 = __importDefault(require("events"));
const SetMembershipRevision_1 = require("./SetMembershipRevision");
const Logger_1 = require("../Logging/Logger");
const log = new Logger_1.Logger('StandardSetMembershipRevisionListener');
class StandardSetMembershipRevisionIssuer extends events_1.default {
    constructor(setRoomMembershipIssuer) {
        super();
        this.setRoomMembershipIssuer = setRoomMembershipIssuer;
        log.debug('Creating a set membership revision issuer, this can take some time.');
        this.currentRevision = setRoomMembershipIssuer.allRooms.reduce((revision, roomMembershipRevision) => {
            return revision.reviseFromChanges(revision.changesFromAddedRoom(roomMembershipRevision));
        }, SetMembershipRevision_1.StandardSetMembershipRevision.blankRevision());
        log.debug('Finished creating a set membership revision issuer.');
        this.roomMembershipRevisionListener = this.membershipRevision.bind(this);
        setRoomMembershipIssuer.on('membership', this.roomMembershipRevisionListener);
        this.setRoomChangeListener = this.setRoomChange.bind(this);
        setRoomMembershipIssuer.on('SetChange', this.setRoomChangeListener);
    }
    unregisterListeners() {
        this.setRoomMembershipIssuer.off('membership', this.roomMembershipRevisionListener);
        this.setRoomMembershipIssuer.off('SetChange', this.setRoomChangeListener);
    }
    membershipRevision(roomID, _nextMembershipRevision, changes) {
        const previousRevision = this.currentRevision;
        const delta = previousRevision.changesFromMembershipChanges(changes);
        this.currentRevision = this.currentRevision.reviseFromChanges(delta);
        this.emit('revision', this.currentRevision, delta, previousRevision);
    }
    setRoomChange(roomID, direction, revision) {
        const previousRevision = this.currentRevision;
        const delta = direction === 'add'
            ? previousRevision.changesFromAddedRoom(revision)
            : previousRevision.changesFromRemovedRoom(revision);
        this.currentRevision = previousRevision.reviseFromChanges(delta);
        this.emit('revision', this.currentRevision, delta, previousRevision);
    }
}
exports.StandardSetMembershipRevisionIssuer = StandardSetMembershipRevisionIssuer;
//# sourceMappingURL=SetMembershipRevisionIssuer.js.map